<?php

/**
 * Admin Settings Section Activate
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<div x-show="currentStep.id == 'activate'" x-transition.opacity>

	<?php

	do_action( 'scf_before_activate_fields' );
	?>
	<!-- activate  -->


	<div class="scf-switch" @click.prevent="options.enabled = is_true(options.enabled) ? false : true" :class="[is_true(options.enabled) ? 'active' : 'inactive']">
		<div></div>
		<label><?php esc_html_e( 'Activate Social Contact Form', 'social-contact-form' ); ?></label>
	</div>

	<div class="mb-5 flex items-center gap-2" :class="{
		'pointer-events-none opacity-60': !options.enabled,
	}">
		<label for="form_delay" class="text-sm text-slate-500"><?php esc_html_e( 'Show form after', 'social-contact-form' ); ?></label>
		<input id="form_delay" type="number" min="0" step="1" class="w-14 scf-input text-xs" x-model="options.form.delay" placeholder="<?php esc_html_e( '0', 'social-contact-form' ); ?>">
		<span class="text-sm text-slate-500"><?php esc_html_e( 'ms when page is loaded', 'social-contact-form' ); ?></span>
	</div>

	<?php do_action( 'scf_after_activate_fields' ); ?>
</div>
