<?php

/**
 * Admin Settings Progress Bar
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<!-- progressbar   -->
<div class="grid grid-cols-3 pt-4 pb-1 bg-white">
	<!-- multi step form progress  -->
	<template x-for="(step, index) in state.steps">
		<div class="flex items-center flex-col justify-center cursor-pointer transition duration-100 relative font-medium">
			<div class="w-4 h-4 rounded-full z-20" @click.prevent="jumpStep(index + 1)" :class="state.step > index ? 'bg-indigo-600' : 'bg-slate-300'"></div>
			<div x-show="index > 0" class="z-0 absolute top-1.5 right-1/2 -mx-1 h-1 w-full duration-100" :class="state.step > index ? 'bg-indigo-600' : 'bg-slate-300'"></div>
			<div class="py-2 flex items-center" @click.prevent="jumpStep(index + 1)" :class="state.step <= index ? 'text-slate-300' : 'text-indigo-600'">
				<span x-show="!isMobile" x-text="index+1"></span>
				<span x-show="!isMobile">.</span>
				<span class="sm:flex sm:ml-1 text-center" x-text="step.title || ''"></span>
			</div>
		</div>
	</template>
</div>
