<?php

/**
 * Admin Settings Preview Icon
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<div x-show="!state.preview_form" x-transition.opacity class="transition duration-200 sm:absolute z-0 top-0 mx-auto" :class="{ 'w-48' : state.mobile && !state.preview_form, 'w-full max-w-sm md:max-w-md' : !state.mobile || state.preview_form }">

	<!-- preview form -->
	<div class="border border-slate-200 rounded-md w-full shadow-sm">

		<div class="h-8 px-3 bg-slate-50 flex items-center gap-2 border-b border-slate-200">
			<div class="w-2 h-2 bg-slate-300 rounded-full"></div>
			<div class="w-2 h-2 bg-slate-300 rounded-full"></div>
			<div class="w-2 h-2 bg-slate-300 rounded-full"></div>
		</div>
		<div class="relative bg-white w-full mx-auto" :class="state.mobile ? 'h-72' : 'h-72'">
			<div class="absolute flex items-center gap-0.5 cursor-pointer transition duration-150" :class="{
									'left-2 bottom-2': icon.align == 'left', 
									'flex-row-reverse' : icon.align == 'left' || (icon.position.left && !icon.position.right),
									'right-2 bottom-2': icon.align == 'right',                                    
									'hover:opacity-90' : options.enabled,
									'opacity-20' : !options.enabled,
								}" :style="{
									top: icon.align === 'custom' ? icon.position.top : 'auto',
									left: icon.align === 'custom' ? icon.position.left : 'auto',
									right: icon.align === 'custom' ? icon.position.right : 'auto',
									bottom: icon.align === 'custom' ? icon.position.bottom : 'auto',
								}">
				<div x-show="call_to_action.text" x-text="call_to_action.text" class="shadow-md border border-slate-200 rounded-xl px-2 py-1" :style="{
										fontSize: call_to_action.size,
										color: call_to_action.color,
										backgroundColor: call_to_action.background, 
										fontFamily: options.form.font
									}"></div>
				<img :src="icon.image" alt="<?php esc_html_e( 'WhatsForm Image', 'social-contact-form' ); ?>" :style="{
										'width': icon.size, 
									}">
			</div>
		</div>

	</div>



	<!-- responsive handler  -->
	<div class="mt-3 text-center">
		<div class="inline-flex items-center justify-center gap-0 bg-slate-200 rounded-md p-0.5">

			<label class="rounded-md px-2 py-2 transition duration-150" :class="{
									'bg-white' : !state.mobile
								}" @click.prevent="state.mobile = false">
				<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-laptop" viewBox="0 0 16 16">
					<path d="M13.5 3a.5.5 0 0 1 .5.5V11H2V3.5a.5.5 0 0 1 .5-.5h11zm-11-1A1.5 1.5 0 0 0 1 3.5V12h14V3.5A1.5 1.5 0 0 0 13.5 2h-11zM0 12.5h16a1.5 1.5 0 0 1-1.5 1.5h-13A1.5 1.5 0 0 1 0 12.5z" />
				</svg>
			</label>
			<label class="rounded-md px-2 py-2  transition duration-150" :class="{
									'bg-white' : state.mobile
								}" @click.prevent="state.mobile = 1">
				<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-phone" viewBox="0 0 16 16">
					<path d="M11 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h6zM5 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H5z" />
					<path d="M8 14a1 1 0 1 0 0-2 1 1 0 0 0 0 2z" />
				</svg>
			</label>
		</div>
	</div>
</div>
