<?php

/**
 * Admin Settings Preview Form
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<!-- preview form  -->
<div x-show="state.preview_form" x-transition.opacity class="transition duration-300 sm:absolute z-0 top-0 left-0"
	:class="{ 'w-48' : state.mobile && !state.preview_form, 'w-full max-w-sm md:max-w-md' : !state.mobile || state.preview_form }">
	<div class="scf-widget flex items-center justify-center relative p-2">
		<div class="scf-form right relative right-0 bottom-0 p-0 m-0 transition duration-150" :style="{
			width: form.size,  fontFamily: options.form.font}">

			<!-- icon  -->
			<div class="scf-form-header" :style="{ background: form.background, color: form.color }">
				<div class="scf-form-title" :style="{fontSize: form.titleFontSize}" x-text="form.title"></div>
				<!-- close  -->
				<div class="scf-form-close">
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
						<path fill-rule="evenodd"
							d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z">
						</path>
					</svg>
				</div>
			</div>

			<div
				x-show="options.contact_form_7.modepress != 'cf7' || options.contact_form_7.modepress != 'scf' && options.contact_form_7.cf7Installed == true && options.contact_form_7.cf7NotActivated == true || options.contact_form_7.modepress != 'scf' && options.contact_form_7.cf7Installed === false">
				<!-- form -->
				<div class="scf-form-content" id="scf-form-content">

					<div class="text-sm text-slate-500" x-show="form.header" x-text="form.header"></div>
					<!-- <div class="text-sm text-slate-500" x-show="test.testheader" x-text="test.testheader"></div> -->
					<div class="py-1.5"></div>

					<!-- <template x-for="field in fields"> -->
					<template x-for="(field, index) in fields">
						<div class="scf-form-group" :class="['scf-form-group-hide-' + (index + 1)]"
							:style="(index + 1 === 5) ? 'display: none !important;' : ''">
							<input
								x-show="['text', 'email', 'number', 'time', 'date', 'week', 'datetime-local', 'week'].includes(field.type)"
								:type="field.type" :id="field.name" :name="field.name" :placeholder="field.placeholder">

							<!-- <div x-show="['tel'].includes(field.type) && options.form.allow_country_selection.toString() == 'true'"> -->
							<div
								x-show="['tel'].includes(field.type) && options.form.allow_country_selection.toString() == 'true'">
								<div class="scf-input relative w-full flex items-center border border-gray-300 rounded"
									style="border-radius: 6px !important; height: 37px; border-color: #e2e2e2 !important; ">
									<div class="mt-n3" style="font-size: 8px; width: 62px; margin-top: -4px;">
										<button
											class="px-2 block py-2 h-10 sm:h-9 flex items-center gap-1 font-medium border-r-0">
											<span x-show="defaultCountry"
												x-html="defaultCountry.emoji || ''">🇦🇫</span>
											<span x-show="defaultCountry" x-text="defaultCountry.phone_code"></span>
											<span x-show="!defaultCountry"
												class="italic text-indigo-600"><?php esc_html_e( 'Select a country', 'social-contact-form' ); ?></span>
										</button>
									</div>

									<svg class="w-4 h-4 text-gray-500" viewBox="0 0 20 20" fill="currentColor">
										<path fill-rule="evenodd" d="M10 12l-6-6 1.5-1.5L10 9l4.5-4.5L16 6z"
											clip-rule="evenodd" />
									</svg>

									<input x-show="['tel'].includes(field.type)" :type="field.type" :id="field.name"
										:name="field.name" :placeholder="field.placeholder"
										class="border-none h-4 shadow-none">

								</div>
							</div>

							<!-- Telephone number when country code selection off -->
							<input
								x-show="['tel'].includes(field.type) && options.form.allow_country_selection.toString() == 'false'"
								:type="field.type" :id="field.name" :name="field.name" :placeholder="field.placeholder">

							<!-- <input x-show="['tel'].includes(field.type) && options.form.allow_country_selection.toString() == 'false'" :type="field.type" :id="field.name" :name="field.name" :placeholder="field.placeholder"> -->

							<!-- end  -->

							<textarea x-show="['textarea'].includes(field.type)" :id="field.name" :name="field.name"
								:placeholder="field.placeholder" ::spellcheck="field.spellcheck || true"></textarea>

							<select x-show="['select'].includes(field.type)" :id="field.name" :name="field.name">
								<template x-for="(option, label) in field.options">
									<option x-text="label" :checked="option == field.default"></option>
								</template>
							</select>

							<div class="scf-checkbox-wrap" x-show="['checkbox'].includes(field.type)">
								<input :type="field.type" :id="field.name" :name="field.name" :checked="field.default">
								<label :for="field.name" class="scf-checkbox-label">
									<span x-text="field.label"></span>
								</label>
							</div>
							<div class="scf-radio-wrap" x-show="['radio'].includes(field.type)">
								<input :type="field.type" :id="field.name" :name="field.name" :checked="field.default">
								<label :for="field.name" class="scf-radio-label">
									<span x-text="field.label"></span>
								</label>
							</div>
						</div>
					</template>

					<div class="scf-form-footer" x-show="form.footer" x-text="form.footer"></div>

					<button class="scf-form-submit" type="submit"
						:style="{ background: form.background, color: form.color,  fontFamily: options.form.font }">
						<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-4" viewBox="0 0 16 16">
							<path
								d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z">
							</path>
						</svg>
						<span x-text="form.submit"></span> </button>
				</div>
			</div>


			<!-- CF7 Form  -->
			<div x-show="options.contact_form_7.modepress != 'scf' && options.contact_form_7.cf7NotActivated == false">
				<!-- Second Form  -->
				<div class="scf-form-content" id="scf-form-content">
					<div class="text-sm text-slate-500" x-show="form.header" x-text="form.header"></div>
					<div class="py-1.5"></div>
					<div class="cf7-form-render">
						<div class="form-container" x-html="options.contact_form_7.formrender"></div>
					</div>
					<div class="scf-form-footer" x-show="form.footer" x-text="form.footer"></div>
				</div>
			</div>


		</div>
	</div>
</div>
