<?php

/**
 * Admin Settings Header
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<div
	class="px-6 flex flex-col sm:flex-row items-center justify-center sm:justify-between p-3 gap-3 sticky self-start top-0 z-50">

	<div x-show="currentStep" class="text-xl font-bold w-full text-center sm:text-left">
		<span class="text-slate-700 font-semibold" x-text="`Step ${state.step}:`"> </span>
		<span class="text-slate-500 font-normal" x-text="currentStep.title"></span>
	</div>

	<div class="w-full flex items-center justify-center sm:justify-end gap-1.5 font-medium"
		x-data="{ isActive: options.activeform.showform }">
		<template x-if="state.step > 1">
			<button @click.prevent="state.step--"
				class="bg-transparent border border-indigo-600 text-indigo-600 hover:bg-indigo-600 hover:opacity-90 hover:text-white px-3 py-1.5 rounded-sm flex items-center gap-1">
				<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-5" viewBox="0 0 16 16">
					<path fill-rule="evenodd"
						d="M12 8a.5.5 0 0 1-.5.5H5.707l2.147 2.146a.5.5 0 0 1-.708.708l-3-3a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L5.707 7.5H11.5a.5.5 0 0 1 .5.5z" />
				</svg>
				<span><?php esc_html_e( 'Back', 'social-contact-form' ); ?></span>
			</button>
		</template>
		<button @click.prevent="jumpStep()"
			class="bg-indigo-600 border border-indigo-600 text-white hover:opacity-90 px-4 py-1.5 rounded-sm  flex items-center gap-2">
			<span x-text="nextButton" x-on:click="isActive = 'true'; options.activeform.showform = 'true'"></span>
			<svg x-show="!state.saving" xmlns="http://www.w3.org/2000/svg" class="fill-current w-5" viewBox="0 0 16 16">
				<path x-show="state.step === 3"
					d="M8 2a5.53 5.53 0 0 0-3.594 1.342c-.766.66-1.321 1.52-1.464 2.383C1.266 6.095 0 7.555 0 9.318 0 11.366 1.708 13 3.781 13h8.906C14.502 13 16 11.57 16 9.773c0-1.636-1.242-2.969-2.834-3.194C12.923 3.999 10.69 2 8 2zm2.354 4.854-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7 8.793l2.646-2.647a.5.5 0 0 1 .708.708z" />
				<path x-show="state.step !== 3" fill-rule="evenodd"
					d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
			</svg>
			<div x-show="state.saving">
				<div style="border-top-color:transparent"
					class="w-4 h-4 border-2 border-indigo-600 border-dashed rounded-full animate-spin"></div>
			</div>
		</button>

	</div>
</div>
