<?php

/**
 * Admin Settings Customize Icon
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<div class="flex items-center justify-between mb-4 border-l-4 border-indigo-600 pl-2">
	<div class="text-base font-semibold text-slate-600 block flex items-center gap-2" @click.prevent="state.hide_customize_icon = 0"><?php esc_html_e( 'Customize Icon', 'social-contact-form' ); ?></div>
	<div class="flex items-center cursor-pointer text-slate-600 px-2 py-1 rounded-md hover:bg-slate-200 transition duration-150" @click.prevent="state.hide_customize_icon = !state.hide_customize_icon">
		<span class="dashicons" :class="[!state.hide_customize_icon ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2']"></span>
	</div>
</div>

<div x-show="!state.hide_customize_icon" x-transition.opacity>
	<!-- image  -->
	<div class="mb-5" @click="upgradeModal">
		<label class="form-label">
			<span :class="not_free"> <?php esc_html_e( 'Custom Icon', 'social-contact-form' ); ?> </span>
			<ultimate-badge />
			<info-tip><?php echo wp_sprintf( '%s : %s', esc_html__( 'Recommended size for custom icon', 'social-contact-form' ), '<span class="text-sm text-slate-600">64x64</span>' ); ?></info-tip></label>
		<div :class="not_free" class="inline-flex items-center">
			<div class="w-full flex items-center justify-center gap-4">
				<div @click.prevent="uploadImage" for="scf-icon-image" class="cursor-pointer scf-input w-44 p-1.5 hover:shadow flex items-center gap-2">
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-image" viewBox="0 0 16 16">
						<path d="M6.002 5.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
						<path d="M2.002 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2h-12zm12 1a1 1 0 0 1 1 1v6.5l-3.777-1.947a.5.5 0 0 0-.577.093l-3.71 3.71-2.66-1.772a.5.5 0 0 0-.63.062L1.002 12V3a1 1 0 0 1 1-1h12z" />
					</svg> <?php esc_html_e( 'Upload Custom Icon', 'social-contact-form' ); ?>
				</div>

			</div>
			<div class="ml-2 relative flex items-center gap-2 group" x-show="options.icon.image">
				<img :src="options.icon.image" class="w-10 h-auto rounded-full">
				<span x-show="options.icon.image" x-transition @click.prevent="options.icon.image = ''" class="invisible group-hover:visible text-xs cursor-pointer bg-red-500 text-white px-2 py-0.5 rounded-md">Remove</span>
			</div>
		</div>

	</div>

	<!-- icon size  -->
	<div class="mb-5">
		<label class="form-label"><?php esc_html_e( 'Icon Size', 'social-contact-form' ); ?></label>
		<div>
			<div class="w-auto inline-flex items-center rounded-md bg-slate-100  border border-slate-200 shadow-sm">
				<template x-for="size in ['small', 'medium', 'large', 'custom']">
					<label class="px-3 py-1.5 rounded-sm capitalize border font-medium" x-text="size" :class="{
			'bg-white border-slate-100 text-indigo-600': size == options.icon.size, 
			'border-transparent text-slate-600': size != options.icon.size, 
			'opacity-60': size == 'custom'
		}" @click.prevent="setIconSize(size)"> </label>
				</template>
			</div>
		</div>
	</div>

	<!-- icon size custom  -->
	<div class="mb-5" x-show="options.icon.size == 'custom'" x-transition @click.prevent="upgradeModal" :class="not_free">
		<label for="scf-icon-size-custom" class="form-label"><?php esc_html_e( 'Custom Icon Size', 'social-contact-form' ); ?></label>

		<div class="w-64 max-w-full flex items-center gap-2">
			<span x-text="`${options.icon.size_custom || 0}px`"></span>
			<input class="scf-range" x-model="options.icon.size_custom" type="range" min='10' max="150">
		</div>
	</div>


	<!-- position  -->
	<div class="mb-5">
		<label for="whatsapp_number" class="text-sm text-slate-600 mb-1 block"><?php esc_html_e( 'Position', 'social-contact-form' ); ?></label>
		<div>
			<div class="w-auto inline-flex items-center rounded-md bg-slate-100  border border-slate-200 shadow-sm">
				<template x-for="position in ['left', 'right', 'custom']">
					<label class="px-3 py-1.5 rounded-sm capitalize border font-medium" x-text="position" :class="{
			'bg-white border-slate-100 text-indigo-600': position == options.icon.position, 
			'border-transparent': position != options.icon.position, 
			'opacity-40' : position == 'custom' && !isPro,
		}" @click.prevent="setIconPosition(position)"> </label>
				</template>
			</div>
		</div>
	</div>

	<!-- custom position  -->
	<div @click="upgradeModal" class="mb-5" x-show="options.icon.position == 'custom'" x-transition>
		<label class="form-label"><?php esc_html_e( 'Custom position', 'social-contact-form' ); ?></label>
		<div :class="not_free" class="grid grid-cols-2 gap-2  justify-between text-sm">
			<!-- top  -->
			<div class="flex items-center gap-2">
				<label class="form-label w-12"><?php esc_html_e( 'Top', 'social-contact-form' ); ?></label>
				<div class="flex items-center gap-1">
					<input placeholder="<?php esc_html_e( 'Top', 'social-contact-form' ); ?>" type="number" class="w-16 scf-input" x-model="options.icon.position_top">
					<span class="text-slate-500">px</span>
				</div>
			</div>
			<!-- left  -->
			<div class="flex items-center gap-2">
				<label class="form-label w-12"><?php esc_html_e( 'Left', 'social-contact-form' ); ?></label>
				<div class="flex items-center gap-1">
					<input placeholder="<?php esc_html_e( 'Left', 'social-contact-form' ); ?>" type="number" class="w-16 scf-input" x-model="options.icon.position_left">
					<span class="text-slate-500">px</span>
				</div>
			</div>

			<!-- right  -->
			<div class="flex items-center gap-2">
				<label class="form-label w-12"><?php esc_html_e( 'Right', 'social-contact-form' ); ?></label>
				<div class="flex items-center gap-1">
					<input placeholder="<?php esc_html_e( 'Right', 'social-contact-form' ); ?>" type="number" class="w-16 scf-input" x-model="options.icon.position_right">
					<span class="text-slate-500">px</span>
				</div>
			</div>

			<!-- bottom  -->
			<div class="flex items-center gap-2">
				<label class="form-label w-12"><?php esc_html_e( 'Bottom', 'social-contact-form' ); ?></label>
				<div class="flex items-center gap-1">
					<input placeholder="<?php esc_html_e( 'Bottom', 'social-contact-form' ); ?>" type="number" class="w-16 scf-input" x-model="options.icon.position_bottom">
					<span class="text-slate-500">px</span>
				</div>
			</div>

		</div>
	</div>
</div>
