<?php

/**
 * Admin Settings Customize Form
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<div x-ref="customize_form" class="flex items-center justify-between mb-4 border-l-4 border-indigo-600 pl-2"
	@scroll.window="handlerPreviewScreen">
	<div class="text-base font-semibold text-slate-600 block" @click.prevent="state.hide_customize_form = 0">
		<?php esc_html_e( 'Customize Form', 'social-contact-form' ); ?></div>
	<div class="flex items-center cursor-pointer text-slate-600 px-2 py-1 rounded-md hover:bg-slate-200 transition duration-150"
		@click.prevent="state.hide_customize_form = !state.hide_customize_form">
		<span class="dashicons"
			:class="[!state.hide_customize_form ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2']"></span>
	</div>
</div>


<div x-show="!state.hide_customize_form" x-transition.opacity>
	<!-- form selection for social-contact-form -->
	<?php scf_render( 'admin/settings/contact-form-7' ); ?>
	<!-- CF7 END-->

	<!-- Mail  -->
	<div class="mb-5" @click="upgradeModal">
		<!-- <label for="mail_title" :class="not_free"
			class="form-label"><?php esc_html_e( 'Receive Mail', 'social-contact-form' ); ?></label> -->
		<div class="scf-switch"
			@click.prevent="options.contact_form_7.activemail = !not_free && is_true(options.contact_form_7.activemail) ? false : true"
			:class="[ !not_free && is_true(options.contact_form_7.activemail) ? 'active' : 'inactive']">
			<div></div>
			<label :class="not_free"><?php esc_html_e( 'Receive leads via email', 'social-contact-form' ); ?></label>
			<info-tip>
				<?php esc_html_e( 'Enable this option to receive all lead information to your given email address', 'social-contact-form' ); ?>
			</info-tip>

			<!-- Badge  -->
			<span class="scf_ultimate_badge" @click="upgradeModal">
				<ultimate-badge />
			</span>
			<span class="scf_new_badge">
				<new-badge style="background-color: rgb(9, 129, 109); color: rgb(255, 255, 255);"
					class="px-1.5 py-0.5 text-xs text-white rounded-xl">New</new-badge>
			</span>
		</div>

		<div class="mb-5 " x-show="!not_free && options.contact_form_7.activemail.toString() == 'true'">

			<div id="cf7context"
				x-data="{ confirmationstateofCustommail: options.contact_form_7.confirmationstateofCustommail }"
				x-init="confirmationstateofCustommail = options.contact_form_7.confirmationstateofCustommail.toString()">

				<div class="scf-mail-confirmation flex">
					<input type="checkbox" id="cf7checkboxContainer" x-model="confirmationstateofCustommail"
						class="mr-2 mt-1" :checked="confirmationstateofCustommail == 'true'"
						x-on:change="options.contact_form_7.confirmationstateofCustommail = confirmationstateofCustommail.toString()">

					<label for="leads_mail"
						class="form-label mt-1"><?php esc_html_e( 'Use admin email to receive leads', 'social-contact-form' ); ?>
						<!-- <info-tip>
					<?php esc_html_e( "Add email only if you don't want to use default admin mail. This will send all the leads in your given mail.", 'social-contact-form' ); ?>
					 </info-tip> -->
					</label>

				</div>

				<div class="leads_custom_mail mt-2">
					<input id="leads_mail"
						placeholder="<?php esc_html_e( 'Enter your preferred email address to receive WhatsApp leads', 'social-contact-form' ); ?>"
						type="text" class="w-full scf-input"
						x-model="options.contact_form_7.confirmationstateofCustommail.toString() === 'true' ? options.contact_form_7.defaultmail : options.contact_form_7.cf7mail"
						:style="{ border: options.contact_form_7.confirmationstateofCustommail.toString() === 'false' ? (isValidGmail(options.contact_form_7.cf7mail) ? '1px solid blue' : '1px solid red') : '' }"
						:readonly="options.contact_form_7.confirmationstateofCustommail.toString() === 'true'"
						:disabled="options.contact_form_7.confirmationstateofCustommail.toString() === 'true'"
						pattern="[a-zA-Z0-9._%+-]+@gmail\.com" title="Please enter a valid Gmail address">

				</div>

				<p class="form-label mt-1 italic text-gray-700">
					<?php esc_html_e('Note: Please configure any SMTP e.g.', 'social-contact-form'); ?>
					<a href="<?php echo esc_url(admin_url('plugin-install.php?s=SMTP&tab=search&type=term')); ?>"
						class="text-blue-500 underline"
						target="_blank"><?php esc_html_e( 'WP Mail SMTP', 'social-contact-form' ); ?></a>
					<?php esc_html_e('or', 'social-contact-form'); ?>
					<a href="<?php echo esc_url(admin_url('plugin-install.php?s=SMTP&tab=search&type=term')); ?>"
						class="text-blue-500 underline"
						target="_blank"><?php esc_html_e( 'FluentSMTP', 'social-contact-form' ); ?></a>
					<?php esc_html_e('plugin to receive mail.', 'social-contact-form'); ?>
				</p>

			</div>
		</div>

	</div>


	<!-- form header text  -->
	<div class="mb-5">
		<label for="form_title" class="form-label"><?php esc_html_e( 'Form Title', 'social-contact-form' ); ?></label>
		<input id="form_title"
			placeholder="<?php esc_html_e( 'Form Title (Ex: Contact via WhatsApp)', 'social-contact-form' ); ?>"
			type="text" class="w-full scf-input" x-model="options.form.title">
	</div>

	<!-- form header description  -->
	<div class="mb-5">
		<label for="form_header" class="form-label"><?php esc_html_e( 'Header Text', 'social-contact-form' ); ?></label>
		<textarea id="form_header"
			placeholder="<?php esc_html_e( 'Header Text (Ex: Please fill up the fields below)', 'social-contact-form' ); ?>"
			type="text" class="w-full scf-input p-2 px-3" x-model="options.form.header"></textarea>
		<!-- <textarea id="form_header" placeholder="<?php esc_html_e( 'Header Text (Ex: Please fill up the fields below)', 'social-contact-form' ); ?>" type="text" class="w-full scf-input p-2 px-3" x-model="options.test.testheader"></textarea> -->
	</div>

	<!-- form footer description  -->
	<div class="mb-5">
		<label for="form_footer" class="form-label"><?php esc_html_e( 'Footer Text', 'social-contact-form' ); ?></label>
		<textarea id="form_footer"
			placeholder="<?php esc_html_e( 'Footer Text (Ex: Powered by Social Contact Form', 'social-contact-form' ); ?>"
			type="text" class="w-full scf-input p-2 px-3" x-model="options.form.footer"></textarea>
	</div>

	<!-- form submit button text  -->
	<div class="mb-5">
		<label for="form_submit"
			class="form-label"><?php esc_html_e( 'Submit Button Text', 'social-contact-form' ); ?></label>
		<input id="form_submit"
			placeholder="<?php esc_html_e( 'Button Text (Ex: Send on WhatsApp)', 'social-contact-form' ); ?>"
			type="text" class="w-full scf-input" x-model="options.form.submit">
	</div>

	<!-- form number button NEW WORK  -->
	<div class="mb-5" @click="upgradeModal" x-data="{ allow_country_selection: options.form.allow_country_selection }"
		x-init="allow_country_selection = options.form.allow_country_selection.toString();">
		<div class="w-full scf-country-code-feature" style="display: flex; gap: 5px;">

			<div :class="not_free" x-data="{ allow_country_selection: options.form.allow_country_selection }"
				x-init="allow_country_selection = options.form.allow_country_selection.toString(); options.form.allow_country_selection = not_free ? false : options.form.allow_country_selection.toString();">

				<div class="scf-switch"
					@click.prevent="options.form.allow_country_selection = !not_free && is_true(options.form.allow_country_selection) ? false : true"
					:class="[ !not_free && is_true(options.form.allow_country_selection) ? 'active' : 'inactive']">
					<div></div>
					<label><?php esc_html_e( 'Allow users to select country code', 'social-contact-form' ); ?></label>
					<info-tip>
						<?php esc_html_e( 'This will add country code with number to choose.', 'social-contact-form' ); ?>
					</info-tip>
				</div>
			</div>
			<span class="scf_ultimate_badge" @click="upgradeModal">
				<ultimate-badge />
			</span>
			<span class="scf_new_badge">
				<new-badge style="background-color: rgb(9, 129, 109); color: rgb(255, 255, 255);"
					class="px-1.5 py-0.5 text-xs text-white rounded-xl">New</new-badge>
			</span>
		</div>

		<!-- Here pl-12  -->
		<div class="w-full" @click="upgradeModal"
			x-show="!not_free && options.form.allow_country_selection.toString() == 'true'" x-transition>

			<div class="w-full flex items-center scf-default-country-code">
				<label for="whatsapp_number" :class="not_free" class="form-label"
					style="white-space: nowrap;"><?php esc_html_e( 'Choose default country', 'social-contact-form' ); ?></label>
				<div x-show="state.showCountryList" class="absolute top-0 left-0 w-full h-full z-10"
					@click.prevent="state.showCountryList = false"></div>
				<div class="relative" :class="not_free">
					<div class="pl-3 py-3 pr-2">
						<button class="scf-input px-2 block py-2 h-10 sm:h-9 flex items-center gap-1 font-medium"
							@click.prevent="state.showCountryList = !state.showCountryList; setTimeout(() => {$refs.search_country.focus()}, 50)">
							<span x-show="defaultCountry" x-html="defaultCountry.emoji || ''">🇦🇫</span>
							<span x-show="defaultCountry"
								x-text="defaultCountry.phone_code ? defaultCountry.phone_code : '44'"></span>
							<span x-show="!defaultCountry"
								class="italic text-indigo-600"><?php esc_html_e( 'Select a country', 'social-contact-form' ); ?></span>
						</button>
					</div>
					<div x-show="state.showCountryList" x-transition.opacity
						class="absolute z-50 bg-white rounded-md w-64 h-56 overflow-y-auto mt-2 shadow-lg z-10 scrollbar scrollbar-thin scrollbar-track-slate-200 scrollbar-thumb-indigo-600">
						<!-- search  -->
						<div class="p-1 w-full pr-3">
							<input x-ref="search_country" x-model="state.search_country" class="scf-input w-full"
								@keydown.enter="options.form.phone_code = countries[0].phone_code; state.showCountryList = false"
								type="text"
								placeholder="<?php esc_html_e( 'Search country', 'social-contact-form' ); ?>">
						</div>
						<template x-for="dfcountry in countries">
							<label
								@click.prevent="options.form.phone_code = dfcountry.phone_code; state.showCountryList = false; options.form.phone_emoji = dfcountry.emoji;"
								class="flex items-center py-2 px-4 hover:bg-gray-100">
								<span
									x-html="`${dfcountry.emoji} (${dfcountry.phone_code}) - ${dfcountry.name}`"></span>
							</label>
						</template>
					</div>
				</div>
				<!-- <ultimate-badge/> -->
			</div>

			<!-- </div> -->
		</div>

	</div>
	<!-- End  -->

	<!-- call to action text style  -->
	<div @click="upgradeModal" class="mb-5">
		<label class="form-label">
			<span :class="not_free"><?php esc_html_e( 'Form Style', 'social-contact-form' ); ?> </span>
			<ultimate-badge />
		</label>
		<div :class="not_free" class="w-full flex items-center gap-4">
			<div class="w-full flex items-center gap-4">
				<label for="form_color"
					class="cursor-pointer scf-input w-32 p-1.5 hover:shadow flex items-center gap-2">
					<input type="color" id="form_color" class="invisible w-0 h-0" x-model="options.form.color">
					<span class="w-4 h-4 rounded-full shadow" :style="{background: options.form.color}"></span>
					<?php esc_html_e( 'Text Color', 'social-contact-form' ); ?>
				</label>
				<label for="form_background"
					class="cursor-pointer scf-input w-32 p-1.5 hover:shadow flex items-center gap-2">
					<input type="color" id="form_background" class="invisible w-0 h-0"
						x-model="options.form.background">
					<span class="w-4 h-4 rounded-full shadow" :style="{background: options.form.background}"></span>
					<?php esc_html_e( 'Background', 'social-contact-form' ); ?>
				</label>

			</div>
		</div>
	</div>


	<!-- form size  -->
	<div class="mb-5">
		<label class="form-label"><?php esc_html_e( 'Form Size', 'social-contact-form' ); ?></label>
		<div>
			<div class="w-auto inline-flex items-center rounded-md bg-slate-100  border border-slate-200 shadow-sm">
				<template x-for="size in ['small', 'medium', 'large', 'custom']">
					<label class="px-3 py-1.5 rounded-sm capitalize border font-medium" x-text="size" :class="{
			'bg-white border-slate-100 text-indigo-600': size == options.form.size, 
			'border-transparent': size != options.form.size, 
			'opacity-40' : size == 'custom' && !isPro,
		}" @click.prevent="setFormSize(size)"> </label>
				</template>
			</div>
		</div>
	</div>


	<!-- custom form size  -->
	<div class="mb-5" x-show="options.form.size == 'custom'" x-transition @click.prevent="upgradeModal"
		:class="not_free">
		<label class="form-label"><?php esc_html_e( 'Custom Size', 'social-contact-form' ); ?></label>
		<div class="flex items-center gap-1">
			<span class="text-slate-400 text-sm"><?php esc_html_e( 'Width', 'social-contact-form' ); ?></span>
			<input class="scf-input w-20" x-model="options.form.size_custom" type="number" min="250" max="650" step=""
				placeholder="<?php esc_html_e( 'Form Width', 'social-contact-form' ); ?>">
			<span class="text-slate-400 text-sm"><?php esc_html_e( 'px', 'social-contact-form' ); ?></span>
		</div>
	</div>

	<!-- select font family from dropdown -->
	<div class="mb-5">
		<label for="font_family" class="form-label"><?php esc_html_e( 'Font Family', 'social-contact-form' ); ?></label>
		<div class="w-full inline-flex items-center gap-2">
			<div class="w-1/2 inline-flex items-center justify-end gap-2">
				<?php $font_family = WPPOOL\SCF\App::fonts(); ?>
				<select class="w-full scf-input" x-model="options.form.font">
					<?php
					if ( $font_family ) {
						$current = 0;
						foreach ( $font_family as $key => $value ) {
							$current++;
							$disabled = $current > 14 && ! is_scf_ultimate() ? 'disabled' : ''; // <ultimate-badge />
							$badge = $current > 14 && ! is_scf_ultimate() ? 'Ultimate' : '';
							$after    = $current > 14 && ! is_scf_ultimate() ? '<ultimate-badge/>' : '';
							echo '<option class="' . esc_html( $badge ) . '" value="' . esc_attr( $key ) . '" ' . esc_attr( $disabled ) . '>' . esc_html( $value) . wp_kses_post( $after ) . '</option>';
						}
					}
					?>
				</select>
			</div>
		</div>
	</div>
</div>
