<?php

/**
 * Admin Settings Customize Call to Action
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>

<div class="flex items-center justify-between mb-4 border-l-4 border-indigo-600 pl-2">
	<div class="text-base font-semibold text-slate-600 block" @click.prevent="state.hide_customize_cta = 0"><?php esc_html_e( 'Call to action', 'social-contact-form' ); ?></div>
	<div class="flex items-center cursor-pointer text-slate-600 px-2 py-1 rounded-md hover:bg-slate-200 transition duration-150" @click.prevent="state.hide_customize_cta = !state.hide_customize_cta">
		<span class="dashicons" :class="[!state.hide_customize_cta ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2']"></span>
	</div>
</div>


<div x-show="!state.hide_customize_cta" x-transition.opacity>

	<!-- call to action text  -->
	<div class="mb-5">
		<label for="call_to_action_text" class="form-label"><?php esc_html_e( 'Call to action text', 'social-contact-form' ); ?></label>
		<input id="call_to_action_text" placeholder="<?php esc_html_e( 'Call to action text', 'social-contact-form' ); ?>" type="text" class="w-full scf-input" x-model="options.call_to_action.text">
		<div class="form-help"><?php esc_html_e( 'Leave blank to hide call to action text', 'social-contact-form' ); ?></div>
	</div>

	<!-- call to action text style  -->
	<div @click="upgradeModal" class="mb-5" x-show="options.call_to_action.text" x-transition>
		<label class="form-label">
			<span :class="not_free"><?php esc_html_e( 'Call to action style', 'social-contact-form' ); ?></span>
			<ultimate-badge /></label>
		<div :class="not_free" class="w-full flex items-center gap-4">
			<div class="w-full flex items-center gap-4">
				<label for="call_to_action_text_color" class="cursor-pointer scf-input w-32 p-1.5 hover:shadow flex items-center gap-2">
					<input type="color" id="call_to_action_text_color" class="invisible w-0 h-0" x-model="options.call_to_action.color">
					<span class="w-4 h-4 rounded-full shadow" :style="{background: options.call_to_action.color}"></span> <?php esc_html_e( 'Text Color', 'social-contact-form' ); ?>
				</label>
				<label for="call_to_action_text_background" class="cursor-pointer scf-input w-32 p-1.5 hover:shadow flex items-center gap-2">
					<input type="color" id="call_to_action_text_background" class="invisible w-0 h-0" x-model="options.call_to_action.background">
					<span class="w-4 h-4 rounded-full shadow" :style="{background: options.call_to_action.background}"></span> <?php esc_html_e( 'Background', 'social-contact-form' ); ?>
				</label>

			</div>
		</div>
	</div>

	<!-- call to action text size -->
	<div class="mb-5">
		<label for="call_to_action_text_size" class="form-label"><?php esc_html_e( 'Text size', 'social-contact-form' ); ?></label>
		<div>
			<div class="w-auto inline-flex items-center rounded-md bg-slate-100  border border-slate-200 shadow-sm">
				<template x-for="size in ['small', 'medium', 'large', 'custom']">
					<label class="px-3 py-1.5 rounded-sm capitalize border font-medium" x-text="size" :class="{
			'bg-white border-slate-100 text-indigo-600': size == options.call_to_action.size, 
			'border-transparent': size != options.call_to_action.size, 
			'opacity-40' : size == 'custom' && !isPro,
		}" @click.prevent="setTextSize(size)"> </label>
				</template>
			</div>
		</div>
	</div>

	<!-- text size custom  -->
	<div class="mb-5" x-show="options.call_to_action.size == 'custom'" x-transition @click.prevent="upgradeModal" :class="not_free">
		<label class="form-label"><?php esc_html_e( 'Custom Text Size', 'social-contact-form' ); ?></label>

		<div class="w-64 max-w-full flex items-center gap-2">
			<span x-text="`${options.call_to_action.size_custom || 0}px`"></span>
			<input class="scf-range" x-model="options.call_to_action.size_custom" type="range" min='4' max="90">
		</div>
	</div>
</div>
