<?php

/**
 * Admin Settings Customize Behavior
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<div class="flex items-center justify-between mb-4 border-l-4 border-indigo-600 pl-2">
	<div class="text-base font-semibold text-slate-600 block" @click.prevent="state.hide_customize_behavior = 0"><?php esc_html_e( 'Form Behavior', 'social-contact-form' ); ?></div>
	<div class="flex items-center cursor-pointer text-slate-600 px-2 py-1 rounded-md hover:bg-slate-200 transition duration-150" @click.prevent="state.hide_customize_behavior = !state.hide_customize_behavior">
		<span class="dashicons" :class="[!state.hide_customize_behavior ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2']"></span>
	</div>
</div>


<div x-show="!state.hide_customize_behavior" x-transition.opacity>
	<!-- open by default  -->
	<div class="scf-switch" @click.prevent="options.form.open_by_default = is_true(options.form.open_by_default) ? false : true" :class="[ is_true(options.form.open_by_default) ? 'active' : 'inactive']">
		<div></div>
		<label><?php esc_html_e( 'Open by default', 'social-contact-form' ); ?></label>
		<info-tip><?php esc_html_e( 'Open the form by default when the page is loaded.', 'social-contact-form' ); ?></info-tip>
	</div>

	<!-- close on submit  -->

	<div class="scf-switch" @click.prevent="options.form.close_on_submit = is_true(options.form.close_on_submit) ? false : true" :class="[is_true(options.form.close_on_submit) ? 'active' : 'inactive']">
		<div></div>
		<label><?php esc_html_e( 'Close on Submit', 'social-contact-form' ); ?></label>
		<info-tip><?php esc_html_e( 'Close the form after a successful submission.', 'social-contact-form' ); ?></info-tip>
	</div>

	<!-- open in a new tab  -->


	<div class="scf-switch" @click.prevent="options.form.open_in_new_tab = is_true(options.form.open_in_new_tab) ? false : true" :class="[is_true(options.form.open_in_new_tab) ? 'active' : 'inactive']">
		<div></div>
		<label><?php esc_html_e( 'Open WhatsApp in a new tab', 'social-contact-form' ); ?></label>
		<info-tip><?php esc_html_e( 'Open the WhatsApp link in a new tab on Desktop.', 'social-contact-form' ); ?></info-tip>
	</div>
</div>
