<?php

/**
 * Admin Settings Contact Form 7
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>

<div class="cf7-form-scf"
	x-data="{ expanded: false, showModal: false, cf7Installed: false, cf7NotActivated: false, forms: [], selected: options.contact_form_7.selectedmode, modepress: options.contact_form_7.modepress, cf7NotActivated:options.contact_form_7.cf7NotActivated }"
	x-init="async () => {
				setInterval(async () => {
					try {
						const response = await fetch(`${scf_admin.ajax_url}?action=scf_is_cf7_installed`);
						const data = await response.json();
						forms = data;
						
						if (Array.isArray(data)) {
							cf7Installed = true;
							cf7NotActivated = false;
							options.contact_form_7.cf7NotActivated = false;
							options.contact_form_7.cf7Installed = true;
							

						} else if (data === 'inactive') {
							cf7Installed = false;
							cf7NotActivated = true;
							options.contact_form_7.cf7NotActivated = true;
							options.contact_form_7.cf7Installed = true;


						} else {
							cf7Installed = false;
							cf7NotActivated = false;
							options.contact_form_7.cf7Installed = false;
						}

					} catch (error) {
						console.error(error);
					}
				}, 2000);

			}">
	<label
		class="selection-label"><?php esc_html_e( 'Choose the source through which you want to send message to WhatsApp', 'social-contact-form' ); ?></label>
	<!-- form.formmode -->
	<div x-data="{ selected: options.contact_form_7.selectedmode, modepress: options.contact_form_7.modepress }">
		<div class="flex gap-3 mt-3 mb-3 w-35" style="width:395px;">

			<div x-on:click="selected = 'scf'; options.contact_form_7.selectedmode = 'scf'; modepress = 'scf'; options.contact_form_7.modepress= 'scf'; localStorage.setItem('activeTab', 'scfTab')"
				class="flex flex-col relative w-161 h-200 border-gray-500 border-2 rounded-lg  p-4 text-center flex justify-center items-center hover:cursor-pointer"
				:class="{ 'border-green-700': options.contact_form_7.modepress != 'cf7' || options.contact_form_7.cf7NotActivated }">
				<!-- default text for SCF -->
				<p class="absolute top-0 left-0 bottom-2 ml-2 mt-2 text-sm text-gray-400 h-26 bg-cfcfcf text-302f2f w-57 rounded-full"
					style="height: 20px; background: rgb(247, 245, 245); color: rgb(114, 111, 111); width: 57px; border-radius: 10px;">
					<?php esc_html_e( 'default', 'social-contact-form' ); ?></p>

				<!-- select icon -->
				<svg x-show="options.contact_form_7.modepress != 'cf7' || options.contact_form_7.cf7NotActivated"
					class="absolute right-0 top-0 mr-2 mt-2 text-gray-400" xmlns="http://www.w3.org/2000/svg"
					viewBox="0 0 48 48" width="18px" height="18px">
					<path fill="green"
						d="M44,24c0,11.045-8.955,20-20,20S4,35.045,4,24S12.955,4,24,4S44,12.955,44,24z" />
					<path fill="white"
						d="M34.586,14.586l-13.57,13.586l-5.602-5.586l-2.828,2.828l8.434,8.414l16.395-16.414L34.586,14.586z" />
				</svg>
				<div class="scf-form-selection" x-show="form.scfimage">
					<img class="w-40 h-100 mx-auto max-w-30 h-auto" :src="form.scfimage" alt="">
				</div>
				<!-- images -->
				<p class="scf-form-title text-xs"><?php esc_html_e( 'Social Contact Form', 'social-contact-form' ); ?>
				</p>
			</div>

			<div x-on:click="if (!options.contact_form_7.cf7NotActivated) { selected = 'cf7'; options.contact_form_7.selectedmode = 'cf7';}
   modepress = 'cf7'; options.contact_form_7.modepress= 'cf7'; localStorage.setItem('activeTab', 'cf7Tab'); expanded = true"
				class="flex flex-col relative w-161 h-200 border-gray-500 border-2 rounded-lg p-4 text-center flex justify-center items-center hover:cursor-pointer"
				:class="{ 'border-green-700': options.contact_form_7.modepress != 'scf' && !options.contact_form_7.cf7NotActivated }">

				<!-- default text  For CF7-->
				<p class="absolute right-0 top-0 ml-2 mt-2 text-sm text-gray-400 mr-2"
					x-show="options.contact_form_7.modepress != 'scf' && !options.contact_form_7.cf7NotActivated">
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48" width="18px" height="18px">
						<path fill="green"
							d="M44,24c0,11.045-8.955,20-20,20S4,35.045,4,24S12.955,4,24,4S44,12.955,44,24z" />
						<path fill="white"
							d="M34.586,14.586l-13.57,13.586l-5.602-5.586l-2.828,2.828l8.434,8.414l16.395-16.414L34.586,14.586z" />
					</svg>
				</p>
				<!-- images -->
				<div class="cf7-form-selection" x-show="form.cf7image">
					<img class="w-40 h-100 mx-auto max-w-30 h-auto" :src="form.cf7image" alt="">
				</div>
				<!-- images -->
				<p class="cf7-form-title text-xs"><?php esc_html_e( 'Contact Form 7', 'social-contact-form' ); ?></p>
			</div>

		</div>
		<!-- Show Form and alert plugin is not installed  -->
		<template x-if="cf7Installed && forms.length > 0">
			<div x-show="options.contact_form_7.modepress != 'scf' "
				class="rounded-md transform transition ease-out duration-500" style="transform: translateY(-50px);"
				x-transition:enter="transition ease-out duration-500"
				x-transition:enter-start="opacity-0 transform translate-y-2"
				x-transition:enter-end="opacity-100 transform translate-y-0"
				x-transition:leave="transition ease-out duration-500"
				x-transition:leave-start="opacity-100 transform translate-y-0"
				x-transition:leave-end="opacity-0 transform translate-y-2">

				<!-- Conditionally show form list item and selected one  -->
				<div class="text-gray-900 antialiased font-sans"
					x-data="{ open: false, selectedForm:null, title:null }">
					<label id="assigned-to-label"
						class="block text-sm leading-5 font-medium text-gray-700"><?php esc_html_e( 'Select Contact Form', 'social-contact-form' ); ?>
						<info-tip>
							<?php esc_html_e( 'Go to Contact Form 7 plugin and select your desired contact from. Then go to "Social Contact Form" tab to setup your WhatsApp account.', 'social-contact-form' ); ?>
						</info-tip>
					</label>

					<!-- New Dropdown with select field  -->
					<div class="flex">
						<!-- <div class="flex" x-data="{ options.contact_form_7.configurationformname }"> -->
						<!-- <div class="flex" x-data="{ options: { contact_form_7: { configurationformname: '' } } }"> -->
						<template x-if="!open">
							<select x-model="selectedForm" aria-labelledby="assigned-to-label"
								class="w-30 cursor-default relative rounded-md border border-gray-300 bg-white pl-3 pr-10 py-2 text-left hover:cursor-pointer hover:bg-gray-200 hover:text-gray-700 focus:outline-none focus:shadow-outline-blue focus:border-blue-300 transition ease-in-out duration-150 sm:text-sm sm:leading-5 mt-1 mb-1"
								style="width: 250px" x-on:input="
								selectedForm = $event.target.value;
								open = false;
								loadOptions($event.target.selectedIndex, $event.target.value);
								options.contact_form_7.selectedid = $event.target.value;
								title = $event.target.options[$event.target.selectedIndex].getAttribute('data-title');
								options.contact_form_7.configurationformname = title;
								localStorage.setItem('selectedForm', JSON.stringify({ id: $event.target.value, title: title }));
							">
								<option class="hidden"
									:value="JSON.parse(localStorage.getItem('selectedForm')) ? JSON.parse(localStorage.getItem('selectedForm')).id : 'null'"
									x-text="options.contact_form_7.configurationformname ? options.contact_form_7.configurationformname : 'Choose your form'">
								</option>
								<template x-for="(form, index) in forms" :key="index">
									<option :data-title="form.title" :id="form.id" :value="form.id" x-text="form.title">
									</option>
								</template>
							</select>
						</template>

						<template x-if="options.contact_form_7.configurationformname.length > 0">
							<button type="button" x-show="options.contact_form_7.configurationformname.length > 0"
								class="flex flex-row text-center items-center gap-2 w-30 cursor-default relative rounded-md border border-gray-300 bg-indigo-600 text-white ml-3 pl-3 pr-10 py-2 text-left hover:cursor-pointer hover:bg-indigo-700 hover:text-white-700"
								style="padding-top: 9px; height: 38px; margin-top:4px"
								x-on:click="window.open('<?php echo esc_url( admin_url( 'admin.php?page=wpcf7&post=' ) ); ?>' + (options.contact_form_7.selectedid ? options.contact_form_7.selectedid : '') + '&action=edit', '_blank')">
								<!-- Setting icon  -->
								<svg fill="#ffffff" height="15px" width="15px" version="1.1" id="Capa_1"
									xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
									viewBox="0 0 291.957 291.957" xml:space="preserve" stroke="#ffffff">
									<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
									<g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
									<g id="SVGRepo_iconCarrier">
										<path
											d="M283.07,168.875l-17.106-9.876c0.461-4.279,0.704-8.622,0.704-13.02s-0.243-8.742-0.704-13.021l17.106-9.876 c3.655-2.11,6.27-5.519,7.363-9.598c1.092-4.078,0.531-8.338-1.58-11.994l-32.908-57.001c-2.816-4.878-8.067-7.907-13.705-7.907 c-2.759,0-5.485,0.734-7.887,2.12l-17.155,9.905c-6.973-5.114-14.51-9.497-22.503-13.037V15.807C194.695,7.091,187.604,0,178.889,0 h-65.82c-8.716,0-15.807,7.091-15.807,15.807V35.57c-7.993,3.54-15.531,7.924-22.503,13.038l-17.155-9.904 c-2.401-1.387-5.128-2.121-7.887-2.121c-5.638,0-10.889,3.029-13.705,7.907L3.103,101.49c-2.111,3.655-2.672,7.916-1.58,11.994 c1.094,4.079,3.708,7.487,7.363,9.598l17.106,9.876c-0.461,4.279-0.704,8.622-0.704,13.021s0.243,8.742,0.704,13.02l-17.106,9.876 c-3.655,2.11-6.269,5.518-7.363,9.598c-1.092,4.078-0.531,8.339,1.58,11.994l32.908,57.001c2.816,4.878,8.067,7.907,13.705,7.907 c2.759,0,5.485-0.733,7.887-2.12l17.155-9.905c6.973,5.114,14.51,9.497,22.503,13.037v19.764c0,4.222,1.644,8.19,4.631,11.176 c2.985,2.985,6.955,4.63,11.176,4.63h65.82c8.715,0,15.807-7.09,15.807-15.806v-19.764c7.992-3.541,15.53-7.923,22.502-13.037 l17.156,9.904c2.401,1.387,5.128,2.12,7.887,2.12c5.638,0,10.889-3.029,13.705-7.907l32.908-57.001 c2.111-3.655,2.672-7.916,1.58-11.994C289.34,174.393,286.726,170.985,283.07,168.875z M145.979,201.668 c-30.756,0-55.689-24.934-55.689-55.689s24.934-55.689,55.689-55.689s55.689,24.934,55.689,55.689S176.734,201.668,145.979,201.668z ">
										</path>
									</g>
								</svg>
								<?php esc_html_e( 'Configure', 'social-contact-form' ); ?>
							</button>
						</template>
					</div>

					<!-- END  -->

					<!-- Checkbox for confirmation -->
					<div class="flex items-center mt-2 mb-3" id="cf7context"
						x-data="{ confirmationstateofCF7: options.contact_form_7.confirmationstateofCF7 }"
						x-init="confirmationstateofCF7 = options.contact_form_7.confirmationstateofCF7.toString()">
						<input type="checkbox" id="cf7checkboxContainer" x-model="confirmationstateofCF7"
							class="mr-2 mt-1" :checked="confirmationstateofCF7 == 'true'"
							x-on:change="options.contact_form_7.confirmationstateofCF7 = confirmationstateofCF7.toString()">

						<!-- Video and checkbox confirmation  -->

						<div class="scf_video_template flex mt-1">
							<label for="cf7checkboxContainer"><strong>
									<?php esc_html_e( "I've configured ", 'social-contact-form' ); ?></strong>
								<span>the</span>
								<span
									x-text="`'${options.contact_form_7.configurationformname ? options.contact_form_7.configurationformname : 'Contact Form'}'`"></span>
								<?php esc_html_e( ' form. ', 'social-contact-form' ); ?>
							</label>
							<div class="flex items-center">
								<a class="ml-1 text-indigo-900 hover:underline font-bold" href="#"
									x-on:click.prevent="showModal = true">
									<svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 inline-block text-indigo-600"
										style="fill: #6610f2;" id="video" x="0" y="0" version="1.1" viewBox="0 0 29 29"
										xml:space="preserve">
										<path
											d="M17 21.5H4a2 2 0 01-2-2v-10a2 2 0 012-2h13a2 2 0 012 2v10a2 2 0 01-2 2zM21 11.5v6l4.445 2.964A1 1 0 0027 19.631V9.369a1 1 0 00-1.555-.832L21 11.5z">
										</path>
									</svg>
									<span class="ml-1 text-indigo-600"
										style="font-size: 12px;"><?php esc_html_e( 'Watch tutorial', 'social-contact-form' ); ?></span>
								</a>
							</div>
						</div>

						<!-- Here  -->

					</div>

				</div>
				<!-- End here  -->
		</template>

		<template x-if="cf7Installed && forms.length === 0">
			<!-- <div x-show="expanded && selected != 'scf'"  -->
			<div x-show="options.contact_form_7.modepress != 'scf'"
				class="p-4 rounded-md mb-2 mt-2 transform transition ease-out duration-500 rounded-md bg-slate-100  border border-slate-200 shadow-sm"
				style="transform: translateY(-50px);" x-transition:enter="transition ease-out duration-500"
				x-transition:enter-start="opacity-0 transform translate-y-2"
				x-transition:enter-end="opacity-100 transform translate-y-0"
				x-transition:leave="transition ease-out duration-500"
				x-transition:leave-start="opacity-100 transform translate-y-0"
				x-transition:leave-end="opacity-0 transform translate-y-2">
				<p><?php esc_html_e( 'Contact Form 7 is activate but has no forms.', 'social-contact-form' ); ?></p>
			</div>
		</template>

		<!-- If not installed  -->
		<template x-if="!cf7Installed && !cf7NotActivated">
			<div x-show="options.contact_form_7.modepress != 'scf'"
				class="p-4 rounded-md mb-2 mt-2 transform transition ease-out duration-500 rounded-md bg-slate-100 border border-slate-200 shadow-sm"
				style="transform: translateY(-50px);" x-transition:enter="transition ease-out duration-500"
				x-transition:enter-start="opacity-0 transform translate-y-2"
				x-transition:enter-end="opacity-100 transform translate-y-0"
				x-transition:leave="transition ease-out duration-500"
				x-transition:leave-start="opacity-100 transform translate-y-0"
				x-transition:leave-end="opacity-0 transform translate-y-2">

				<div class="flex items-center justify-center space-x-4">
					<svg class="svg-icon"
						style="width: 3em; height: 3em;vertical-align: middle;fill: currentColor;overflow: hidden;"
						viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg">
						<path
							d="M509.57653367 31.675733a477.866667 477.866667 0 1 0 0 955.733334 477.866667 477.866667 0 0 0 0-955.733334m0 51.2a427.144533 427.144533 0 0 1 426.666666 426.666667 427.144533 427.144533 0 0 1-426.666666 426.666667 427.144533 427.144533 0 0 1-426.666667-426.666667 427.144533 427.144533 0 0 1 426.666667-426.666667"
							fill="#515151" />
						<path
							d="M483.97653367 241.2544a25.6 25.6 0 0 1 51.2 0v373.418667a25.6 25.6 0 0 1-51.2 0v-373.418667z"
							fill="#515151" />
						<path
							d="M546.91839967 750.045867a37.341867 37.341867 0 1 1-74.683733 0 37.341867 37.341867 0 0 1 74.683733 0"
							fill="#515151" />
					</svg>
					<div class="flex-1">
						<p class="text-left px-3 py-1.5 rounded-sm border font-medium border-transparent">
							<?php esc_html_e( 'Contact Form 7 is ', 'social-contact-form' ); ?><span
								class="font-bold"><?php esc_html_e( 'not installed ', 'social-contact-form' ); ?></span><?php esc_html_e( 'yet! Please Install it first to send unlimited messages through any of your CF7 forms', 'social-contact-form' ); ?>
						</p>
					</div>
					<button x-on:click="options.contact_form_7.selectedmode = 'cf7'; installCF7();"
						style="background: rgb(7, 120, 102); color: rgb(255, 255, 255);"
						class="cursor-pointer scf-input hover:shadow flex items-center rounded-md px-4 py-2  text-white hover:bg-indigo-600 hover:text-white"><?php esc_html_e( 'Install', 'social-contact-form' ); ?></button>

					<template x-if="options.installingCF7">
						<svg width="25" height="25" viewBox="0 0 100 100">
							<g transform="translate(50,50)">
								<g transform="scale(1)">
									<circle cx="0" cy="0" r="50" fill="#687c93"></circle>
									<circle cx="0" cy="-26" r="12" fill="#ffffff" transform="rotate(161.634)">
										<animateTransform attributeName="transform" type="rotate" calcMode="linear"
											values="0 0 0;360 0 0" keyTimes="0;1" dur="1s" begin="0s"
											repeatCount="indefinite"></animateTransform>
									</circle>
								</g>
							</g>
						</svg>
					</template>
				</div>
			</div>
		</template>

		<!-- If install but not activate  -->
		<template x-if="!cf7Installed && cf7NotActivated">
			<div x-show="options.contact_form_7.modepress != 'scf'"
				class="p-4 rounded-md mb-2 mt-2 transform transition ease-out duration-500 rounded-md bg-slate-100  border border-slate-200 shadow-sm"
				style="transform: translateY(-50px);" x-transition:enter="transition ease-out duration-500"
				x-transition:enter-start="opacity-0 transform translate-y-2"
				x-transition:enter-end="opacity-100 transform translate-y-0"
				x-transition:leave="transition ease-out duration-500"
				x-transition:leave-start="opacity-100 transform translate-y-0"
				x-transition:leave-end="opacity-0 transform translate-y-2">

				<div class="flex items-center justify-center space-x-4">
					<svg class="svg-icon"
						style="width: 3em; height: 3em;vertical-align: middle;fill: currentColor;overflow: hidden;"
						viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg">
						<path
							d="M509.57653367 31.675733a477.866667 477.866667 0 1 0 0 955.733334 477.866667 477.866667 0 0 0 0-955.733334m0 51.2a427.144533 427.144533 0 0 1 426.666666 426.666667 427.144533 427.144533 0 0 1-426.666666 426.666667 427.144533 427.144533 0 0 1-426.666667-426.666667 427.144533 427.144533 0 0 1 426.666667-426.666667"
							fill="#515151" />
						<path
							d="M483.97653367 241.2544a25.6 25.6 0 0 1 51.2 0v373.418667a25.6 25.6 0 0 1-51.2 0v-373.418667z"
							fill="#515151" />
						<path
							d="M546.91839967 750.045867a37.341867 37.341867 0 1 1-74.683733 0 37.341867 37.341867 0 0 1 74.683733 0"
							fill="#515151" />
					</svg>
					<div class="flex-1">
						<p class="text-left px-3 py-1.5 rounded-sm border font-medium border-transparent">
							<?php esc_html_e( 'Contact Form 7 is ', 'social-contact-form' ); ?><span
								class="font-bold"><?php esc_html_e( 'not activated ', 'social-contact-form' ); ?></span><?php esc_html_e( 'yet! Please Active it first to send unlimited messages through any of your CF7 forms', 'social-contact-form' ); ?>
						</p>
					</div>
					<button x-on:click="options.contact_form_7.selectedmode = 'cf7'; installCF7()"
						style="background: rgb(7, 120, 102); color: rgb(255, 255, 255);"
						class="cursor-pointer scf-input hover:shadow flex items-center rounded-md px-4 py-2  text-white hover:bg-indigo-600 hover:text-white"><?php esc_html_e( 'Activate', 'social-contact-form' ); ?></button>

					<template x-if="options.installingCF7">
						<svg width="25" height="25" viewBox="0 0 100 100">
							<g transform="translate(50,50)">
								<g transform="scale(1)">
									<circle cx="0" cy="0" r="50" fill="#687c93"></circle>
									<circle cx="0" cy="-26" r="12" fill="#ffffff" transform="rotate(161.634)">
										<animateTransform attributeName="transform" type="rotate" calcMode="linear"
											values="0 0 0;360 0 0" keyTimes="0;1" dur="1s" begin="0s"
											repeatCount="indefinite"></animateTransform>
									</circle>
								</g>
							</g>
						</svg>
					</template>
				</div>
			</div>
		</template>
	</div>

	<!-- Modal for Video  -->
	<template x-if="showModal" class="relative">
		<div class="fixed inset-0 z-50 flex items-center justify-center yt-modal-main">
			<div class="fixed inset-0 bg-black opacity-50"></div>
			<div
				class="absolute top-0 left-0 right-0 bottom-0 flex items-center justify-center relative yt-modal-parent">
				<div class="modal-container bg-transparent mx-auto p-8 rounded-lg yt-modal-child">
					<button x-on:click.prevent="showModal = false"
						class="close-button absolute top-0 right-0 m-4 text-gray-500 hover:text-gray-700 focus:outline-none">
						<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor"
							class="h-4 w-4 text-white hover:brightness-110">
							<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
								d="M6 18L18 6M6 6l12 12"></path>
						</svg>
					</button>
					<iframe class="flex justify-center items-center scf-yt-video" width="560" height="315"
						src="https://www.youtube.com/embed/kQO9Bbp7tgA?rel=0" title="YouTube video player"
						frameborder="0"
						allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
						frameborder="0" allowfullscreen></iframe>
				</div>
			</div>
		</div>
</div>
</template>

</div>
