<?php

/**
 * Admin settings base template
 *
 * @package SocialContactForm
 * @since 1.0.0
 */
do_action( 'scf_setting_header' ); ?>

<div class="wrap scf_wrapper" style="display: block" x-data="SCF_Settings">
	<div class="scf_container" :class="{ 'pointer-events-none  animate-pulse' : state.saving && !state.finished }">

		<template x-if="state.finished">
				<div class="h-full">
					<?php scf_render( 'admin/settings/setup-finished' ); ?>
				</div>
			</template>

		<!-- settings  -->

		<!-- <div x-show="!state.finished" class="h-full"> -->
		<template x-if="!state.finished">
			<div class="h-full">
				<div class="flex justify-end text-xs text-slate-500 px-5 pt-3 cursor-pointer items-center hover:text-slate-600 transition duration-150">
					<div class="scf_headway"></div>
					<div class="flex items-center gap-2"><?php esc_html_e( 'Whats\'s new?', 'social-contact-form' ); ?> 😍</div>
				</div>

				<!-- progressbar   -->
				<?php scf_render( 'admin/settings/progress-bar' ); ?>

				<!-- content  -->
				<div class="py-3 rounded-md h-full">

					<!-- header  -->
					<?php scf_render( 'admin/settings/header' ); ?>

					<!-- main content  -->
					<section class="p-6 h-full content-height flex sm:justify-between flex-col-reverse sm:flex-row gap-4 h-full">


						<!-- settings fields  -->
						<div class="w-full sm:w-3/4 h-full pr-4 sm:border-r sm:border-slate-200 sm:border-dotted ">

							<!-- whatsapp fields  -->
							<?php scf_render( 'admin/settings/section-whatsapp' ); ?>

							<!-- customization fields -->
							<?php scf_render( 'admin/settings/section-customize' ); ?>

							<!--activation -->
							<?php scf_render( 'admin/settings/section-activate' ); ?>
						</div>

						<!-- preview  -->
						<?php scf_render( 'admin/settings/preview' ); ?>


						<!-- preview ends  -->
					</section>
				</div>
			</div>
		</template>


		<!-- upgrade notice  -->
		<?php scf_render( 'admin/upgrade-popup' ); ?>

	</div>

	<!-- footer text  -->
	<template x-if="!state.finished">
		<div class="px-3 mb-2 text-center text-xs text-slate-400">
			<?php
			echo wp_sprintf(
				'%s',
				esc_html( apply_filters(
					'scf_footer',
					__( 'Social Contact Form is powered by WPPOOL', 'social-contact-form' )
				) )
			);
			?>
		</div>
	</template>
</div>


<style>
	#wpcontent {
		padding-left: 0 !important;
	}
</style>

<?php do_action( 'scf_setting_footer' );
?>
