<?php

/**
 * Admin Leads Pagination Template
 *
 * @package Social Contact Form
 * @since 1.0.0
 */
?>
<div class="flex items-center space-x-1">

	<a href="#" @click.prevent="lead.page--" class="h-7 px-2 flex items-center text-gray-700 bg-gray-200 rounded-md hover:opacity-90 hover:text-white focus:outline-none" :class="{
		'opacity-50 pointer-events-none' : lead.page < 2,
	}">
		<svg xmlns="http://www.w3.org/2000/svg" class="w-4- h-4 fill-current" fill="none" viewBox="0 0 24 24" stroke="currentColor">
			<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 17l-5-5m0 0l5-5m-5 5h12" />
		</svg>
	</a>

	<template x-for="n in Math.ceil(leads.length / lead.perPage)">
		<a href="#" @click.prevent="lead.page = n" :class="{'bg-indigo-600 text-white' : n == lead.page, 'text-gray-700 bg-gray-200' : n != lead.page}" class="h-7 px-3 flex items-center rounded-md hover:opacity-90 hover:text-white focus:outline-none" x-text="n"></a>
	</template>

	<a href="#" @click.prevent="lead.page++" :class="{
		'opacity-50 pointer-events-none' : lead.page >= lead.leads.length / lead.perPage,
	}" class="h-7 px-2 flex items-center text-gray-700 bg-gray-200 rounded-md hover:opacity-90 hover:text-white">
		<svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 fill-current" fill="none" viewBox="0 0 24 24" stroke="currentColor">
			<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6" />
		</svg>
	</a>
</div>
