<?php
/**
 * Admin Leads Modal Template
 *
 * @package Social Contact Form
 */
?>
<template x-if="state.lead">
	<div class="fixed top-0 left-0 h-full w-full sm:ml-16" x-show="state.modal_open === true && state.lead != false" x-transition.opacity>
		<div class="w-full max-w-full rounded-md shadow-lg absolute top-0 left-0 h-full flex items-center justify-center">
			<div @click.prevent="state.modal_open = false" class="absolute bg-slate-800 w-full h-full z-40 opacity-40"></div>
			<div class="w-full max-w-3xl scf-modal-height scrollbar-thin scrollbar-thumb-indigo-600 scrollbar-track-gray-100 overflow-y-auto bg-white p-4 rounded-md shadow-md border border-slate-200 z-50 mx-2">

				<!-- close  -->
				<div class="flex justify-between mb-4">
					<h2 class="text-base font-semibold text-slate-600 border-l-4 border-indigo-600 pl-4"><?php esc_html_e('Lead Details', 'social-contact-form'); ?></h2>
					<button class="text-red-300 hover:text-red-600 transition duration-150" @click="state.modal_open = false">
						<svg class="h-6 w-6" fill="currentColor" viewBox="0 0 20 20">
							<path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
						</svg>
					</button>
				</div>

				<div class="flex items-center justify-between mt-6 mb-2">
					<h3 class="font-medium text-slate-700"><?php esc_html_e('Form fields', 'social-contact-form'); ?></h3>
					<div class="flex items-center justify-center cursor-pointer px-3 py-1.5 rounded-md hover:bg-slate-200" @click.prevent="state.lead.hide_fields = !state.lead.hide_fields">
						<span class="dashicons" :class="state.lead.hide_fields != true ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2'"></span>
					</div>
				</div>


				<div class="bg-slate-50 p-4 rounded-md" x-show="!state.lead.hide_fields && isPro" x-transition.opacity>
					<template v-if="state.lead && state.lead.field" x-for="(field, label) in state.lead.field">
						<div class="mb-4">
							<label class="font-medium text-slate-400 text-xs font-medium mb-2 uppercase" x-text="label"></label>
							<div class="text-sm text-slate-600" x-text="field"></div>
						</div>
					</template>
				</div>

				<div x-show="!state.lead.hide_fields && !isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
					<div class="text-indigo-600">
						<?php esc_html_e('This feature is available in the PRO version.', 'social-contact-form'); ?>
					</div>
				</div>


				<div class="flex items-center justify-between mt-6 mb-2">
					<h3 class="font-medium text-slate-700"><?php esc_html_e('Meta data', 'social-contact-form'); ?></h3>
					<div class="flex items-center justify-center cursor-pointer px-3 py-1.5 rounded-md hover:bg-slate-200" @click.prevent="state.lead.show_meta = !state.lead.show_meta">
						<span class="dashicons" :class="state.lead.show_meta == true ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2'"></span>
					</div>
				</div>



				<div x-show="state.lead.show_meta && isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
					<template v-if="state.meta && state.lead.meta" x-for="(meta, label) in state.lead.meta">
						<div class="mb-4">
							<label class="font-medium text-slate-400 text-xs font-medium mb-2 uppercase" x-text="label"></label>
							<div class="text-sm text-slate-600" x-text="meta"></div>
						</div>
					</template>
				</div>

				<div x-show="state.lead.show_meta && !isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
					<div class="text-indigo-600">
						<?php esc_html_e('This feature is available in the PRO version.', 'social-contact-form'); ?>
					</div>
				</div>

				<div class="mt-4 flex items-center justify-between">
					<div class="text-xs text-slate-400 flex items-center gap-1.5">
						<svg xmlns="http://www.w3.org/2000/svg" class="fill-current text-slate-600 w-3" viewBox="0 0 16 16">
							<path d="M5.5 10.5A.5.5 0 0 1 6 10h4a.5.5 0 0 1 0 1H6a.5.5 0 0 1-.5-.5z" />
							<path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM2 2a1 1 0 0 0-1 1v11a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H2z" />
							<path d="M2.5 4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5H3a.5.5 0 0 1-.5-.5V4z" />
						</svg>
						<span x-text="state.lead.created_at"></span>
					</div>
					<div class="flex items-center justify-center sm:justify-end gap-1">
						
			
							<button @click.prevent="deleteLead([state.lead.id])" class="bg-red-400 hover:bg-red-500 text-white px-3 py-1.5 rounded-md transition duration-150 flex items-center justify-center gap-1">
								<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-3" viewBox="0 0 16 16">
									<path d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5Zm-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06Zm6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528ZM8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5Z" />
								</svg>
								<span><?php esc_html_e('Delete', 'social-contact-form'); ?></span>
							</button>
				
						<!-- Single view delete for CF7  -->

						<button @click="state.modal_open = false" class="bg-slate-500 hover:bg-slate-600 text-white px-3 py-1.5 rounded-md transition duration-150 flex items-center justify-center gap-1">
							<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-3" viewBox="0 0 16 16">
								<path d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5Zm-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06Zm6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528ZM8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5Z" />
							</svg>
							<span><?php esc_html_e('Close', 'social-contact-form'); ?></span>
						</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</template>


<template x-if="state.cf7lead">
	<div class="fixed top-0 left-0 h-full w-full sm:ml-16" x-show="state.modal_open === true && state.cf7lead != false" x-transition.opacity>
		<div class="w-full max-w-full rounded-md shadow-lg absolute top-0 left-0 h-full flex items-center justify-center">
			<div @click.prevent="state.modal_open = false" class="absolute bg-slate-800 w-full h-full z-40 opacity-40"></div>
			<div class="w-full max-w-3xl scf-modal-height scrollbar-thin scrollbar-thumb-indigo-600 scrollbar-track-gray-100 overflow-y-auto bg-white p-4 rounded-md shadow-md border border-slate-200 z-50 mx-2">

				<!-- close  -->
				<div class="flex justify-between mb-4">
					<h2 class="text-base font-semibold text-slate-600 border-l-4 border-indigo-600 pl-4"><?php esc_html_e('Lead Details', 'social-contact-form'); ?></h2>
					<button class="text-red-300 hover:text-red-600 transition duration-150" @click="state.modal_open = false">
						<svg class="h-6 w-6" fill="currentColor" viewBox="0 0 20 20">
							<path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
						</svg>
					</button>
				</div>

				<div class="flex items-center justify-between mt-6 mb-2">
					<h3 class="font-medium text-slate-700"><?php esc_html_e('Form fields', 'social-contact-form'); ?></h3>
					<div class="flex items-center justify-center cursor-pointer px-3 py-1.5 rounded-md hover:bg-slate-200" @click.prevent="state.cf7lead.hide_fields = !state.cf7lead.hide_fields">
						<span class="dashicons" :class="state.cf7lead.hide_fields != true ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2'"></span>
					</div>
				</div>


				<div class="bg-slate-50 p-4 rounded-md" x-show="!state.cf7lead.hide_fields && isPro" x-transition.opacity>
					<template v-if="state.cf7lead && state.cf7lead.field" x-for="(field, label) in state.cf7lead.field">
						<div class="mb-4">
							<label class="font-medium text-slate-400 text-xs font-medium mb-2 uppercase" x-text="label"></label>
							<div class="text-sm text-slate-600" x-text="field"></div>
						</div>
					</template>
				</div>

				<div x-show="!state.cf7lead.hide_fields && !isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
					<div class="text-indigo-600">
						<?php esc_html_e('This feature is available in the PRO version.', 'social-contact-form'); ?>
					</div>
				</div>


				<div class="flex items-center justify-between mt-6 mb-2">
					<h3 class="font-medium text-slate-700"><?php esc_html_e('Meta data', 'social-contact-form'); ?></h3>
					<div class="flex items-center justify-center cursor-pointer px-3 py-1.5 rounded-md hover:bg-slate-200" @click.prevent="state.cf7lead.show_meta = !state.cf7lead.show_meta">
						<span class="dashicons" :class="state.cf7lead.show_meta == true ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2'"></span>
					</div>
				</div>



				<div x-show="state.cf7lead.show_meta && isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
					<template v-if="state.meta && state.cf7lead.meta" x-for="(meta, label) in state.cf7lead.meta">
						<div class="mb-4">
							<label class="font-medium text-slate-400 text-xs font-medium mb-2 uppercase" x-text="label"></label>
							<div class="text-sm text-slate-600" x-text="meta"></div>
						</div>
					</template>
				</div>

				<div x-show="state.cf7lead.show_meta && !isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
					<div class="text-indigo-600">
						<?php esc_html_e('This feature is available in the PRO version.', 'social-contact-form'); ?>
					</div>
				</div>

				<div class="mt-4 flex items-center justify-between">
					<div class="text-xs text-slate-400 flex items-center gap-1.5">
						<svg xmlns="http://www.w3.org/2000/svg" class="fill-current text-slate-600 w-3" viewBox="0 0 16 16">
							<path d="M5.5 10.5A.5.5 0 0 1 6 10h4a.5.5 0 0 1 0 1H6a.5.5 0 0 1-.5-.5z" />
							<path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM2 2a1 1 0 0 0-1 1v11a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H2z" />
							<path d="M2.5 4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5H3a.5.5 0 0 1-.5-.5V4z" />
						</svg>
						<span x-text="state.cf7lead.created_at"></span>
					</div>
					<div class="flex items-center justify-center sm:justify-end gap-1">
						
						<!-- Single view delete for CF7  -->
				
							<button @click.prevent="deleteLeadcf7([state.cf7lead.id])" class="bg-red-400 hover:bg-red-500 text-white px-3 py-1.5 rounded-md transition duration-150 flex items-center justify-center gap-1">
								<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-3" viewBox="0 0 16 16">
									<path d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5Zm-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06Zm6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528ZM8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5Z" />
								</svg>
								<span><?php esc_html_e('Delete', 'social-contact-form'); ?></span>
							</button>

						<button @click="state.modal_open = false" class="bg-slate-500 hover:bg-slate-600 text-white px-3 py-1.5 rounded-md transition duration-150 flex items-center justify-center gap-1">
							<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-3" viewBox="0 0 16 16">
								<path d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5Zm-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06Zm6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528ZM8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5Z" />
							</svg>
							<span><?php esc_html_e('Close', 'social-contact-form'); ?></span>
						</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</template>
