<?php
/**
 * Admin Leads Header Template
 *
 * @package Social Contact Form
 */
?>
 <div x-cloak>
	 <div x-data="{ activeTab: localStorage.getItem('activeTab') || 'scfTab' }" x-init="$watch('activeTab', val => localStorage.setItem('activeTab', val))">
		<div x-show="activeTab === 'scfTab'">
			<div class="flex flex-col sm:flex-row sm:items-center justify-between">
				<div class="text-lg font-medium text-slate-700 flex items-center gap-2"><?php esc_html_e('Contact form leads', 'social-contact-form'); ?>
					<!-- delete icon  -->
					<label x-show="selectedLeads.length" @click.prevent="deleteSelected" class="cursor-pointer text-red-400 px-2 py-1.5 rounded-md hover:bg-red-500 hover:text-white transition duration-150">
						<svg class="fill-current h-4 w-4" viewBox="0 0 20 20">
							<path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
						</svg>
						</label>
				</div>
				<div class="text-slate-400">
					<?php echo wp_sprintf('Showing %s out of %s leads', '<span class="font-medium text-slate-500" x-text="leads.length"></span>', '<span class="font-medium text-slate-500" x-text="lead.leads.length || 0"></span>'); ?>
				</div>
			</div>
		</div>

		<div x-show="activeTab === 'cf7Tab'">
			<div class="flex flex-col sm:flex-row sm:items-center justify-between">
				<div class="text-lg font-medium text-slate-700 flex items-center gap-2"><?php esc_html_e('Contact form leads', 'social-contact-form'); ?>
					<!-- delete icon  -->
					<!-- <label x-show="selectedCF7Leads.length" @click.prevent="deleteCF7Selected" class="cursor-pointer text-red-400 px-2 py-1.5 rounded-md hover:bg-red-500 hover:text-white transition duration-150"> -->
					<label x-show="selectedLeads.length" @click.prevent="deleteSelected" class="cursor-pointer text-red-400 px-2 py-1.5 rounded-md hover:bg-red-500 hover:text-white transition duration-150">
						<svg class="fill-current h-4 w-4" viewBox="0 0 20 20">
							<path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
						</svg>
						</label>
				</div>
				<div class="text-slate-400">
					<?php echo wp_sprintf('Showing %s out of %s leads', '<span class="font-medium text-slate-500" x-text="cf7leads.length"></span>', '<span class="font-medium text-slate-500" x-text="cf7lead.cf7leads.length || 0"></span>'); ?>
				</div>
			</div>
		</div>
	</div>
</div>

