<?php
/**
 * Admin Leads Content Template
 *
 * @package Social Contact Form
 */
?>
<!-- table contents  -->
<div class="block relative overflow-x-auto shadow sm:rounded-lg my-6">

	<!-- load found  -->
	<template x-if="leads && leads.length">
		<table class="w-full text-sm text-left">

			<thead class="text-xs uppercase">
				<tr class="text-slate-500 bg-indigo-100">
					<th scope="col" class="px-4 w-10  text-center">
						<input type="checkbox" @change.prevent="bulkSelectLeads">
					</th>
					<th scope="col" class="px-6 py-3">
						<?php esc_html_e( 'Date', 'social-contact-form' ); ?>
					</th>
					<th scope="col" class="px-6 py-3">
						<?php
						esc_html_e( 'Name', 'social-contact-form' );
						?>
					</th>
					<th scope="col" class="px-6 py-3">
						<?php

						 esc_html_e( 'Email', 'social-contact-form' );
						?>
					</th>
					<th scope="col" class="px-6 py-3">
						<?php

						 esc_html_e( 'Phone', 'social-contact-form' );
						?>
					</th>
					<th scope="col" class="px-6 py-3">
						<?php

						 esc_html_e( 'Message', 'social-contact-form' );
						?>
					</th>
					<th scope="col" class="px-6 py-3">
						<span class="sr-only">
						<?php
						 esc_html_e( 'Action', 'social-contact-form' );
						?>
						  </span>
					</th>
				</tr>
			</thead>

			<tbody>
				<template v-if="leads && leads.length" x-for="clead in leads">
					<tr class="border-b border-slate-100 text-slate-600 text-sm group">
						<th scope="row" class="px-4 w-10 text-center">
						<input type="checkbox" x-model="clead.selected">
						</th>
						<th scope="row" class="px-6 py-4 font-medium whitespace-nowrap" x-text="getTime(clead.created_at)"></th>
						<!-- New add  -->
						<td class="px-6 py-4" x-text="Object.values(clead.field)[0]"></td>
						<td class="px-6 py-4" x-text="Object.values(clead.field)[1]"></td>
						<td class="px-6 py-4" x-text="Object.values(clead.field)[2]"></td>
						<td class="px-6 py-4" x-text="Object.values(clead.field)[3]"></td>

						<td class="px-6 py-4 text-right">
							<div class="flex flex-col items-center gap-0.5 transition duration-150">
								<a href="#" @click.prevent="show_lead(clead)" class="px-2 py-1.5 rounded-md hover:bg-indigo-100 transition duration-150 text-slate-500">
									<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-4" viewBox="0 0 16 16">
										<path d="M10.5 8a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0z" />
										<path d="M0 8s3-5.5 8-5.5S16 8 16 8s-3 5.5-8 5.5S0 8 0 8zm8 3.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7z" />
									</svg>
								</a>
								<a href="#" @click.prevent="deleteLead([clead.id])" class="px-2 py-1.5 rounded-md hover:bg-indigo-100 transition duration-150 text-slate-500">
									<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-4" viewBox="0 0 16 16">
										<path d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5Zm-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06Zm6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528ZM8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5Z" />
									</svg>
								</a>
							</div>
						</td>
					</tr>
				</template>

			</tbody>
		</table>
	</template>

	<!-- no lead found  -->
	<template x-if="!leads || leads.length === 0">
		<div class="text-center my-4">
			<div class="inline-block px-4 py-2 text-sm bg-red-400 text-white text-center rounded-md">
				<?php
				echo esc_html( apply_filters(
					'scf_no_leads_message',
					__( 'No leads found.', 'social-contact-form' )
				) );
				?>
			</div>
		</div>
	</template>
</div>
