<?php
/**
 * CF7 Admin Leads Content Template
 *
 * @package Social Contact Form
 */
?>
<!-- table contents  -->
<div class="">
    <div class="" x-data="{ expanded: false, cf7Installed: false, cf7NotActivated: false, forms: [] }" x-init="async () => {
					setInterval(async () => {
						try {
							const response = await fetch(`${scf_admin.ajax_url}?action=scf_is_cf7_installed`);
							const data = await response.json();
							forms = data;
							
							if (Array.isArray(data)) {
								cf7Installed = true;
							} else if (data === 'inactive') {
								cf7Installed = false;
								cf7NotActivated = true;
							} else {
								cf7Installed = false;
							}
						} catch (error) {
							console.error(error);
						}
					}, 2000);

				}">
        <!-- Conditionally show form list item and selected one  -->
        <div class="text-gray-900 antialiased font-sans" x-data="{ open: false, selectedFormleads:null }">

            <div class="flex">
                <template x-if="!open">
                    <select x-model="selectedFormleads" aria-labelledby="assigned-to-label"
                        class="w-30 cursor-default relative rounded-md border border-gray-300 bg-white pl-3 pr-10 py-2 text-left hover:cursor-pointer hover:bg-gray-200 hover:text-gray-700 focus:outline-none focus:shadow-outline-blue focus:border-blue-300 transition ease-in-out duration-150 sm:text-sm sm:leading-5 mt-1 mb-1 leads-page-select-dropdown"
                        style="width: 266px" x-on:input="
								selectedFormleads = $event.target.value;
								open = false;
								loadCF7Leads($event.target.value);
								options.contact_form_7.selectedid = $event.target.value;
								title = $event.target.options[$event.target.selectedIndex].getAttribute('data-title');
								localStorage.setItem('selectedFormleads', JSON.stringify({ id: $event.target.value, title: title }));
							">
                        <option class="hidden"
                            :value="JSON.parse(localStorage.getItem('selectedFormleads')) ? JSON.parse(localStorage.getItem('selectedFormleads')).id : 'null'"
                            x-text="JSON.parse(localStorage.getItem('selectedFormleads')) ? JSON.parse(localStorage.getItem('selectedFormleads')).title : 'Choose your form' ">
                        </option>
                        <template x-for="(form, index) in forms" :key="index">
                            <option :data-title="form.title" :id="form.id" :value="form.id" x-text="form.title">
                            </option>
                        </template>
                    </select>
                </template>
            </div>

        </div>
    </div>
    <!-- End here  -->
</div>
<!-- load found  -->
<div class="block relative overflow-x-auto shadow sm:rounded-lg my-6">
    <template x-if="cf7leads && cf7leads.length">
        <table class="w-full text-sm text-left">

            <thead class="text-xs uppercase">
                <tr class="text-slate-500 bg-indigo-100">
                    <th scope="col" class="px-4 w-10 text-center">
                        <input type="checkbox" @change.prevent="bulkSelectLeadsCF7">
                    </th>
                    <th scope="col" class="px-6 py-3">
                        <?php esc_html_e('Dates', 'social-contact-form'); ?>
                    </th>
                    <template x-for="(key, index) in Object.keys(cf7leads[0].field).slice(0, 4)" :key="index">
                        <th scope="col" class="px-6 py-3">
                            <span x-text="key"></span>
                        </th>
                    </template>
                    <th scope="col" class="px-6 py-3">
                        <span class="sr-only"><?php esc_html_e('Action', 'social-contact-form'); ?></span>
                    </th>
                </tr>
            </thead>

            <tbody>
                <template v-if="cf7leads && cf7leads.length" x-for="clead in cf7leads">
                    <tr class="border-b border-slate-100 text-slate-600 text-sm group">
                        <th scope="row" class="px-4 w-10 text-center">
                            <input type="checkbox" x-model="clead.selected">
                        </th>
                        <th scope="row" class="px-6 py-4 font-medium whitespace-nowrap"
                            x-text="getTime(clead.created_at)"></th>
                        <!-- New add  -->
                        <td class="px-6 py-4" x-text="Object.values(clead.field)[0]"></td>
                        <td class="px-6 py-4" x-text="Object.values(clead.field)[1]"></td>
                        <td class="px-6 py-4" x-text="Object.values(clead.field)[2]"></td>
                        <td class="px-6 py-4" x-text="Object.values(clead.field)[3]"></td>

                        <td class="px-6 py-4 text-right">
                            <div class="flex flex-col items-center gap-0.5 transition duration-150">
                                <a href="#" @click.prevent="show_leadcf7(clead)"
                                    class="px-2 py-1.5 rounded-md hover:bg-indigo-100 transition duration-150 text-slate-500">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-4"
                                        viewBox="0 0 16 16">
                                        <path d="M10.5 8a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0z" />
                                        <path
                                            d="M0 8s3-5.5 8-5.5S16 8 16 8s-3 5.5-8 5.5S0 8 0 8zm8 3.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7z" />
                                    </svg>
                                </a>
                                <a href="#" @click.prevent="deleteLeadcf7([clead.id])"
                                    class="px-2 py-1.5 rounded-md hover:bg-indigo-100 transition duration-150 text-slate-500">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-4"
                                        viewBox="0 0 16 16">
                                        <path
                                            d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5Zm-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06Zm6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528ZM8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5Z" />
                                    </svg>
                                </a>
                            </div>
                        </td>
                    </tr>
                </template>
            </tbody>
        </table>

    </template>
</div>

<!-- no lead found  -->
<template x-if="!cf7leads || cf7leads.length === 0">
    <div class="text-center my-4">
        <div class="inline-block px-4 py-2 text-sm bg-red-400 text-white text-center rounded-md">
            <?php
				echo esc_html( apply_filters(
					'scf_no_leads_message',
					__( 'No leads found.', 'social-contact-form' )
				) );
				?>
        </div>
    </div>
</template>
</div>