<?php

/**
 * Admin Leads template
 *
 * @package SocialContactForm
 * @since 1.0.0
 */
?>
<div class="wrap scf_wrapper" style="display: none" x-data="SCF_Leads">
<div x-data="{ activeTab: localStorage.getItem('activeTab') || 'scfTab' }" x-init="localStorage.setItem('activeTab', activeTab)">

	<div @click="upgradeModal" class="scf_container">
		<div class="p-4 min-h-screen" x-show="!lead.loading" :class="{'pointer-events-none animate-pulse': lead.loading, 'pointer-events-none opacity-60' : !isPro}">
			<!-- list of the leads  -->
			<?php
				// scf_render('admin/leads/header'); // If all ok then header will be delete as I am addin all together.
			?>
				<!-- Header SCF -->
					<div x-show="activeTab === 'scfTab'">
						<div class="flex flex-col sm:flex-row sm:items-center justify-between">
							<div class="text-lg font-medium text-slate-700 flex items-center gap-2"><?php esc_html_e('Contact form leads', 'social-contact-form'); ?>
								<!-- delete icon  -->
								<label x-show="selectedLeads.length" @click.prevent="deleteSelected" class="cursor-pointer text-red-400 px-2 py-1.5 rounded-md hover:bg-red-500 hover:text-white transition duration-150">
									<svg class="fill-current h-4 w-4" viewBox="0 0 20 20">
										<path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
									</svg>
									</label>
							</div>
							<div class="text-slate-400">
								<?php echo wp_sprintf('Showing %s out of %s leads', '<span class="font-medium text-slate-500" x-text="leads.length"></span>', '<span class="font-medium text-slate-500" x-text="lead.leads.length || 0"></span>'); ?>
							</div>
						</div>
					</div>
				<!-- Header CF7 -->
					<div x-show="activeTab === 'cf7Tab'">
						<div class="flex flex-col sm:flex-row sm:items-center justify-between">
							<div class="text-lg font-medium text-slate-700 flex items-center gap-2"><?php esc_html_e('Contact form leads', 'social-contact-form'); ?>
								<!-- delete icon  -->
								<label x-show="selectedCF7Leads.length" @click.prevent="deleteCF7Selected" class="cursor-pointer text-red-400 px-2 py-1.5 rounded-md hover:bg-red-500 hover:text-white transition duration-150">
								<!-- <label x-show="selectedLeads.length" @click.prevent="deleteSelected" class="cursor-pointer text-red-400 px-2 py-1.5 rounded-md hover:bg-red-500 hover:text-white transition duration-150"> -->
									<svg class="fill-current h-4 w-4" viewBox="0 0 20 20">
										<path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
									</svg>
								</label>
							</div>
							<div class="text-slate-400">
								<?php echo wp_sprintf('Showing %s out of %s leads', '<span class="font-medium text-slate-500" x-text="cf7leads.length"></span>', '<span class="font-medium text-slate-500" x-text="cf7lead.cf7leads.length || 0"></span>'); ?>
							</div>
						</div>
					</div>
				<!-- Header CF7 End -->


				<!-- Tabs start -->
				<div  class="my-3">
					<ul class="flex">
						<!-- Tabs  -->
						<li class="mr-0">
							<button class="bg-gray-200 rounded-l rounded-r-none px-4 py-2 focus:outline-none" :class="{ 'bg-gray-700 text-white': activeTab === 'scfTab' }" x-on:click="activeTab = 'scfTab' ">Social Contact Form</button>
							<!-- <button class="bg-gray-200 rounded-l rounded-r-none px-4 py-2 focus:outline-none" :class="{ 'bg-gray-700 text-white': activeTab === 'scfTab' }" x-on:click="activeTab = 'scfTab'; localStorage.setItem('activeTab', 'scfTab')">Social Contact Form</button> -->
						</li>
						<li class="mr-0">
							<button class="bg-gray-200 rounded-r rounded-l-none px-4 py-2 focus:outline-none" :class="{ 'bg-gray-700 text-white': activeTab === 'cf7Tab' }" x-on:click="activeTab = 'cf7Tab' ">Contact Form 7</button>
							<!-- <button class="bg-gray-200 rounded-r rounded-l-none px-4 py-2 focus:outline-none" :class="{ 'bg-gray-700 text-white': activeTab === 'cf7Tab' }" x-on:click="activeTab = 'cf7Tab'; localStorage.setItem('activeTab', 'cf7Tab')">Contact Form 7</button> -->
						</li>
						
							<!-- filters SCF -->
						<li class="ml-auto">
							<div x-show="activeTab === 'scfTab'">
								<div class="flex flex-col sm:flex-row sm:items-center justify-between gap-2">
								<!-- Date between  -->
								<div class="flex items-center gap-1">
									<div class="flex items-center gap-2">
									<input type="date" class="w-full scf-input" x-model="lead.from">

									<span class="font-medium text-slate-400"><?php esc_html_e('To', 'social-contact-form'); ?></span>
									<input type="date" class="w-full scf-input" x-model="lead.to">
									</div>
								</div>

								<div class="flex items-center gap-2">
									<!-- Export CSV -->
									<button @click.prevent="exportLeadsAsCSV" class="bg-white text-slate-500 border border-slate-300 rounded-md shadow-sm whitespace-nowrap px-4 py-2 hover:opacity-90 hover:bg-indigo-600 hover:text-white transition duration-150 hover:border-transparent font-medium"><?php esc_html_e('Export .CSV', 'social-contact-form'); ?></button>
									<!-- search  -->
									<input placeholder="<?php esc_html_e('Search..', 'social-contact-form'); ?>" type="text" class="w-full scf-input" x-model="lead.search">
								</div>
								</div>
							</div>
							<!-- filters CF7 -->
							<div x-show="activeTab === 'cf7Tab'">
								<div class="flex flex-col sm:flex-row sm:items-center justify-between gap-2">
									<!-- Date between  -->
									<div class="flex items-center gap-1">
										<div class="flex items-center gap-2">
										<input type="date" class="w-full scf-input" x-model="cf7lead.cf7from">

										<span class="font-medium text-slate-400"><?php esc_html_e('To', 'social-contact-form'); ?></span>
										<input type="date" class="w-full scf-input" x-model="cf7lead.cf7to">
										</div>
									</div>
									<!-- Export CF7Leads As CSV -->
									<div class="flex items-center gap-2">
										<button @click.prevent="exportCF7LeadsAsCSV" class="bg-white text-slate-500 border border-slate-300 rounded-md shadow-sm whitespace-nowrap px-4 py-2 hover:opacity-90 hover:bg-indigo-600 hover:text-white transition duration-150 hover:border-transparent font-medium"><?php esc_html_e('Export .CSV', 'social-contact-form'); ?></button>
										<!-- search  -->
										<input placeholder="<?php esc_html_e('Search..', 'social-contact-form'); ?>" type="text" class="w-full scf-input" x-model="cf7lead.cf7search">
									</div>
								</div>
							</div>	
						</li>

					</ul>

					<div x-show="activeTab === 'scfTab'">
						<?php scf_render('admin/leads/content'); ?>
					</div>

					<div x-show="activeTab === 'cf7Tab'">
						<?php scf_render('admin/leads/content-cf7'); ?>
					</div>

				<!-- Pagination  -->
					<!-- Pagination SCF  -->
					<div x-show="activeTab === 'scfTab'">
						<div class="flex items-center space-x-1">

							<a href="#" @click.prevent="lead.page--" class="h-7 px-2 flex items-center text-gray-700 bg-gray-200 rounded-md hover:opacity-90 hover:text-white focus:outline-none" :class="{
								'opacity-50 pointer-events-none' : lead.page < 2,
							}">
								<svg xmlns="http://www.w3.org/2000/svg" class="w-4- h-4 fill-current" fill="none" viewBox="0 0 24 24" stroke="currentColor">
									<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 17l-5-5m0 0l5-5m-5 5h12" />
								</svg>
							</a>

							<template x-for="n in Math.ceil(leads.length / lead.perPage)">
								<a href="#" @click.prevent="lead.page = n" :class="{'bg-indigo-600 text-white' : n == lead.page, 'text-gray-700 bg-gray-200' : n != lead.page}" class="h-7 px-3 flex items-center rounded-md hover:opacity-90 hover:text-white focus:outline-none" x-text="n"></a>
							</template>

							<a href="#" @click.prevent="lead.page++" :class="{
								'opacity-50 pointer-events-none' : lead.page >= lead.leads.length / lead.perPage,
							}" class="h-7 px-2 flex items-center text-gray-700 bg-gray-200 rounded-md hover:opacity-90 hover:text-white">
								<svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 fill-current" fill="none" viewBox="0 0 24 24" stroke="currentColor">
									<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6" />
								</svg>
							</a>
							</div>
						</div>
					<!-- Pagination CF7  -->
					<div x-show="activeTab === 'cf7Tab'">
						<div class="flex items-center space-x-1">

							<a href="#" @click.prevent="cf7lead.cf7page--" class="h-7 px-2 flex items-center text-gray-700 bg-gray-200 rounded-md hover:opacity-90 hover:text-white focus:outline-none" :class="{
								'opacity-50 pointer-events-none' : cf7lead.cf7page < 2,
							}">
								<svg xmlns="http://www.w3.org/2000/svg" class="w-4- h-4 fill-current" fill="none" viewBox="0 0 24 24" stroke="currentColor">
									<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 17l-5-5m0 0l5-5m-5 5h12" />
								</svg>
							</a>

							<template x-for="n in Math.ceil(cf7leads.length / cf7lead.cf7perPage)">
								<a href="#" @click.prevent="cf7lead.cf7page = n" :class="{'bg-indigo-600 text-white' : n == cf7lead.cf7page, 'text-gray-700 bg-gray-200' : n != cf7lead.cf7page}" class="h-7 px-3 flex items-center rounded-md hover:opacity-90 hover:text-white focus:outline-none" x-text="n"></a>
							</template>

							<a href="#" @click.prevent="cf7lead.cf7page++" :class="{
								'opacity-50 pointer-events-none' : cf7lead.cf7page >= cf7lead.cf7leads.length / cf7lead.cf7perPage,
							}" class="h-7 px-2 flex items-center text-gray-700 bg-gray-200 rounded-md hover:opacity-90 hover:text-white">
								<svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 fill-current" fill="none" viewBox="0 0 24 24" stroke="currentColor">
									<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6" />
								</svg>
							</a>
							</div>
						</div>
					</div>
					<!-- Pagination CF7 END  -->
					<?php
						// scf_render('admin/leads/pagination'); // If all ok then pagination will be delete as I am addin all together.

						// scf_render('admin/leads/modal'); // If all ok then pagination will be delete as I am addin all together.
					?>

					<!-- Modal Add here Start -->
					<!-- SCF Modal Start -->
					<div x-show="activeTab === 'scfTab'">
							<!-- Start  -->
							<template x-if="state.lead">
								<div class="fixed top-0 left-0 h-full w-full sm:ml-16" x-show="state.modal_open === true && state.lead != false" x-transition.opacity>
									<div class="w-full max-w-full rounded-md shadow-lg absolute top-0 left-0 h-full flex items-center justify-center">
										<div @click.prevent="state.modal_open = false" class="absolute bg-slate-800 w-full h-full z-40 opacity-40"></div>
										<div class="w-full max-w-3xl scf-modal-height scrollbar-thin scrollbar-thumb-indigo-600 scrollbar-track-gray-100 overflow-y-auto bg-white p-4 rounded-md shadow-md border border-slate-200 z-50 mx-2">

											<!-- close  -->
											<div class="flex justify-between mb-4">
												<h2 class="text-base font-semibold text-slate-600 border-l-4 border-indigo-600 pl-4"><?php esc_html_e('Lead Details', 'social-contact-form'); ?></h2>
												<button class="text-red-300 hover:text-red-600 transition duration-150" @click="state.modal_open = false">
													<svg class="h-6 w-6" fill="currentColor" viewBox="0 0 20 20">
														<path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
													</svg>
												</button>
											</div>

											<div class="flex items-center justify-between mt-6 mb-2">
												<h3 class="font-medium text-slate-700"><?php esc_html_e('Form fields', 'social-contact-form'); ?></h3>
												<div class="flex items-center justify-center cursor-pointer px-3 py-1.5 rounded-md hover:bg-slate-200" @click.prevent="state.lead.hide_fields = !state.lead.hide_fields">
													<span class="dashicons" :class="state.lead.hide_fields != true ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2'"></span>
												</div>
											</div>


											<div class="bg-slate-50 p-4 rounded-md" x-show="!state.lead.hide_fields && isPro" x-transition.opacity>
												<template v-if="state.lead && state.lead.field" x-for="(field, label) in state.lead.field">
													<div class="mb-4">
														<label class="font-medium text-slate-400 text-xs font-medium mb-2 uppercase" x-text="label"></label>
														<div class="text-sm text-slate-600" x-text="field"></div>
													</div>
												</template>
											</div>

											<div x-show="!state.lead.hide_fields && !isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
												<div class="text-indigo-600">
													<?php esc_html_e('This feature is available in the PRO version.', 'social-contact-form'); ?>
												</div>
											</div>


											<div class="flex items-center justify-between mt-6 mb-2">
												<h3 class="font-medium text-slate-700"><?php esc_html_e('Meta data', 'social-contact-form'); ?></h3>
												<div class="flex items-center justify-center cursor-pointer px-3 py-1.5 rounded-md hover:bg-slate-200" @click.prevent="state.lead.show_meta = !state.lead.show_meta">
													<span class="dashicons" :class="state.lead.show_meta == true ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2'"></span>
												</div>
											</div>



											<div x-show="state.lead.show_meta && isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
												<template v-if="state.meta && state.lead.meta" x-for="(meta, label) in state.lead.meta">
													<div class="mb-4">
														<label class="font-medium text-slate-400 text-xs font-medium mb-2 uppercase" x-text="label"></label>
														<div class="text-sm text-slate-600" x-text="meta"></div>
													</div>
												</template>
											</div>

											<div x-show="state.lead.show_meta && !isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
												<div class="text-indigo-600">
													<?php esc_html_e('This feature is available in the PRO version.', 'social-contact-form'); ?>
												</div>
											</div>

											<div class="mt-4 flex items-center justify-between">
												<div class="text-xs text-slate-400 flex items-center gap-1.5">
													<svg xmlns="http://www.w3.org/2000/svg" class="fill-current text-slate-600 w-3" viewBox="0 0 16 16">
														<path d="M5.5 10.5A.5.5 0 0 1 6 10h4a.5.5 0 0 1 0 1H6a.5.5 0 0 1-.5-.5z" />
														<path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM2 2a1 1 0 0 0-1 1v11a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H2z" />
														<path d="M2.5 4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5H3a.5.5 0 0 1-.5-.5V4z" />
													</svg>
													<span x-text="state.lead.created_at"></span>
												</div>
												<div class="flex items-center justify-center sm:justify-end gap-1">
													
										
														<button @click.prevent="deleteLead([state.lead.id])" class="bg-red-400 hover:bg-red-500 text-white px-3 py-1.5 rounded-md transition duration-150 flex items-center justify-center gap-1">
															<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-3" viewBox="0 0 16 16">
																<path d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5Zm-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06Zm6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528ZM8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5Z" />
															</svg>
															<span><?php esc_html_e('Delete', 'social-contact-form'); ?></span>
														</button>
											
													<!-- Single view delete for CF7  -->

													<button @click="state.modal_open = false" class="bg-slate-500 hover:bg-slate-600 text-white px-3 py-1.5 rounded-md transition duration-150 flex items-center justify-center gap-1">
														<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-3" viewBox="0 0 16 16">
															<path d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5Zm-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06Zm6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528ZM8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5Z" />
														</svg>
														<span><?php esc_html_e('Close', 'social-contact-form'); ?></span>
													</button>
												</div>
											</div>
										</div>
									</div>
								</div>
							</template>
							<!-- End  -->
					</div>
					<!-- CF7 Modal Start -->
					<div x-show="activeTab === 'cf7Tab'">
						<!-- Start  -->
						<template x-if="state.cf7lead">
							<div class="fixed top-0 left-0 h-full w-full sm:ml-16" x-show="state.modal_open === true && state.cf7lead != false" x-transition.opacity>
								<div class="w-full max-w-full rounded-md shadow-lg absolute top-0 left-0 h-full flex items-center justify-center">
									<div @click.prevent="state.modal_open = false" class="absolute bg-slate-800 w-full h-full z-40 opacity-40"></div>
									<div class="w-full max-w-3xl scf-modal-height scrollbar-thin scrollbar-thumb-indigo-600 scrollbar-track-gray-100 overflow-y-auto bg-white p-4 rounded-md shadow-md border border-slate-200 z-50 mx-2">

										<!-- close  -->
										<div class="flex justify-between mb-4">
											<h2 class="text-base font-semibold text-slate-600 border-l-4 border-indigo-600 pl-4"><?php esc_html_e('Lead Details', 'social-contact-form'); ?></h2>
											<button class="text-red-300 hover:text-red-600 transition duration-150" @click="state.modal_open = false">
												<svg class="h-6 w-6" fill="currentColor" viewBox="0 0 20 20">
													<path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
												</svg>
											</button>
										</div>

										<div class="flex items-center justify-between mt-6 mb-2">
											<h3 class="font-medium text-slate-700"><?php esc_html_e('Form fields', 'social-contact-form'); ?></h3>
											<div class="flex items-center justify-center cursor-pointer px-3 py-1.5 rounded-md hover:bg-slate-200" @click.prevent="state.cf7lead.hide_fields = !state.cf7lead.hide_fields">
												<span class="dashicons" :class="state.cf7lead.hide_fields != true ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2'"></span>
											</div>
										</div>


										<div class="bg-slate-50 p-4 rounded-md" x-show="!state.cf7lead.hide_fields && isPro" x-transition.opacity>
											<template v-if="state.cf7lead && state.cf7lead.field" x-for="(field, label) in state.cf7lead.field">
												<div class="mb-4">
													<label class="font-medium text-slate-400 text-xs font-medium mb-2 uppercase" x-text="label"></label>
													<div class="text-sm text-slate-600" x-text="field"></div>
												</div>
											</template>
										</div>

										<div x-show="!state.cf7lead.hide_fields && !isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
											<div class="text-indigo-600">
												<?php esc_html_e('This feature is available in the PRO version.', 'social-contact-form'); ?>
											</div>
										</div>


										<div class="flex items-center justify-between mt-6 mb-2">
											<h3 class="font-medium text-slate-700"><?php esc_html_e('Meta data', 'social-contact-form'); ?></h3>
											<div class="flex items-center justify-center cursor-pointer px-3 py-1.5 rounded-md hover:bg-slate-200" @click.prevent="state.cf7lead.show_meta = !state.cf7lead.show_meta">
												<span class="dashicons" :class="state.cf7lead.show_meta == true ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2'"></span>
											</div>
										</div>



										<div x-show="state.cf7lead.show_meta && isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
											<template v-if="state.meta && state.cf7lead.meta" x-for="(meta, label) in state.cf7lead.meta">
												<div class="mb-4">
													<label class="font-medium text-slate-400 text-xs font-medium mb-2 uppercase" x-text="label"></label>
													<div class="text-sm text-slate-600" x-text="meta"></div>
												</div>
											</template>
										</div>

										<div x-show="state.cf7lead.show_meta && !isPro" x-transition.opacity class="bg-slate-50 p-4 rounded-md">
											<div class="text-indigo-600">
												<?php esc_html_e('This feature is available in the PRO version.', 'social-contact-form'); ?>
											</div>
										</div>

										<div class="mt-4 flex items-center justify-between">
											<div class="text-xs text-slate-400 flex items-center gap-1.5">
												<svg xmlns="http://www.w3.org/2000/svg" class="fill-current text-slate-600 w-3" viewBox="0 0 16 16">
													<path d="M5.5 10.5A.5.5 0 0 1 6 10h4a.5.5 0 0 1 0 1H6a.5.5 0 0 1-.5-.5z" />
													<path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM2 2a1 1 0 0 0-1 1v11a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H2z" />
													<path d="M2.5 4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5H3a.5.5 0 0 1-.5-.5V4z" />
												</svg>
												<span x-text="state.cf7lead.created_at"></span>
											</div>
											<div class="flex items-center justify-center sm:justify-end gap-1">
												
												<!-- Single view delete for CF7  -->
										
													<button @click.prevent="deleteLeadcf7([state.cf7lead.id])" class="bg-red-400 hover:bg-red-500 text-white px-3 py-1.5 rounded-md transition duration-150 flex items-center justify-center gap-1">
														<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-3" viewBox="0 0 16 16">
															<path d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5Zm-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06Zm6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528ZM8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5Z" />
														</svg>
														<span><?php esc_html_e('Delete', 'social-contact-form'); ?></span>
													</button>

												<button @click="state.modal_open = false" class="bg-slate-500 hover:bg-slate-600 text-white px-3 py-1.5 rounded-md transition duration-150 flex items-center justify-center gap-1">
													<svg xmlns="http://www.w3.org/2000/svg" class="fill-current w-3" viewBox="0 0 16 16">
														<path d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5Zm-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06Zm6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528ZM8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5Z" />
													</svg>
													<span><?php esc_html_e('Close', 'social-contact-form'); ?></span>
												</button>
											</div>
										</div>
									</div>
								</div>
							</div>
						</template>
						<!-- CF7 Modal END -->
					<!-- END  -->
					</div>

					<!-- Modal Add here End -->
				</div>

				<!-- Loading has some problem need to fix It conflict with pagination of CF7 x-show="activeTab === 'scfTab'"-->
				<div x-show="activeTab === 'scfTab'">
					<div x-show="lead.loading" class="p-8">
						<div class="w-full h-full flex items-center justify-center text-center gap-2 animate-pulse ">
							<div class="w-6 h-6 rounded-md bg-gray-300"></div>
							<span class="text-base font-medium text-slate-600"><?php esc_html_e('Loading please wait...', 'social-contact-form'); ?></span>
						</div>
					</div>
				</div>
				<div x-show="activeTab === 'cf7Tab'">
					<div x-show="cf7lead.cf7loading" class="p-8">
						<div class="w-full h-full flex items-center justify-center text-center gap-2 animate-pulse ">
							<div class="w-6 h-6 rounded-md bg-gray-300"></div>
							<span class="text-base font-medium text-slate-600"><?php esc_html_e('Loading please wait...', 'social-contact-form'); ?></span>
						</div>
					</div>
				</div>
		</div>
	</div>

	<!-- footer text  -->
	<div class="px-3 my-2 text-center text-xs text-slate-400"><?php echo wp_sprintf('%s', esc_html(apply_filters('scf_footer', __('Social Contact Form is powered by WPPOOL', 'social-contact-form')))); ?></div>
</div>
</div>


<style>
	#wpcontent {
		padding-left: 0 !important;
	}
	div#wpfooter {
		position: relative;
	}
</style>
