    // Move focus to number
    const dropdowns = document.getElementsByClassName("custom-dropdown");
    const dropdownOptions = document.querySelector(".options");
    if (dropdownOptions) {
    dropdownOptions.addEventListener("click", () => {
        const numberInput = document.querySelector("#social_contact_form_number");
        if (numberInput) {
        numberInput.focus();
        }
    });
    }

    for (var i = 0; i < dropdowns.length; i++) {
        var label = dropdowns[i].querySelector(".dropdown-label");
        var options = dropdowns[i].querySelectorAll(".option");
        var searchInput = dropdowns[i].querySelector(".search-input");

        // Add event listener to label to toggle dropdown options
        label.addEventListener("click", function() {
            this.parentNode.classList.toggle("open");
        });

        // Add event listener to each option to update label text and selected option value
        for (var j = 0; j < options.length; j++) {
                options[j].addEventListener("click", function() {
                var value = this.getAttribute("data-value");
                var text = this.textContent.trim();
                var flagIcon = this.querySelector(".flag-icon").innerHTML.trim();
                // Split the text to extract country code and name separately
                var parts = text.split('-');
                var countryCode = parts[0];
                label.innerHTML = flagIcon + " " + countryCode;
                
                document.getElementById("social_contact_form_country_code").value = value;
                document.getElementById("social_contact_form_country_store").value = flagIcon + " " + countryCode;

                this.parentNode.parentNode.classList.remove("open");
                var openDropdown = document.querySelector(".custom-dropdown.open");
                openDropdown.classList.remove("open");
            });
        }

        // Add event listener to search input to filter options
        searchInput.addEventListener("input", function() {
                var filter = this.value.toUpperCase();
                var options = this.parentNode.parentNode.querySelectorAll(".option");
                for (var i = 0; i < options.length; i++) {
                    var text = options[i].textContent.toUpperCase();
                    if (text.indexOf(filter) > -1) {
                        options[i].style.display = "";
                    } else {
                    options[i].style.display = "none";
                    }
            }
        });
        // Add event listener to document to close dropdown when user clicks outside of it
        document.addEventListener("click", function (event) {
                var dropdown = event.target.closest(".custom-dropdown");
                if (!dropdown) {
                var openDropdown = document.querySelector(".custom-dropdown.open");
                if (openDropdown) {
                    openDropdown.classList.remove("open");
                }
            }
        });

    }

    // Add popup
    const toggle = document.getElementById('scf-ultimate');
    if (toggle) {
        toggle.addEventListener('click', function() {
            WPPOOL.Popup('social_contact_form').show();
        });
    }

    window.addEventListener('load', function() {
        if (document.querySelector("#new-tab .scf-input-error")) {
          document.querySelector("input#social_contact_form_number").style.border = "1px solid red";
          var newTabTab = document.querySelector("#new-tab-tab");
          if (newTabTab) {
              newTabTab.classList.add("scf-error-config");
          }

        }

      });
      