<?php
/**
 * Common trait.
 *
 * @package Social Contact Form
 * @since 1.0.0
 */

// Namespace.
namespace WPPOOL\SCF;

// Exit if accessed directly.
defined('ABSPATH') || exit;

if ( ! trait_exists('\WPPOOL\SCF\Common') ) :
	/**
	 * Common trait.
	 *
	 * @package Social Contact Form
	 * @since 1.0.0
	 */
	trait Common {

		/**
		 * Format font.
		 *
		 * @param string $font Font.
		 * @return string
		 */
		public function format_font( $font = '' ) {
			$fonts = explode(',', $font);
			$fonts = array_map(function ( $font ) {
				// if space found in font name.
				if ( false !== strpos($font, ' ') ) {
					$font = "'" . $font . "'";
				}
				return $font;
			}, $fonts);

			return implode(', ', $fonts);
		}
	}
endif;
