<?php
/**
 * Functions file.
 * Contains all the functions for Social Contact Form.
 *
 * @package SocialContactForm
 * @since 1.0.0
 */

if ( ! function_exists( 'is_scf_ultimate' ) ) {
	/**
	 * Check is scf ultimate.
	 *
	 * @return bool
	 */
	function is_scf_ultimate() {
		return apply_filters( 'is_scf_ultimate', false );
	}
}

if ( ! function_exists( 'scf_is_setup_run' ) ) {
	/**
	 * Check is setup run.
	 *
	 * @return bool
	 */
	function scf_is_setup_run() {
		$is_setup = get_option( 'scf-setup-run' );
		return true === $is_setup;
	}
}


if ( ! function_exists( 'scf_get_option' ) ) {
	/**
	 * Get option.
	 *
	 * @param string $option_name Option name.
	 * @param mixed  $default Default value.
	 * @return mixed
	 */
	function scf_get_option( $option_name, $default = null ) {
		$option_name_array  = explode( '/', $option_name );
		$option_name_prefix = isset( $option_name_array[0] ) ? $option_name_array[0] : null;
		$option_name_suffix = isset( $option_name_array[1] ) ? $option_name_array[1] : null;
		$option_name        = 'scf_' . $option_name_prefix;

		$option = get_option( $option_name, $default );

		if ( ! is_null ( $option_name_suffix ) ) {
			$option = isset( $option[ $option_name_suffix ] ) ? $option[ $option_name_suffix ] : $default;
		}

		if ( ( empty( $option ) || is_null( $option ) ) ) {
			$default_options = \WPPOOL\SCF\App::options();
			$option          = isset( $default_options[ $option_name_prefix ] ) ? $default_options[ $option_name_prefix ] : $default;

			if ( isset( $option_name_suffix ) && ! empty( $option_name_suffix ) ) {
				$option = isset( $option[ $option_name_suffix ] ) ? $option[ $option_name_suffix ] : $default;
			}
		}

		return $option;
	}
}

if ( ! function_exists( 'scf_get_options' ) ) {
	/**
	 * Get options.
	 *
	 * @return array
	 */
	function scf_get_options() {
		$options = \WPPOOL\SCF\App::options();

		$option_values = [];

		foreach ( $options as $option_name => $option_value ) {
			$option_values[ $option_name ] = scf_get_option( $option_name, $option_value );
		}
		return $option_values;
	}
}

if ( ! function_exists( 'scf_render' ) ) {
	/**
	 * Render template.
	 *
	 * @param string $template Template name.
	 * @param array  $args Arguments.
	 */
	function scf_render( $template, $args = [] ) { // phpcs:ignore
		$template_path = SCF_TEMPLATE . '/' . $template . '.php';
		if ( file_exists( $template_path ) ) {
			include $template_path;
		}
	}
}


if ( ! function_exists( 'scf_is_true' ) ) {
	/**
	 * Check is true.
	 *
	 * @param mixed $value Value.
	 * @return bool
	 */
	function scf_is_true( $value ) {
		return wp_validate_boolean( $value );
	}
}

if ( ! function_exists('scf_is_dev') ) {
	/**
	 * Check is dev.
	 *
	 * @return bool
	 */
	function scf_is_dev() {
		return defined('WP_DEBUG') && WP_DEBUG;
	}
}
