<?php
/**
 * Boot file.
 * Loads all the required files.
 *
 * @package SocialContactForm
 * @since 1.0.0
 */

// Other constants.
define( 'SCF_DIR', plugin_dir_path( SCF_FILE ) );
define( 'SCF_URL', plugin_dir_url( SCF_FILE ) );
define( 'SCF_INC', SCF_DIR . DIRECTORY_SEPARATOR . 'includes' );
define( 'SCF_PUBLIC', SCF_URL . 'public' );
define( 'SCF_TEMPLATE', SCF_DIR . DIRECTORY_SEPARATOR . 'templates' );

// Require files.
if ( file_exists( SCF_INC . '/wppool/class-plugin.php' ) ) {
	require_once SCF_INC . '/wppool/class-plugin.php';
}

// core files.
require_once SCF_INC . '/others/trait-common.php';

require_once SCF_INC . '/classes/class-app.php';

require_once SCF_INC . '/others/functions.php';


require_once SCF_INC . '/models/class-lead.php';

require_once SCF_INC . '/admin/class-admin-hooks.php';

require_once SCF_INC . '/admin/class-admin-ajax.php';

require_once SCF_INC . '/contact-form/class-admin-contact-form.php';

require_once SCF_INC . '/contact-form/class-admin-send-message.php';

/**
 * Global hooks
 */
require_once SCF_INC . '/classes/class-hooks.php';

require_once SCF_INC . '/classes/class-field.php';

