<?php
global $post, $PIXAD_Autos;
$Settings = new PIXAD_Settings();
$settings = $Settings->getSettings('WP_OPTIONS', '_pixad_autos_settings', true);

$validate = $Settings->getSettings('WP_OPTIONS', '_pixad_autos_validation', true); // Get validation settings


$showInList = pixad::getlistviewfields($validate);
//print_r($showInList);

$validate = pixad::validation($validate); // Fix undefined index notice

$auto_translate = unserialize(get_option('_pixad_auto_translate'));

$daysCount = $_GET['daysCount'] ?? 1;
$datesRequest = $_GET['$datesRequest'] ?? '';

?>
<?php while (have_posts()) : the_post(); ?>

<?php
    $comment_args = array('status' => 'approve', 'post_id' => $post->ID,);
    $comments = get_comments($comment_args);
    $post_rating = [];
    foreach ($comments as $comment) {
        $post_rating[] = floatval(get_comment_meta($comment->comment_ID, 'rating', true));
    }
    $pixad_auto_price_season = get_post_meta(get_the_ID(), 'pixad_auto_price_season', []);
    $season_price_class = '';

    $currentTime = new DateTime();
    foreach ($pixad_auto_price_season as $key => $price) {
        foreach ($price as $p) {

            $date_start = DateTime::createFromFormat('Y-m-d', $p['pixad_auto_price_season_start']);
            $date_end = DateTime::createFromFormat('Y-m-d', $p['pixad_auto_price_season_end']);
            $date_start->getTimestamp();
            $date_end->getTimestamp();
            $currentTime->getTimestamp();

            if (($date_start <= $currentTime) and ($currentTime >= $date_end)) {
            } else {
                $season_price_class = "card_season_price";
            }
        }
    }

    ?>
<article class="card clearfix <?php echo esc_attr($season_price_class) ?>" id="post-<?php the_ID(); ?>">
    <div class="card__img">
        <?php if (has_post_thumbnail()) : ?>
        <a href="<?php the_permalink(); ?>">
            <?php the_post_thumbnail('autozone-auto-cat', array('class' => 'img-responsive')); ?>
        </a>
        <?php else : ?>
        <img class="no-image" src="<?php echo PIXAD_AUTO_URI . 'assets/img/no_image.jpg'; ?>" alt="no-image">
        <?php endif; ?>

        <?php if (get_post_meta(get_the_ID(), 'pixad_auto_featured_text', true)) : ?>
        <span class="card__wrap-label"><span class="card__label"><?php echo  get_post_meta(get_the_ID(), 'pixad_auto_featured_text', true); ?></span></span>
        <?php endif; ?>

        <?php if ($PIXAD_Autos->get_meta('_auto_sale_price') != '') : ?>
        <span class="card__wrap-label sale"><?php esc_html_e('Sale', 'autozone'); ?></span>
        <?php endif; ?>
        <?php do_action('autozone_autos_single_auto_img', $post); ?>


        <?php if (is_user_logged_in()) : ?>
        <?php
                $author_ID = get_post_field('post_author', get_the_ID());
                $user = get_user_by('ID', $author_ID);
                if ($author_ID == get_current_user_id()) { ?>
        <a class="tm-autos-top-edit-button" href=" <?php echo esc_url(get_site_url() . '/members/') . $user->user_login . '/add_item?auto_id=' . get_the_ID(); ?>"><span><?php echo __('Edit', 'autozone') ?></span></a>
        <?php } ?>
        <?php endif; ?>

    </div>
    <div class="card__inner">
        <h2 class="card__title ui-title-inner"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
        <div class="decor-1"></div>
        <?php if (!empty($post_rating)) : ?>
        <div class="star-rating"><span style="width:<?php echo  esc_html(array_sum($post_rating) / count($post_rating) * 20); ?>%"></span></div>
        <?php endif; ?>

        <div class="card__description">
            <p><?php if (has_excerpt()) {
                            the_excerpt();
                        } ?></p>
        </div>


        <div class="card__flex_col">
            <div class="card__desc_col">
                <div class="card__desc_wrap">


                    <!-- Car Details -->
                    <ul class="card__list list-unstyled">



                        <?php foreach ($showInList as $id => $sideAttribute) : ?>
                        <?php

                        $settingName =  $showInList[$id]['title'];
                        $settingName = trim($settingName);

                        //       $settingName = esc_html__( $settingName.':', 'autozone' );

                        $id = '_' . $id;
                        $id = str_replace('-', '_', $id);
                        ?>
                        <?php if ($PIXAD_Autos->get_meta($id)) : ?>
                        <li class="card-list__row">
                            <?php
                                $val_attr =  $PIXAD_Autos->get_meta($id);
                                if (!empty($auto_translate[$val_attr])) {
                                    //   echo esc_html($auto_translate[$val_attr]);
                                ?>
                            <span class="card-list__title">
                                <?php

                                        if ($settingName) {
                                            //  esc_html_e( $settingName.':', 'autozone' ); 
                                            echo esc_html($auto_translate[$settingName]) . ": ";
                                        } else {
                                            $customId = substr($id, 1);
                                            $сustomSettingName  = $validate[$customId . '_name'];
                                            echo   esc_html($сustomSettingName);
                                        }

                                        ?></span>
                            <span class="card-list__info">
                                <?php
                                        echo esc_html($auto_translate[$val_attr]);
                                        ?>
                            </span>
                            <?php } else { ?>
                            <span class="card-list__title">
                                <?php

                                        if ($settingName) {
                                            //   esc_html_e( $settingName.':', 'autozone' ); 
                                            echo esc_html($auto_translate[$settingName]) . ": ";
                                        } else {
                                            $customId = substr($id, 1);
                                            $сustomSettingName  = $validate[$customId . '_name'];
                                            echo   esc_html($сustomSettingName);
                                        }

                                        ?></span>

                            <span class="card-list__info">
                                <?php
                                        if ($id == '_auto_mileage') {
                                            echo number_format($PIXAD_Autos->get_meta('_auto_mileage'), 0, '', "{$settings['autos_thousand']}");
                                        } else {
                                            echo esc_html($PIXAD_Autos->get_meta($id));
                                        }
                                        // echo $id
                                        if ($id == '_auto_horsepower') {
                                            echo " ";
                                            esc_html_e('hp', 'autozone');
                                        } elseif ($id == '_auto_engine') {
                                            echo " ";
                                            esc_html_e('cm3', 'autozone');
                                        } elseif ($id == '_auto_doors') {
                                            echo " ";
                                            esc_html_e('doors', 'autozone');
                                        }

                                        ?>
                            </span>
                            <?php } ?>
                        </li>
                        <?php endif; ?>

                        <?php endforeach; ?>

                        <?php if (array_key_exists('auto-date', $showInList)  && $validate['auto-date_show'] && get_the_date()) : ?>
                        <li><span class="card-list__title"><?php esc_html_e('Updated :', 'autozone'); ?></span>
                            <span><?php echo get_the_date(); ?></span>
                        </li>
                        <?php endif; ?>


                    </ul><!-- / Car Details -->
                </div>
            </div>

            <div class="card__price_col">

                <?php if ($validate['auto-price_show'] && $PIXAD_Autos->get_meta('_auto_price')) : ?>
                <?php
                $custom_price_catalog = get_post_meta($post->ID, 'custom_price_catalog', 1);
                $price_catalog = $custom_price_catalog ? $custom_price_catalog :
                    $PIXAD_Autos->get_price(null, $daysCount);
                //$price_catalog = is_numeric($PIXAD_Autos->get_meta('_auto_price')) || $PIXAD_Autos->get_meta('_auto_price') == '' ? $PIXAD_Autos->get_price() : $auto_translate[$PIXAD_Autos->get_price()];
                ?>


                <?php //$price = is_numeric($PIXAD_Autos->get_meta('_auto_price')) || $PIXAD_Autos->get_meta('_auto_price') == ''  ? $PIXAD_Autos->get_price() : $auto_translate[$PIXAD_Autos->get_price()]; 
                ?>

                <?php
                $Settings = new PIXAD_Settings();
                $options = $Settings->getSettings('WP_OPTIONS', '_pixad_autos_settings', true);

                $text_after = "";
                if ($daysCount === 1) {
                    $text_after     = isset($options['autos_price_text']) ? $options['autos_price_text'] : '';
                } else {
                    $text_after = "/ per " . $daysCount . " days";
                }


                $currentTime = new DateTime();
                $currency = pixad_get_currencies($options['autos_site_currency']);
                $pixad_auto_price_season = get_post_meta(get_the_ID(), 'pixad_auto_price_season', []);
                foreach ($pixad_auto_price_season as $key => $price) {
                    foreach ($price as $p) {

                        $date_start = DateTime::createFromFormat('Y-m-d', $p['pixad_auto_price_season_start']);
                        $date_end = DateTime::createFromFormat('Y-m-d', $p['pixad_auto_price_season_end']);
                        $date_start->getTimestamp();
                        $date_end->getTimestamp();
                        $currentTime->getTimestamp();
                        $season_price_class = "card_season_price";

                        if (($date_start <= $currentTime) and ($currentTime <= $date_end)) {
                            $price_catalog = '<span class="card__price-number">' . $currency['symbol'] . $p['pixad_auto_price_season_price'] * $daysCount . '<span class="after-price-text">' . $text_after . '</span></span>';
                            //  $price_catalog .= '<span class="price_description">'. __('Price from ', 'pixba') . $date_start->format('d F') . __(' to ', 'pixba') . $date_end->format('d F') . '</span>';

                        } else {

                            $price_catalog .= '<div class="season_prices">';
                            $price_catalog .= '<span class="card__price-number">' . $currency['symbol'] . $p['pixad_auto_price_season_price'] * $daysCount . '<span class="after-price-text">' . $text_after . '</span></span>';
                            $price_catalog .= '<span class="price_description">' .  $date_start->format('d F') . __(' to ', 'autozone') . $date_end->format('d F') . '</span>';
                            $price_catalog .= '</div>';
                        }
                    }
                }
                ?>


                <div class="card__price"><?php esc_html_e('PRICE:', 'autozone') ?><span class="card__price-number"><?php echo wp_kses_post($price_catalog); ?></span></div>
                <div class="card__book_link">
                    <a href="<?php the_permalink();?><?php esc_attr_e($datesRequest);?>"><?php esc_html_e('Read More', 'autozone') ?><i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
                </div>
                <?php endif; ?>

            </div>
        </div>

        <?php
            $gallery = array();
            $values = get_post_custom($post->ID);
            if (class_exists('Pix_Autos')) {
                if (isset($values['pixad_auto_gallery_2'][0])) {
                    $gallery = json_decode(pix_baseencode($values['pixad_auto_gallery_2'][0]));
                }
            }


            if (isset($values['pixad_auto_gallery_2'][0]) && $gallery[0]  !== '-1') {
                if (!empty($gallery) && array_key_exists('1', $gallery)) {
                    $listClass = 'auto-promo-inline';
                } else {
                    $listClass = '';
                }
                echo "<div class='promo_gallery_wrapper " . $listClass . "'><ul>";
            }
            if (isset($gallery[0]) && !empty($gallery[0]) && $gallery[0]  !== '-1') {
                // The json decode and base64 decode return an array of image ids
                $attachment_ids = $gallery;
            } else {
                $attachment_ids = array();
            }
            foreach ($attachment_ids as $attachment_id) {
                //  $image       = wp_get_attachment_image( $attachment_id, 'autozone-auto-single_crop' );
                $image       = wp_get_attachment_image($attachment_id, 'autozone-thumb');
                echo '<li>' . $image . '</li>';
            }
            if (isset($values['pixad_auto_gallery_2'][0]) && $gallery[0]  !== '-1') {
                echo "</ul></div>";
            } ?>


    </div>

</article>
<?php endwhile; ?>
