<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">

<meta name="viewport" content="width=device-width">


<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-ZSLHQWM9W0"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-ZSLHQWM9W0');
</script>
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> data-scrolling-animations="false" data-header="fixed-header">
<?php wp_body_open(); ?>
<?php
    
   if ( ! class_exists( 'PixthemeCustom' ) ){
		$additional_custom_class = 'tmpl-plugins-not-activated';
	}else{
		$additional_custom_class = 'tmpl-plugins-activated';
	}
    if ( class_exists( 'Templines_Helper_Core_Addons' ) ){
        $additional_custom_class = 'tmpl-plugins-activated';
    }

	$post_ID = isset ($wp_query) ? $wp_query->get_queried_object_id() : (isset($post->ID) && $post->ID>0 ? $post->ID : '');
	if( class_exists( 'WooCommerce' ) && autozone_is_woo_page() && autozone_get_option('autozone_woo_header_global','1') ){
		$post_ID = get_option( 'woocommerce_shop_page_id' ) ? get_option( 'woocommerce_shop_page_id' ) : $post_ID;
	}

	$autozone_header = apply_filters('autozone_header_settings', $post_ID);
?>


<?php if( (autozone_get_option('loader_settings_loader','useall') == 'usemain' && is_front_page() ) || autozone_get_option('loader_settings_loader','') == 'useall' ) : ?>
<!-- Loader -->

<?php if (autozone_get_option('loader_settings_img','')) { ?>
	<div id="loader" style="background-image: url(<?php echo esc_url(autozone_get_option('loader_settings_img','')) ?> "></div>
<?php } else { ?>
	<div id="page-preloader">
        
  
        <div id="cssload-wrapper">
            <div class="cssload-loader">
                <div class="cssload-line"></div>
                <div class="cssload-line"></div>
                <div class="cssload-line"></div>
                <div class="cssload-line"></div>
                <div class="cssload-line"></div>
                <div class="cssload-line"></div>
                <div class="cssload-subline"></div>
                <div class="cssload-subline"></div>
                <div class="cssload-subline"></div>
                <div class="cssload-subline"></div>
                <div class="cssload-subline"></div>
                <div class="cssload-loader-circle-1"><div class="cssload-loader-circle-2"></div></div>
                <div class="cssload-needle"></div>
                <div class="cssload-loading">loading</div>
            </div>
        </div>

    
    </div>
    
<?php } ?>






<!-- Loader end -->
<?php endif; ?>



<?php
	include(get_template_directory() . '/templates/header/header_menu/search.php');

	if ( in_array($autozone_header['header_menu_add_position'], array('left', 'right', 'top', 'bottom'))  && $autozone_header['header_type'] != 'header3' ) {
		include(get_template_directory() . '/templates/header/header_menu/slide.php');
	}
	?>
<div class="h-menu-mobile" id="js-mobile-menu">
    <div class="h-menu-mobile__menu-shadow"></div>
    <div class="h-menu-mobile__menu-wrap">
        <div class="h-menu-mobile__menu-buttons">
            <button type="button" class="h-menu-mobile__menu-back" id="mobile-menu-back">
                <i class="fa fa-angle-left" aria-hidden="true"></i>
                Back
            </button>
            <button type="button" class="h-menu-mobile__menu-close" id="mobile-menu-close">
                <i class="fa fa-close" aria-hidden="true"></i>
            </button>
        </div>
        <div class="h-menu-mobile__menu-content">
			<?php
			if ( has_nav_menu( 'mobile_nav' ) ) {
				wp_nav_menu(array(
					'theme_location'  => 'mobile_nav',
					'container'       => false,
					'menu_id'		  => 'mobile-menu',
					'menu_class'      => 'h-menu-mobile__nav'
				));
			} else {
				echo autozone_site_menu('h-menu-mobile__nav');
			}
			?>
            <ul class="h-menu-mobile__contact">
		        <?php if ($autozone_header['header_phone']) : ?>
                    <li><i class="icon fa fa-phone"></i> <a href="tel:<?php echo wp_kses_post(autozone_get_option('header_phone', '')) ?> "><?php echo wp_kses_post(autozone_get_option('header_phone', '')) ?> </a>
                    </li>
		        <?php endif; ?>
		        <?php if ($autozone_header['header_email']) : ?>
                    <li><i class="icon fa fa-envelope"></i> <a href="mailto:<?php echo wp_kses_post(autozone_get_option('header_email', '')) ?>"><?php echo wp_kses_post(autozone_get_option('header_email', '')) ?></a></li>
		        <?php endif; ?>
            </ul>
            <div class="h-menu-mobile__custom-button">
		        <?php if ( $autozone_header['header_custom_button']) :  ?>
                    <a class="autozone-custom-button" href="<?php echo esc_attr($autozone_header['header_custom_button_link']); ?>">
				        <?php // echo esc_attr($autozone_header['header_custom_button_name']); ?>
				        <?php   _e($autozone_header['header_custom_button_name'], 'autozone') ?>
				        <?php
				        if(has_action('wpml_register_single_string')) {
					        $header_custom_button_name      = strip_tags($autozone_header['header_custom_button_name']);
					        do_action( 'wpml_register_single_string', 'autozone', 'Custom Button name', $header_custom_button_name );
				        }
				        ?>
                    </a>
		        <?php endif; ?>
            </div>
        </div>
        <div class="h-menu-mobile__socials">
		    <?php if ( $autozone_header['header_socials'] ) : ?>
                <ul>
				    <?php if (autozone_get_option('social_facebook', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_facebook', '')); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_vk', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_vk', '')); ?>" target="_blank"><i class="fa fa-vk"></i></a></li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_youtube', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_youtube', '')); ?>" target="_blank"><i class="fa fa-youtube"></i></a></li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_vimeo', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_vimeo', '')); ?>" target="_blank"><i class="fa fa-vimeo"></i></a></li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_twitter', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_twitter', '')); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_google', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_google', '')); ?>" target="_blank"><i class="fa fa-google-plus"></i></a></li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_tumblr', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_tumblr', '')); ?>" target="_blank"><i class="fa fa-tumblr"></i></a></li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_instagram', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_instagram', '')); ?>" target="_blank"><i class="fa fa-instagram"></i></a></li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_pinterest', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_pinterest', '')); ?>" target="_blank"><i class="fa fa-pinterest"></i></a></li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_linkedin', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_linkedin', '')); ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_custom_url_1', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_custom_url_1', '')); ?>" target="_blank"><i class="fa <?php echo esc_attr(autozone_get_option('social_custom_icon_1', '')); ?>"></i></a>
                        </li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_custom_url_2', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_custom_url_2', '')); ?>" target="_blank"><i class="fa <?php echo esc_attr(autozone_get_option('social_custom_icon_2', '')); ?>"></i></a>
                        </li>
				    <?php } ?>
				    <?php if (autozone_get_option('social_custom_url_3', '')) { ?>
                        <li class="header-social-link"><a href="<?php echo esc_url(autozone_get_option('social_custom_url_3', '')); ?>" target="_blank"><i class="fa <?php echo esc_attr(autozone_get_option('social_custom_icon_3', '')); ?>"></i></a>
                        </li>
				    <?php } ?>
                </ul>
		    <?php endif; ?>
        </div>
    </div>
</div>
<div class="header-mobile">
    <div class="header-mobile__top">
        <div class="container header-mobile__top-wrap">
            <ul>
                <?php if ($autozone_header['header_phone']) : ?>
                    <li class="no-hover header-phone"><i class="icon fa fa-phone"></i> <a href="tel:<?php echo wp_kses_post(autozone_get_option('header_phone', '')) ?> "><?php echo wp_kses_post(autozone_get_option('header_phone', '')) ?> </a>
                    </li>
                <?php endif; ?>
                <?php if ($autozone_header['header_email']) : ?>
                    <li class="no-hover header-email"><i class="icon fa fa-envelope"></i> <a href="mailto:<?php echo wp_kses_post(autozone_get_option('header_email', '')) ?>"><?php echo wp_kses_post(autozone_get_option('header_email', '')) ?></a></li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
    <div class="container header-mobile__wrap">
        <a class="header-mobile__logo-mobile" href="<?php echo esc_url(home_url('/')) ?>" >
            <?php if ($autozone_header['logo']): ?>
                <img class="header-mobile__logo-img" src="<?php echo esc_url($autozone_header['logo']) ?>" alt="logo" />
            <?php else: ?>
                <img class="header-mobile__logo-img" src="<?php echo get_template_directory_uri(); ?>/images/logo-w.png" alt="logo" />
            <?php endif ?>
        </a>
        <div class="header-mobile__center">
	        <?php if(class_exists('WooCommerce') && $autozone_header['header_minicart']){  ?>
            <div class="header-mobile__bag">
                <a href="<?php echo wc_get_cart_url();?>"><span class="theme-fonts-icon_bag_alt"></span></a>
                <span class="header-cart-count"><?php echo WC()->cart->cart_contents_count; ?></span>
            </div>
            <?php } ?>
            <div class="header-mobile__custom-button">
	            <?php if ( $autozone_header['header_custom_button']) :  ?>
                    <a class="autozone-custom-button" href="<?php echo esc_attr($autozone_header['header_custom_button_link']); ?>">
			            <?php // echo esc_attr($autozone_header['header_custom_button_name']); ?>
			            <?php   _e($autozone_header['header_custom_button_name'], 'autozone') ?>
			            <?php
			            if(has_action('wpml_register_single_string')) {
				            $header_custom_button_name      = strip_tags($autozone_header['header_custom_button_name']);
				            do_action( 'wpml_register_single_string', 'autozone', 'Custom Button name', $header_custom_button_name );
			            }
			            ?>
                    </a>
	            <?php endif; ?>
            </div>
	        <?php do_action( 'autozone_header_start', $autozone_header); ?>
        </div>
        <button class="toggle-menu-button " id="mobile-menu-open">
                            <span class="toggle-menu-button-icon"><span></span> <span></span> <span></span> <span></span>
                                <span></span> <span></span></span>
        </button>
    </div>
</div>

	<?php
	if ( $autozone_header['header_menu_add_position'] == 'screen' && $autozone_header['header_type'] != 'header3' ) {
		include(get_template_directory() . '/templates/header/header_menu/full-screen.php');
	}
?>

<?php if($autozone_header['header_sidebar_view'] == 'fixed') : ?>
	<!-- FIXED SIDEBAR MENU  -->
	<div class="wrap-left-open ">
<?php endif; ?>
        


<?php
	if($autozone_header['header_type'] == 'header3')
		autozone_get_theme_header();
?>

<?php if($autozone_header['header_menu_animation'] == 'reveal') : ?>
	<!-- ========================== -->
	<!-- CONTAINER SLIDE MENU  -->
	<!-- ========================== -->
	<div data-canvas="container">
<?php endif; ?>
        
   

<div class="layout-theme animated-css <?php echo esc_attr($additional_custom_class)?> "  data-header="<?php echo esc_attr($autozone_header['header_sticky'] != 'sticky' ? 'nosticky' : 'sticky');?>" data-header-top="2"  >

<?php
	if($autozone_header['header_type'] != 'header3')
		autozone_get_theme_header();

	if (!is_page_template('page-home.php')) {
		autozone_load_block('header/title');
	}
?>

<div id="wrapper">



