jQuery(document).ready(function ($) {

    "use strict";

    var $toggle_mobile_menu = $('#js-mobile-menu');
    var $toggle_mobile_menu_open = $('#mobile-menu-open');
    var $toggle_mobile_menu_close = $('#mobile-menu-close,.h-menu-mobile__menu-shadow');
    var $toggle_mobile_menu_back = $('#mobile-menu-back');
    var $toggle_mobile_menu_wrap = $('.h-menu-mobile__menu-wrap');
    var $toggle_mobile_menu_doc = $('html');
    var $toggle_mobile_submenu = [];
    var toggle_mobile_menu_initialized = false;
    var toggle_mobile_menu_active = false;
    var templines_is_mobile_layout = window.innerWidth < 1170;

    function templines_empty(obj) {
        return typeof (obj) == 'undefined' || (typeof (obj) == 'object' && obj == null) || typeof (obj) == 'string' || obj === 0;
    }

    function toggle_mobile_menu_popup(show) {
        if (toggle_mobile_menu_initialized) {
            if (show && !toggle_mobile_menu_active) {
                toggle_mobile_menu_active = true;
                $toggle_mobile_menu_doc.addClass('no-scroll-mobile');
                $toggle_mobile_menu.addClass('h-menu-mobile__menu--active');
                $toggle_mobile_menu_wrap.addClass('h-menu-mobile__menu-wrap--active');
            } else if (toggle_mobile_menu_active) {
                toggle_mobile_menu_active = false;
                $toggle_mobile_menu_doc.removeClass('no-scroll-mobile');
                $toggle_mobile_menu.removeClass('h-menu-mobile__menu--active');
                $toggle_mobile_menu_wrap.removeClass('h-menu-mobile__menu-wrap--active');
            }
        }
    };

    var Core = {


        initialized: false,
        initialize: function () {
            if (this.initialized)
                return;
            this.initialized = true;
            this.build();
        },


        build: function () {

            this.fixedHeader();
            // Init toggle menu
            this.initToggleMenu();
            // Search
            this.initSearchModal();
            // Dropdown menu
            this.dropdownhover();
            // Submenu
            this.submenuControll();
            // mobile menu
            this.mobile_menu_init();


        },



        // Searc Modal

        initSearchModal: function (options) {




            $(document).on("click", ".btn_header_search", function (event) {


                $(".header-search").addClass("open");
            });


            $(document).on("click", ".search-form_close", function (event) {

                $(".header-search").removeClass("open");
            });



            $(document).on("click", ".btn_header_subscribe", function (event) {


                $(".header-subscribe").addClass("open");
            });
            $(document).on("click", ".search-form_close", function (event) {

                $(".header-subscribe").removeClass("open");
            });





        },

        // Toggle Menu

        initToggleMenu: function () {


        },

        // Dropdown

        dropdownhover: function (options) {

            $(" .header .dropdown").hover(
                function () {
                    $(this).toggleClass('open');
                },
                function () {
                    $(this).toggleClass('open');
                }
            );

        },


        //Fixed header

        fixedHeader: function (options) {
            if ($(window).width() > 767) {
                // Fixed Header
                var topOffset = $(window).scrollTop();
                if (topOffset > 90) {


                    if ($(".header").is(".navbar-fixed-js")) {

                        $('.header').addClass('navbar-scrolling');


                    }


                }
                $(window).on('scroll', function () {
                    var fromTop = $(this).scrollTop();
                    if (fromTop > 90) {

                        if ($(".header").is(".navbar-fixed-js")) {

                            $('body').addClass('fixed-header');
                            $('.header').addClass('navbar-scrolling');

                        }

                    } else {
                        $('body').removeClass('fixed-header');
                        $('.header').removeClass('navbar-scrolling');
                    }

                });
            }
        },


        // Submenu

        submenuControll: function (options) {

            $('li.menu-item-has-children a').prepend('<span class="submenu-controll"></span>')


            $(".mobile-slidebar-menu li.dropdown").click(function () {




                $('.mobile-slidebar-menu li').removeClass('dropdown-open-mobile');

                $(this).toggleClass('dropdown-open-mobile');


            });


            $('li.menu-item-has-children li.menu-item-has-children').prepend('<span class="submenu-controll-inner"><i class="fa fa-angle-right" aria-hidden="true"></i></span>');


            $('.slidebar-menu  li.menu-item-has-children').prepend('<span class="submenu-controll-inner"><i class="fa fa-angle-right" aria-hidden="true"></i></span>');


        },

        mobile_menu_init: function (options) {
            if (templines_is_mobile_layout && !toggle_mobile_menu_initialized && $toggle_mobile_menu.length) {
                $(document).on('templines.wpadminbar.scroll', function (event, wpadminbar_height) {
                    $toggle_mobile_menu.css({
                        transform: 'translateY(' + wpadminbar_height + 'px)',
                        'max-height': 'calc(100% - ' + wpadminbar_height + 'px)'
                    });
                });
                $toggle_mobile_menu.find('.h-menu-mobile__menu-content .menu-item-has-children').each(function () {
                    var $li = $(this);
                    if ($li.find('ul').length) {
                        var $button = $('<button type="button" class="h-menu-mobile__more js-tiggle-submenu"><i class="fa fa-angle-right" aria-hidden="true"></i></button>');
                        $li.find('.dropdown-menu').addClass('h-menu-mobile__submenu');
                        $li.find('.dropdown-menu').removeClass('dropdown-menu');
                        $li.append($button);
                        $li.children('a').each(function () {
                            if (templines_empty($(this).attr('href'))) {
                                $(this).click(function () {
                                    $button.trigger('click');
                                });
                            }
                        });
                    }
                });
                $('.js-tiggle-submenu').click(function () {
                    var $submenu = $(this).closest('li').children('ul');
                    var $current_submenu = $(this).closest('.h-menu-mobile__submenu');
                    $toggle_mobile_submenu.push($submenu);
                    var top = $('.h-menu-mobile__menu-buttons').outerHeight();
                    var bottom = $('.h-menu-mobile__socials').outerHeight();
                    if ($toggle_mobile_submenu.length == 1) {
                        $submenu.css({
                            top: top + 'px',
                            bottom: bottom + 'px',
                            'max-height': 'calc(100% - ' + (top + bottom) + 'px)'
                        });
                    }
                    if ($current_submenu.length) {
                        $current_submenu.scrollTop(0);
                        $current_submenu.addClass('h-menu-mobile__submenu--parent');
                    }
                    $submenu.addClass('h-menu-mobile__submenu--active');
                    $toggle_mobile_menu_back.addClass('h-menu-mobile__menu-back--active');
                });
                $toggle_mobile_menu_back.click(function () {
                    if ($toggle_mobile_submenu.length) {
                        var $submenu = $toggle_mobile_submenu.pop();
                        $submenu.removeClass('h-menu-mobile__submenu--active');
                    }
                    if (!$toggle_mobile_submenu.length) {
                        $toggle_mobile_menu_back.removeClass('h-menu-mobile__menu-back--active');
                    } else {
                        var $prev = $toggle_mobile_submenu[$toggle_mobile_submenu.length - 1];
                        $prev.removeClass('h-menu-mobile__submenu--parent');
                    }
                });
                $toggle_mobile_menu_open.click(function () {
                    toggle_mobile_menu_popup(true);
                });
                $toggle_mobile_menu_close.click(function () {
                    toggle_mobile_menu_popup(false);
                });
                toggle_mobile_menu_initialized = true;
            }
        },


    };






    Core.initialize();


});
