<?php
// Autos Tab
function templines_helper_profile_tab_autos() {
    global $bp;
    bp_core_new_nav_item( array(
        'name' => 'Autos',
        'slug' => 'autos',
        'screen_function' => 'templines_helper_autos_screen',
        'position' => 40,
        'parent_url'      => bp_loggedin_user_domain() . '/autos/',
        'parent_slug'     => $bp->profile->slug,
        'default_subnav_slug' => 'autos'
    ) );
}
add_action( 'bp_setup_nav', 'templines_helper_profile_tab_autos' );
function templines_helper_autos_screen() {
    add_action( 'bp_template_title', 'templines_helper_autos_title' );
    add_action( 'bp_template_content', 'templines_helper_autos_content' );
    bp_core_load_template( 'buddypress/members/single/plugins' );
}
function templines_helper_autos_title() {
    $return_title = '';
    $return_title .= '
                        <div class="item-list-tabs youzify-default-subnav no-ajax" id="subnav" aria-label="Member secondary navigation" role="navigation">
                            <ul>
                                <li id="posts-all-personal-li" class="current selected"><a id="all" href="#"><i class="fas fa-globe"></i>'.__("Autos", "templines-helper-core").'</a></li>
                            </ul>
                        </div>
                        ';
    echo $return_title;
}
function templines_helper_autos_content() {

    global $post, $PIXAD_Autos;
    $Settings = new PIXAD_Settings();
    $settings = $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_settings', true );
    $validate = $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_validation', true ); // Get validation settings

    if(isset($_GET['auto_id']) && $_GET['auto_id'] != ''){
        if(isset($_GET['hide']) && $_GET['hide'] == 'true'){

            $update_auto = array(
                'ID' => $_GET['auto_id'],
                'post_status' => 'draft'
            );
            wp_update_post($update_auto);

        } elseif (isset($_GET['hide']) && $_GET['hide'] == 'false'){
            $update_auto = array(
                'ID' => $_GET['auto_id'],
                'post_status' => 'publish'
            );
            wp_update_post($update_auto);
        }
    }

    $showInList = pixad::getlistviewfields($validate);
    $validate = pixad::validation( $validate );
    $auto_translate = unserialize( get_option( '_pixad_auto_translate' ) );
    $author_ID =  bp_displayed_user_id();
    $args = array(
        'post_type' => 'pixad-autos',
        'post_status' => array('publish'),
        'orderby' => 'post_status',
        'order'   => 'DESC',
        'author'    =>  $author_ID,
        'posts_per_page'	=> intval($settings['autos_per_page']),
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1
    );
    $autos_publish = new WP_Query($args);


    $args_pending = array(
        'post_type' => 'pixad-autos',
        'post_status' => array('pending', 'draft'),
        'orderby' => 'post_status',
        'order'   => 'DESC',
        'author'    =>  $author_ID,
        'posts_per_page'	=> intval($settings['autos_per_page']),
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1
    );
    $autos_pending = new WP_Query($args_pending);

    ?>
<div id="pixad-listing" class="list">
    <?php if(is_user_logged_in()){?>
    <?php if(get_current_user_id() == bp_displayed_user_id()){?>
    <?php if ($autos_pending->have_posts()) : while ( $autos_pending->have_posts() ) : $autos_pending->the_post();
                    $comment_args = array( 'status' => 'approve', 'post_id' => $autos_pending->ID, );
                    $comments = get_comments($comment_args);
                    $post_rating = [];

                    foreach($comments as $comment){
                        $post_rating[] = floatval( get_comment_meta( $comment->comment_ID, 'rating', true ) );
                    }
                    ?>
    <article class="card clearfix auto-pending" id="post-<?php the_ID(); ?>">
        <div class="card__img">
            <?php if( has_post_thumbnail() ): ?>
            <a href="<?php the_permalink(); ?>">
                <?php the_post_thumbnail('autozone-auto-cat', array('class' => 'img-responsive')); ?>
            </a>
            <?php else: ?>
            <img class="no-image" src="<?php echo PIXAD_AUTO_URI .'assets/img/no_image.jpg'; ?>" alt="no-image">
            <?php endif; ?>


            <span class="card__wrap-label templines-label-status-<?php echo get_post_status(); ?>">
                <span class="card__label">
                    <?php
                                            $status = get_post_status() == 'publish' ? 'published' : get_post_status();
                                            echo esc_html($status);
                                            ?>
                </span>
            </span>


            <?php if( $PIXAD_Autos->get_meta('_auto_sale_price') != '' ): ?>
            <span class="card__wrap-label sale"><?php esc_html_e( 'Sale', 'autozone' ); ?></span>
            <?php endif; ?>
            <?php do_action( 'autozone_autos_single_auto_img', $post ); ?>


            <?php if( is_user_logged_in() ): ?>
            <?php
                                $author_ID =  bp_displayed_user_id();
                                $user = get_user_by('ID', $author_ID);
                                if( $author_ID == get_current_user_id()){?>
            <a class="tm-autos-top-edit-button" href=" <?php echo esc_url(get_site_url().'/members/') . $user->user_login . '/add_item?auto_id=' . get_the_ID();?>"><span><?php echo __('Edit', 'templines-helper-core')?></span></a>

            <?php if(get_post_status() == 'draft'){?>
            <a class="tm-autos-top-draft-button" href="<?php echo esc_url(get_site_url().'/members/') . $user->user_login . '/autos?hide=false&auto_id=' . get_the_ID();?>">
                <span><?php echo __('Show', 'templines-helper-core')?></span>
            </a>
            <?php } ?>

            <?php } ?>
            <?php endif; ?>

        </div>


        <div class="card__inner">

            <h2 class="card__title ui-title-inner"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
            <div class="decor-1"></div>



            <div class="card__flex_col">
                <div class="card__flex_col">


                    <div class="card__description">
                        <p><?php if( has_excerpt() ){
                                            the_excerpt();
                                        } ?></p>
                    </div>


                    <div class="card__desc_wrap">

                        <!-- Car Details -->
                        <ul class="card__list list-unstyled">
                            <?php foreach ($showInList as $id => $sideAttribute):?>
                            <?php
                                        $settingName =  $showInList[$id]['title'];
                                        $settingName = trim($settingName);
                                        //       $settingName = esc_html__( $settingName.':', 'autozone' );

                                        $id='_'.$id;
                                        $id = str_replace('-', '_', $id);
                                        ?>
                            <?php  if( $PIXAD_Autos->get_meta($id) ): ?>
                            <li class="card-list__row">
                                <?php
                                                $val_attr =  $PIXAD_Autos->get_meta($id);
                                                if(!empty($auto_translate[$val_attr])  ){
                                                    //   echo esc_html($auto_translate[$val_attr]);
                                                    ?>
                                <span class="card-list__title">
                                    <?php

                                                 if ($settingName) {
                                                     //  esc_html_e( $settingName.':', 'autozone' );
                                                     echo esc_html($auto_translate[$settingName]).": ";
                                                 } else{
                                                     $customId = substr( $id, 1);
                                                     $сustomSettingName  = $validate[$customId.'_name'];
                                                     echo   esc_html($сustomSettingName);

                                                 }

                                                 ?></span>
                                <span class="card-list__info">
                                    <?php
                                                echo esc_html($auto_translate[$val_attr]);
                                                ?>
                                </span>
                                <?php }else{ ?>
                                <span class="card-list__title">
                                    <?php

                                                if ($settingName) {
                                                    //   esc_html_e( $settingName.':', 'autozone' );
                                                    echo esc_html($auto_translate[$settingName]).": ";
                                                } else{
                                                    $customId = substr( $id, 1);
                                                    $сustomSettingName  = $validate[$customId.'_name'];
                                                    echo   esc_html($сustomSettingName);

                                                }

                                                ?></span>

                                <span class="card-list__info">
                                    <?php
                                                if ($id == '_auto_mileage') {
                                                    echo number_format($PIXAD_Autos->get_meta('_auto_mileage'), 0, '', "{$settings['autos_thousand']}");
                                                }else{
                                                    echo esc_html($PIXAD_Autos->get_meta($id));
                                                }
                                                // echo $id
                                                if ($id == '_auto_horsepower') {
                                                    echo " ";  esc_html_e( 'hp', 'autozone' );
                                                }elseif ($id == '_auto_engine') {
                                                    echo " ";   esc_html_e( 'cm3', 'autozone' );
                                                }elseif ($id == '_auto_doors') {
                                                    echo " ";   esc_html_e( 'doors', 'autozone' );
                                                }

                                                ?>
                                </span>
                                <?php } ?>
                            </li>
                            <?php endif; ?>

                            <?php endforeach;?>

                            <?php if(array_key_exists('auto-date', $showInList)  && $validate['auto-date_show'] && get_the_date() ): ?>
                            <li><span class="card-list__title"><?php esc_html_e( 'Updated :', 'autozone' ); ?></span>
                                <span><?php echo get_the_date(); ?></span></li>
                            <?php endif; ?>


                        </ul><!-- / Car Details -->
                    </div>

                </div>
                <div class="card__price_col">

                    <?php if( $validate['auto-price_show'] && $PIXAD_Autos->get_meta('_auto_price') ): ?>
                    <?php
                                $custom_price_catalog = get_post_meta( $post->ID, 'custom_price_catalog', 1 );
                                $price_catalog = $custom_price_catalog ? $custom_price_catalog : $PIXAD_Autos->get_price();
                                //$price_catalog = is_numeric($PIXAD_Autos->get_meta('_auto_price')) || $PIXAD_Autos->get_meta('_auto_price') == '' ? $PIXAD_Autos->get_price() : $auto_translate[$PIXAD_Autos->get_price()];
                                ?>
                    <?php //$price = is_numeric($PIXAD_Autos->get_meta('_auto_price')) || $PIXAD_Autos->get_meta('_auto_price') == ''  ? $PIXAD_Autos->get_price() : $auto_translate[$PIXAD_Autos->get_price()]; ?>
                    <div class="card__price"><?php esc_html_e( 'PRICE:' , 'autozone') ?><span class="card__price-number"><?php echo wp_kses_post($price_catalog); ?></span></div>
                    <?php endif; ?>

                    <?php
                         $gallery = array();
                            $values = get_post_custom($_GET['auto_id']);

                            if (isset( $values['pixad_auto_gallery_2'][0])) {
                                if(class_exists('Pix_Autos')){
                                    $gallery = json_decode(pix_baseencode( $values['pixad_auto_gallery_2'][0]));
                                }
                            }
                            if(isset( $values['pixad_auto_gallery_2'][0]) && $gallery[0]  !== '-1' ) {

                                if($gallery != NULL){
                                    if (array_key_exists('1', $gallery )) {
                                        $listClass = 'auto-promo-inline';
                                    }else{
                                        $listClass ='';
                                    }
                                    echo "<div class='promo_gallery_wrapper ". $listClass."'><ul>";
                                }

                            }
                            if(isset($gallery[0]) && !empty($gallery[0]) && $gallery[0]  !== '-1' )  {

                                $attachment_ids = $gallery;
                            }else{
                                $attachment_ids = array();
                            }
                            foreach ( $attachment_ids as $attachment_id ) {
                                $image = wp_get_attachment_image( $attachment_id, 'revus-promo-thumb' );
                                echo '<li>'.$image.'</li>';

                            }
                            if(isset( $values['pixad_auto_gallery_2'][0]) && $gallery[0]  !== '-1') {
                                echo "</ul></div>";
                            }
                            ?>


                </div>
            </div>


        </div>


    </article>
    <?php endwhile; endif;?>
    <?php } ?>
    <?php } ?>

    <?php if ($autos_publish->have_posts()) : while ( $autos_publish->have_posts() ) : $autos_publish->the_post();
            $comment_args = array( 'status' => 'approve', 'post_id' => $autos_publish->ID, );
            $comments = get_comments($comment_args);
            $post_rating = [];


            foreach($comments as $comment){
                $post_rating[] = floatval( get_comment_meta( $comment->comment_ID, 'rating', true ) );
            }
            ?>

    <article class="card clearfix" id="post-<?php the_ID(); ?>">
        <div class="card__img">
            <?php if( has_post_thumbnail() ): ?>
            <a href="<?php the_permalink(); ?>">
                <?php the_post_thumbnail('autozone-auto-cat', array('class' => 'img-responsive')); ?>
            </a>
            <?php else: ?>
            <img class="no-image" src="<?php echo PIXAD_AUTO_URI .'assets/img/no_image.jpg'; ?>" alt="no-image">
            <?php endif; ?>

            <?php if(is_user_logged_in()){?>
            <?php if(get_current_user_id() == bp_displayed_user_id()){?>
            <span class="card__wrap-label templines-label-status-<?php echo get_post_status(); ?>">
                <span class="card__label">
                    <?php
                                        $status = get_post_status() == 'publish' ? 'published' : get_post_status();
                                        echo esc_html($status);
                                        ?>
                </span>
            </span>
            <?php } ?>
            <?php } ?>

            <?php if( $PIXAD_Autos->get_meta('_auto_sale_price') != '' ): ?>
            <span class="card__wrap-label sale"><?php esc_html_e( 'Sale', 'autozone' ); ?></span>
            <?php endif; ?>
            <?php do_action( 'autozone_autos_single_auto_img', $post ); ?>


            <?php if( is_user_logged_in() ): ?>
            <?php
                            $author_ID =  bp_displayed_user_id();
                            $user = get_user_by('ID', $author_ID);
                            if( $author_ID == get_current_user_id()){?>
            <a class="tm-autos-top-edit-button" href=" <?php echo esc_url(get_site_url().'/members/') . $user->user_login . '/add_item?auto_id=' . get_the_ID();?>"><span><?php echo __('Edit', 'templines-helper-core')?></span></a>

            <a class="tm-autos-top-draft-button" href="<?php echo esc_url(get_site_url().'/members/') . $user->user_login . '/autos?hide=true&auto_id=' . get_the_ID();?>">
                <span><?php echo __('Hide', 'templines-helper-core')?></span>
            </a>
            <?php } ?>
            <?php endif; ?>

        </div>
        <div class="card__inner">
            <h2 class="card__title ui-title-inner"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
            <div class="decor-1"></div>



            <div class="card__description">
                <p><?php if( has_excerpt() ){
                                        the_excerpt();
                                    } ?></p>
            </div>

            <div class="card__flex_col">

                <div class="card__desc_col">

                    <!-- Car Details -->
                    <ul class="card__list list-unstyled">
                        <?php foreach ($showInList as $id => $sideAttribute):?>
                        <?php
                                    $settingName =  $showInList[$id]['title'];
                                    $settingName = trim($settingName);
                                    //       $settingName = esc_html__( $settingName.':', 'autozone' );

                                    $id='_'.$id;
                                    $id = str_replace('-', '_', $id);
                                    ?>
                        <?php  if( $PIXAD_Autos->get_meta($id) ): ?>
                        <li class="card-list__row">
                            <?php
                                            $val_attr =  $PIXAD_Autos->get_meta($id);
                                            if(!empty($auto_translate[$val_attr])  ){
                                                //   echo esc_html($auto_translate[$val_attr]);
                                                ?>
                            <span class="card-list__title">
                                <?php

                                     if ($settingName) {
                                         //  esc_html_e( $settingName.':', 'autozone' );
                                         echo esc_html($auto_translate[$settingName]).": ";
                                     } else{
                                         $customId = substr( $id, 1);
                                         $сustomSettingName  = $validate[$customId.'_name'];
                                         echo   esc_html($сustomSettingName);

                                     }

                                     ?></span>
                            <span class="card-list__info">
                                <?php
                                    echo esc_html($auto_translate[$val_attr]);
                                    ?>
                            </span>
                            <?php }else{ ?>
                            <span class="card-list__title">
                                <?php

                                    if ($settingName) {
                                        //   esc_html_e( $settingName.':', 'autozone' );
                                        echo esc_html($auto_translate[$settingName]).": ";
                                    } else{
                                        $customId = substr( $id, 1);
                                        $сustomSettingName  = $validate[$customId.'_name'];
                                        echo   esc_html($сustomSettingName);

                                    }

                                    ?></span>

                            <span class="card-list__info">
                                <?php
                                    if ($id == '_auto_mileage') {
                                        echo number_format($PIXAD_Autos->get_meta('_auto_mileage'), 0, '', "{$settings['autos_thousand']}");
                                    }else{
                                        echo esc_html($PIXAD_Autos->get_meta($id));
                                    }
                                    // echo $id
                                    if ($id == '_auto_horsepower') {
                                        echo " ";  esc_html_e( 'hp', 'autozone' );
                                    }elseif ($id == '_auto_engine') {
                                        echo " ";   esc_html_e( 'cm3', 'autozone' );
                                    }elseif ($id == '_auto_doors') {
                                        echo " ";   esc_html_e( 'doors', 'autozone' );
                                    }

                                    ?>
                            </span>
                            <?php } ?>
                        </li>
                        <?php endif; ?>

                        <?php endforeach;?>

                        <?php if(array_key_exists('auto-date', $showInList)  && $validate['auto-date_show'] && get_the_date() ): ?>
                        <li><span class="card-list__title"><?php esc_html_e( 'Updated :', 'autozone' ); ?></span>
                            <span><?php echo get_the_date(); ?></span></li>
                        <?php endif; ?>


                    </ul><!-- / Car Details -->


                </div>

                <div class="card__price_col">

                    <?php if( $validate['auto-price_show'] && $PIXAD_Autos->get_meta('_auto_price') ): ?>
                    <?php
                            $custom_price_catalog = get_post_meta( $post->ID, 'custom_price_catalog', 1 );
                            $price_catalog = $custom_price_catalog ? $custom_price_catalog : $PIXAD_Autos->get_price();
                            //$price_catalog = is_numeric($PIXAD_Autos->get_meta('_auto_price')) || $PIXAD_Autos->get_meta('_auto_price') == '' ? $PIXAD_Autos->get_price() : $auto_translate[$PIXAD_Autos->get_price()];
                            ?>
                    <?php //$price = is_numeric($PIXAD_Autos->get_meta('_auto_price')) || $PIXAD_Autos->get_meta('_auto_price') == ''  ? $PIXAD_Autos->get_price() : $auto_translate[$PIXAD_Autos->get_price()]; ?>
                    <div class="card__price"><?php esc_html_e( 'PRICE:' , 'autozone') ?><span class="card__price-number"><?php echo wp_kses_post($price_catalog); ?></span></div>
                    <?php endif; ?>

                    <?php
                        $gallery = array();
                    $values = get_post_custom($_GET['auto_id']);
                    if (isset( $values['pixad_auto_gallery_2'][0])) {
                        if(class_exists('Pix_Autos')){
                            $gallery = json_decode(pix_baseencode( $values['pixad_auto_gallery_2'][0]));
                        }
                    }
                    if(isset( $values['pixad_auto_gallery_2'][0]) && $gallery[0]  !== '-1' ) {

                        if($gallery != NULL){
                            if (array_key_exists('1', $gallery )) {
                                $listClass = 'auto-promo-inline';
                            }else{
                                $listClass ='';
                            }
                            echo "<div class='promo_gallery_wrapper ". $listClass."'><ul>";
                        }

                    }
                    if(isset($gallery[0]) && !empty($gallery[0]) && $gallery[0]  !== '-1' )  {

                        $attachment_ids = $gallery;
                    }else{
                        $attachment_ids = array();
                    }
                    foreach ( $attachment_ids as $attachment_id ) {
                        $image = wp_get_attachment_image( $attachment_id, 'revus-promo-thumb' );
                        echo '<li>'.$image.'</li>';

                    }
                    if(isset( $values['pixad_auto_gallery_2'][0]) && $gallery[0]  !== '-1') {
                        echo "</ul></div>";
                    }?>

                </div>
            </div>
        </div>
    </article>

    <?php endwhile;
        else : ?>
    <div class="empty-search-wrapper">
        <div id="message" class="info">
            <p><?php echo  __( "You don't have cars online", "templines-helper-core" );?></p>
        </div>
    </div>
    <?php endif;
        $templines_pagination = '';
        $args_to_count = array(
            'post_type' => 'pixad-autos',
            'status'    => 'publish',
            'author'    =>  $author_ID
        );
        $autos_to_count = new WP_Query($args_to_count);
        if($autos_to_count->post_count > intval($settings['autos_per_page'])){
            $templines_pagination .= '<div class="pixad_autos_pagination">';
            $author_ID =  bp_displayed_user_id();
            $user = get_user_by('ID', $author_ID);
            $base = home_url() . '/members/'. $user->user_login .'/autos/';
            $orig_req_uri = $_SERVER['REQUEST_URI'];
            $_SERVER['REQUEST_URI'] = $base;
            $base = $base . '?paged=%#%';
            $big = 999999999;
            $templines_pagination .= paginate_links(array(
                'base' => str_replace($big, '%#%', esc_url($base)),
                'format' => '/?paged=%#%',
                'current' => max(1, get_query_var('paged')),
                'prev_text' => __('PREV', 'templines-helper-core'),
                'next_text' => __('NEXT', 'templines-helper-core'),
                'total' => $autos_publish->max_num_pages,
            ));
            $templines_pagination .= '</div>';
            echo $templines_pagination;
        }
        ?>
</div>
<?php
}




// Add Autos Tab
function templines_helper_profile_tab_add_autos() {
    global $bp;
    if ( is_admin()){
        bp_core_new_nav_item( array(
            'name' => 'Add Auto',
            'slug' => 'add_item',
            'screen_function' => 'templines_helper_add_autos_screen',
            'position' => 40,
            'parent_url'      => bp_loggedin_user_domain() . '/add_item/',
            'parent_slug'     => $bp->profile->slug,
            'default_subnav_slug' => 'add_item'
        ) );
    } else {
      //  if(get_current_user_id() == bp_displayed_user_id()){
            bp_core_new_nav_item( array(
                'name' => 'Add Auto',
                'slug' => 'add_item',
                'screen_function' => 'templines_helper_add_autos_screen',
                'position' => 40,
                'parent_url'      => bp_loggedin_user_domain() . '/add_item/',
                'parent_slug'     => $bp->profile->slug,
                'default_subnav_slug' => 'add_item'
            ) );
      // }
    }

}
add_action( 'bp_setup_nav', 'templines_helper_profile_tab_add_autos' );
function templines_helper_add_autos_screen() {
    add_action( 'wp_enqueue_scripts', 'autozone_enqueue_media' );
    add_action( 'bp_template_title', 'templines_helper_add_autos_title' );
    add_action( 'bp_template_content', 'templines_helper_add_autos_content' );
    bp_core_load_template( 'buddypress/members/single/plugins' );
}
function templines_helper_add_autos_title() {
    $return_title = '';
    if (isset($_GET['auto_id']) && $_GET['auto_id'] != ''){
        $return_title .= '
                        <div class="item-list-tabs youzify-default-subnav no-ajax" id="subnav" aria-label="Member secondary navigation" role="navigation">
                            <ul>
                                <li id="posts-all-personal-li" class="current selected"><a id="all" href="#"><i class="fas fa-edit"></i>'.__("Edit Auto", "templines-helper-core").'</a></li>
                            </ul>
                        </div>
                        ';
    } else {
        $return_title .= '
                        <div class="item-list-tabs youzify-default-subnav no-ajax" id="subnav" aria-label="Member secondary navigation" role="navigation">
                            <ul>
                                <li id="posts-all-personal-li" class="current selected"><a id="all" href="#"><i class="fas fa-plus-square"></i>'.__("Add Auto", "templines-helper-core").'</a></li>
                            </ul>
                        </div>
                        ';
    }


    echo $return_title;
}
function templines_helper_add_autos_content() {
    $author_ID =  bp_displayed_user_id();
    $user = get_user_by('ID', $author_ID);
    if(function_exists("pmpro_getMembershipLevelForUser")){
        $author_level = false;
        $notice = '';
        $author_level = pmpro_getMembershipLevelForUser($user->ID);
    }



    if(is_user_logged_in()){
      //  if($author_level != false) {
            global $field_car;
            $Settings = new PIXAD_Settings();
            $validate = $Settings->getSettings('WP_OPTIONS', '_pixad_autos_validation',
                true); // Get validation settings
            $options = $Settings->getSettings('WP_OPTIONS', '_pixad_autos_settings', true);
            $auto_validate = $validate;

            $strict_auth = !(is_user_logged_in() || !empty($options['autos_reg_user']));
            $form_url = admin_url('admin-post.php');
            if (isset($_GET['auto_id']) && $_GET['auto_id'] != '') {
                $form_action = 'auto_update_form';
            } else {
                $form_action = 'auto_upload_form';
            }
            $autos_demo_mode = isset($options['autos_demo_mode']) ? $options['autos_demo_mode'] : '';

            if ($strict_auth) {
                auth_redirect();
            } else {
                if (!is_user_logged_in()) {
                    $form_url = get_permalink();
                    $form_action = 'auto_upload_form_front';

                }
            }

            $custom = isset ($wp_query) ? get_post_custom($wp_query->get_queried_object_id()) : '';
            $layout = isset ($custom['pix_page_layout']) ? $custom['pix_page_layout'][0] : '2';
            $sidebar = isset ($custom['pix_selected_sidebar'][0]) ? $custom['pix_selected_sidebar'][0] : 'sidebar-1'; //<?php echo esc_url( admin_url('admin-post.php') );
            if (!is_active_sidebar($sidebar)) {
                $layout = '1';
            }
            if (empty($autos_demo_mode)) {
                add_action('wp_enqueue_scripts', 'autozone_enqueue_media');
            }


            $title = $post_content = $auto_model = $auto_color = $auto_color_int = $auto_year = $auto_transmission = $auto_condition = $auto_purpose =
            $auto_drive = $auto_doors = $auto_fuel = $auto_mileage = $auto_engine = $auto_price = $auto_warranty = $auto_vin = $auto_horsepower =
            $auto_seats = $auto_version = $auto_video_code =
            $seller_first_name = $seller_last_name = $seller_phone = $seller_email = $seller_town = $seller_country = $seller_state = $seller_location = $seller_location_lat = $seller_location_long = $seller_company = '';
            $auto_body_check = [];
            $auto_equipment_check = [];

            if (isset($_GET['auto_id']) && $_GET['auto_id'] != '') {
                $auto_edit = get_post($_GET['auto_id']);
                $auto_fields = get_post_custom($_GET['auto_id']);

                if ($auto_edit->post_title) {
                    $title = $auto_edit->post_title;
                } else {
                    $title = '';
                }

                if ($auto_edit->post_content) {
                    $post_content = $auto_edit->post_content;
                } else {
                    $post_content = '';
                }

                //Model
                $auto_model_term = get_the_terms($_GET['auto_id'], 'auto-model');
                foreach ($auto_model_term as $m) {
                    $auto_model = $m->slug;
                }
                //body
                $auto_body_term = get_the_terms($_GET['auto_id'], 'auto-body');
                foreach ($auto_body_term as $b) {
                    $auto_body_check[] = $b->slug;
                }
                //equipment
                $auto_equipment_term = get_the_terms($_GET['auto_id'], 'auto-equipment');
                foreach ($auto_equipment_term as $e) {
                    $auto_equipment_check[] = $e->slug;
                }


                if (isset($auto_fields['_auto_color'][0])) {
                    $auto_color = $auto_fields['_auto_color'][0];
                } else {
                    $auto_color = '';
                }


                if (isset($auto_fields['_auto_color_int'][0])) {
                    $auto_color_int = $auto_fields['_auto_color_int'][0];
                } else {
                    $auto_color_int = '';
                }

                if (isset($auto_fields['_auto_year'][0])) {
                    $auto_year = $auto_fields['_auto_year'][0];
                } else {
                    $auto_year = '';
                }


                if (isset($auto_fields['_auto_transmission'][0])) {
                    $auto_transmission = $auto_fields['_auto_transmission'][0];
                } else {
                    $auto_transmission = '';
                }

                if (isset($auto_fields['_auto_condition'][0])) {
                    $auto_condition = $auto_fields['_auto_condition'][0];
                } else {
                    $auto_condition = '';
                }

                if (isset($auto_fields['_auto_purpose'][0])) {
                    $auto_purpose = $auto_fields['_auto_purpose'][0];
                } else {
                    $auto_purpose = '';
                }

                if (isset($auto_fields['_auto_drive'][0])) {
                    $auto_drive = $auto_fields['_auto_drive'][0];
                } else {
                    $auto_drive = '';
                }

                if (isset($auto_fields['_auto_doors'][0])) {
                    $auto_doors = $auto_fields['_auto_doors'][0];
                } else {
                    $auto_doors = '';
                }

                if (isset($auto_fields['_auto_fuel'][0])) {
                    $auto_fuel = $auto_fields['_auto_fuel'][0];
                } else {
                    $auto_fuel = '';
                }

                if (isset($auto_fields['_auto_mileage'][0])) {
                    $auto_mileage = $auto_fields['_auto_mileage'][0];
                } else {
                    $auto_mileage = '';
                }

                if (isset($auto_fields['_auto_engine'][0])) {
                    $auto_engine = $auto_fields['_auto_engine'][0];
                } else {
                    $auto_engine = '';
                }

                if (isset($auto_fields['_auto_price'][0])) {
                    $auto_price = $auto_fields['_auto_price'][0];
                } else {
                    $auto_price = '';
                }

                if (isset($auto_fields['_auto_warranty'][0])) {
                    $auto_warranty = $auto_fields['_auto_warranty'][0];
                } else {
                    $auto_warranty = '';
                }

                if (isset($auto_fields['_auto_vin'][0])) {
                    $auto_vin = $auto_fields['_auto_vin'][0];
                } else {
                    $auto_vin = '';
                }

                if (isset($auto_fields['_auto_horsepower'][0])) {
                    $auto_horsepower = $auto_fields['_auto_horsepower'][0];
                } else {
                    $auto_horsepower = '';
                }

                if (isset($auto_fields['_auto_seats'][0])) {
                    $auto_seats = $auto_fields['_auto_seats'][0];
                } else {
                    $auto_seats = '';
                }

                if (isset($auto_fields['_auto_version'][0])) {
                    $auto_version = $auto_fields['_auto_version'][0];
                } else {
                    $auto_version = '';
                }

                if (isset($auto_fields['_seller_first_name'][0])) {
                    $seller_first_name = $auto_fields['_seller_first_name'][0];
                } else {
                    $seller_first_name = '';
                }

                if (isset($auto_fields['_seller_last_name'][0])) {
                    $seller_last_name = $auto_fields['_seller_last_name'][0];
                } else {
                    $seller_last_name = '';
                }

                if (isset($auto_fields['_seller_phone'][0])) {
                    $seller_phone = $auto_fields['_seller_phone'][0];
                } else {
                    $seller_phone = '';
                }


                if (isset($auto_fields['_seller_town'][0])) {
                    $seller_town = $auto_fields['_seller_town'][0];
                } else {
                    $seller_town = '';
                }


                if (isset($auto_fields['_seller_email'][0])) {
                    $seller_email = $auto_fields['_seller_email'][0];
                } else {
                    $seller_email = '';
                }


                if (isset($auto_fields['_seller_country'][0])) {
                    $seller_country = $auto_fields['_seller_country'][0];
                } else {
                    $seller_country = '';
                }


                if (isset($auto_fields['_seller_state'][0])) {
                    $seller_state = $auto_fields['_seller_state'][0];
                } else {
                    $seller_state = '';
                }


                if (isset($auto_fields['_seller_location'][0])) {
                    $seller_location = $auto_fields['_seller_location'][0];
                } else {
                    $seller_location = '';
                }


                if (isset($auto_fields['_seller_location_lat'][0])) {
                    $seller_location_lat = $auto_fields['_seller_location_lat'][0];
                } else {
                    $seller_location_lat = '';
                }


                if (isset($auto_fields['_seller_location_long'][0])) {
                    $seller_location_long = $auto_fields['_seller_location_long'][0];
                } else {
                    $seller_location_long = '';
                }


                if (isset($auto_fields['_seller_company'][0])) {
                    $seller_company = $auto_fields['_seller_company'][0];
                } else {
                    $seller_company = '';
                }

                if (isset($auto_fields['_auto_video_code'][0])) {
                    $auto_video_code = $auto_fields['_auto_video_code'][0];
                } else {
                    $auto_video_code = '';
                }
                if (isset($auto_fields['pixad_auto_gallery'][0])) {
                    $pixad_auto_gallery = $auto_fields['pixad_auto_gallery'][0];
                } else {
                    $pixad_auto_gallery = '';
                }


                $gallery = array();
                $values = get_post_custom($_GET['auto_id']);
                $return_gall = '';
                if (isset($values['pixad_auto_gallery'][0])) {
                    if (class_exists('Pix_Autos')) {
                        $gallery = json_decode(pix_baseencode($values['pixad_auto_gallery'][0]));
                    }
                }

                if (isset($values['pixad_auto_gallery'][0]) && $gallery[0] !== '-1') {

                    if ($gallery != null) {
                        if (array_key_exists('1', $gallery)) {
                            $listClass = 'auto-promo-inline';
                        } else {
                            $listClass = '';
                        }
                        $return_gall .= "<div class='promo_gallery_wrapper " . $listClass . "'><ul>";
                    }

                }
                if (isset($gallery[0]) && !empty($gallery[0]) && $gallery[0] !== '-1') {

                    $attachment_ids = $gallery;
                } else {
                    $attachment_ids = array();
                }
                foreach ($attachment_ids as $attachment_id) {
                    $image = wp_get_attachment_image($attachment_id, 'autozone-promo-thumb');
                    $return_gall .=  '<li>' . $image . '</li>';

                }
                if (isset($values['pixad_auto_gallery'][0]) && $gallery[0] !== '-1') {
                    $return_gall .=  "</ul></div>";
                }

            }

            ?>


<section class="page-content" id="pageContent">
    <div>
        <div class="row">
            <div class="pixad-control-input col-md-12 col-sm-12 col-xs-12">
                <form enctype="multipart/form-data" method="post" action="<?php echo esc_url($form_url); ?>">
                    <input type="hidden" name="action" value="<?php echo esc_attr($form_action) ?>">
                    <?php if (isset($_GET['auto_id']) && $_GET['auto_id'] != '') { ?>
                    <input type="hidden" name="auto_id" value="<?php echo esc_attr($_GET['auto_id']) ?>">
                    <?php } ?>
                    <?php
                                $field_car = array(
                                    'auto-condition' => array(
                                        'name' => esc_html__('Auto Condition', 'autozone'),
                                        'field' => 'auto-condition',
                                        'slug' => '_auto_condition',
                                        'type' => 'select',
                                        'temp' => 'templines_temp_select_cond'
                                    ),
                                    'auto-doors' => array(
                                        'name' => esc_html__('Doors', 'autozone'),
                                        'field' => 'auto-doors',
                                        'slug' => '_auto_doors',
                                        'type' => 'select',
                                        'temp' => 'templines_temp_select_doors'
                                    ),
                                    'auto-drive' => array(
                                        'name' => esc_html__('Auto Drive', 'autozone'),
                                        'field' => 'auto-drive',
                                        'slug' => '_auto_drive',
                                        'type' => 'select',
                                        'temp' => 'templines_temp_select_drive'
                                    ),
                                    'auto-purpose' => array(
                                        'name' => esc_html__('Auto Purpose', 'autozone'),
                                        'field' => 'auto-purpose',
                                        'slug' => '_auto_purpose',
                                        'type' => 'select',
                                        'temp' => 'templines_temp_select_purpose'
                                    ),
                                    'auto-color' => array(
                                        'name' => esc_html__('Color', 'autozone'),
                                        'field' => 'auto-color',
                                        'slug' => '_auto_color',
                                        'placeholder' => esc_html__('eg: red', 'autozone'),
                                        'type' => 'text'
                                    ),
                                    'auto-color-int' => array(
                                        'name' => esc_html__('Interior Color', 'autozone'),
                                        'field' => 'auto-color-int',
                                        'slug' => '_auto_color_int',
                                        'type' => 'text',
                                        'placeholder' => esc_html__('eg: black', 'autozone')
                                    ),
                                    'auto-warranty' => array(
                                        'name' => esc_html__('Warranty', 'autozone'),
                                        'field' => 'auto-warranty',
                                        'slug' => '_auto_warranty',
                                        'type' => 'select',
                                        'temp' => 'templines_temp_select_warranty'
                                    ),
                                    'auto-vin' => array(
                                        'name' => esc_html__('VIN', 'autozone'),
                                        'field' => 'auto-vin',
                                        'slug' => '_auto_vin',
                                        'type' => 'text',
                                        'placeholder' => esc_html__('eg: 1VXBR12EXCP901213', 'autozone')
                                    ),
                                    'auto-horsepower' => array(
                                        'name' => esc_html__('Horsepower, hp', 'autozone'),
                                        'field' => 'auto-horsepower',
                                        'slug' => '_auto_horsepower',
                                        'type' => 'text',
                                        'placeholder' => esc_html__('eg: 200', 'autozone')
                                    ),
                                    'auto-seats' => array(
                                        'name' => esc_html__('Seating Capacity', 'autozone'),
                                        'field' => 'auto-seats',
                                        'slug' => '_auto_seats',
                                        'type' => 'text',
                                        'placeholder' => esc_html__('eg: 5', 'autozone')
                                    ),
                                    'auto-version' => array(
                                        'name' => esc_html__('Auto Version', 'autozone'),
                                        'field' => 'auto-version',
                                        'slug' => '_auto_version',
                                        'type' => 'text',
                                        'placeholder' => esc_html__('eg: 1.6 hdi', 'autozone')
                                    ),
                                );
                                ?>


                    <section class="step-section" id="step01">
                        <div class="pixad-form-horizontal">
                            <div class="col-md-12 col-xs-12">
                                <div class="pixad-form-group">
                                    <label class="pixad-control-label">
                                        <?php esc_html_e('Title', 'autozone'); ?> <span class="required-field">*</span>
                                    </label>
                                    <div class="pixad-control-input">
                                        <input name="auto-post-title" type="text" required placeholder="<?php esc_html_e('eg: Mercedes-Benz E220',
                                                               'autozone'); ?>" value="<?php echo esc_attr($title) ?>" class="pixad-form-control">
                                    </div>
                                </div>

                                <?php
                                            $args = array(
                                                'taxonomy' => 'auto-model',
                                                'parent' => '0',
                                                'hide_empty' => false,
                                            );
                                            $autos_categories = get_terms($args);
                                            //uasort($autos_categories,"autozone_ASCSort");
                                            $out_makes = '';
                                            ?>
                                <div class="pixad-form-group">
                                    <label class="pixad-control-label">
                                        <?php esc_html_e('Make', 'autozone'); ?> <span class="required-field">*</span>
                                    </label>
                                    <div class="pixad-control-input auto-make-wrap">
                                        <select name="auto-make" required class="auto-make">
                                            <option value=""><?php esc_html_e('-- Please Select --',
                                                                'autozone'); ?></option>
                                            <?php foreach ($autos_categories as $key => $auto_cat) {
                                                            if ($auto_cat->parent == 0) {
                                                                $termchildren = get_term_children($auto_cat->term_id,
                                                                    'auto-model');
                                                            }
                                                            echo '<optgroup label="' . $auto_cat->name . '">';
                                                            if ($auto_model == $auto_cat->slug) {
                                                                echo '<option selected value="' . esc_attr($auto_cat->slug) . '">' . wp_kses_post($auto_cat->name) . '</option>';
                                                            } else {
                                                                echo '<option value="' . esc_attr($auto_cat->slug) . '">' . wp_kses_post($auto_cat->name) . '</option>';
                                                            }
                                                            if (!empty($termchildren)) {
                                                                foreach ($termchildren as $key_child => $child_term_id) {
                                                                    $child_term = get_term_by('id', $child_term_id,
                                                                        'auto-model');
                                                                    if ($auto_model == $child_term->slug) {
                                                                        echo '<option selected value="' . esc_attr($child_term->slug) . '">' . wp_kses_post($child_term->name) . '</option>';
                                                                    } else {
                                                                        echo '<option value="' . esc_attr($child_term->slug) . '">' . wp_kses_post($child_term->name) . '</option>';

                                                                    }
                                                                }
                                                            }
                                                            echo ' </optgroup>';
                                                        } ?>
                                        </select>
                                    </div>
                                </div>
                                <?php
                                            if (isset($auto_validate['auto-year_show']) || isset($auto_validate['auto-year_req'])): ?>
                                <div class="pixad-form-group">
                                    <label class="pixad-control-label">
                                        <?php esc_html_e('Made Year',
                                                            'autozone'); ?><?php echo isset($auto_validate['auto-year_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                    </label>
                                    <div class="pixad-control-input">
                                        <select name="auto-year" required class="pixad-form-control">
                                            <option value=""><?php esc_html_e('-- Please Select --',
                                                                    'autozone'); ?></option>
                                            <?php pixad_get_options_range(date('Y'), 1930,
                                                                $auto_year); ?>
                                        </select>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <?php if (isset($auto_validate['auto-transmission_show']) || isset($auto_validate['auto-transmission_req'])): ?>
                                <div class="pixad-form-group">
                                    <label class="pixad-control-label">
                                        <?php esc_html_e('Transmission',
                                                            'autozone'); ?><?php echo isset($auto_validate['auto-transmission_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                    </label>
                                    <div class="pixad-control-input">
                                        <select name="auto-transmission" <?php echo isset($auto_validate['auto-transmission_req']) ? 'required' : ''; ?> class="pixad-form-control">
                                            <option value=""><?php esc_html_e('-- Please Select --',
                                                                    'autozone'); ?></option>
                                            <option value="automatic" <?php if ($auto_transmission == 'automatic') {
                                                                echo 'selected';
                                                            } ?>><?php esc_html_e('Automatic', 'autozone'); ?></option>
                                            <option value="manual" <?php if ($auto_transmission == 'manual') {
                                                                echo 'selected';
                                                            } ?>><?php esc_html_e('Manual', 'autozone'); ?></option>
                                            <option value="semi-automatic" <?php if ($auto_transmission == 'semi-automatic') {
                                                                echo 'selected';
                                                            } ?>><?php esc_html_e('Semi-Automatic',
                                                                    'autozone'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <?php
                                            if (isset($auto_condition)) {
                                                templines_temp_field_update_car($field_car['auto-condition'],
                                                    $auto_validate, $auto_condition);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-condition'],
                                                    $auto_validate);
                                            }
                                            ?>

                                <?php
                                            if (isset($auto_purpose)) {
                                                templines_temp_field_update_car($field_car['auto-purpose'],
                                                    $auto_validate, $auto_purpose);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-purpose'],
                                                    $auto_validate);
                                            }
                                            ?>

                                <?php
                                            if (isset($auto_drive)) {
                                                templines_temp_field_update_car($field_car['auto-drive'],
                                                    $auto_validate, $auto_drive);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-drive'],
                                                    $auto_validate);
                                            }
                                            ?>

                                <?php
                                            if ($auto_color != '') {
                                                templines_temp_field_update_car($field_car['auto-color'],
                                                    $auto_validate, $auto_color);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-color'],
                                                    $auto_validate);
                                            }
                                            ?>

                                <?php
                                            if (isset($auto_color_int)) {
                                                templines_temp_field_update_car($field_car['auto-color-int'],
                                                    $auto_validate, $auto_color_int);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-color-int'],
                                                    $auto_validate);
                                            }
                                            ?>


                                <?php
                                            if (isset($auto_doors)) {
                                                templines_temp_field_update_car($field_car['auto-doors'],
                                                    $auto_validate, $auto_doors);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-doors'],
                                                    $auto_validate);
                                            }
                                            ?>


                                <?php if (isset($auto_validate['auto-fuel_show']) || isset($auto_validate['auto-fuel_req'])): ?>
                                <div class="pixad-form-group">
                                    <label class="pixad-control-label">
                                        <?php esc_html_e('Fuel Type',
                                                            'autozone'); ?><?php echo isset($auto_validate['auto-fuel_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                    </label>
                                    <div class="pixad-control-input">
                                        <select name="auto-fuel" <?php echo isset($auto_validate['auto-fuel_req']) ? 'required' : ''; ?> class="pixad-form-control">
                                            <option value=""><?php esc_html_e('-- Please Select --',
                                                                    'autozone'); ?></option>
                                            <option value="diesel" <?php if ($auto_fuel == 'diesel') {
                                                                echo 'selected';
                                                            } ?>><?php esc_html_e('Diesel', 'autozone'); ?></option>
                                            <option value="electric" <?php if ($auto_fuel == 'electric') {
                                                                echo 'selected';
                                                            } ?>><?php esc_html_e('Electric', 'autozone'); ?></option>
                                            <option value="petrol" <?php selected('petrol', $auto_fuel,
                                                                true); ?>><?php esc_html_e('Petrol',
                                                                    'autozone'); ?></option>
                                            <option value="hybrid" <?php if ($auto_fuel == 'hybrid') {
                                                                echo 'selected';
                                                            } ?>><?php esc_html_e('Hybrid', 'autozone'); ?></option>
                                            <option value="plugin_electric" <?php if ($auto_fuel == 'plugin_electric') {
                                                                echo 'selected';
                                                            } ?>><?php esc_html_e('Plugin electric',
                                                                    'autozone'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <?php if (isset($auto_validate['auto-mileage_show']) || isset($auto_validate['auto-mileage_req'])): ?>
                                <div class="pixad-form-group">
                                    <label class="pixad-control-label">
                                        <?php esc_html_e('Mileage',
                                                            'autozone'); ?><?php echo isset($auto_validate['auto-mileage_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                    </label>
                                    <div class="pixad-control-input">
                                        <input name="auto-mileage" type="text" <?php echo isset($auto_validate['auto-mileage_req']) ? 'required' : ''; ?> placeholder="<?php esc_html_e('eg: 100000',
                                                                   'autozone'); ?>" value="<?php echo esc_attr($auto_mileage) ?>" class="pixad-form-control">
                                        <span class="errmileage"></span>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <?php if (isset($auto_validate['auto-engine_show']) || isset($auto_validate['auto-engine_req'])): ?>
                                <div class="pixad-form-group">
                                    <label class="pixad-control-label">
                                        <?php esc_html_e('Engine, cm3',
                                                            'autozone'); ?><?php echo isset($auto_validate['auto-engine_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                    </label>
                                    <div class="pixad-control-input">
                                        <input name="auto-engine" type="text" <?php echo isset($auto_validate['auto-engine_req']) ? 'required' : ''; ?> placeholder="<?php esc_html_e('eg: 1900',
                                                                   'autozone'); ?>" value="<?php echo esc_attr($auto_engine) ?>" class="pixad-form-control">
                                        <span class="errengine"></span>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <?php if (isset($auto_validate['auto-price_show']) || isset($auto_validate['auto-price_req'])): ?>
                                <div class="pixad-form-group">
                                    <label class="pixad-control-label">
                                        <?php esc_html_e('Price',
                                                            'autozone'); ?><?php echo isset($auto_validate['auto-price_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                    </label>
                                    <div class="pixad-control-input">
                                        <input name="auto-price" type="text" <?php echo isset($auto_validate['auto-price_req']) ? 'required' : ''; ?> placeholder="<?php esc_html_e('eg: 10000',
                                                                   'autozone'); ?>" value="<?php echo esc_attr($auto_price); ?>" list="price_option" class="pixad-form-control">

                                        <span class="errprice"></span>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <?php
                                            if (isset($auto_warranty)) {
                                                templines_temp_field_update_car($field_car['auto-warranty'],
                                                    $auto_validate, $auto_warranty);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-warranty'],
                                                    $auto_validate);
                                            }
                                            ?>


                                <?php
                                            if (isset($auto_vin)) {
                                                templines_temp_field_update_car($field_car['auto-vin'], $auto_validate,
                                                    $auto_vin);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-vin'], $auto_validate);
                                            }
                                            ?>


                                <?php
                                            if (isset($auto_horsepower)) {
                                                templines_temp_field_update_car($field_car['auto-horsepower'],
                                                    $auto_validate, $auto_horsepower);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-horsepower'],
                                                    $auto_validate);
                                            }
                                            ?>


                                <?php
                                            if (isset($auto_seats)) {
                                                templines_temp_field_update_car($field_car['auto-seats'],
                                                    $auto_validate, $auto_seats);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-seats'],
                                                    $auto_validate);
                                            }
                                            ?>


                                <?php
                                            if (isset($auto_version)) {
                                                templines_temp_field_update_car($field_car['auto-version'],
                                                    $auto_validate, $auto_version);
                                            } else {
                                                autozone_temp_field_update_car($field_car['auto-version'],
                                                    $auto_validate);
                                            }
                                            ?>


                                <?php

                                            $field_car = [];
                                            for ($i = 1; $i <= 80; $i++) {
                                                if (isset($auto_validate['custom_' . $i . '_name'])) {
                                                    $field_car['custom_' . $i] = array(
                                                        'name' => $auto_validate['custom_' . $i . '_name'],
                                                        'field' => 'custom_' . $i,
                                                        'slug' => 'custom_' . $i,
                                                        'type' => 'text',
                                                        'placeholder' => esc_html('')
                                                    );

                                                }
                                            }
                                            ?>

                                <?php
                                            for ($i = 1; $i <= 80; $i++) {
                                                if (isset($field_car['custom_' . $i])) {
                                                    autozone_temp_field_update_car($field_car['custom_' . $i],
                                                        $auto_validate);
                                                }
                                            }
                                            ?>
                            </div>

                    </section>

                    <section class="step-section" id="step02">
                        <div class="col-md-12 col-xs-12">
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Body Style', 'autozone'); ?>
                                </label>
                                <div class="pixad-control-input">
                                    <?php
                                                $args_body = array('taxonomy' => 'auto-body', 'hide_empty' => '0');
                                                $auto_body_cat = get_categories($args_body);
                                                $body_out = '';
                                                foreach ($auto_body_cat as $category) {
                                                    $figure = $body_class = '';
                                                    if (is_object($category)) {
                                                        $t_id = $category->term_id;
                                                        $auto_cat_meta = get_option("auto_body_$t_id");
                                                        $auto_cat_thumb_url = get_option("pixad_body_thumb$t_id");

                                                        if (isset($auto_t_id) && $auto_t_id != '') {
                                                            $auto_cat_thumb_filter_url = get_option("pixad_body_thumb_filter$auto_t_id");

                                                        }
                                                        if (isset($auto_cat_thumb_filter_url) && $auto_cat_thumb_filter_url != '') {
                                                            if ($auto_cat_thumb_filter_url) {
                                                                $img_src = wp_get_attachment_image_src(attachment_url_to_postid($auto_cat_thumb_filter_url),
                                                                    'autozone-body-thumb');
                                                                $figure = '<img  src="' . esc_url($img_src[0]) . '" alt="' . esc_attr($auto_body->name) . '">';

                                                            }
                                                        } elseif ($auto_cat_thumb_url) {
                                                            $img_src = wp_get_attachment_image_src(attachment_url_to_postid($auto_cat_thumb_url),
                                                                'medium');
                                                            $figure = '<img  src="' . esc_url($img_src[0]) . '" alt="' . esc_attr($category->name) . '">';
                                                            $body_class = 'pixad-body-image';
                                                        } elseif (isset($auto_cat_meta['pixad_body_icon'])) {
                                                            $figure = '<i class="icon ' . esc_attr($auto_cat_meta['pixad_body_icon']) . '"></i>';
                                                            $body_class = 'pixad-body-icon';
                                                        }
                                                        $body_out .= '<li class="pixad-exist pixad-body-upload ' . esc_attr($body_class) . '"> <input ' . esc_attr(in_array($category->slug,
                                                                $auto_body_check) ? 'checked' : '') . ' type="checkbox" name="auto-body[]" id="' . esc_attr($category->slug) . '" value="' . esc_attr($category->slug) . '"><label for="' . esc_attr($category->slug) . '">' . wp_kses_post($figure) . ' <span>' . wp_kses_post($category->name) . '</span></label> </li>';
                                                    }
                                                }
                                                if ($body_out != '') {
                                                    echo '<ul class="pixad-form-control pixad-features-list pixad-features-upload pixad-body-styles">' . ($body_out) . '</ul>';
                                                }
                                                ?>
                                </div>
                            </div>

                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Car Equipment', 'autozone'); ?>
                                </label>
                                <div class="pixad-control-input">
                                    <?php
                                                $args_eq = array('taxonomy' => 'auto-equipment', 'hide_empty' => '0');
                                                $auto_equipment_cat = get_categories($args_eq);
                                                $equip_out = '';
                                                foreach ($auto_equipment_cat as $category) {
                                                    if (is_object($category)) {
                                                        $t_id = $category->term_id;
                                                        $equipment_icon = get_option("auto_equipment_icon_$t_id");
                                                        $class_icon_set = $equipment_icon != '' ? 'equipment-icon-set' : '';
                                                        $feature_icon = $equipment_icon != '' ? '<i class="icon ' . esc_attr($equipment_icon) . '"></i>' : '';
                                                        $equip_out .= '<li class="pixad-exist ' . esc_attr($class_icon_set) . '"> <input type="checkbox" ' . esc_attr(in_array($category->slug,
                                                                $auto_equipment_check) ? 'checked' : '') . ' name="auto-equipment[]" id="' . esc_attr($category->slug) . '" value="' . esc_attr($category->slug) . '"><label for="' . esc_attr($category->slug) . '">' . wp_kses_post($feature_icon . $category->name) . '</label> </li>';
                                                    }
                                                }
                                                if ($equip_out != '') {
                                                    echo '<ul class="pixad-form-control pixad-features-list pixad-features-upload">' . ($equip_out) . '</ul>';
                                                }
                                                ?>
                                </div>
                            </div>
                        </div>
                    </section>

                    <section class="step-section" id="step03">
                        <div class="col-md-12 col-xs-12">
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e( 'Main photo', 'fl-themes-helper' ); ?>
                                </label>
                                <?php
                                $manage_gallery = __('Manage gallery', 'fl-themes-helper');
                                $clear_gallery  = __('Clear gallery', 'fl-themes-helper');
                                if(is_user_logged_in()){

                                    if(isset($_GET['auto_id']) && $_GET['auto_id'] != ''){
                                        $html = '<div id="thumbnail_id_show">' . get_the_post_thumbnail($_GET['auto_id']) .'</div>';
                                        $thumbnail_id = get_post_thumbnail_id($_GET['auto_id']);
                                    } else {
                                        $html = '<div id="thumbnail_id_show"></div>';
                                        $thumbnail_id = '16649';
                                    }
                                    $html .= '<input id="_thumbnail_id" type="hidden" name="_thumbnail_id" value="'. $thumbnail_id .'" />';
                                    $html .= '<input id="manage_thumbnail_id" title="'.esc_html($manage_gallery).'" type="button" value="'.esc_html($manage_gallery).'" />';
                                    $html .= '<input id="clear_thumbnail_id" title="'.esc_html($clear_gallery).'" type="button" value="'.esc_html($clear_gallery).'" />';
                                    echo wp_specialchars_decode($html);
                                }else{
                                    $html = '<label style="-webkit-appearance: button;cursor: pointer;border: 1px solid #ddd;background: #ddd;padding: 10px 20px;margin: 0 10px 15px 0;text-transform: uppercase;font-size: 11px;" class="custom-file-upload">
                                                <input style="display:none" name="_thumbnail_id" id="_thumbnail_id" type="file"  accept="image/*" />
                                                         '.esc_html($manage_gallery).'
                                                    </label>';
                                    echo wp_specialchars_decode($html);
                                }

                                ?>
                                <?php if (!empty($autos_demo_mode)): ?>
                                    <div class="pixad-autos">
                                        <span class="pixad-text-warning"><?php esc_attr_e('Uploading images is disabled in demo mode', 'fl-themes-helper'); ?></span>
                                    </div>
                                <?php endif ?>
                            </div>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label"><?php esc_html_e( 'Gallery photos', 'fl-themes-helper' ); ?></label>
                                <div class="pixad-control-input">
                                    <?php
                                    $html2 = '';
                                    if (is_user_logged_in()) {

                                        $ids = json_decode(pix_baseencode( $values['pixad_auto_gallery'][0]));


                                        $cs_ids = is_array($ids) ? implode(",", $ids) : '';

                                        if(!empty($ids)){
                                            $html2 .= '<div id="gallery_id_show">';
                                            foreach ($ids as $id){
                                                $html2 .= '<img src="'. wp_get_attachment_image_url($id, 'thumbnail') . '"/>';
                                            }
                                            $html2 .= '</div>';
                                        } else {
                                            $cs_ids_val = '-1';
                                            $html2 .= '<div id="gallery_id_show"></div>';
                                        }

                                        if($cs_ids != ''){
                                            // $html2  = do_shortcode('[gallery ids="'.$cs_ids.'"]');

                                            // $html2 .= '<div id="gallery_id_show">';

                                            //  $html2 .= '</div>';

                                            $cs_ids_val = $cs_ids;
                                        } else {
                                            $cs_ids_val = '-1';
                                        }





                                        $html2 .= '<input id="pixad_auto_gallery_ids" type="hidden" name="pixad_auto_gallery_ids" value="' . $cs_ids_val .'" />';
                                        $html2 .= '<input id="manage_gallery" title="'.esc_html($manage_gallery).'" type="button" value="'.esc_html($manage_gallery).'" />';
                                        $html2 .= '<input id="clear_gallery" title="'.esc_html($clear_gallery).'" type="button" value="'.esc_html($clear_gallery).'" />';
                                        echo wp_specialchars_decode($html2);

                                    } else {

                                        $html2  = '<label style="-webkit-appearance: button;cursor: pointer;border: 1px solid #ddd;background: #ddd;padding: 10px 20px;margin: 0 10px 15px 0;text-transform: uppercase;font-size: 11px;" class="custom-file-upload">
                                                            <input style="display:none" name="files-image[]" type="file" multiple accept="image/*">
                                                             '.esc_html($manage_gallery).'
                                                        </label>';
                                        echo wp_specialchars_decode($html2);
                                    }
                                    ?>
                                    <?php if (!empty($autos_demo_mode)): ?>
                                        <div class="pixad-autos">
                                            <span class="pixad-text-warning"><?php esc_attr_e('Uploading images is disabled in demo mode', 'fl-themes-helper'); ?></span>
                                        </div>
                                    <?php endif ?>


                                </div>
                            </div>
                            <div class="pixad-form-group">
                                <?php $video = wp_unslash(json_decode($auto_video_code)); ?>
                                <label class="pixad-control-label">
                                    <?php esc_html_e('YouTube Video URL', 'autozone'); ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input type="text" class="regular-text pixad-form-control" placeholder="<?php esc_html_e('Please Enter A Hosted Video URL Of Your Vehicle',
                                                           'autozone'); ?>" name="auto_video_code" id="auto_video_code" value="<?php echo esc_attr($video); ?>">
                                </div>
                            </div>
                            <?php wp_nonce_field('seller_auto_upload', 'seller_auto_upload_nonce'); ?>
                        </div>
                    </section>

                    <section class="step-section" id="step04">
                        <div class="col-md-12 col-xs-12">
                            <?php if (isset($auto_validate['first-name_show']) || isset($auto_validate['first-name_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller first name',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-first-name_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input name="seller-first-name" type="text" <?php echo isset($auto_validate['seller-first-name_req']) ? 'required' : ''; ?> placeholder="<?php esc_html_e('eg: John', 'autozone'); ?>" value="<?php echo esc_attr($seller_first_name); ?>" class="pixad-form-control">
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if (isset($auto_validate['last-name_show']) || isset($auto_validate['last-name_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller last name',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-last-name_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input name="seller-last-name" placeholder="<?php esc_html_e('eg: Doe', 'autozone'); ?>" type="text" <?php echo isset($auto_validate['seller-last-name_req']) ? 'required' : ''; ?> value="<?php echo esc_attr($seller_last_name); ?>" class="pixad-form-control">
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if (isset($auto_validate['seller-phone_show']) || isset($auto_validate['seller-phone_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller phone',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-phone_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input name="seller-phone" type="text" <?php echo isset($auto_validate['seller-phone_req']) ? 'required' : ''; ?> placeholder="<?php esc_html_e('eg: +38160656545',
                                                               'autozone'); ?>" value="<?php echo esc_attr($seller_phone); ?>" class="pixad-form-control">
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if (isset($auto_validate['seller-email_show']) || isset($auto_validate['seller-email_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller Email',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-email_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input name="seller-email" type="text" <?php echo isset($auto_validate['seller-email_req']) ? 'required' : ''; ?> placeholder="<?php esc_html_e('email', 'autozone'); ?>" value="<?php echo esc_attr($seller_email); ?>" class="pixad-form-control">
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if (isset($auto_validate['seller-country_show']) || isset($auto_validate['seller-country_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller country',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-country_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <select name="seller-country" class="pixad-form-control">
                                        <option value=""><?php _e('-- Please Select --',
                                                                'autozone'); ?></option>
                                        <?php $country = new PIXAD_Country();
                                                        $country->option_output($seller_country); ?>
                                    </select>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if (isset($auto_validate['seller-state_show']) || isset($auto_validate['seller-state_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller state',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-state_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input name="seller-state" placeholder="<?php esc_html_e('eg: Texas', 'autozone'); ?>" type="text" <?php echo isset($auto_validate['seller-state_req']) ? 'required' : ''; ?> value="<?php echo esc_attr($seller_state); ?>" class="pixad-form-control">
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if (isset($auto_validate['seller-location_show']) || isset($auto_validate['seller-location_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller location',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-location_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input name="seller-location" type="text" <?php echo isset($auto_validate['seller-location_req']) ? 'required' : ''; ?> placeholder="<?php esc_html_e('eg: 1410 W Cheltenham Ave, Philadelphia, PA 19126, United States',
                                                               'autozone'); ?>" value="<?php echo esc_attr($seller_location); ?>" class="pixad-form-control">
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if (isset($auto_validate['seller-location-lat_show']) || isset($auto_validate['seller-location-lat_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller location latitude',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-location-lat_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input name="seller-location-lat" type="text" <?php echo isset($auto_validate['seller-location-lat_req']) ? 'required' : ''; ?> placeholder="<?php esc_html_e('eg: 40.0632723',
                                                               'autozone'); ?>" value="<?php echo esc_attr($seller_location_lat); ?>" class="pixad-form-control">
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if (isset($auto_validate['seller-location-long_show']) || isset($auto_validate['seller-location-long_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller location longitude',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-location-long_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input name="seller-location-long" type="text" <?php echo isset($auto_validate['seller-location-long_req']) ? 'required' : ''; ?> placeholder="<?php esc_html_e('eg: -75.1411223',
                                                               'autozone'); ?>" value="<?php echo esc_attr($seller_location_long); ?>" class="pixad-form-control">
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if (isset($auto_validate['seller-company_show']) || isset($auto_validate['seller-company_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller company',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-company_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input name="seller-company" placeholder="<?php esc_html_e('eg: General Motors',
                                                               'autozone'); ?>" type="text" <?php echo isset($auto_validate['seller-company_req']) ? 'required' : ''; ?> value="<?php echo esc_attr($seller_company); ?>" class="pixad-form-control">
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if (isset($auto_validate['seller-town_show']) || isset($auto_validate['seller-town_req'])): ?>
                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Seller town',
                                                        'autozone'); ?><?php echo isset($auto_validate['seller-town_req']) ? '<span class="required-field">*</span>' : ''; ?>
                                </label>
                                <div class="pixad-control-input">
                                    <input name="seller-town" placeholder="<?php esc_html_e('eg: Atlanta', 'autozone'); ?>" type="text" <?php echo isset($auto_validate['seller-town_req']) ? 'required' : ''; ?> value="<?php echo esc_attr($seller_town); ?>" class="pixad-form-control">
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </section>

                    <section class="step-section" id="step05">

                        <div class="col-md-12 col-xs-12">

                            <div class="pixad-form-group">
                                <label class="pixad-control-label">
                                    <?php esc_html_e('Description', 'autozone'); ?>
                                </label>
                                <div class="pixad-control-input">
                                    <textarea name="content" placeholder="<?php esc_html_e('', 'autozone'); ?>" class="pixad-form-control"><?php echo esc_html($post_content); ?></textarea>
                                </div>

                                <div class="pixad-control-input">
                                    <input type="submit" name="submit" value="<?php esc_html_e('Submit', 'autozone'); ?>">
                                </div>
                            </div>
                        </div>

                    </section>

            </div>

            </form>


        </div>
    </div>
</section>

<?php
       // }
    } else {
        echo do_shortcode('[youzify_login]');
        /*
        echo '<div class="templines-login-wrap">
                  <span class="fa fa-sign-out fl-third-color" aria-hidden="true"></span>
                  ' . esc_html__('You must be ', 'templines-helper-core') . ' <a href="'.get_admin_url().'">' . esc_html__('logged in.', 'templines-helper-core') .'</a>
              </div>';*/
    }

}





//Widgets
//Membership Levels
function templines_paid_membership_level_shortcode() {

    if(class_exists('MemberOrder')) {



        if (is_user_logged_in()) {
            $html = '';
            $author_ID = bp_displayed_user_id();
            $current_user_id = get_current_user_id();
            $author_level = pmpro_getMembershipLevelForUser($current_user_id);

            if ($author_level == false) {
                $html .= '<div class="fl_themes_form_notice_wrap"><span>' . __('Please select a ', 'templines-helper-core') . '
                        <a href="' . esc_url(home_url("/membership-account/membership-levels/")) . '">' . __('plan',
                        'templines-helper-core') . '</a>
                        ' . __(' to add a vehicle. ', 'templines-helper-core') . '
                    </span></div>';
            }

            if ($current_user_id == $author_ID) {
                if ($author_level->name != '') {
                    $html .= '<div class="templines_your_level">' . __('Your Level: ',
                            'templines-helper-core') . $author_level->name . '</div>';
                }
                if ($author_level->startdate != 0 && $author_level->startdate != '') {
                    $html .= '<div class="templines_your_level_start">' . __('Start: ',
                            'templines-helper-core') . date("d F, Y", $author_level->startdate) . '</div>';
                }
                if ($author_level->enddate != 0 && $author_level->enddate != '') {
                    $html .= '<div class="templines_your_level_end">' . __('End: ', 'templines-helper-core') . date("d F, Y",
                            $author_level->enddate) . '</div>';
                }
                if ($author_level->description != '') {
                    $html .= '<div class="templines_your_description">' . $author_level->description . '</div>';
                }
                $html .= '<div class="templines_show_levels">' . '<a class="templines_show_levels_btn" href="' . esc_url(home_url("/membership-account/membership-levels/")) . '">' . __("All Levels",
                        'templines-helper-core') . '</a>' . '</div>';


            }




            return $html;
        }
    }

}
add_shortcode('templines_level', 'templines_paid_membership_level_shortcode');




//Woo Sales
function templines_woo_sales_shortcode() {

    if(class_exists('WooCommerce')) {
        if(class_exists('Pixad_Booking_AUTO')){
            if (is_user_logged_in()) {
                global $wpdb;
                $html = '';
                $author_ID = bp_displayed_user_id();
                $current_user_id = get_current_user_id();
                $html .= '<div class="templines_sales">';
                if($author_ID == $current_user_id){

                    $html .= '<div class="sales_container">';
                    $html .= '<span>' . pixba_get_price_with_currency(wc_get_customer_total_spent($current_user_id)) . '</span>';
                    $html .= '</div>';

                }

                $html .= '</div>';



                return $html;
            }
        }
    }

}
add_shortcode('templines_sales', 'templines_woo_sales_shortcode');
