<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class FL_THEME_HELPER_Contact_Info extends TEMPLINES_THEME_HELPER_WP_Widget {
	protected $widget_base_id = 'FL_THEME_HELPER_Contact_Info';
	protected $widget_name = 'Custom : Contact Info';
	
	protected $options;

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
		$this->options = array(
            array(
                'left_content', 'text', '',
                'label'		=> esc_html__('Left content', 'templines-helper-core'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),

            array(
                'right_content', 'text', '3135  Oliver St, Fort Worth TX 76134',
                'label'		=> esc_html__('Right content', 'templines-helper-core'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),

		);
		
        parent::__construct();
    }
	
    /**
     * Display widget
     */
    function widget( $args, $instance ) {
		$el_class = '';
		
        extract( $args );
		$this->setInstances($instance, 'filter');

        $left = $this->getInstance('left_content');
        $right = $this->getInstance('right_content');

		/*HTML*/


        if($left !='' or $right!=''){
            echo '<div class="footer__contacts col-md-3">';
                if($left!=''){
                    echo '<div class="footer__name">'.$left.'</div>';
                }
                if($right!=''){
                    echo '<div class="footer__text">'.$right.'</div>';
                }
            echo '</div>';
        }


    }
}