<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class TM_THEME_HELPER_Social_Profiles extends TEMPLINES_THEME_HELPER_WP_Widget {
	protected $widget_base_id = 'TM_THEME_HELPER_Social_Profiles';
	protected $widget_name = 'Custom : Footer Social';
	
	protected $options;

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
		$this->options = array(
			array(
				'title', 'text', '',
				'label'		=> esc_html__('Title', 'fl-themes-helper'),
				'input'		=> 'text',
				'filters'	=> 'widget_title',
				'on_update'	=> 'esc_attr'
			),

            array(
                'tw', 'text', '#',
                'label'		=> esc_html__('Twitter Link:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
            array(
                'bh', 'text','',
                'label'		=> esc_html__('Behance Link:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
            array(
                'fb', 'text', '#',
                'label'		=> esc_html__('Facebook Link:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),

            array(
                'pn', 'text', '#',
                'label'		=> esc_html__('Pinterest Link:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
            array(
                'yo', 'text', '#',
                'label'		=> esc_html__('Youtube Link:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
            array(
                'in', 'text', '#',
                'label'		=> esc_html__('Instagram Link:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
            array(
                'c_l_1_i', 'text', '',
                'label'		=> esc_html__('Custom Icon 1 HTML Class:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
            array(
                'c_l_1', 'text', '',
                'label'		=> esc_html__('Custom Icon 1 Link:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
            array(
                'c_l_2_i', 'text', '',
                'label'		=> esc_html__('Custom Icon 2 HTML Class:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
            array(
                'c_l_2', 'text', '',
                'label'		=> esc_html__('Custom Icon 2 Link:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
            array(
                'c_l_3_i', 'text', '',
                'label'		=> esc_html__('Custom Icon 3 HTML Class:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
            array(
                'c_l_3', 'text', '',
                'label'		=> esc_html__('Custom Icon 3 Link:', 'fl-themes-helper'),
                'input'		=> 'text',
                'on_update'	=> 'esc_attr'
            ),
		);
		
        parent::__construct();
    }
	
    /**
     * Display widget
     */
    function widget( $args, $instance ) {
        $result = '';
		
        extract( $args );
		$this->setInstances($instance, 'filter');
		
        echo wp_kses($before_widget, array(
				'div' => array('id' => array(), 'class' => array()),
				'section' => array('id' => array(), 'class' => array())
			));
		
		$title = $this->getInstance('title');
        $tw = $this->getInstance('tw');
        $bh = $this->getInstance('bh');
        $fb = $this->getInstance('fb');
        $pn = $this->getInstance('pn');
        $yo = $this->getInstance('yo');
        $in = $this->getInstance('in');
        $c_l_1_i = $this->getInstance('c_l_1_i');
        $c_l_1 = $this->getInstance('c_l_1');
        $c_l_2_i = $this->getInstance('c_l_2_i');
        $c_l_2 = $this->getInstance('c_l_2');
        $c_l_3_i = $this->getInstance('c_l_3_i');
        $c_l_3 = $this->getInstance('c_l_3');
		echo (!empty($title)) ? $before_title . $title . $after_title : '';
				
		/*HTML*/


            $result .='<ul class="social-links list-inline">';
                if(!empty($tw)){
                    $result .='<li>
                                    <a href="'.$tw.'" class="icon fa fa fa-twitter">
                                    </a>
                                </li>';
                }
                if(!empty($pn)){
                    $result .='<li>
                                    <a href="'.$pn.'" class="icon fa fa fa-pinterest">
                                    </a>
                                </li>';
                }
                if(!empty($bh)){
                    $result .='<li class="social__item">
                                    <a href="'.$bh.'"  class="icon fa fa fa-behance">
                                    </a>
                                </li>';
                }
                if(!empty($fb)){
                    $result .='<li class="social__item">
                                    <a href="'.$fb.'"  class="icon fa fa fa-facebook">
                                    </a>
                                </li>';
                }
                if(!empty($yo)){
                    $result .='<li class="social__item">
                                            <a href="'.$yo.'"  class="icon fa fa fa-youtube-play">
                                            </a>
                                        </li>';
                }
                if(!empty($in)){
                    $result .='<li class="social__item">
                                            <a href="'.$in.'"  class="icon fa fa fa-instagram">
                                            </a>
                                        </li>';
                }
                if(!empty($c_l_1_i) and !empty($c_l_1)){
                    $result .='<li class="social__item"><a href="'.$c_l_1.'"  class="'.$c_l_1_i.'"></a></li>';
                }
                if(!empty($c_l_2_i) and !empty($c_l_2)){
                    $result .='<li class="social__item"><a href="'.$c_l_2.'"  class="'.$c_l_2_i.'"></a></li>';
                }
                if(!empty($c_l_3_i) and !empty($c_l_3)){
                    $result .='<li class="social__item"><a href="'.$c_l_3.'"  class="'.$c_l_3_i.'"></a></li>';
                }
            $result .='</ul>';



        echo !empty($result) ? $result : '';

        echo wp_kses($after_widget, array(
				'div' => array('id' => array(), 'class' => array()),
				'section' => array('id' => array(), 'class' => array())
			));
    }
}