<?php
/**
 * Plugin Name: Templines Elementor Helper Core
 * Plugin URI:: https://themeforest.net/user/templines
 * Description: Helper plugin for Templines themes. Don't delete this plugin.
 * Version: 1.6.5
 * Author:Templines
 * Author URI: https://themeforest.net/user/templines
 * License: GPL v2
 */

/**====================================================================
==  Make sure we don't expose any info if called directly
====================================================================*/





 
    

if ( !function_exists( 'add_action' ) ) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

/**====================================================================
==  Load Text domain
====================================================================*/
add_action('plugins_loaded', 'templines_helper_core_load_textdomain');
function templines_helper_core_load_textdomain() {
    load_plugin_textdomain( 'templines-helper-core', false, dirname( plugin_basename(__FILE__) ) . '/languages/' );
}

define('TEMPLINES_HELPER_CORE_PLUGIN_PATH',plugin_dir_path(__FILE__));
define('TEMPLINES_HELPER_CORE_PLUGIN_URL',plugins_url() . '/templines-helper-core');

defined('TEMPLINES_HELPER_CORE_PLUGIN_VERSION' )   or define( 'TEMPLINES_HELPER_CORE_PLUGIN_VERSION', '1.0');
defined('FL_THEME_HELPER_ROOT_DIR' )    or define( 'FL_THEME_HELPER_ROOT_DIR', plugins_url() . '/templines-helper-core');
defined('TEMPLINES_HELPER_CORE_PREVIEW_IMAGE')     or define('TEMPLINES_HELPER_CORE_PREVIEW_IMAGE', plugin_dir_url(__FILE__) . '/assets/images/presentation-images');
defined('FL_THEME_HELPER_URL' )         or define( 'FL_THEME_HELPER_URL', plugin_dir_url( __FILE__ ));
defined('TEMPLINES_HELPER_CORE_PREVIEW_IMAGE_ELEMENTOR')     or define('TEMPLINES_HELPER_CORE_PREVIEW_IMAGE_ELEMENTOR', plugin_dir_url(__FILE__) . '/elementor/custom-controle/image-selector/preview_image');


if (class_exists('PIXAD_Settings')){
        $Settings   = new PIXAD_Settings();
        $options    = $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_settings', true );
    }


//var_dump($levels_array);
/**====================================================================
==  Require Templines Helper Core Addons
====================================================================*/
if( !class_exists('Templines_Helper_Core_Addons') ) {

    class Templines_Helper_Core_Addons {

        public static $instance;
        // Construct
        public function __construct() {
            $this->addSocial();
            $this->addLike();
            $this->addCustomFunction();
            $this->addWidgets();

            // Version 5 ACF PRO
            add_action('acf/include_field_types',  array($this, 'include_field_types'));

            add_action('wp_enqueue_scripts', array($this, 'enqueue_styles'));
            $this->addYouzify();
        }

        /**
         * Check if theme has elementor
         *
         * @return boolean
         */
        public function has_elementor() {
            return did_action( 'elementor/loaded' );
        }

        public function enqueue_styles(){
            wp_enqueue_style('front', plugin_dir_url( __FILE__ ). 'assets/front_css/front.css', array(),'1.0');
            wp_enqueue_style('templines_kaswara_css', plugin_dir_url( __FILE__ ). 'assets/css/kaswara/kaswara_style.css', array(),'1.0');
            wp_enqueue_script('templines_kaswara_js', plugin_dir_url( __FILE__ ). 'assets/js/kaswara/script.js', array( 'jquery' ));
            wp_enqueue_style( 'templines_icons', plugin_dir_url( __FILE__ ) .'assets/font-icon/icons.css' );


        }
        /**
         * Returns allowed order by fields for options
         *
         * @return array
         */
        public function orderby_arr() {
            return array(
                'none'          => esc_html__( 'None', 'templines-helper-core' ),
                'ID'            => esc_html__( 'ID', 'templines-helper-core' ),
                'author'        => esc_html__( 'Author', 'templines-helper-core' ),
                'title'         => esc_html__( 'Title', 'templines-helper-core' ),
                'name'          => esc_html__( 'Name (slug)', 'templines-helper-core' ),
                'date'          => esc_html__( 'Date', 'templines-helper-core' ),
                'modified'      => esc_html__( 'Modified', 'templines-helper-core' ),
                'rand'          => esc_html__( 'Rand', 'templines-helper-core' ),
                'comment_count' => esc_html__( 'Comment Count', 'templines-helper-core' ),
                'menu_order'    => esc_html__( 'Menu Order', 'templines-helper-core' ),
            );
        }


        function include_field_types( $version ) {
            include_once('afc_custom_fields/icon_picker/acf-fonticonpicker-v5.php');
            include_once('afc_custom_fields/image_selector/acf-image_select-v5.php');
        }
        /** Add Social Share Function*/
        public function addSocial() {
            require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH.'function/social-share/social.php');
        }
        /** Add Like Function*/
        public function addLike() {
            require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH.'function/like/post-like.php');
        }
        /** Add Custom Function*/
        public function addCustomFunction() {
            require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH.'function/custom_function.php');
            require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH.'function/public_function.php');
            require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH.'function/load-more-car.php');
            require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH.'function/theme-import.php');
            require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH.'function/ajax.php');
            require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH.'function/post-fields.php');
        }


        /** Add Custom Widgets*/
        public function addWidgets() {
            require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH.'widgets/widgets.php');
        }

        public static function getInstance() {
            if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Templines_Helper_Core_Addons ) ) {
                self::$instance = new Templines_Helper_Core_Addons();
            }

            return self::$instance;
        }

        /** Add Youzify*/
        public function addYouzify() {
            if(class_exists('BuddyPress')){
                require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH.'youzify/youzify.php');
            }
        }



    } // end of class

} // end of class_exists
/**
 * Returns instance of Jet_Elements_Tools
 *
 * @return Templines_Helper_Core_Addons
 */
if ( ! function_exists( 'templines_helper_core_addons' ) ) {
    function templines_helper_core_addons()
    {
        return Templines_Helper_Core_Addons::getInstance();
    }
}

templines_helper_core_addons();

// Custom Elementor Option
require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH. '/elementor/elementor.php' );
function Templines_Helper_Core_Elementor() {
    $instance = Templines_Helper_Core_Elementor::instance( __FILE__, TEMPLINES_HELPER_CORE_PLUGIN_VERSION );

    return $instance;
}

Templines_Helper_Core_Elementor();


add_action( 'wp_enqueue_scripts', 'templines_equeue_scripts');
function templines_equeue_scripts(){
    wp_enqueue_script   ('templines__custom_admin_js',  plugin_dir_url( __FILE__ ) .  '/assets/js/scripts.js', '', '', true);
}

//Adding svg extension
function my_myme_types($mime_types){
    $mime_types['svg'] = 'image/svg+xml';
    return $mime_types;
}
add_filter('upload_mimes', 'my_myme_types', 1, 1);


add_action('pre_get_posts','fl_themes_users_own_attachments');
function fl_themes_users_own_attachments( $wp_query_obj ) {
    global $current_user, $pagenow;
    $is_attachment_request = ($wp_query_obj->get('post_type')=='attachment');
    if( !$is_attachment_request )
        return;
    if( !is_a( $current_user, 'WP_User') )
        return;
    if( !in_array( $pagenow, array( 'upload.php', 'admin-ajax.php' ) ) )
        return;
    if( !current_user_can('delete_pages') )
        $wp_query_obj->set('author', $current_user->ID );
    return;
}

?>
