<?php

add_action( 'wp_ajax_carloadmore_ajax_load_more_car_vc', 'carloadmore_ajax_load_more_car_vc');
add_action( 'wp_ajax_nopriv_carloadmore_ajax_load_more_car_vc', 'carloadmore_ajax_load_more_car_vc');
function carloadmore_ajax_load_more_car_vc() {

    check_ajax_referer( 'carloadmore-load-more-car-nonce', 'nonce' );
    $args                   = isset( $_POST['query'] ) ? array_map( 'esc_attr', $_POST['query'] ) : array();
    $args['post_type']      = isset( $args['post_type'] ) ? esc_attr( $args['post_type'] ) : 'pixad-autos';
    $args['paged']          = esc_attr( $_POST['page'] );
    $args['post_status']    = 'publish';
    $args['posts_per_page'] = esc_attr( $_POST['car_per_page'] );

    $article_css_classes [] = $animation_delay = '';
    global $PIXAD_Autos;
    $Settings = new PIXAD_Settings();
    $validate = $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_validation', true ); // Get validation settings

    $showInSidebar = pixad::getsideviewfields($validate);
    $validate = pixad::validation( $validate ); // Fix undefined index notice

    $auto_translate = unserialize( get_option( '_pixad_auto_translate' ) );


    ob_start();
    $posts = new WP_Query( $args );

    if ( $posts->have_posts() ) :  while ( $posts->have_posts() ): $posts->the_post();?>

        <article class="resent-car-item"><!--article start-->

            <div class="entry-auto-grid-wrap"><!--.entry-auto-grid-wrap -->

                <div class="top-content-wrap">

                    <?php
                    if (function_exists('compare_cars_settings_page')) {
                        echo  '<div class="compare-car-wrap templines-font-style-lighter-than">
                                    <a class="add-to-compare" data-id="'.get_the_ID().'" data-action="add">
                                       <span class="add-cmpr"> 
                                           <i class="icon-speedometer" aria-hidden="true"></i>
                                          <em class="cmpr-btn-text">'.esc_attr__('Add To Compare','templines-helper-core').'</em>
                                        </span>
                                        <span class="rem-cmpr">
                                          <i class="icon-speedometer" aria-hidden="true"></i>
                                          <em class="cmpr-btn-text">'.esc_attr__('Remove From Compare','templines-helper-core').'</em>
                                        </span>   
                                     </a>
                                 </div>';

                        echo '<div class="favorite-car-wrap">';
                        if(empty(get_option('compare_cars_templ')) || empty(get_option('compare_cars_templ')['no_favorite'])) :
                            echo  '<a class="car-favorite" data-id="'.get_the_ID().'" data-action="add-favorite">
                           <span class="add-fvrt"> 
                              <i class="fa fa-star-o"></i>
                            </span>
                            <span class="rem-fvrt"> 
                              <i class="fa fa-star-o"></i>
                            </span>
                        </a>';
                        endif;
                        echo '</div>';
                    }
                    ?>
                    <div class="image-grid-mask"></div>
                    <a class="auto-link-image-link" href="<?php the_permalink(); ?>"></a>
                    <?php if( has_post_thumbnail() ): ?>

                        <?php the_post_thumbnail('revus_size_520x440_crop', array('class' => 'img-responsive')); ?>

                    <?php else: ?>
                        <img class="no-image" src="<?php echo PIXAD_AUTO_URI .'assets/img/no_image.jpg'; ?>" alt="<?php esc_attr_e('No Image','templines-helper-core')?>">
                    <?php endif; ?>
                    <?php do_action( 'revus_autos_single_auto_img', $post ); ?>
                </div>
                <div class="bottom-content-wrap">
                    <h6 class="title-content">
                        <?php if (revus_get_theme_mod('auto_featured_text',true)):
                            ?>
                            <span class="card-auto-label templines-font-style-lighter-than"><?php echo revus_get_theme_mod('auto_featured_text',true); ?></span>
                        <?php endif; ?>
                        <?php if (function_exists('pix_autodealer_output_info')) {?>
                            <span class="grid-auto-title templines-text-title-style"><?php echo pix_autodealer_output_info(get_the_title()); ?></span>
                        <?php } ?>
                    </h6>
                    <div class="auto-grid-list-content">
                        <ul class="list-grid--info">
                            <?php foreach ($showInSidebar as $id => $sideAttribute):
                                $id='_'.$id; $id = str_replace('-', '_', $id);
                                if( $PIXAD_Autos->get_meta($id) ): ?>
                                    <li class="list-grid-item templines-font-style-regular"><?php if($sideAttribute['icon'] !='autofont-cars'){?><i class="<?php echo esc_html($sideAttribute['icon'])?>"></i><?php } ?>
                                        <?php
                                        $val_attr =  $PIXAD_Autos->get_meta($id);
                                        if(!empty($auto_translate[$val_attr])  ){
                                            echo esc_html($auto_translate[$val_attr]);
                                        }else{
                                            echo esc_html($PIXAD_Autos->get_meta($id));
                                        }
                                        ?>
                                    </li>
                                <?php endif;
                            endforeach;?>
                        </ul>
                    </div>

                    <?php if( $validate['auto-price_show'] && $PIXAD_Autos->get_meta('_auto_price') ): ?>
                        <div class="price-auto-wrap">
                            <?php if (function_exists('pix_autodealer_output_info')) {?>
                                <span class="slider-grid-price templines-font-style-semi-bolt"><?php echo pix_autodealer_output_info($PIXAD_Autos->get_price(false)); ?></span>
                            <?php } ?>
                        </div>
                    <?php endif; ?>

                </div>
            </div>  <!--//.entry-auto-grid-wrap -->
        </article><!--article end-->



    <?php
    endwhile; endif;
    wp_reset_postdata();
    $data = ob_get_clean();
    wp_send_json_success( $data );

    wp_die();

}