<?php
/**
 * Custom User Contact methods
 */

    add_filter('user_contactmethods', 'templines_add_contact_info');

    if (!function_exists('templines_add_contact_info')) {

        function templines_add_contact_info($contact_info)
        {
            $contact_info['facebook']       = esc_html__('Facebook Username', 'templines-helper-core');
            $contact_info['google']         = esc_html__('Google Plus Username', 'templines-helper-core');
            $contact_info['instagram']      = esc_html__('Instagram Username', 'templines-helper-core');
            $contact_info['pinterest']      = esc_html__('Pinterest Username', 'templines-helper-core');
            $contact_info['twitter']        = esc_html__('Twitter Username', 'templines-helper-core');
            $contact_info['behance']        = esc_html__('Behance Username', 'templines-helper-core');
            $contact_info['phone']          = esc_html__('Phone Number', 'templines-helper-core');
            return $contact_info;
        }

    }

// Instagram
function templines_theme_helper_instagram_api_curl_connect( $api_url ){
    $connection_c = curl_init(); // initializing
    curl_setopt( $connection_c, CURLOPT_URL, $api_url ); // API URL to connect
    curl_setopt( $connection_c, CURLOPT_RETURNTRANSFER, 1 ); // return the result, do not print
    curl_setopt( $connection_c, CURLOPT_TIMEOUT, 20 );
    $json_return = curl_exec( $connection_c ); // connect and get json data
    curl_close( $connection_c ); // close connection
    return json_decode( $json_return ); // decode and return
}

/**====================================================================
==  Shortcode custom text
====================================================================*/
if (!function_exists('templines_js_delete_wpautop')) {
    function templines_delete_wpautop($content, $wpautop = false)
    {
        if ($wpautop) {
            $content = preg_replace('/<\/?p\>/', "\n", $content);
        }

        return $content;
    }
}
/**
 * Custom Excerpt length
 */
function templines_limit_excerpt($limit) {
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'...';
    } else {
        $excerpt = implode(" ",$excerpt);
    }
    $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
    return $excerpt;
}
/**
 * Custom Pagination
 */
function templines_custom_pagination($pages = '', $range = 2)
{

    global $paged;
    if(empty($paged)) $paged = 1;

    if($pages == '')
    {
        global $wp_query;
        $pages = $wp_query->max_num_pages;
        if(!$pages)
        {
            $pages = 1;
        }
    }

    if(1 != $pages)
    {

        if($paged > 1  ) echo "<a href='".get_pagenum_link($paged - 1)."' class='page-numbers'><i class=\"fa fa-angle-left\" aria-hidden=\"true\"></i></a>";

        if($paged > 2 && $paged > $range+1 && $range < $pages) echo "<a href='".get_pagenum_link(1)."' class='page-numbers'>1</a>";
        if($paged > 2 && $paged > $range+2 && $range < $pages) echo "<span class='page-numbers dots'>…</span>";
        for ($i=1; $i <= $pages; $i++)
        {
            if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $range ))
            {
                echo ($paged == $i)? "<span class=\"page-numbers current\">".$i."</span>":"<a href='".get_pagenum_link($i)."' class=\"page-numbers\">".$i."</a>";
            }
        }
        if ($paged < $pages-1 &&  $paged+$range+1 < $pages && $range+1 < $pages ) echo "<span class='page-numbers dots'>…</span>";
        if ($paged < $pages-1 &&  $paged+$range < $pages && $range+1 < $pages ) echo "<a href='".get_pagenum_link($pages)."' class=\"page-numbers\">".$pages."</a>";

        if ($paged < $pages ) echo "<a href=\"".get_pagenum_link($paged + 1)."\" class=\"page-numbers\"><i class=\"fa fa-angle-right\" aria-hidden=\"true\"></i></a>";
    }
}


/* get_intermediate_image_sizes() without keys */
if (!function_exists( 'templines_get_image_sizes' )) :
    function templines_get_image_sizes() {
        $sizes = get_intermediate_image_sizes();
        $result = array('full' => 'full');
        foreach($sizes as $k => $name) {
            $result[$name] = $name;
        }
        return $result;
    }
endif;


/**
 * Get Attachment Attribute for Images
 */
if (!function_exists( 'templines_get_attachment' )) :
    function templines_get_attachment($attachment_id, $attachment_size = 'full')
    {
        if (filter_var($attachment_id, FILTER_VALIDATE_URL)) {
            $path_to_image = $attachment_id;
            $attachment_id = attachment_url_to_postid($attachment_id);
            if (is_numeric($attachment_id) && $attachment_id == 0) {
                return array(
                    'alt' => null,
                    'caption' => null,
                    'description' => null,
                    'href' => null,
                    'src' => $path_to_image,
                    'title' => null,
                    'width' => null,
                    'height' => null,
                );
            }
        }

        if (is_numeric($attachment_id) && $attachment_id !== 0) {
            $attachment = get_post($attachment_id);
            if(is_object($attachment)) {
                $attachment_src = array();
                if (isset($attachment_size)) {
                    $attachment_src = wp_get_attachment_image_src($attachment_id, $attachment_size);
                }
                return array(
                    'alt' => get_post_meta($attachment->ID, '_wp_attachment_image_alt', true),
                    'caption' => $attachment->post_excerpt,
                    'description' => $attachment->post_content,
                    'href' => get_permalink($attachment->ID),
                    'src' => isset($attachment_src[0]) ? $attachment_src[0] : $attachment->guid,
                    'title' => $attachment->post_title,
                    'width' => isset($attachment_src[1]) ? $attachment_src[1] : false,
                    'height' => isset($attachment_src[2]) ? $attachment_src[2] : false,
                );
            }
        }
        return false;
    }
endif;


function templines_post_taxonomy($post_id, $taxonomy, $delimiter = ', ', $get = 'name', $link = true)
{
    $tags = wp_get_post_terms($post_id, $taxonomy);
    $list = '';
    foreach ($tags as $tag) {
        if ($link) {
            $list .= '<a href="' . get_category_link($tag->term_id) . '">' . $tag->$get . '</a>' . $delimiter;
        } else {
            $list .= $tag->$get . $delimiter;
        }
    }
    return substr($list, 0, strlen($delimiter) * (-1));
}


function templines_wp_kses($templines_string){
    $allowed_tags = array(
        'img' => array(
            'src' => array(),
            'alt' => array(),
            'width' => array(),
            'height' => array(),
            'class' => array(),
        ),
        'a' => array(
            'href' => array(),
            'title' => array(),
            'class' => array(),
        ),
        'span' => array(
            'class' => array(),
        ),
        'div' => array(
            'class' => array(),
            'id' => array(),
        ),
        'h1' => array(
            'class' => array(),
            'id' => array(),
        ),
        'h2' => array(
            'class' => array(),
            'id' => array(),
        ),
        'h3' => array(
            'class' => array(),
            'id' => array(),
        ),
        'h4' => array(
            'class' => array(),
            'id' => array(),
        ),
        'h5' => array(
            'class' => array(),
            'id' => array(),
        ),
        'h6' => array(
            'class' => array(),
            'id' => array(),
        ),
        'p' => array(
            'class' => array(),
            'id' => array(),
        ),
        'strong' => array(
            'class' => array(),
            'id' => array(),
        ),
        'i' => array(
            'class' => array(),
            'id' => array(),
        ),
        'del' => array(
            'class' => array(),
            'id' => array(),
        ),
        'ul' => array(
            'class' => array(),
            'id' => array(),
        ),
        'li' => array(
            'class' => array(),
            'id' => array(),
        ),
        'ol' => array(
            'class' => array(),
            'id' => array(),
        ),
        'input' => array(
            'class' => array(),
            'id' => array(),
            'type' => array(),
            'style' => array(),
            'name' => array(),
            'value' => array(),
        ),
    );
    if (function_exists('wp_kses')) {
        return wp_kses($templines_string,$allowed_tags);
    }
}









add_filter('style_loader_tag', 'templines_fixed_validator_error', 10, 2);
add_filter('script_loader_tag', 'templines_fixed_validator_error', 10, 2);
add_filter('wp_print_footer_scripts ', 'templines_fixed_validator_error', 10, 2);
function templines_fixed_validator_error($tag) {
    return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
}



// Generate custom css option vc
if( ! function_exists( 'templines_helping_generate_custom_css' ) ) {
    function templines_helping_generate_custom_css() {
        global $templines_helping_responsive_lg_style , $templines_helping_responsive_md_style ,$templines_helping_responsive_sm_style , $templines_helping_css_style;

        // Custom Css
        $output_css_style = '';
        if( !empty($templines_helping_css_style)) {
            ob_start();
            echo '<style id="templines-helping-custom-vc-css" type="text/css">';
            foreach ($templines_helping_css_style as $key => $value) {
                echo $value;
            }
            echo '</style>';
            $output_css_style = ob_get_contents();
            ob_end_clean();

            // 1. Remove comments.
            // 2. Remove whitespace.
            // 3. Remove starting whitespace.
            $output_css_style = preg_replace( '#/\*.*?\*/#s', '', $output_css_style );
            $output_css_style = preg_replace( '/\s*([{}|:;,])\s+/', '$1', $output_css_style );
            $output_css_style = preg_replace( '/\s\s+(.*)/', '$1', $output_css_style );

            ?>
            <script type="text/javascript"> (function($) { $('head').append('<?php print $output_css_style; ?>'); })(jQuery); </script>
            <?php
        }
        // Custom Css Resonsive Style
        // Large
        if( !empty( $templines_helping_responsive_lg_style ) ) {
            $output_responsive_css = '';
            ob_start();
            echo '<style id="templines-helping-custom-responsive-lg-css" type="text/css">';
                echo '@media screen and (max-width: 992px) {';
                    foreach ($templines_helping_responsive_lg_style as $key => $value) {
                        echo $value;
                    }
                echo '}';
            echo '</style>';
            $output_responsive_css = ob_get_contents();
            ob_end_clean();

            // 1. Remove comments.
            // 2. Remove whitespace.
            // 3. Remove starting whitespace.
            $output_responsive_css = preg_replace( '#/\*.*?\*/#s', '', $output_responsive_css );
            $output_responsive_css = preg_replace( '/\s*([{}|:;,])\s+/', '$1', $output_responsive_css );
            $output_responsive_css = preg_replace( '/\s\s+(.*)/', '$1', $output_responsive_css );

            ?>
            <script type="text/javascript"> (function($) { $('head').append('<?php print $output_responsive_css ?>'); })(jQuery); </script>
            <?php
        }
        // Medium
        if( !empty( $templines_helping_responsive_md_style ) ) {
            $output_responsive_css = '';
            ob_start();
            echo '<style id="templines-helping-custom-responsive-md-css" type="text/css">';
                echo '@media screen and (max-width: 768px) {';
                    foreach ($templines_helping_responsive_md_style as $key => $value) {
                        echo $value;
                    }
                echo '}';
            echo '</style>';
            $output_responsive_css = ob_get_contents();
            ob_end_clean();

            // 1. Remove comments.
            // 2. Remove whitespace.
            // 3. Remove starting whitespace.
            $output_responsive_css = preg_replace( '#/\*.*?\*/#s', '', $output_responsive_css );
            $output_responsive_css = preg_replace( '/\s*([{}|:;,])\s+/', '$1', $output_responsive_css );
            $output_responsive_css = preg_replace( '/\s\s+(.*)/', '$1', $output_responsive_css );

            ?>
            <script type="text/javascript"> (function($) { $('head').append('<?php print $output_responsive_css ?>'); })(jQuery); </script>
            <?php
        }
        // Small
        if( !empty( $templines_helping_responsive_sm_style ) ) {
            $output_responsive_css = '';
            ob_start();
            echo '<style id="templines-helping-custom-responsive-sm-css" type="text/css">';
                echo '@media screen and (max-width: 576px) {';
                    foreach ($templines_helping_responsive_sm_style as $key => $value) {
                        echo $value;
                    }
                echo '}';
            echo '</style>';
            $output_responsive_css = ob_get_contents();
            ob_end_clean();

            // 1. Remove comments.
            // 2. Remove whitespace.
            // 3. Remove starting whitespace.
            $output_responsive_css = preg_replace( '#/\*.*?\*/#s', '', $output_responsive_css );
            $output_responsive_css = preg_replace( '/\s*([{}|:;,])\s+/', '$1', $output_responsive_css );
            $output_responsive_css = preg_replace( '/\s\s+(.*)/', '$1', $output_responsive_css );

            ?>
            <script type="text/javascript"> (function($) { $('head').append('<?php print $output_responsive_css ?>'); })(jQuery); </script>
            <?php
        }
    }
}
add_action( 'wp_footer', 'templines_helping_generate_custom_css', 999 );



/*
 * Post share
 * */

function templines_share_buttons($tw=false,$fb=false,$lk=false,$pin=false,$rd=false,$vk = false) {
    global $post;
    if( !$post )
        return false;
    $output ='';
    // Permalink
    $permalink      = get_permalink( $post->ID );
    // Post image
    $featured_image  =  wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
    $image_post_share = $featured_image['0'];
    // Post Title
    $post_title     = rawurlencode( get_the_title( $post->ID ) );
    $excerpt        = get_the_excerpt();
    // Twitter
    if($tw =='true'){
        $output  .= '<a class="templines-share--icon templines-primary-color-hv" href="https://twitter.com/home?status=' . $post_title . '+' . $permalink . '" target="_blank" onclick="window.open(this.href,this.title,\'width=500,height=500,top=300px,left=300px\');  return false;"><i class="fa fa-twitter"></i></a>';
    }
    //Facebook
    if($fb =='true') {
        $output .= '<a class="templines-share--icon templines-primary-color-hv" href="https://www.facebook.com/share.php?u=' . $permalink . '&title=' . $post_title . '" target="_blank" onclick="window.open(this.href,this.title,\'width=500,height=500,top=300px,left=300px\');  return false;"><i class="fa fa-facebook"></i></a>';
    }
    // LinkedIn
    if($lk =='true') {
        $output .= '<a class="templines-share--icon templines-primary-color-hv" href="http://www.linkedin.com/shareArticle?mini=true&url=' . $permalink . '&title=' . $post_title . '" target="_blank" onclick="window.open(this.href,this.title,\'width=500,height=500,top=300px,left=300px\');  return false;"><i class="fa fa-linkedin"></i></a>';
    }
    // Pinterest
    if($pin =='true') {
        $output .= '<a class="templines-share--icon templines-primary-color-hv" href="http://pinterest.com/pin/create/bookmarklet/?media=' . $image_post_share . '&url=' . $permalink . '&is_video=false&description=' . $post_title . '" target="_blank" onclick="window.open(this.href,this.title,\'width=500,height=500,top=300px,left=300px\');  return false;"><i class="fa fa-pinterest-p"></i></a>';
    }
    // Reddit
    if($rd =='true') {
        $output .= '<a class="templines-share--icon templines-primary-color-hv" href="http://reddit.com/submit?url='.$permalink.'&title=' . $post_title . '" target="_blank" onclick="window.open(this.href,this.title,\'width=500,height=500,top=300px,left=300px\');  return false;"><i class="fa fa-reddit-alien"></i></a>';
    }
    // VK
    if($vk =='true') {
         $output .='<a class="templines-share--icon templines-primary-color-hv" href="http://vkontakte.ru/share.php?url='.urlencode(esc_url($permalink)).'&title=' . $post_title . '&description='.esc_attr($excerpt).'" target="_blank" onclick="window.open(this.href,this.title,\'width=500,height=500,top=300px,left=300px\');  return false;"><i class="fa fa-vk"></i></a>';
    }
    return $output;
}




// Breadcrumbs function



if( ! function_exists( 'templines_theme_helping_breadcrumb' ) ) {
    //Breadcrumbs Function
    function templines_theme_helping_breadcrumb() {

        $text['home']           = esc_html__('Home','templines-helper-core');
        $text['blog']           = esc_html__('Blog','templines-helper-core');
        $text['category']       = esc_html__('Archive','templines-helper-core').' "%s"';
        $text['search']         = esc_html__('Search results:','templines-helper-core').' "%s"';
        $text['tag']            = esc_html__('Tag','templines-helper-core').' "%s"';
        $text['author']         = esc_html__('Author','templines-helper-core').' %s';
        $text['404']            = esc_html__('Error 404','templines-helper-core');
        $text['shop_page']      = esc_html__('Shop','templines-helper-core');



        $show_current           = 1;
        $show_on_home           = 0;
        $show_home_link         = 1;
        $show_title             = 1;
        $delimiter              = '<span class="breadcrumbs-delimiter templines-primary-color"><i class="fa fa-chevron-right" aria-hidden="true"></i><i class="fa fa-chevron-right" aria-hidden="true"></i></span>';

        global $post;
        $home_link    = esc_url(home_url('/'));
        $blog_link    = get_permalink( get_option( 'page_for_posts' ) );
        $link_before  = '<span typeof="v:Breadcrumb">';
        $link_after   = '</span>';
        $link_attr    = ' rel="v:url" property="v:title"';
        $link         = $link_before . '<a' . $link_attr . ' href="%1$s">%2$s</a>' . $link_after;
        if(isset($post->post_parent)){$my_post_parent = $post->post_parent;}else{$my_post_parent=1;}
        $parent_id    = $parent_id_2 = $my_post_parent;
        $frontpage_id = get_option('page_on_front');

        if (is_home() || is_front_page()) {
            if ($show_on_home == 1) echo '<div class="breadcrumbs"><a href="' . $home_link . '">' . $text['home'] . '</a></div>';
            if(get_option( 'page_for_posts' )){
                echo '<div class="breadcrumbs">
                    <a href="' . esc_url($home_link) . '">' . esc_attr($text['home']) . '</a>'.$delimiter.' ' . esc_attr($text['blog']) . '
                  </div>';
            }
        }
        else {
            echo '<div class="breadcrumbs">';
            if ($show_home_link == 1) {
                echo sprintf($link, $home_link, $text['home']);
                if ($frontpage_id == 0 || $parent_id != $frontpage_id) echo $delimiter;
            }

            if ( is_category() ) {
                if(get_option( 'page_for_posts' )){
                    echo '<a href="' . esc_url($blog_link) . '">' . esc_attr($text['blog']) . '</a>'.$delimiter;
                }

                $this_cat = get_category(get_query_var('cat'), false);
                if ($this_cat->parent != 0) {
                    $cats = get_category_parents($this_cat->parent, TRUE, $delimiter);
                    if ($show_current == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
                    $cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
                    $cats = str_replace('</a>', '</a>' . $link_after, $cats);
                    if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
                    echo templines_wp_kses($cats);
                }
                if ($show_current == 1) echo '<span class="current">' . sprintf($text['category'], single_cat_title('', false)) . '</span>' ;

            } elseif ( is_search() ) {
                if(get_option( 'page_for_posts' )){
                    echo '<a href="' . esc_url($blog_link) . '">' . esc_attr($text['blog']) . '</a>'.$delimiter;
                }
                echo '<span class="current">' . sprintf($text['search'], get_search_query()) . '</span>';

            } elseif ( is_day() ) {
                if(get_option( 'page_for_posts' )){
                    echo '<a href="' . esc_url($blog_link) . '">' . esc_attr($text['blog']) . '</a>'.$delimiter;
                }
                echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
                echo sprintf($link, get_month_link(get_the_time('Y'),get_the_time('m')), get_the_time('F')) . $delimiter;
                echo '<span class="current">' . get_the_time('d') . '</span>';

            } elseif ( is_month() ) {
                if(get_option( 'page_for_posts' )){
                    echo '<a href="' . esc_url($blog_link) . '">' . esc_attr($text['blog']) . '</a>'.$delimiter;
                }
                echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
                echo '<span class="current">' . get_the_time('F') . '</span>';

            } elseif ( is_year() ) {
                if(get_option( 'page_for_posts' )){
                    echo '<a href="' . esc_url($blog_link) . '">' . esc_attr($text['blog']) . '</a>'.$delimiter;
                }
                echo '<span class="current">' . get_the_time('Y') . '</span>';

            } elseif ( is_single() && !is_attachment() ) {
                if ( get_post_type() != 'post' ) {
                    $post_type = get_post_type_object(get_post_type());
                    $slug = $post_type->rewrite;
                    printf($link, $home_link . '/' . $slug['slug'] . '/', $post_type->labels->singular_name);
                    if ($show_current == 1) echo $delimiter . '<span class="current">' . get_the_title() . '</span>';
                } else {
                    if(get_option( 'page_for_posts' )){
                        echo '<a href="' . esc_url($blog_link) . '">' . esc_attr($text['blog']) . '</a>'.$delimiter;
                    }
                    $cat = get_the_category(); $cat = $cat[0];
                    $cats = get_category_parents($cat, TRUE, $delimiter);
                    if ($show_current == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
                    $cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
                    $cats = str_replace('</a>', '</a>' . $link_after, $cats);
                    if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
                    echo templines_wp_kses($cats);
                    if ($show_current == 1) echo '<span class="current">' . get_the_title() . '</span>';
                }

            } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
                $post_type = get_post_type_object(get_post_type());
                echo '<span class="current">' . esc_attr($post_type->labels->singular_name) . '</span>';

            } elseif ( is_attachment() ) {
                $parent = get_post($parent_id);
                $cat = get_the_category($parent->ID); $cat = $cat[0];
                $cats = get_category_parents($cat, TRUE, $delimiter);
                $cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
                $cats = str_replace('</a>', '</a>' . $link_after, $cats);
                if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
                echo templines_wp_kses($cats);
                printf($link, get_permalink($parent), $parent->post_title);
                if ($show_current == 1) echo $delimiter . '<span class="current">' . get_the_title() . '</span>';

            } elseif ( is_page() && !$parent_id ) {
                if ($show_current == 1) echo '<span class="current">' . get_the_title() . '</span>';

            } elseif ( is_page() && $parent_id ) {
                if ($parent_id != $frontpage_id) {
                    $breadcrumbs = array();
                    while ($parent_id) {
                        $page = get_page($parent_id);
                        if ($parent_id != $frontpage_id) {
                            $breadcrumbs[] = sprintf($link, get_permalink($page->ID), get_the_title($page->ID));
                        }
                        $parent_id = $page->post_parent;
                    }
                    $breadcrumbs = array_reverse($breadcrumbs);
                    for ($i = 0; $i < count($breadcrumbs); $i++) {
                        echo templines_wp_kses($breadcrumbs[$i]);
                        if ($i != count($breadcrumbs)-1) echo $delimiter;
                    }
                }
                if ($show_current == 1) {
                    if ($show_home_link == 1 || ($parent_id_2 != 0 && $parent_id_2 != $frontpage_id)) echo $delimiter;
                    echo '<span class="current">' . get_the_title() . '</span>';
                }

            } elseif ( is_tag() ) {
                echo '<span class="current">' . sprintf($text['tag'], single_tag_title('', false)) . '</span>';

            } elseif ( is_author() ) {
                global $author;
                $userdata = get_userdata($author);
                echo '<span class="current">' . sprintf($text['author'], $userdata->display_name) . '</span>';

            } elseif ( is_404() ) {
                echo '<span class="current">' . esc_attr($text['404']) . '</span>';

            }




            if ( get_query_var('paged') ) {
                if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
                echo esc_html__('Page','templines-helper-core') . ' ' . get_query_var('paged');
                if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
            }




            echo '</div><!-- .breadcrumbs -->';

        }
    }
}



add_filter( 'script_loader_tag', 'templines_helper_core_remove_type', 10, 3 );
add_filter( 'style_loader_tag', 'templines_helper_core_remove_type', 10, 3 );  // Ignore the $media argument to allow for a common function.
function templines_helper_core_remove_type( $markup, $handle, $href ) {
    //error_log( 'Markup: ' . $markup );
    //error_log( 'Handle: ' . $handle );
    //error_log( 'Href: ' . $href );
    // Remove the 'type' attribute.
    $markup = str_replace( " type='text/javascript'", '', $markup );
    $markup = str_replace( " type='text/css'", '', $markup );
    return $markup;
}
// Store and process wp_head output to operate on inline scripts and styles.
add_action( 'wp_head', 'templines_helper_core_wp_head_ob_start', 0 );
function templines_helper_core_wp_head_ob_start() {
    ob_start();
}
add_action( 'wp_head', 'templines_helper_core_wp_head_ob_end', 10000 );
function templines_helper_core_wp_head_ob_end() {
    $wp_head_markup = ob_get_contents();
    ob_end_clean();

    // Remove the 'type' attribute. Note the use of single and double quotes.
    $wp_head_markup = str_replace( " type='text/javascript'", '', $wp_head_markup );
    $wp_head_markup = str_replace( ' type="text/javascript"', '', $wp_head_markup );
    $wp_head_markup = str_replace( ' type="text/css"', '', $wp_head_markup );
    $wp_head_markup = str_replace( " type='text/css'", '', $wp_head_markup );
    echo $wp_head_markup;
}


// Store and process wp_footer output to operate on inline scripts and styles.
add_action( 'wp_footer', 'templines_helper_core_wp_footer_ob_start', 0 );
function templines_helper_core_wp_footer_ob_start() {
    ob_start();
}

add_action( 'wp_footer', 'templines_helper_core_wp_footer_ob_end', 10000 );
function templines_helper_core_wp_footer_ob_end() {
    $wp_footer_markup = ob_get_contents();
    ob_end_clean();

    // Remove the 'type' attribute. Note the use of single and double quotes.
    $wp_footer_markup = str_replace( " type='text/javascript'", '', $wp_footer_markup );
    $wp_footer_markup = str_replace( ' type="text/javascript"', '', $wp_footer_markup );
    $wp_footer_markup = str_replace( ' type="text/css"', '', $wp_footer_markup );
    $wp_footer_markup = str_replace( " type='text/css'", '', $wp_footer_markup );
    echo $wp_footer_markup;
}




function fl_japanworm_shorten_title( $title ) {
    $newTitle = substr( $title, 0, 21 ); // Only take the first 20 characters

    return $newTitle . " &hellip;"; // Append the elipsis to the text (...)
}



function templines_temp_field_update_car($field, $validate, $update_field){

    $show = isset($field['show']) ? $field['show'] : $field['field'].'_show';
    $req = isset($field['show']) ? $field['show'] : $field['field'].'_req';
    $placeholder = isset($field['placeholder']) ? $field['placeholder'] : '';

    if( isset($validate[$show]) || isset($validate[$req]) ): ?>
        <div class="pixad-form-group">
            <label class="pixad-control-label">
                <?php echo esc_attr($field['name']) ?> <?php echo isset($validate[$req]) ? '<span class="required-field">*</span>' : ''; ?>
            </label>
            <div class="pixad-control-input">
                <?php if($field['type'] === 'select') : ?>
                    <?php if(!empty($field['temp']) && function_exists($field['temp'])){
                        $field['temp']($field, $validate, $update_field);
                    } ?>
                <?php endif; ?>
                <?php if($field['type'] === 'text') : ?>
                    <input name="<?php echo esc_attr($field['field']); ?>" type="text" <?php echo isset($validate[$req]) ? 'required' : ''; ?> placeholder="<?php echo esc_html( $placeholder); ?>" value="<?php echo esc_attr($update_field); ?>" class="pixad-form-control">
                    <span class="errengine"></span>
                <?php endif; ?>
            </div>
        </div>
    <?php endif;
}

// шаблон вывода select полей
function templines_temp_select_cond($field, $validate, $update){
    $show = isset($field['show']) ? $field['show'] : $field['field'].'_show';
    $req = isset($field['show']) ? $field['show'] : $field['field'].'_req';
    $placeholder = isset($field['placeholder']) ? $field['placeholder'] : '';

    ?>
    <select name="<?php echo esc_attr($field['field']); ?>" <?php echo isset($validate[$req]) ? 'required' : ''; ?> class="pixad-form-control">
        <option value=""><?php _e( '-- Please Select --', 'autozone' ); ?></option>
        <option value="new" <?php if($update=='new') echo 'selected'; ?>><?php _e( 'New', 'autozone' ); ?></option>
        <option value="used" <?php if($update=='used') echo 'selected'; ?>><?php _e( 'Used', 'autozone' ); ?></option>
        <option value="driver" <?php if($update=='driver') echo 'selected'; ?>><?php _e( 'Driver', 'autozone' ); ?></option>
        <option value="non driver" <?php if($update=='non driver') echo 'selected'; ?>><?php _e( 'Non driver', 'autozone' ); ?></option>
        <option value="projectcar" <?php if($update=='projectcar') echo 'selected'; ?>><?php _e( 'Projectcar', 'autozone' ); ?></option>
        <option value="barnfind" <?php if($update=='barnfind') echo 'selected'; ?>><?php _e( 'Barnfind', 'autozone' ); ?></option>
    </select>
    <?php
}



function templines_temp_select_purpose($field, $validate, $update){
    $show = isset($field['show']) ? $field['show'] : $field['field'].'_show';
    $req = isset($field['show']) ? $field['show'] : $field['field'].'_req';
    $placeholder = isset($field['placeholder']) ? $field['placeholder'] : '';
    ?>
    <select name="<?php echo esc_attr($field['field']); ?>" <?php echo isset($validate[$req]) ? 'required' : ''; ?> class="pixad-form-control">
        <option value=""><?php _e( '-- Please Select --', 'autozone' ); ?></option>
        <option value="sell" <?php if($update=='sell') echo 'selected'; ?>><?php _e( 'Sell', 'autozone' ); ?></option>
        <option value="rent" <?php if($update=='rent') echo 'selected'; ?>><?php _e( 'Rent', 'autozone' ); ?></option>
        <option value="sold" <?php if($update=='sold') echo 'selected'; ?>><?php _e( 'Sold', 'autozone' ); ?></option>
    </select>
    <?php
}

function templines_temp_select_warranty($field, $validate, $update){
    $show = isset($field['show']) ? $field['show'] : $field['field'].'_show';
    $req = isset($field['show']) ? $field['show'] : $field['field'].'_req';
    $placeholder = isset($field['placeholder']) ? $field['placeholder'] : '';
    ?>
    <select name="<?php echo esc_attr($field['field']); ?>" <?php echo isset($validate[$req]) ? 'required' : ''; ?> class="pixad-form-control">
        <option value="no" <?php selected( 'no', $update, true ); ?>><?php _e( 'No', 'autozone' ); ?></option>
        <option value="yes" <?php selected( 'yes', $update, true ); ?>><?php _e( 'Yes', 'autozone' ); ?></option>
    </select>
    <?php
}

function templines_temp_select_drive($field, $validate, $update){
    $show = isset($field['show']) ? $field['show'] : $field['field'].'_show';
    $req = isset($field['show']) ? $field['show'] : $field['field'].'_req';
    $placeholder = isset($field['placeholder']) ? $field['placeholder'] : '';
    ?>
    <select name="<?php echo esc_attr($field['field']); ?>" <?php echo isset($validate[$req]) ? 'required' : ''; ?> class="pixad-form-control">
        <option value=""><?php _e( '-- Please Select --', 'autozone' ); ?></option>
        <option value="front" <?php if($update=='front') echo 'selected'; ?>><?php _e( 'Front', 'autozone' ); ?></option>
        <option value="rear" <?php if($update=='rear') echo 'selected'; ?>><?php _e( 'Rear', 'autozone' ); ?></option>
        <option value="4x4" <?php if($update=='4x4') echo 'selected'; ?>><?php _e( '4x4', 'autozone' ); ?></option>
    </select>
    <?php
}

function templines_temp_select_doors($field, $validate, $update){
    $show = isset($field['show']) ? $field['show'] : $field['field'].'_show';
    $req = isset($field['show']) ? $field['show'] : $field['field'].'_req';
    $placeholder = isset($field['placeholder']) ? $field['placeholder'] : '';
    ?>
    <select name="<?php echo esc_attr($field['field']); ?>" <?php echo isset($validate[$req]) ? 'required' : ''; ?> class="pixad-form-control">
        <option value=""><?php _e( '-- Please Select --', 'autozone' ); ?></option>
        <?php pixad_get_options_range( 2, 5, $update ); ?>
    </select>
    <?php
}

function templines_user_registered() {
    $days = round((date('U') - get_the_time('U')) / (60*60*24));
    if ($days == 0) {
        return esc_attr__("Registered Today", 'tm-reviews');
    }
    elseif ($days == 1) {
        return esc_attr__("Member fron last " . $days . " day", 'tm-reviews');
    }
    else {
        return esc_attr__( "Member fron last " . $days . " days", 'tm-reviews');
    }
}



function templines_get_option($slug,$_default = false){

    if ($stgs = templines_getCustomizeSettings()){
        $slug_option_name = 'autozone_'.$slug;
        if (isset($stgs->$slug_option_name))
            return esc_attr($stgs->$slug_option_name);
    }

    $slug = 'autozone_' . $slug;

    //$pix_options = get_option('theme_mods_autozone');
    $pix_options = get_theme_mods();

    if (isset($pix_options[$slug])){
        return esc_attr($pix_options[$slug],'default');
    }else{
        if ($_default)
            return esc_attr($_default,'default');
        else
            return false;
    }

}
function templines_getCustomizeSettings(){
    if (isset($_POST['wp_customize']) && $_POST['wp_customize'] == 'on'){
        $settings = json_decode(stripslashes($_POST['customized']));
        return $settings;
    }else{
        return false;
    }

}



if ( ! function_exists( 'templines_image_meta' ) ) {
    function templines_image_meta( $image_id, $size = 'full' ) {
        $full = wp_get_attachment_image_src( $image_id, 'full' );
        if ( $image = $size == 'full' ? $full : wp_get_attachment_image_src( $image_id, $size ) ) {
            $srcset     = wp_get_attachment_image_srcset( $image_id, $size );
            $sizes      = wp_get_attachment_image_sizes( $image_id, $size );
            $alt        = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
            $attachment = get_post( $image_id );
            if ( ! $alt ) {
                if ( ! $attachment ) {
                    $alt = '';
                } else {
                    $alt = $attachment->post_excerpt;
                    if ( ! $alt ) {
                        $alt = $attachment->post_title;
                    }
                }
            }
            $alt   = trim( strip_tags( $alt ) );
            $title = $attachment ? $attachment->post_title : '';

            return [
                'width'       => $image[1],
                'height'      => $image[2],
                'src'         => str_replace( ' ', '%20', $image[0] ),
                'srcset'      => $srcset,
                'sizes'       => $sizes,
                'full'        => $full[0],
                'full_width'  => $full[1],
                'full_height' => $full[2],
                'alt'         => $alt,
                'title'       => $title,
            ];
        }

        return false;
    }
}

if ( ! function_exists( 'templines_img' ) ) {
    function templines_img( $image_meta, $class = '', $lazy = null ) {
        if ( $image_meta ) {
            if ( $class ) {
                $image_meta['class'] = $class;
            }
            if ( templines_mod( 'lazyload' ) && $lazy === null || $lazy === true ) {
                $image_meta['loading'] = 'lazy';
            }
            $s = "<img";
            foreach (
                [
                    'class',
                    'width',
                    'height',
                    'src',
                    'srcset',
                    'sizes',
                    'alt',
                    'loading'
                ] as $attr_name
            ) {
                if ( ! empty( $image_meta[ $attr_name ] ) ) {
                    if ( ( $attr_name == 'srcset' || $attr_name == 'sizes' ) && ( empty( $image_meta['srcset'] ) || empty( $image_meta['sizes'] ) ) ) {
                        continue;
                    }
                    $s .= ' ' . $attr_name . '="' . esc_attr( $image_meta[ $attr_name ] ) . '"';
                }
            }
            $s .= "/>";

            return $s;
        }
    }
}

