<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Welcome_Banner extends Widget_Base {

    public function get_name() {
        return 'templines-welcome-banner';
    }

    public function get_title() {
        return esc_html__( 'Welcome Banner', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-font templines-icon';
    }

    public function get_categories() { 
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_welcome_banner_style',
            [
                'label' => __( 'General Settings', 'templines-helper-core' ),
            ]
        );

        // Title
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Enter your title', 'templines-helper-core' ),
                'default' => 'AUTOZONE',
            ]
        );

        // Advanced Title
        $this->add_control(
            'adv_title',
            [
                'label' => esc_html__( 'Advanced Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Advanced Title', 'templines-helper-core' ),
                'default' => 'WELCOME TO',
            ]
        );

        // Use Decor
        $this->add_control(
            'use_decor',
            [
                'label' => __( 'Use Decor', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'              =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'on'
            ]
        );

        //Image 1
        $this->add_control(
            'image1',
            [
                'label' => __( 'Image 1', 'tm-helper-core' ),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // Image Text 1
        $this->add_control(
            'img_text1',
            [
                'label' => esc_html__( 'Image Text 1', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Image Text 1', 'templines-helper-core' ),
                'default' => 'all brands',
            ]
        );

        // Link 1
        $this->add_control(
            'link1',
            [
                'label' => __( 'Link 1', 'tm-helper-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'https://your-link.com', 'tm-helper-core' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        //Image 2
        $this->add_control(
            'image2',
            [
                'label' => __( 'Image 2', 'tm-helper-core' ),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // Image Text 2
        $this->add_control(
            'img_text2',
            [
                'label' => esc_html__( 'Image Text 2', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Image Text 2', 'templines-helper-core' ),
                'default' => 'FREE SUPPORT',
            ]
        );

        // Link 2
        $this->add_control(
            'link2',
            [
                'label' => __( 'Link 2', 'tm-helper-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'https://your-link.com', 'tm-helper-core' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        //Image 3
        $this->add_control(
            'image3',
            [
                'label' => __( 'Image 3', 'tm-helper-core' ),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // Image Text 3
        $this->add_control(
            'img_text3',
            [
                'label' => esc_html__( 'Image Text 3', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Image Text 3', 'templines-helper-core' ),
                'default' => 'DEALERSHIP',
            ]
        );

        // Link 3
        $this->add_control(
            'link3',
            [
                'label' => __( 'Link 3', 'tm-helper-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'https://your-link.com', 'tm-helper-core' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        //Image 4
        $this->add_control(
            'image4',
            [
                'label' => __( 'Image 4', 'tm-helper-core' ),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // Image Text 4
        $this->add_control(
            'img_text4',
            [
                'label' => esc_html__( 'Image Text 4', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Image Text 4', 'templines-helper-core' ),
                'default' => 'AFFORDABLE',
            ]
        );

        // Link 4
        $this->add_control(
            'link4',
            [
                'label' => __( 'Link 4', 'tm-helper-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'https://your-link.com', 'tm-helper-core' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );
        //Content
        $this->add_control(
            'content',
            [
                'label' => '',
                'type' => Controls_Manager::WYSIWYG,
                'default' => 'THE ONLINE AUTOS WORLD',
            ]
        );




        $this->add_control(
            'css_animation',
            [
                'label' => __( 'CSS Animation', 'templines-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'no'                  => esc_html__( 'No', 'autozone' ),
                    'bounce'            => esc_html__( 'bounce', 'autozone' ),
                    'flash'             => esc_html__( 'flash', 'autozone' ),
                    'pulse'             => esc_html__( 'pulse', 'autozone' ),
                    'rubberBand'        => esc_html__( 'rubberBand', 'autozone' ),
                    'shake'             => esc_html__( 'shake', 'autozone' ),
                    'swing'             => esc_html__( 'swing', 'autozone' ),
                    'tada'              => esc_html__( 'tada', 'autozone' ),
                    'wobble'            => esc_html__( 'wobble', 'autozone' ),
                    'jello'             => esc_html__( 'jello', 'autozone' ),
                    'bounceIn'          => esc_html__( 'bounceIn', 'autozone' ),
                    'bounceInDown'      => esc_html__( 'bounceInDown', 'autozone' ),
                    'bounceInLeft'      => esc_html__( 'bounceInLeft', 'autozone' ),
                    'bounceInRight'     => esc_html__( 'bounceInRight', 'autozone' ),
                    'bounceInUp'        => esc_html__( 'bounceInUp', 'autozone' ),
                    'bounceOut'         => esc_html__( 'bounceOut', 'autozone' ),
                    'bounceOutDown'     => esc_html__( 'bounceOutDown', 'autozone' ),
                    'bounceOutLeft'     => esc_html__( 'bounceOutLeft', 'autozone' ),
                    'bounceOutRight'    => esc_html__( 'bounceOutRight', 'autozone' ),
                    'bounceOutUp'       => esc_html__( 'bounceOutUp', 'autozone' ),
                    'fadeIn'            => esc_html__( 'fadeIn', 'autozone' ),
                    'fadeInDown'        => esc_html__( 'fadeInDown', 'autozone' ),
                    'fadeInDownBig'     => esc_html__( 'fadeInDownBig', 'autozone' ) ,
                    'fadeInLeft'        => esc_html__( 'fadeInLeft', 'autozone' ),
                    'fadeInLeftBig'     => esc_html__( 'fadeInLeftBig', 'autozone' ),
                    'fadeInRight'       => esc_html__( 'fadeInRight', 'autozone' ),
                    'fadeInRightBig'    => esc_html__( 'fadeInRightBig', 'autozone' ),
                    'fadeInUp'          => esc_html__( 'fadeInUp', 'autozone' ),
                    'fadeInUpBig'       => esc_html__( 'fadeInUpBig', 'autozone' ),
                    'fadeOut'           => esc_html__( 'fadeOut', 'autozone' ),
                    'fadeOutDown'       => esc_html__( 'fadeOutDown', 'autozone' ),
                    'fadeOutDownBig'    => esc_html__( 'fadeOutDownBig', 'autozone' ) ,
                    'fadeOutLeft'       => esc_html__( 'fadeOutLeft', 'autozone' ),
                    'fadeOutLeftBig'    => esc_html__( 'fadeOutLeftBig', 'autozone' ),
                    'fadeOutRight'      => esc_html__( 'fadeOutRight', 'autozone' ),
                    'fadeOutRightBig'   => esc_html__( 'fadeOutRightBig', 'autozone' ),
                    'fadeOutUp'         => esc_html__( 'fadeOutUp', 'autozone' ),
                    'fadeOutUpBig'      => esc_html__( 'fadeOutUpBig', 'autozone' ),
                    'flip'              => esc_html__( 'flip', 'autozone' ),
                    'flipInX'           => esc_html__( 'flipInX', 'autozone' ),
                    'flipInY'           => esc_html__( 'flipInY', 'autozone' ),
                    'flipOutX'          => esc_html__( 'flipOutX', 'autozone' ),
                    'flipOutY'          => esc_html__( 'flipOutY', 'autozone' ),
                    'lightSpeedIn'      => esc_html__( 'lightSpeedIn', 'autozone' ),
                    'lightSpeedOut'     => esc_html__( 'lightSpeedOut', 'autozone' ),
                    'rotateIn'          => esc_html__( 'rotateIn', 'autozone' ),
                    'rotateInDownLeft'  => esc_html__( 'rotateInDownLeft', 'autozone' ),
                    'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'autozone' ),
                    'rotateInUpLeft'    => esc_html__( 'rotateInUpLeft', 'autozone' ),
                    'rotateInUpRight'   => esc_html__( 'rotateInUpRight', 'autozone' ),
                    'rotateOut'         => esc_html__( 'rotateOut', 'autozone' ),
                    'rotateOutDownLeft' => esc_html__( 'rotateOutDownLeft', 'autozone' ),
                    'rotateOutDownRight'=> esc_html__( 'rotateOutDownRight', 'autozone' ),
                    'rotateOutUpLeft'   => esc_html__( 'rotateOutUpLeft', 'autozone' ),
                    'rotateOutUpRight'  => esc_html__( 'rotateOutUpRight', 'autozone' ),
                    'slideInUp'         => esc_html__( 'slideInUp', 'autozone' ),
                    'slideInDown'       => esc_html__( 'slideInDown', 'autozone' ),
                    'slideInLeft'       => esc_html__( 'slideInLeft', 'autozone' ),
                    'slideInRight'      => esc_html__( 'slideInRight', 'autozone' ),
                    'slideOutUp'        => esc_html__( 'slideOutUp', 'autozone' ),
                    'slideOutDown'      => esc_html__( 'slideOutDown', 'autozone' ),
                    'slideOutLeft'      => esc_html__( 'slideOutLeft', 'autozone' ),
                    'slideOutRight'     => esc_html__( 'slideOutRight', 'autozone' ),
                    'zoomIn'            => esc_html__( 'zoomIn', 'autozone' ),
                    'zoomInDown'        => esc_html__( 'zoomInDown', 'autozone' ),
                    'zoomInLeft'        => esc_html__( 'zoomInLeft', 'autozone' ),
                    'zoomInRight'       => esc_html__( 'zoomInRight', 'autozone' ),
                    'zoomInUp'          => esc_html__( 'zoomInUp', 'autozone' ),
                    'zoomOut'           => esc_html__( 'zoomOut', 'autozone' ),
                    'zoomOutDown'       => esc_html__( 'zoomOutDown', 'autozone' ),
                    'zoomOutLeft'       => esc_html__( 'zoomOutLeft', 'autozone' ),
                    'zoomOutRight'      => esc_html__( 'zoomOutRight', 'autozone' ),
                    'zoomOutUp'         => esc_html__( 'zoomOutUp', 'autozone' ),
                    'hinge'             => esc_html__( 'hinge', 'autozone' ),
                    'rollIn'            => esc_html__( 'rollIn', 'autozone' ),
                    'rollOut'           => esc_html__( 'rollOut', 'autozone' ),

                ],
                'default' => 'no',
            ]
        );





        $this->end_controls_section();
    }

    protected function render() {
        $this->add_render_attribute( 'wrapper', 'class', 'page-builder-custom-welcome-banner-wrap' );
        $settings = $this->get_settings_for_display();


        $href1 = $settings['link1'];
        $href2 = $settings['link2'];
        $href3 = $settings['link3'];
        $href4 = $settings['link4'];


        if ($href1['url']) {
            $href1_class = '';
        }else{
            $href1_class = 'link-img__link_disabled';
        }
        if ($href2['url']) {
            $href2_class = '';
        }else{
            $href2_class = 'link-img__link_disabled';
        }
        if ($href3['url']) {
            $href3_class = '';
        }else{
            $href3_class = 'link-img__link_disabled';
        }
        if ($href4['url']) {
            $href4_class = '';
        }else{
            $href4_class = 'link-img__link_disabled';
        }

        $img_id = preg_replace( '/[^\d]/', '', $settings['image1']['id'] );
        $img_link = wp_get_attachment_image_src( $img_id, 'medium' );
        $img_link1 = $img_link[0];
        $image_meta = autozone_wp_get_attachment($img_id);
        $image_alt1 = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];

        $img_id = preg_replace( '/[^\d]/', '', $settings['image2']['id'] );
        $img_link = wp_get_attachment_image_src( $img_id, 'medium' );
        $img_link2 = $img_link[0];
        $image_meta = autozone_wp_get_attachment($img_id);
        $image_alt2 = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];

        $img_id = preg_replace( '/[^\d]/', '', $settings['image3']['id'] );
        $img_link = wp_get_attachment_image_src( $img_id, 'medium' );
        $img_link3 = $img_link[0];
        $image_meta = autozone_wp_get_attachment($img_id);
        $image_alt3 = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];

        $img_id = preg_replace( '/[^\d]/', '', $settings['image4']['id'] );
        $img_link = wp_get_attachment_image_src( $img_id, 'medium' );
        $img_link4 = $img_link[0];
        $image_meta = autozone_wp_get_attachment($img_id);
        $image_alt4 = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];

        $out = $settings['css_animation'] != '' ? '<div class="animated" data-animation="' . esc_attr($settings['css_animation']) . '">' : '<div>';

        $adv_title = !empty($adv_title) ? '<div class="main-block__label">'.wp_kses_post($adv_title).'</div><div class="decor-1 center-block"></div>' : '';
        $decor = isset($settings['use_decor']) && $settings['use_decor'] == 'on' ? '<div class="decor-2"><i class="icon fa fa-caret-down"></i></div>' : '';

        $img_text1 = !empty($settings['img_text1']) ? '<div class="link-img__wrap-title"><span class="link-img__title">'.wp_kses_post($settings['img_text1']).'</span></div>' : '';
        $img_text2 = !empty($settings['img_text2']) ? '<div class="link-img__wrap-title"><span class="link-img__title">'.wp_kses_post($settings['img_text2']).'</span></div>' : '';
        $img_text3 = !empty($settings['img_text3']) ? '<div class="link-img__wrap-title"><span class="link-img__title">'.wp_kses_post($settings['img_text3']).'</span></div>' : '';
        $img_text4 = !empty($settings['img_text4']) ? '<div class="link-img__wrap-title"><span class="link-img__title">'.wp_kses_post($settings['img_text4']).'</span></div>' : '';


        $out .= '
	<div class="col-xs-12">
		<div class="main-block text-center">
			'.$settings['adv_title'].'
			<h1 class="main-block__title"><strong>'.wp_kses_post($settings['title']).'</strong>'.esc_html(do_shortcode($settings['content'])).'</h1>
			'.$decor.'
		</div>
		<div class="wrap-link-img">
			<ul class="link-img link-img_mod-a list-inline">
				<li class="link-img__item">
					<a class="link-img__link '.$href1_class.'" href="'.esc_url($href1['url']).'">
						<img class="img-responsive" src="'.esc_url($img_link1).'" height="250" width="170" alt="'.esc_attr($image_alt1).'">
						'.$img_text1.'
					</a>
				</li>
				<li class="link-img__item">
					<a class="link-img__link '.$href2_class.'" href="'.esc_url($href2['url']).'">
						<img class="img-responsive" src="'.esc_url($img_link2).'" height="250" width="170" alt="'.esc_attr($image_alt2).'">
						'.$img_text2.'
					</a>
				</li>
			</ul>
			<ul class="link-img link-img_mod-b list-inline">
				<li class="link-img__item">
					<a class="link-img__link '.$href3_class.'" href="'.esc_url($href3['url']).'">
						<img class="img-responsive" src="'.esc_url($img_link3).'" height="250" width="170" alt="'.esc_attr($image_alt3).'">
						'.$img_text3.'
					</a>
				</li>
				<li class="link-img__item">
					<a class="link-img__link '.$href4_class.'" href="'.esc_url($href4['url']).'">
						<img class="img-responsive" src="'.esc_url($img_link4).'" height="250" width="170" alt="'.esc_attr($image_alt4).'">
						'.$img_text4.'
					</a>
				</li>
			</ul>
		</div>
	</div>';

        $out .= '</div>';
        echo $out;


    }
}
