<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Vehicle_Search extends Widget_Base {

    public function get_name() {
        return 'templines-vehicle-search';
    }

    public function get_title() {
        return esc_html__( 'Vehicle Search', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-font templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_title_general_style',
            [
                'label' => __( 'General Settings', 'templines-helper-core' ),
            ]
        );

        // Style
        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'hsearch_style_1'             =>          esc_attr__('Simple','tm-helper-core'),
                    'hsearch_style_2'              =>          esc_attr__('Boxed','tm-helper-core'),
                ],
                'default' => 'hsearch_style_1'
            ]
        );

        // Show Booking Time
        $this->add_control(
            'booking_time',
            [
                'label' => __( 'Show Booking Time', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Booking PICK-UP DATE Title
        $this->add_control(
            'booking_pick_up_title',
            [
                'label' => esc_html__( 'Booking PICK-UP DATE Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Booking PICK-UP DATE Title', 'templines-helper-core' ),
                'default' => 'PICK-UP DATE',
            ]
        );

        // Booking DROP-OFF DATE Title
        $this->add_control(
            'booking_drop_off_title',
            [
                'label' => esc_html__( 'Booking DROP-OFF DATE Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Booking DROP-OFF DATE Title', 'templines-helper-core' ),
                'default' => 'DROP-OFF DATE',
            ]
        );

        // Show Price Range
        $this->add_control(
            'price_range',
            [
                'label' => __( 'Show Price Range', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Price Block Title
        $this->add_control(
            'price_range_title',
            [
                'label' => esc_html__( 'Price Block Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Price Block Title', 'templines-helper-core' ),
                'default' => 'Price Range',
            ]
        );

        // Show Vehicle Body Type
        $this->add_control(
            'vehicle_body',
            [
                'label' => __( 'Show Vehicle Body Type', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Vehicle Body Type Title
        $this->add_control(
            'vehicle_body_title',
            [
                'label' => esc_html__( 'Vehicle Body Type Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Vehicle Body Type Title', 'templines-helper-core' ),
                'default' => 'Vehicle Body Type',
            ]
        );

        // Show Makers of Vehicle
        $this->add_control(
            'vehicle_makers',
            [
                'label' => __( 'Show Makers of Vehicle', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Makers of Vehicle Title
        $this->add_control(
            'vehicle_makers_title',
            [
                'label' => esc_html__( 'Makers of Vehicle Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Makers of Vehicle Title', 'templines-helper-core' ),
                'default' => 'Makers of Vehicle',
            ]
        );

        // Show Model of the Vehicle
        $this->add_control(
            'vehicle_model',
            [
                'label' => __( 'Show Model of the Vehicle', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Model of the Vehicle Title
        $this->add_control(
            'vehicle_model_title',
            [
                'label' => esc_html__( 'Model of the Vehicle Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Model of the Vehicle Title', 'templines-helper-core' ),
                'default' => 'Model of the Vehicle',
            ]
        );

        // Show Fuel Type
        $this->add_control(
            'fuel_type',
            [
                'label' => __( 'Show Fuel Type', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Fuel Type Title
        $this->add_control(
            'fuel_type_title',
            [
                'label' => esc_html__( 'Fuel Type Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Fuel Type Title', 'templines-helper-core' ),
                'default' => 'Fuel Type',
            ]
        );

        // Show Vehice Dealers
        $this->add_control(
            'vehicle_authors',
            [
                'label' => __( 'Show Vehice Dealers', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Vehice Dealers Title
        $this->add_control(
            'vehicle_authors_title',
            [
                'label' => esc_html__( 'Vehice Dealers Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Vehice Dealers Title', 'templines-helper-core' ),
                'default' => 'Vehice Dealers',
            ]
        );

        // Show Mileage Range
        $this->add_control(
            'mileage_range',
            [
                'label' => __( 'Show Mileage Range', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Mileage Block Title
        $this->add_control(
            'mileage_range_title',
            [
                'label' => esc_html__( 'Mileage Block Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Mileage Block Title', 'templines-helper-core' ),
                'default' => 'Mileage Range',
            ]
        );

        // Show Year Range
        $this->add_control(
            'year_range',
            [
                'label' => __( 'Show Year Range', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Year Range Title
        $this->add_control(
            'year_range_title',
            [
                'label' => esc_html__( 'Year Range Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Year Range Title', 'templines-helper-core' ),
                'default' => 'Year Range',
            ]
        );

        // Show Transmission Type
        $this->add_control(
            'transmission_type',
            [
                'label' => __( 'Show Transmission Type', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Transmission Type Title
        $this->add_control(
            'transmission_type_title',
            [
                'label' => esc_html__( 'Transmission Type Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Transmission Type Title', 'templines-helper-core' ),
                'default' => 'Transmission Range',
            ]
        );

        // Show Engine Volume
        $this->add_control(
            'engine_volume',
            [
                'label' => __( 'Show Engine Volume', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Engine Volume Title
        $this->add_control(
            'engine_volume_title',
            [
                'label' => esc_html__( 'Engine Volume Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Engine Volume Title', 'templines-helper-core' ),
                'default' => 'Engine Volume',
            ]
        );

        // Show Condition
        $this->add_control(
            'condition',
            [
                'label' => __( 'Show Condition', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Condition Title
        $this->add_control(
            'condition_title',
            [
                'label' => esc_html__( 'Condition Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Condition Title', 'templines-helper-core' ),
                'default' => 'Condition',
            ]
        );

        // Show Purpose
        $this->add_control(
            'purpose',
            [
                'label' => __( 'Show Purpose', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Purpose Title
        $this->add_control(
            'purpose_title',
            [
                'label' => esc_html__( 'Purpose Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Purpose Title', 'templines-helper-core' ),
                'default' => 'Purpose',
            ]
        );

        // Show Engine displacement
        $this->add_control(
            'custom_1',
            [
                'label' => __( 'Show Engine displacement', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Show Horsepower
        $this->add_control(
            'custom_2',
            [
                'label' => __( 'Show Horsepower', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        // Show Torque
        $this->add_control(
            'custom_3',
            [
                'label' => __( 'Show Torque', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'on'             =>          esc_attr__('On','tm-helper-core'),
                    'off'            =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'off'
            ]
        );

        $this->add_control(
        'pick_up_location',
        [
          'label' => __( 'Show Pick-Up Location', 'tm-helper-core' ),
          'type' => Controls_Manager::SELECT,
          'options' => [
            'on'             =>          esc_attr__('On','tm-helper-core'),
            'off'            =>          esc_attr__('Off','tm-helper-core'),
          ],
          'default' => 'off'
        ]
      );

        $this->add_control(
            'pick_up_location_title',
            [
                'label' => esc_html__( 'Pick-up Location Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Pick-up Location Title', 'templines-helper-core' ),
                'default' => 'Pick-Up Location',
            ]
        );

        $this->add_control(
        'drop_off_location',
        [
          'label' => __( 'Show Drop-off Location', 'tm-helper-core' ),
          'type' => Controls_Manager::SELECT,
          'options' => [
            'on'             =>          esc_attr__('On','tm-helper-core'),
            'off'            =>          esc_attr__('Off','tm-helper-core'),
          ],
          'default' => 'off'
        ]
      );

        $this->add_control(
            'drop_off_location_title',
            [
                'label' => esc_html__( 'Drop-off Location Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Drop-off Location Title', 'templines-helper-core' ),
                'default' => 'Drop-off Location',
            ]
        );


        $this->add_control(
        'seller_country',
        [
          'label' => __( 'Seller country', 'tm-helper-core' ),
          'type' => Controls_Manager::SELECT,
          'options' => [
            'on'             =>          esc_attr__('On','tm-helper-core'),
            'off'            =>          esc_attr__('Off','tm-helper-core'),
          ],
          'default' => 'off'
        ]
      );

        $this->add_control(
            'seller_country_title',
            [
                'label' => esc_html__( 'Seller country Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Seller country Title', 'templines-helper-core' ),
                'default' => 'Seller country',
            ]
        );


        $this->end_controls_section();
    }

    protected function render() {
        $this->add_render_attribute( 'wrapper', 'class', 'page-builder-custom-vehicle-search-wrap' );
        $settingss = $this->get_settings_for_display();

        $args_tax = array(
            'taxonomy'      => array( 'auto-model' ),
            'orderby'       => 'name',
            'order'         => 'ASC',
            'parent'        => '0',
            'hide_empty'    => '0',

        );
        $autos_categories = get_categories ($args_tax);

        $all_pick_up_location_class = !isset($_REQUEST['pick_up_location']) ? 'jelect-option_state_active' : '';
        $all_drop_off_location_class = !isset($_REQUEST['drop_off_location']) ? 'jelect-option_state_active' : '';
        $all_countries_class = !isset($_REQUEST['seller_country']) ? 'jelect-option_state_active' : '';
        $all_make_class = !isset($_REQUEST['make']) ? 'jelect-option_state_active' : '';
        $all_model_class = !isset($_REQUEST['model']) ? 'jelect-option_state_active' : '';
        $out_make  = __( 'All Makes', 'autozone');
        $out_author  = __( 'All Dealers', 'autozone');
        $out_model = __( 'All Models', 'autozone');
        $out_makes = $out_models = '';
        $get_make = isset($_REQUEST['make']) ? explode(',', $_REQUEST['make']) : array();
        $get_model = isset($_REQUEST['model']) ? explode(',', $_REQUEST['model']) : array();

        $Settings	= new PIXAD_Settings();
        $settings	= $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_settings', true );

        $currencies = unserialize( get_option( '_pixad_autos_currencies' ) ); // Get currencies from database
        $currency = $currencies[$settings['autos_site_currency']];
        $currency_symbol = $currency['symbol'];

        if (isset($settings['autos_listing_car_page'])){
            $url_page_listings = get_page_uri( $settings['autos_listing_car_page']);
        }
        if (isset($url_page_listings) && $url_page_listings !== 'rental') {
            $result_url =  $url_page_listings;
        }else{
            $result_url = esc_url(site_url('/vehicle-listings/'));
        }

        // location
	    $hide_location = get_option('pixba_hide_location');
	    $hide_location = !empty($hide_location) ? $hide_location : false; // is_location

        $locations = get_option('pixba_locations_with_coordinates');
        if(is_array($locations)){
            $locations = array_map(function($v){return $v['name'];}, $locations);
        }


        $pixadCountry = new PIXAD_Country();
        $countries = $pixadCountry->get_used_countries();


        ?>
<form action="<?php echo $result_url ?>" method="get" id="findCarNowForm">
    <div class="vc-auto-search <?php echo $settingss['style']; ?>">


        <div class="search-title2">
            <div class="div_skew"></div><?php _e( 'FIND YOUR PERFECT BIKE', 'autozone') ?>
        </div>


        <?php if ( $settingss['seller_country'] == 'on' ): ?>
        <div class="select select_mod-a jelect">
            <input data-type="jelect" data-field="seller_country" id="seller_country" name="seller_country" value="" data-text="imagemin" type="text" class="jelect-input">
            <div tabindex="0" role="button" class="jelect-current"><?php _e( 'All Countries', 'autozone') ?></div>
            <ul class="jelect-options">
                <li data-val="" class="jelect-option <?php echo esc_attr($all_countries_class) ?>"><?php _e( 'All Countries', 'autozone') ?></li>
                <?php foreach ($countries as $country) : ?>
                <li data-val="<?php echo esc_attr($country['code']) ?>" class="jelect-option"><?php echo esc_attr($country['title']) ?></li>
                <?php endforeach; ?>
            </ul>
            <div class="home-search-label"><?php  echo $settingss['seller_country_title'] ?></div>
        </div>
        <?php endif ?>


        <?php if ( $settingss['pick_up_location'] == 'on' ): ?>
        <div class="select select_mod-a jelect">
            <input data-type="jelect" data-field="pick_up_location" id="pick_up_location" name="pick_up_location" value="" data-text="imagemin" type="text" class="jelect-input">
            <div tabindex="0" role="button" class="jelect-current"><?php _e( 'All Locations', 'autozone') ?></div>
            <ul class="jelect-options">
                <li data-val="" class="jelect-option <?php echo esc_attr($all_pick_up_location_class) ?>"><?php _e( 'All Locations', 'autozone') ?></li>
                <?php foreach ($locations as $location) : ?>
                <li data-val="<?php echo esc_attr($location) ?>" class="jelect-option"><?php echo esc_attr($location) ?></li>
                <?php endforeach; ?>
            </ul>
            <div class="home-search-label"><?php  echo $settingss['pick_up_location_title'] ?></div>
        </div>
        <?php endif ?>

        <?php if ( $settingss['drop_off_location'] == 'on' ): ?>
        <div class="select select_mod-a jelect">
            <input data-type="jelect" data-field="drop_off_location" id="drop_off_location" name="drop_off_location" value="" data-text="imagemin" type="text" class="jelect-input">
            <div tabindex="0" role="button" class="jelect-current"><?php _e( 'All Locations', 'autozone') ?></div>
            <ul class="jelect-options">
                <li data-val="" class="jelect-option <?php echo esc_attr($all_drop_off_location_class) ?>"><?php _e( 'All Locations', 'autozone') ?></li>
                <?php foreach ($locations as $location) : ?>
                <li data-val="<?php echo esc_attr($location) ?>" class="jelect-option"><?php echo esc_attr($location) ?></li>
                <?php endforeach; ?>
            </ul>
            <div class="home-search-label"><?php  echo $settingss['drop_off_location_title'] ?></div>
        </div>
        <?php endif ?>

        <?php if ( $settingss['booking_time'] == 'on' ): ?>
        <?php
                            $hide_timepicker = get_option('pixba_hide_timepicker');
                            if($hide_timepicker != 1){
                                $format_opt = get_option('pixba_format_date', true);
                                if(isset($format_opt) && $format_opt != ''){
                                    $format = $format_opt . ' H:i';
                                } else {
                                    $format = 'm/d/Y H:i';
                                }
                            } else {
                                $format_opt = get_option('pixba_format_date', true);
                                if(isset($format_opt) && $format_opt != ''){
                                    $format = $format_opt;
                                } else {
                                    $format = 'm/d/Y';
                                }
                            }
                            ?>
        <div class="select select_mod-a jelect">
            <input type="hidden" id="pixad_format_date_search" value="<?php echo esc_attr($format);?>">
            <input data-type="jelect" data-field="time-start" id="pixad-time-start" name="start_time" value="<?php esc_html_e( 'Select date', 'autozone' )?>" readonly data-text="imagemin" type="text" class="pix-input-time" value="<?php echo current_time(get_option('date_format')) ?>">
            <div class="home-search-label"><?php echo $settingss['booking_pick_up_title']; ?></div>
        </div>
        <input id="pixad_date_format" type="hidden" value="<?php echo esc_attr(get_option('date_format'))?>">
        <div class="select select_mod-a jelect">
            <input data-type="jelect" data-field="time-finish" id="pixad-time-finish" name="finish_time" value="<?php esc_html_e( 'Select date', 'autozone' )?>" readonly data-text="imagemin" type="text" class="pix-input-time" value="<?php echo current_time(get_option('date_format')) ?>">
            <div class="home-search-label"><?php echo $settingss['booking_drop_off_title']; ?></div>
        </div>
        <?php endif ?>

        <?php if ($settingss['vehicle_body'] == 'on'): ?>
        <section class="home-pixad-filter">


            <div class="home-search-heading"><?php echo $settingss['vehicle_body_title'] ?></div>

            <?php
                        $args_tax = array( 'taxonomy' => 'auto-body', 'hide_empty' => '1');
                        $autos_bodies = get_categories ($args_tax);
                        if( $autos_bodies ):
                            $get_body = isset($_REQUEST['body']) ? explode(',',$_REQUEST['body']) : array();
                            echo '<div class="home-search-content">
                                    <ul class="list-categories body-categories list-unstyled">';
                            foreach($autos_bodies as $auto_body) :  ?>
            <li class="list-categories__item">
                <input data-type="check" data-field="body" type="checkbox" <?php echo in_array($auto_body->slug, $get_body) ? 'checked' : ''; ?> name="body" id="<?php echo esc_attr($auto_body->slug) ?>" value="<?php echo esc_attr($auto_body->slug) ?>">
                <label for="<?php echo esc_attr($auto_body->slug) ?>">
                    <?php
                                            $auto_t_id = $auto_body->term_id;
                                            $auto_cat_meta = get_option("auto_body_$auto_t_id");
                                            $auto_cat_thumb_url = get_option("pixad_body_thumb$auto_t_id");
                                            $auto_cat_thumb_filter_url = get_option("pixad_body_thumb_filter$auto_t_id");

                                            if($auto_cat_thumb_filter_url){
                                                $img_src = wp_get_attachment_image_src( attachment_url_to_postid( $auto_cat_thumb_filter_url ), 'autozone-body-thumb' );
                                                $figure = '<img src="'.esc_url($img_src[0]).'" alt="'.esc_attr($auto_body->name).'">';

                                            }elseif($auto_cat_thumb_url){
                                                $img_src = wp_get_attachment_image_src( attachment_url_to_postid( $auto_cat_thumb_url ), 'autozone-body-thumb' );
                                                $figure = '<img src="'.esc_url($img_src[0]).'" alt="'.esc_attr($auto_body->name).'">';
                                            } elseif(isset($auto_cat_meta['pixad_body_icon'])){
                                                $figure = '<i class="icon '. esc_attr($auto_cat_meta['pixad_body_icon']) .'"></i>';
                                            }?>
                    <div class="body-icon-wrapper">
                        <?php echo wp_kses_post($figure) ?>
                    </div>
                    <span class="auto_body_name"><?php echo wp_kses_post($auto_body->name) ?></span>
                </label>
            </li>
            <?php
                            endforeach;
                            echo '</ul>
                            </div>';
                        endif;
                        ?>

        </section>
        <?php endif?>

        <?php if ($settingss['vehicle_makers'] == 'on'): ?>
        <div class="select select_mod-a jelect pixad-makes-models-select">
            <input data-type="jelect" data-field="make" id="ajax-make" name="make" value="" data-text="imagemin" type="text" class="jelect-input">
            <div tabindex="0" role="button" class="jelect-current"><?php echo wp_kses_post($out_make) ?></div>
            <ul class="jelect-options">
                <li data-val="" class="jelect-option <?php echo esc_attr($all_make_class) ?>"><?php _e( 'All Makes', 'autozone') ?></li>
                <?php foreach ($autos_categories as $auto_cat) :
                                if( in_array($auto_cat->slug, $get_make) ){
                                    $class_make = 'jelect-option_state_active';
                                    $out_make = $auto_cat->name;
                                } else {
                                    $class_make = '';
                                }
                                echo '<li data-val="'.esc_attr($auto_cat->slug).'" class="jelect-option '.esc_attr($class_make).'">'.wp_kses_post($auto_cat->name).'</li>';
                            endforeach;
                         ?>
            </ul>
            <div class="home-search-label"><?php echo $settingss['vehicle_makers_title'] ?></div>
        </div>
        <?php endif?>

        <?php if ($settingss['vehicle_authors'] == 'on'): ?>
        <?php
                $autos_authors = get_users();
                //var_dump($autos_authors);
            ?>
        <div class="select select_mod-a jelect pixad-dealers-select">
            <input data-type="jelect" data-field="dealer" id="ajax-dealer" name="dealer" value="" data-text="imagemin" type="text" class="jelect-input">
            <div tabindex="0" role="button" class="jelect-current"><?php echo wp_kses_post($out_author) ?></div>
            <ul class="jelect-options">
                <li data-val="" class="jelect-option <?php echo esc_attr($all_make_class) ?>"><?php _e( 'All Dealers', 'autozone') ?></li>
                <?php foreach ($autos_authors as $auto_aut) :
                        //if( in_array($auto_aut->slug, $get_make) ){
                        //    $class_make = 'jelect-option_state_active';
                        //    $out_make = $auto_cat->name;
                      //  } else {
                      //      $class_make = '';
                     //   }
                       echo '<li data-val="'.esc_attr($auto_aut->ID).'" class="jelect-option '.esc_attr($class_make).'">'.wp_kses_post($auto_aut->user_nicename).'</li>';
                    endforeach;
                    ?>
            </ul>
            <div class="home-search-label"><?php echo $settingss['vehicle_authors_title'] ?></div>
        </div>
        <?php endif?>

        <?php if ($settingss['vehicle_model'] == 'on' && $settingss['vehicle_makers'] == 'on'): ?>
        <?php
                if(!empty($get_make)){
                    $make_term = get_term_by('slug', $get_make[0], 'auto-model');
                    $args = array(
                        'taxonomy'      => 'auto-model',
                        'orderby'       => 'name',
                        'order'         => 'ASC',
                        'parent'        => $make_term->term_id,
                        'hide_empty'    => false,
                    );
                    $terms_arr = get_terms( $args );

                }
                ?>

        <div class="select select_mod-a jelect">
            <input data-type="jelect" data-field="model" id="pixad-model" name="model" value="" data-text="imagemin" type="text" class="jelect-input">
            <input type="hidden" class="pixad-model-default-hidden" value="<?php esc_attr_e( 'All Models', 'autozone') ?>">
            <div tabindex="0" role="button" class="jelect-current pixad-model"><?php echo wp_kses_post($out_model) ?></div>
            <ul class="jelect-options pixad-model">
                <li data-val="" class="jelect-option <?php echo esc_attr($all_model_class) ?>"><?php _e( 'All Models', 'autozone') ?></li>

                <?php
                            if (!empty($get_make) ) {

                        foreach ($terms_arr as $k => $v) {
                            if( in_array($v->slug, $get_model) ){
                                $class_model = 'jelect-option_state_active';
                                $out_model = $v->name;
                            } else {
                                $class_model = '';
                            }
                            echo '<li data-val="'.esc_attr($v->slug).'" class="jelect-option '.esc_attr($class_model).'">'.wp_kses_post($v->name).'</li>';
                        }
                        }

                        ?>
            </ul>
            <div class="home-search-label"><?php echo $settingss['vehicle_model_title'] ?></div>
        </div>
        <?php endif?>

        <?php if ($settingss['condition'] == 'on'): ?>
        <div class="select select_mod-a jelect">
            <input data-type="jelect" data-field="type" id="pixad-type" name="condition" value="" data-text="imagemin" type="text" class="jelect-input">
            <input type="hidden" class="pixad-type-default-hidden" value="<?php esc_attr_e( 'Vehicle Status', 'autozone') ?>">
            <div tabindex="0" role="button" class="jelect-current pixad-type"><?php esc_attr_e( 'Vehicle Status', 'autozone') ?></div>
            <ul class="jelect-options pixad-type">
                <li data-val="" class="jelect-option <?php echo esc_attr($all_model_class) ?>"><?php _e( 'Vehicle Status', 'autozone') ?></li>
                <li data-val="new" class="jelect-option"><?php _e( 'New', 'autozone') ?></li>
                <li data-val="used" class="jelect-option"><?php _e( 'Used', 'autozone') ?></li>

            </ul>

            <div class="home-search-label"><?php echo $settingss['condition_title']; ?></div>

        </div>
        <?php endif ?>


        <?php if ($settingss['purpose'] == 'on'): ?>
        <div class="select select_mod-a jelect">
            <input data-type="jelect" data-field="purpose" id="pixad-purpose" name="purpose" value="" data-text="imagemin" type="text" class="jelect-input">
            <div tabindex="0" role="button" class="jelect-current"><?php esc_html_e( 'All purposes', 'autozone') ?></div>
            <ul class="jelect-options">
                <li data-val="" class="jelect-option jelect-option_state_active"><?php esc_html_e( 'All purposes', 'autozone') ?></li>
                <li data-val="rent" class="jelect-option"><?php esc_html_e( 'Rent', 'autozone') ?></li>
                <li data-val="sell" class="jelect-option"><?php esc_html_e( 'Sell', 'autozone') ?></li>
                <li data-val="sold" class="jelect-option"><?php esc_html_e( 'Sold', 'autozone') ?></li>

            </ul>
            <div class="home-search-label"><?php echo $settingss['purpose_title']; ?></div>
        </div>
        <?php endif ?>






        <?php if ($settingss['price_range'] == 'on'): ?>

        <div class="slider-price">
            <div class="noUi-target noUi-ltr noUi-horizontal noUi-background" id="slider-price">

            </div>
            <span class="slider-price__wrap-input">


                <div class="tmpl-slide-price-left">

                    <span class="currency-symbol">
                        <?php echo esc_attr($currency_symbol)?>
                    </span>
                    <input data-type="number" data-field="price" class="slider-price__input" id="slider-price_min">
                </div>


                <div class="tmpl-slide-price-right">
                    <span class="currency-symbol">
                        <?php echo esc_attr($currency_symbol)?></span>

                    <input data-type="number" data-field="price" class="slider-price__input" id="slider-price_max">
                </div>

                <input name="price" type="hidden" id="slider-price_total" />
                <input type="hidden" id="pix-min-price" value="">
                <input type="hidden" id="pix-max-price" value="">
                <input type="hidden" id="pix-max-slider-price" value="<?php echo esc_attr($settings['autos_max_price']) ?>">
                <input type="hidden" id="pix-min-slider-year" value="<?php echo esc_attr($settings['autos_min_year']) ?>">
                <input type="hidden" id="pix-currency-symbol" value="$">
                <input type="hidden" id="pix-thousand" value="<?php echo esc_attr($settings['autos_thousand']) ?>">
                <input type="hidden" id="pix-decimal" value="<?php echo esc_attr($settings['autos_decimal']) ?>">
                <input type="hidden" id="pix-decimal_number" value="<?php echo esc_attr($settings['autos_decimal_number']) ?>">
            </span>

            <div class="home-search-label"><?php echo $settingss['price_range_title']; ?></div>
        </div>

        <?php endif ?>
        <?php if ($settingss['fuel_type'] == 'on'): ?>
        <div class="select select_mod-a jelect">
            <input data-type="jelect" data-field="fuel" id="pixad-fuel" name="fuel" value="" data-text="imagemin" type="text" class="jelect-input">
            <div tabindex="0" role="button" class="jelect-current"><?php esc_html_e( 'All Fuel Types', 'autozone') ?></div>
            <ul class="jelect-options">
                <li data-val="" class="jelect-option jelect-option_state_active"><?php esc_html_e( 'All Fuel Types', 'autozone') ?></li>
                <li data-val="petrol" class="jelect-option"><?php esc_html_e( 'Petrol', 'autozone') ?></li>
                <li data-val="diesel" class="jelect-option"><?php esc_html_e( 'Diesel', 'autozone') ?></li>
                <li data-val="hybrid" class="jelect-option"><?php esc_html_e( 'Hybrid', 'autozone') ?></li>
                <li data-val="plugin_electric" class="jelect-option"><?php esc_html_e( 'Plugin electric', 'autozone') ?></li>
                <li data-val="electric" class="jelect-option"><?php esc_html_e( 'Electric', 'autozone') ?></li>
                <li data-val="petrol+cng" class="jelect-option"><?php esc_html_e( 'Petrol+CNG', 'autozone') ?></li>
                <li data-val="lpg" class="jelect-option"><?php esc_html_e( 'LPG', 'autozone') ?></li>
            </ul>

            <div class="home-search-label"><?php echo $settingss['fuel_type_title']; ?></div>
        </div>
        <?php endif ?>
        <?php if ($settingss['transmission_type'] == 'on'): ?>
        <div class="select select_mod-a jelect">
            <input data-type="jelect" data-field="transmission" id="pixad-transmission" name="transmission" value="" data-text="imagemin" type="text" class="jelect-input">
            <div tabindex="0" role="button" class="jelect-current"><?php esc_html_e( 'All Transmissions', 'autozone') ?></div>
            <ul class="jelect-options">
                <li data-val="" class="jelect-option jelect-option_state_active"><?php esc_html_e( 'All Transmissions', 'autozone') ?></li>
                <li data-val="automatic" class="jelect-option"><?php esc_html_e( 'Automatic', 'autozone') ?></li>
                <li data-val="manual" class="jelect-option"><?php esc_html_e( 'Manual', 'autozone') ?></li>
                <li data-val="semi-automatic" class="jelect-option"><?php esc_html_e( 'Semi-Automatic', 'autozone') ?></li>
            </ul>

            <div class="home-search-label"><?php echo $settingss['transmission_type_title']; ?></div>
        </div>
        <?php endif ?>
        <?php if ($settingss['mileage_range'] == 'on'): ?>
        <div class="select select_mod-a jelect">
            <div class="slider-price" id="slider-mileage"></div>
            <span class="slider-price__wrap-input">
                <input data-type="number" data-field="mileage" class="slider-price__input" id="slider-mileage_min">
                <span>-</span>
                <input data-type="number" data-field="mileage" class="slider-price__input" id="slider-mileage_max">
                <input type="hidden" id="pix-min-mileage" value="<?php echo isset($get_mileage[0]) ? esc_attr($get_mileage[0]) : ''; ?>">
                <input type="hidden" id="pix-max-mileage" value="<?php echo isset($get_mileage[1]) ? esc_attr($get_mileage[1]) : ''; ?>">
                <input type="hidden" id="pix-max-slider-mileage" value="500000">
                <input name="mileage" type="hidden" id="pix-max-slider-mileage_total" />
            </span>

            <div class="home-search-label"><?php echo $settingss['mileage_range_title']; ?></div>
        </div>
        <?php endif ?>
        <?php if ($settingss['year_range'] == 'on'): ?>
        <div class="select select_mod-a jelect">
            <div class="slider-price" id="slider-year"></div>
            <span class="slider-price__wrap-input">
                <input data-type="number" data-field="autoyear" class="slider-price__input" id="slider-year_min">
                <span>-</span>
                <input data-type="number" data-field="autoyear" class="slider-price__input" id="slider-year_max">
                <input type="hidden" id="pix-min-year" value="<?php echo isset($get_year[0]) ? esc_attr($get_year[0]) : ''; ?>">
                <input type="hidden" id="pix-max-year" value="<?php echo isset($get_year[1]) ? esc_attr($get_year[1]) : ''; ?>">
                <input type="hidden" id="pix-max-slider-year" value="<?php echo esc_attr(date('Y')+1) ?>">
                <input name="autoyear" type="hidden" id="pix-max-slider-year_total" />
            </span>
            <div class="home-search-label"><?php echo $settingss['year_range_title']; ?></div>
        </div>
        <?php endif ?>
        <?php if ($settingss['engine_volume'] == 'on'): ?>
        <div class="select select_mod-a jelect">
            <div class="slider-price" id="slider-engine"></div>
            <span class="slider-price__wrap-input">
                <input data-type="number" data-field="engine" class="slider-price__input" id="slider-engine_min">
                <span>-</span>
                <input data-type="number" data-field="engine" class="slider-price__input" id="slider-engine_max">
                <input type="hidden" id="pix-min-engine" value="<?php echo isset($get_engine[0]) ? esc_attr($get_engine[0]) : ''; ?>">
                <input type="hidden" id="pix-max-engine" value="<?php echo isset($get_engine[1]) ? esc_attr($get_engine[1]) : ''; ?>">
                <input type="hidden" id="pix-max-slider-engine" value="7">
                <input name="engine" type="hidden" id="pix-max-slider-engine_total" />
            </span>
            <div class="home-search-label"><?php echo $settingss['engine_volume_title']; ?></div>
        </div>
        <?php endif ?>




        <?php
        global $post;
        $Settings = new PIXAD_Settings();
        $settings	= $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_settings', true );
        $validate = $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_validation', true );
        $validate = pixad::validation( $validate );

        $args = array( 'post_type' => 'pixad-autos', 'posts_per_page' => -1,);
        $rand_posts = get_posts( $args );

        $custom_settings_quantity = 1;
        while ($custom_settings_quantity <= 80) {
            ${'_custom_'.$custom_settings_quantity.'_setting_value'} = array();
                $custom_settings_quantity++;
        }
        foreach( $rand_posts as $post ) : ?>
        <?php
            $custom_settings_quantity = 1;
            while ($custom_settings_quantity <= 80) {

                    $_custom_setting_key = get_post_custom_values('_custom_'.$custom_settings_quantity.''); // Получили  характеристику
                    if ($_custom_setting_key[0] !== '') {    // Проверили или есть значение у характеристики
                        $_custom_setting_key[0] = str_replace(' ', '_', $_custom_setting_key[0]);
                        array_push(${'_custom_'.$custom_settings_quantity.'_setting_value'}, $_custom_setting_key[0]); // Добавили значение в нужный массив
                    }
                    $custom_settings_quantity++;
            } ?>

        <?php endforeach; ?>
        <?php  wp_reset_postdata() ?>

        <?php
        $custom_settings_quantity = 1;
        while ($custom_settings_quantity <= 80) {
            ${'_custom_'.$custom_settings_quantity.'_setting_value'} = array_unique(array_filter(${'_custom_'.$custom_settings_quantity.'_setting_value'}));
        ?>

        <?php // print_r($_custom_1_setting_value) ?>


        <?php if(!empty(${'_custom_'.$custom_settings_quantity.'_setting_value'})  && isset(${'custom_'.$custom_settings_quantity}) ) {?>


        <div class="select select_mod-a jelect">
            <input data-type="jelect" data-field="<?php echo 'custom_'. $custom_settings_quantity .''; ?>" id="<?php echo 'pixad-custom_'. $custom_settings_quantity .''; ?>" name="<?php echo 'custom_'. $custom_settings_quantity .''; ?>" value="" data-text="imagemin" type="text" class="jelect-input">
            <div tabindex="0" role="button" class="jelect-current"><?php echo $validate['custom_'. $custom_settings_quantity .'_name']; ?></div>
            <ul class="jelect-options">
                <li data-val="" class="jelect-option jelect-option_state_active"><?php esc_html_e( 'All', 'autozone') ?></li>
                <?php
                                        foreach (${'_custom_'.$custom_settings_quantity.'_setting_value'} as $key => $value) {?>
                <li data-val="<?php echo $value; ?>" class="jelect-option"><?php echo str_replace('_', ' ', $value); ?></li>
                <?php } ?>
            </ul>
            <div class="home-search-label"><?php echo  $validate['custom_'. $custom_settings_quantity .'_name']; ?></div>
        </div>

        <?php }?>

        <?php	$custom_settings_quantity++;
        }?>


        <div class="btn">
            <div class="btn-filter wrap__btn-skew-r js-filter">
                <button type="button" onclick="findCarNowVc(); return false;" class="btn-skew-r btn-effect"><span class="btn-skew-r__inner"><?php echo esc_html_e('Find It Now','autozone')?></span></button>

            </div>
        </div>

    </div>
</form>

<script type="text/javascript">
    function findCarNowVc() {

        /*PRICE*/

        var _price_from = jQuery('#slider-price_min').val();
        if (_price_from) {
            _price_from = _price_from.replace(/\D/g, "");
        }


        var _price_to = jQuery('#slider-price_max').val();
        if (_price_to) {
            _price_to = _price_to.replace(/\D/g, "");
        }
        jQuery('#slider-price_total').val(_price_from + "," + _price_to);

        /*BODY*/
        var checked_body = '';
        jQuery("input[name='body']").each(function(key, val) {
            if (jQuery(this).prop("checked")) {
                checked_body = checked_body + ',' + jQuery(this).val();
            }
        });
        jQuery("input[name='body']").val(checked_body);

        /*MILEAGE*/
        var mileage_from = jQuery('#slider-mileage_min').val();
        var mileage_to = jQuery('#slider-mileage_max').val();
        jQuery('#pix-max-slider-mileage_total').val(mileage_from + "," + mileage_to);

        /*YEAR*/
        var year_from = jQuery('#slider-year_min').val();
        var year_to = jQuery('#slider-year_max').val();
        jQuery('#pix-max-slider-year_total').val(year_from + "," + year_to);

        /*ENGINE*/
        var engine_from = jQuery('#slider-engine_min').val();
        var engine_to = jQuery('#slider-engine_max').val();
        jQuery('#pix-max-slider-engine_total').val(engine_from + "," + engine_to);



        jQuery('#findCarNowForm').submit();

    }

</script>



<?php
    }
}
