<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Title extends Widget_Base {

    public function get_name() {
        return 'templines-title';
    }

    public function get_title() {
        return esc_html__( 'Title', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-font templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_title_general_style',
            [
                'label' => __( 'General Styles', 'templines-helper-core' ),
            ]
        );

        // Title
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Title', 'templines-helper-core' ),
                'default' => 'OUR SERVICES',
            ]
        );

        $this->add_responsive_control(
            'titlepos',
            [
                'label' => __( 'Title Alignment', 'templines-helper-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'text-left' => [
                        'title' => __( 'Left', 'templines-helper-core' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'text-center' => [
                        'title' => __( 'Center', 'templines-helper-core' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'text-right' => [
                        'title' => __( 'Right', 'templines-helper-core' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'text-center',

            ]
        );

        $this->add_control(
            'content',
            [
                'label' => '',
                'type' => Controls_Manager::WYSIWYG,
                'default' => 'WE ARE OFFERING VEHICLE SERVICES 24/7',
            ]
        );
        $this->add_control(
            'css_animation',
            [
                'label' => __( 'CSS Animation', 'templines-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'no'                  => esc_html__( 'No', 'autozone' ),
                    'bounce'            => esc_html__( 'bounce', 'autozone' ),
                    'flash'             => esc_html__( 'flash', 'autozone' ),
                    'pulse'             => esc_html__( 'pulse', 'autozone' ),
                    'rubberBand'        => esc_html__( 'rubberBand', 'autozone' ),
                    'shake'             => esc_html__( 'shake', 'autozone' ),
                    'swing'             => esc_html__( 'swing', 'autozone' ),
                    'tada'              => esc_html__( 'tada', 'autozone' ),
                    'wobble'            => esc_html__( 'wobble', 'autozone' ),
                    'jello'             => esc_html__( 'jello', 'autozone' ),
                    'bounceIn'          => esc_html__( 'bounceIn', 'autozone' ),
                    'bounceInDown'      => esc_html__( 'bounceInDown', 'autozone' ),
                    'bounceInLeft'      => esc_html__( 'bounceInLeft', 'autozone' ),
                    'bounceInRight'     => esc_html__( 'bounceInRight', 'autozone' ),
                    'bounceInUp'        => esc_html__( 'bounceInUp', 'autozone' ),
                    'bounceOut'         => esc_html__( 'bounceOut', 'autozone' ),
                    'bounceOutDown'     => esc_html__( 'bounceOutDown', 'autozone' ),
                    'bounceOutLeft'     => esc_html__( 'bounceOutLeft', 'autozone' ),
                    'bounceOutRight'    => esc_html__( 'bounceOutRight', 'autozone' ),
                    'bounceOutUp'       => esc_html__( 'bounceOutUp', 'autozone' ),
                    'fadeIn'            => esc_html__( 'fadeIn', 'autozone' ),
                    'fadeInDown'        => esc_html__( 'fadeInDown', 'autozone' ),
                    'fadeInDownBig'     => esc_html__( 'fadeInDownBig', 'autozone' ) ,
                    'fadeInLeft'        => esc_html__( 'fadeInLeft', 'autozone' ),
                    'fadeInLeftBig'     => esc_html__( 'fadeInLeftBig', 'autozone' ),
                    'fadeInRight'       => esc_html__( 'fadeInRight', 'autozone' ),
                    'fadeInRightBig'    => esc_html__( 'fadeInRightBig', 'autozone' ),
                    'fadeInUp'          => esc_html__( 'fadeInUp', 'autozone' ),
                    'fadeInUpBig'       => esc_html__( 'fadeInUpBig', 'autozone' ),
                    'fadeOut'           => esc_html__( 'fadeOut', 'autozone' ),
                    'fadeOutDown'       => esc_html__( 'fadeOutDown', 'autozone' ),
                    'fadeOutDownBig'    => esc_html__( 'fadeOutDownBig', 'autozone' ) ,
                    'fadeOutLeft'       => esc_html__( 'fadeOutLeft', 'autozone' ),
                    'fadeOutLeftBig'    => esc_html__( 'fadeOutLeftBig', 'autozone' ),
                    'fadeOutRight'      => esc_html__( 'fadeOutRight', 'autozone' ),
                    'fadeOutRightBig'   => esc_html__( 'fadeOutRightBig', 'autozone' ),
                    'fadeOutUp'         => esc_html__( 'fadeOutUp', 'autozone' ),
                    'fadeOutUpBig'      => esc_html__( 'fadeOutUpBig', 'autozone' ),
                    'flip'              => esc_html__( 'flip', 'autozone' ),
                    'flipInX'           => esc_html__( 'flipInX', 'autozone' ),
                    'flipInY'           => esc_html__( 'flipInY', 'autozone' ),
                    'flipOutX'          => esc_html__( 'flipOutX', 'autozone' ),
                    'flipOutY'          => esc_html__( 'flipOutY', 'autozone' ),
                    'lightSpeedIn'      => esc_html__( 'lightSpeedIn', 'autozone' ),
                    'lightSpeedOut'     => esc_html__( 'lightSpeedOut', 'autozone' ),
                    'rotateIn'          => esc_html__( 'rotateIn', 'autozone' ),
                    'rotateInDownLeft'  => esc_html__( 'rotateInDownLeft', 'autozone' ),
                    'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'autozone' ),
                    'rotateInUpLeft'    => esc_html__( 'rotateInUpLeft', 'autozone' ),
                    'rotateInUpRight'   => esc_html__( 'rotateInUpRight', 'autozone' ),
                    'rotateOut'         => esc_html__( 'rotateOut', 'autozone' ),
                    'rotateOutDownLeft' => esc_html__( 'rotateOutDownLeft', 'autozone' ),
                    'rotateOutDownRight'=> esc_html__( 'rotateOutDownRight', 'autozone' ),
                    'rotateOutUpLeft'   => esc_html__( 'rotateOutUpLeft', 'autozone' ),
                    'rotateOutUpRight'  => esc_html__( 'rotateOutUpRight', 'autozone' ),
                    'slideInUp'         => esc_html__( 'slideInUp', 'autozone' ),
                    'slideInDown'       => esc_html__( 'slideInDown', 'autozone' ),
                    'slideInLeft'       => esc_html__( 'slideInLeft', 'autozone' ),
                    'slideInRight'      => esc_html__( 'slideInRight', 'autozone' ),
                    'slideOutUp'        => esc_html__( 'slideOutUp', 'autozone' ),
                    'slideOutDown'      => esc_html__( 'slideOutDown', 'autozone' ),
                    'slideOutLeft'      => esc_html__( 'slideOutLeft', 'autozone' ),
                    'slideOutRight'     => esc_html__( 'slideOutRight', 'autozone' ),
                    'zoomIn'            => esc_html__( 'zoomIn', 'autozone' ),
                    'zoomInDown'        => esc_html__( 'zoomInDown', 'autozone' ),
                    'zoomInLeft'        => esc_html__( 'zoomInLeft', 'autozone' ),
                    'zoomInRight'       => esc_html__( 'zoomInRight', 'autozone' ),
                    'zoomInUp'          => esc_html__( 'zoomInUp', 'autozone' ),
                    'zoomOut'           => esc_html__( 'zoomOut', 'autozone' ),
                    'zoomOutDown'       => esc_html__( 'zoomOutDown', 'autozone' ),
                    'zoomOutLeft'       => esc_html__( 'zoomOutLeft', 'autozone' ),
                    'zoomOutRight'      => esc_html__( 'zoomOutRight', 'autozone' ),
                    'zoomOutUp'         => esc_html__( 'zoomOutUp', 'autozone' ),
                    'hinge'             => esc_html__( 'hinge', 'autozone' ),
                    'rollIn'            => esc_html__( 'rollIn', 'autozone' ),
                    'rollOut'           => esc_html__( 'rollOut', 'autozone' ),

                ],
                'default' => 'no',
            ]
        );


        $this->end_controls_section();
    }

    protected function render() {
        $this->add_render_attribute( 'wrapper', 'class', 'page-builder-custom-title-wrap' );
        $settings = $this->get_settings_for_display();


        $titlepos = $settings['titlepos'] == '' ? 'text-center' : $settings['titlepos'];
        $fullcontent = ( $settings['content'] == '') ? '' : '<div class="ui-subtitle-block_mod-a '.esc_attr($titlepos).'"><p>'.do_shortcode($settings['content']).'</div>';

        $out = $settings['css_animation'] != '' ? '<div class="animated" data-animation="' . esc_attr($settings['css_animation']) . '">' : '';
        $out .= '

	<div class="section-title-box" >
		<h2 class="ui-title-block ui-title-block_mod-a '.esc_attr($titlepos).'">'.wp_kses_post($settings['title']).'</h2>
        '.$fullcontent.'
	</div>
  		';
        $out .= $settings['css_animation'] != '' ? '</div>' : '';
        echo $out;

    }
}