<?php
use Elementor\Control_Media;
use Elementor\Core\Base\Document;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Testimonials extends Widget_Base {

    public function get_name() {
        return 'templines-testimonials';
    }

    public function get_title() {
        return esc_html__( 'Testimonials Slider', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-user templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_team_general_setting',
            [
                'label' => __( 'General Setting', 'templines-helper-core' ),
            ]
        );


        //Single Testimonial
        $repeater = new Repeater();
        $repeater->add_control(
            'picture_enable',
            [
                'label'   => __( 'Enable Picture Avatar', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'off',
                'options' => [
                    1              =>         esc_attr__('On','templines-helper-core'),
                    0              =>         esc_attr__('Off','templines-helper-core'),
                ],
            ]
        );
        $repeater->add_control(
            'img',
            [
                'label'             => __( 'Thumbnail Avatar', 'templines-helper-core' ),
                'type'              => Controls_Manager::MEDIA,
                'label_block'       => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'style',
            [
                'label'   => __( 'Style', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'off',
                'options' => [
                    'style1'              =>         esc_attr__('Normal','templines-helper-core'),
                    'style2'              =>         esc_attr__('Bubble','templines-helper-core'),
                    'style3'              =>         esc_attr__('Modern','templines-helper-core'),
                ],
            ]
        );
        $repeater->add_control(
            'tm_normal_layout',
            [
                'label'   => __( 'Normal Layout Style', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'off',
                'options' => [
                    'style1'              =>         esc_attr__('Style 1','templines-helper-core'),
                    'style2'              =>         esc_attr__('Style 2','templines-helper-core'),
                    'style3'              =>         esc_attr__('Style 3','templines-helper-core'),
                    'style4'              =>         esc_attr__('Style 4','templines-helper-core'),
                    'style5'              =>         esc_attr__('Style 5','templines-helper-core'),
                ],
            ]
        );
        $repeater->add_control(
            'name',
            [
                'label' => __( 'Name', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'John Stephan',
            ]
        );
        $repeater->add_control(
            'content',
            [
                'label' => '',
                'type' => Controls_Manager::WYSIWYG,
                'default' => 'AutoImage is nisi aliquip consequat duis velit esse cillum dolore fugiat nulla pariatur excepteur sint occaecat lorem ipsum dolor sit amt consectetur adipisicing elit sed eiusmod tempor incididuntu labore et dolore magna aliqua enimad minim veniam quis nostrud exercitation sed ipsum ullamco laboris nisi aliquip.',
            ]
        );

        //Typography
        $repeater->start_controls_section(
            'section_typography',
            [
                'label' => __( 'Typography', 'templines-helper-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $repeater->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'label' => __( 'Name Typography', 'tm-helper-core' ),
                'selector' => '{{WRAPPER}} .km-testimonial-name-info .km-testimonial-name',
            ]
        );
        $repeater->add_control(
            'name_color',
            [
                'label' => __( 'Name Color', 'tm-helper-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#222',
                'selectors' => [
                    '{{WRAPPER}} .km-testimonial-name-info .km-testimonial-name' => 'color: {{VALUE}};',
                ],
            ]
        );
        $repeater->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __( 'Title Typography', 'tm-helper-core' ),
                'selector' => '{{WRAPPER}} .km-testimonial-name-info .km-testimonial-info',
            ]
        );
        $repeater->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'tm-helper-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#222',
                'selectors' => [
                    '{{WRAPPER}} .km-testimonial-name-info .km-testimonial-info' => 'color: {{VALUE}};',
                ],
            ]
        );
        $repeater->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Content Typography', 'tm-helper-core' ),
                'selector' => '{{WRAPPER}} .km-testimonial-content .testimonial-content-span',
            ]
        );
        $repeater->add_control(
            'content_color',
            [
                'label' => __( 'Content Color', 'tm-helper-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#222',
                'selectors' => [
                    '{{WRAPPER}} .km-testimonial-content .testimonial-content-span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $repeater->end_controls_section();

        //Colors
        $repeater->start_controls_section(
            'section_colors',
            [
                'label' => __( 'Colors', 'templines-helper-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $repeater->add_control(
            'icon_color',
            [
                'label' => __( 'Icon Color', 'tm-helper-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#dc2d13',
                'selectors' => [
                    '{{WRAPPER}} .km-testimonial-icon i' => 'color: {{VALUE}};',
                ],
            ]
        );
        $repeater->add_control(
            'icon_style',
            [
                'label'   => __( 'Icon Style', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'off',
                'options' => [
                    'km-icon-quote-'              =>         esc_attr__('Normal','templines-helper-core'),
                    'km-icon-quotes-'              =>         esc_attr__('Rounded','templines-helper-core'),
                ],
            ]
        );
        $repeater->add_control(
            'icon_orientation',
            [
                'label'   => __( 'Icon Orientation', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'off',
                'options' => [
                    'right'              =>         esc_attr__('Right','templines-helper-core'),
                    'left'              =>         esc_attr__('Left','templines-helper-core'),
                ],
            ]
        );
        $repeater->end_controls_section();


        $this->add_control(
            'testimonials_list',
            [
                'label'       => '',
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $this->add_render_attribute( 'wrapper', 'class', 'templines-testimonials-wrap' );
        $settingss = $this->get_settings_for_display();
        $outPut = '';
        $default_container_styles = 'style="margin-top:0px;margin-bottom:0px; --dots-size:14px; --dots-area-margintop:35px; --dots-margins:3px; --dots-clr:#999999; --dots-active-clr:#dc2d13; --arrow-size:15px; --arrow-bgsize:35px; --arrow-clr:#fff; --arrow-back-clr:#222; --arrow-radius:0px; --slides-margin:10px;"';
        $default_icon_styles = 'style="color:#dc2d13;font-size: 35px;padding-top: 6px;padding-bottom: 40px;"';
        $default_content_styles = 'style="color: #222222;font-size: 18px;line-height: 1.8;font-family: Inherit;font-weight: inherit;font-style: italic;"';
        $default_info_styles = 'style="color: #222222;font-size: 14px;font-family: Inherit;font-weight: 700;letter-spacing: 2px;text-transform:uppercase;padding-top: 6px;padding-bottom: 6px;"';

        $styleWithInfoBottom = array('style1','style2','style3');
        $outPut .= '<div class="kswr-slickslider-container" '.$default_container_styles.' data-speed="300" data-infinite="true" data-autoplay="true" data-autoplayspeed="5000" data-adaptiveheight="true" data-centermode="false" data-centerpadding="50px" data-centerpaddingtablet="25px" data-centerpaddingmobile="15px" data-slidestoshow-desk="1" data-slidestoshow-tablet="1" data-slidestoshow-mobile="1" data-dots="true" data-arrows="false" data-tabletbreakpoint="995" data-phonebreakpoint="550" data-dots-align="center" data-dots-style="style6" data-arrows-style="style1" data-arrows-position="middle" data-vertical="false" data-slidestoscroll-desk="1" data-slidestoscroll-tablet="1" data-slidestoscroll-mobile="1" role="toolbar">';
            foreach ($settingss['testimonials_list'] as $item){

            $child_data = ($item['style'] == 'style1') ? 'data-childstyle="'.$item['tm_normal_layout'].'"' : '';

            //Checking for the childstyle
            $isChild1 = $isChild2 = $isChild3 = $isChild4 = $isChild5 =  false;

            if($item['style'] == "style1"){
                $isChild1 = ($item['tm_normal_layout'] == "style1") ? true : false;
                $isChild2 = ($item['tm_normal_layout'] == "style2") ? true : false;
                $isChild3 = ($item['tm_normal_layout'] == "style3") ? true : false;
                $isChild4 = ($item['tm_normal_layout'] == "style4") ? true : false;
                $isChild5 = ($item['tm_normal_layout'] == "style5") ? true : false;
            }


            //Moved Things !!
            $picture = '';
            if($item['picture_enable'] == '1')
                $picture = '<div class="km-testimonial-pic"><img src="'.esc_url($item['img']['url']).'" alt="km-testimonial-pic"></div>';

            $info = '<div class="km-testimonial-name-info" '.$default_info_styles.'><span class="km-testimonial-name kswr-shortcode-element">'.$item['name'].'</span></div>';
            $style1_icon = '<div class="km-testimonial-icon" '.$default_icon_styles.'><i class="'.$item['icon_style'].''.$item['icon_orientation'].'"></i></div>';

            //Begin OutPut
            $outPut .= '<div class="km-testimonial" data-style="'.esc_attr($item['style']).'" data-pic-position="left" '.$child_data.'>
					<div class="km-testimonial-content kswr-shortcode-element" '.$default_content_styles.'>';

            if($isChild1 || $isChild5)	$outPut .= $style1_icon;
            if($isChild2)	$outPut .= $picture.' '.$info;
            if($isChild3)	$outPut .= $style1_icon.' '.$info;
            if($isChild4)	$outPut .= $picture;


            $outPut .= ($item['style'] == 'style3') ? '
	    <div class="km-testimonial-content-icon" data-position="left"><i class="'.esc_attr($item['icon_style']).'left"></i></div>
				<div class="km-testimonial-content-icon" data-position="right"><i class="'.esc_attr($item['icon_style']).'right"></i></div>'
                : '';

            $outPut .= '<span class="testimonial-content-span">'.do_shortcode($item['content']) .'</span></div>';

            if( ($isChild1 || $isChild5) || $item['style'] == "style2" || $item['style'] == "style3"){
                $outPut .= $picture.' '.$info;
            }

            if($isChild2)	$outPut .= $style1_icon;
            if($isChild3)	$outPut .= $picture;
            if($isChild4)	$outPut .= $style1_icon.' '.$info;



            $outPut .=	'</div>';


        }
        $outPut .= '</div>';

        echo $outPut;

        ?>


        <?php

    }
}