<?php
use Elementor\Control_Media;
use Elementor\Core\Base\Document;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use ElementorPro\Modules\QueryControl\Module as QueryControlModule;
use ElementorPro\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Team extends Widget_Base {

    public function get_name() {
        return 'templines-team';
    }

    public function get_title() {
        return esc_html__( 'Team', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-user templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_team_general_setting',
            [
                'label' => __( 'General Setting', 'templines-helper-core' ),
            ]
        );

        // Style
        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-one'             =>          esc_attr__('Style One','tm-helper-core'),
                    'style-two'              =>          esc_attr__('Style Two','tm-helper-core'),
                ],
                'default' => 'style-one'
            ]
        );


        $repeater = new Repeater();
        $repeater->add_control(
            'image',
            [
                'label'             => __( 'Team Image', 'templines-helper-core' ),
                'type'              => Controls_Manager::MEDIA,
                'label_block'       => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'name',
            [
                'label' => __( 'Team Name', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'William Benson',
            ]
        );
        $repeater->add_control(
            'position',
            [
                'label' => 'Position',
                'type' => Controls_Manager::TEXT,
                'default' => 'OWNER & CEO',
            ]
        );
        $repeater->add_control(
            'skill',
            [
                'label' => __( 'Skill Level', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => '80',
            ]
        );
        $repeater->add_control(
            'scn1',
            [
                'label' => __( 'Social Link 1', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'https://www.facebook.com/',
            ]
        );
        $repeater->add_control(
            'scn_icon1',
            [
                'label' => __( 'Social Network Icon 1', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'fa-facebook',
            ]
        );
        $repeater->add_control(
            'scn2',
            [
                'label' => __( 'Social Link 2', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'https://twitter.com/',
            ]
        );
        $repeater->add_control(
            'scn_icon2',
            [
                'label' => __( 'Social Network Icon 2', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'fa-twitter',
            ]
        );
        $repeater->add_control(
            'scn3',
            [
                'label' => __( 'Social Link 3', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'https://www.pinterest.com/',
            ]
        );
        $repeater->add_control(
            'scn_icon3',
            [
                'label' => __( 'Social Network Icon 3', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'fa-pinterest',
            ]
        );
        $repeater->add_control(
            'scn4',
            [
                'label' => __( 'Social Link 4', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'https://dribbble.com',
            ]
        );
        $repeater->add_control(
            'scn_icon4',
            [
                'label' => __( 'Social Network Icon 4', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'fa fa-dribbble',
            ]
        );



        $repeater->add_control(
            'fb',
            [
                'label' => __( 'Facebook Link', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => '#',
            ]
        );
        $repeater->add_control(
            'tw',
            [
                'label' => __( 'Twitter Link', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => '#',
            ]
        );
        $repeater->add_control(
            'lk',
            [
                'label' => __( 'LinkedIn Link', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => '#',
            ]
        );
        $repeater->add_control(
            'inst',
            [
                'label' => __( 'Instagram Link', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => '#',
            ]
        );





        //Info
        $repeater->add_control(
            'content',
            [
                'label' => '',
                'type' => Controls_Manager::WYSIWYG,
                'default' => 'Wliquam sit amet urna sed vel nullam semper aibers vestibulum fringilla',
            ]
        );



        $this->add_control(
            'team_list',
            [
                'label'       => '',
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );


        $this->end_controls_section();
    }

    protected function render() {
        $this->add_render_attribute( 'wrapper', 'class', 'templines-team-wrap' );
        $settings = $this->get_settings_for_display();



        ?>
<?php if($settings['style'] == 'style-one'){?>
<ul class="list-staff list-unstyled">
    <?php foreach($settings['team_list'] as $item){
                $img_id = $item['image']["id"];
                $img_link = wp_get_attachment_image_src( $img_id, 'large' );
                $img_link = $img_link[0];
                $image_meta = autozone_wp_get_attachment($img_id);
                $image_alt = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];

                $final_scn1 = ($item['scn1'] == '') ? '': '<li><a class="icon fa '.esc_attr($item['scn_icon1']).'" href="'.esc_url($item['scn1']).'"></a></li>';
                $final_scn2 = ($item['scn2'] == '') ? '': '<li><a class="icon fa '.esc_attr($item['scn_icon2']).'" href="'.esc_url($item['scn2']).'"></a></li>';
                $final_scn3 = ($item['scn3'] == '') ? '': '<li><a class="icon fa '.esc_attr($item['scn_icon3']).'" href="'.esc_url($item['scn3']).'"></a></li>';
                $final_scn4 = ($item['scn4'] == '') ? '': '<li><a class="icon fa '.esc_attr($item['scn_icon4']).'" href="'.esc_url($item['scn4']).'"></a></li>';
                //$final_scn5 = ($scn5 == '') ? '': '<li><a href="'.esc_url($scn5).'"><span class="ef '.esc_attr($scn_icon5).'"></span></a></li>';
                //$final_scn6 = ($scn6 == '') ? '': '<li><a href="'.esc_url($scn6).'"><span class="ef '.esc_attr($scn_icon6).'"></span></a></li>';
                if (!$item['skill']) { $skill_class = 'staff-no-skill';
                }else{$skill_class = '';}

                ?>
    <li class="list-staff__item clearfix <?php echo esc_attr($skill_class);?>'">
        <div class="list-staff__media">
            <img class="img-responsive" src="<?php echo esc_url($img_link)?>" height="280" width="280" alt="<?php echo esc_attr($image_alt);?>">
            <?php if($item['scn1'] || $item['scn2'] || $item['scn3'] || $item['scn4'] ){ ?>
            <ul class="list-staff__social list-inline">
                <?php echo $final_scn1.$final_scn2.$final_scn3.$final_scn4;?>
            </ul>
            <?php } ?>
        </div>
        <!-- end list-staff__media -->
        <div class="list-staff__inner">
            <div class="list-staff__info">
                <div class="list-staff__wrap_name">
                    <div class="list-staff__name"><?php echo wp_kses_post($item['name']);?></div>
                    <div class="list-staff__categories"><?php echo wp_kses_post($item['position'])?></div>
                </div>
                <div class="decor-1"></div>
                <div class="list-staff__description">
                    <?php echo do_shortcode($item['content'])?>
                </div>
            </div>
            <div class="staff-progress">
                <div class="staff-progress__title"><i class="decor-3 fa fa-caret-right"></i><?php echo esc_html__( 'SKILL LEVEL', 'autozone' );?></div>
                <div class="progress progress-striped active">
                    <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo esc_attr($item['skill'])?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo esc_attr($item['skill'])?>%"> </div>
                </div>
            </div>
        </div>
        <!-- end list-staff__inner -->
    </li>
    <?php } ?>
</ul>
<?php } elseif($settings['style'] == 'style-two'){
            $containerData = ' data-speed="300" data-infinite="true" data-autoplay="true" data-autoplayspeed="5000" data-adaptiveheight="true" data-centermode="false" data-centerpadding="50px" data-centerpaddingtablet="25px" data-centerpaddingmobile="15px" data-slidestoshow-desk="3" data-slidestoshow-tablet="2" data-slidestoshow-mobile="1" data-dots="true" data-arrows="false" data-tabletbreakpoint="995" data-phonebreakpoint="550" data-dots-align="center" data-dots-style="style1" data-arrows-style="style1" data-arrows-position="middle" data-vertical="false" data-slidestoscroll-desk="1" data-slidestoscroll-tablet="1" data-slidestoscroll-mobile="1" role="toolbar"';
            ?>
<div class="kswr-slickslider-container" <?php echo $containerData;?>>

    <?php foreach($settings['team_list'] as $item){ ?>
    <?php
                $socialContainer = '<div class="km-teammate-soc" >';
                    $socialContainer .= (trim($item['fb']) != "") ? '<a target="_blank" href="'.esc_url($item['fb']).'"><i class="km-icon-facebook-f"></i></a>' : '';
                    $socialContainer .= (trim($item['tw']) != "") ? '<a target="_blank" href="'.esc_url($item['tw']).'"><i class="km-icon-twitter"></i></a>' : '';
                    $socialContainer .= (trim($item['lk']) != "") ? '<a target="_blank" href="'.esc_url($item['lk']).'"><i class="km-icon-linkedin2"></i></a>' : '';
                    $socialContainer .= (trim($item['inst']) != "") ? '<a target="_blank" href="'.esc_url($item['inst']).'"><i class="km-icon-instagram2"></i></a>' : '';
                   // $socialContainer .= (trim($tmmate_git_link) != "") ? '<a target="_blank" href="'.esc_url($tmmate_git_link).'"><i class="km-icon-github-alt"></i></a>' : '';
                $socialContainer .='</div>';
                $img_id = $item['image']["id"];
                $img_src = wp_get_attachment_image_src($img_id,'full');
                ?>
    <div class="km-teammate-container" data-style="style3" data-align="center">
        <div class="km-teammate-img">
            <div class="km-teammate-img-overlay"></div>
            <img src="<?php echo $img_src[0];?>">
        </div>
        <div class="km-teammate-info">
            <div class="km-teammate-np">
                <div class="km-teammate-name kswr-shortcode-element">
                    <?php echo wp_kses_post($item['name']);?>
                </div>
                <div class="km-teammate-position kswr-shortcode-element">
                    <?php echo wp_kses_post($item['position'])?>
                </div>
            </div>

            <?php echo $socialContainer;?>
            <div class="km-teammate-content"> <?php echo do_shortcode($item['content'])?> </div>
            <?php echo $socialContainer;?>
        </div>
    </div>
    <?php } ?>

</div>

<?php } ?>
<?php

    }
}
