<?php
use Elementor\Control_Media;
use Elementor\Core\Base\Document;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use ElementorPro\Modules\QueryControl\Module as QueryControlModule;
use ElementorPro\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Social_Buttons extends Widget_Base {

    public function get_name() {
        return 'templines-social-buttons';
    }

    public function get_title() {
        return esc_html__( 'Social Buttons', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-user templines-icon';
    }


    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_pricing_general_setting',
            [
                'label' => __( 'General Setting', 'templines-helper-core' ),
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '', 'templines-helper-core' ),
            ]
        );

        $repeater->add_control(
            'icon_svg',
            [
                'label'            => __( 'Icon', 'templines-helper-core' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'default'          => [
                    'value'   => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'fa4compatibility' => 'icon'
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Enter your button link', 'templines-helper-core' ),
                'default' => '#',
            ]
        );
        $this->add_control(
            'list_fields',
            [
                'label'       => '',
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),

            ]
        );

        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings_for_display();

 ?>
        <ul class="social-links list-inline">
           <?php foreach ($settings['list_fields'] as $item){
               $href = $item['link'];
               $url = empty($href['url']) ? '#' : $href['url'];
               $blank = empty($href['target'])  ? '_self' : $href['target'];
               ?>
               <li>
                   <a target="<?php echo esc_attr($blank);?>" href="<?php echo esc_url($url)?>" class="icon fa '.esc_attr($icon).'" >
                       <?php Icons_Manager::render_icon( $item['icon_svg']); ?>
                   </a>
               </li>
           <?php } ?>
        </ul>
<?php
    }
}