<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;






if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Service_Box extends Widget_Base {

    public function get_name() {
        return 'templines-service-box';
    }

    public function get_title() {
        return esc_html__( 'Service Box', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-list-ol templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }



    protected function register_controls() {
        // Sub Title
        $this->start_controls_section(
            'section_elementor_list_general',
            [
                'label' => __( 'General Service Box Setting', 'templines-helper-core' ),
            ]
        );

        // Carousel
        $this->add_control(
            'disable_carousel',
            [
                'label' => __( 'Carousel', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'               =>          esc_attr__('On','tm-helper-core'),
                    '0'              =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'on'
            ]
        );

        $repeater = new Repeater();
        //Title
        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Vehicle', 'templines-helper-core' ),
            ]
        );
        //Strong Title
        $repeater->add_control(
            'title_strong',
            [
                'label' => __( 'Strong Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'REPAIRING', 'templines-helper-core' ),
            ]
        );
        //Icon
        /*
        $repeater->add_control(
            'type',
            [
                'label' => __( 'Icon library', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'pixflaticon'               =>          esc_attr__('Pixflaticon','tm-helper-core'),
                    'pixfontawesome'              =>          esc_attr__('Pixfontawesome','tm-helper-core'),
                    'pixelegant'              =>          esc_attr__('Pixelegant','tm-helper-core'),
                    'pixsimple'              =>          esc_attr__('Pixsimple','tm-helper-core'),
                    'pixcustom1'              =>          esc_attr__('Pixcustom1','tm-helper-core'),
                    'pixcustom2'              =>          esc_attr__('Pixcustom2','tm-helper-core'),
                    'fontawesome'              =>          esc_attr__('Fontawesome','tm-helper-core'),
                ],
                'default' => 'pixflaticon'
            ]
        );
        $repeater->add_control(
            'icon_pixflaticon',
            [
                'label' => __( 'Flaticon', 'tm-helper-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flaticon-automobile5' => [
                        'title' => __( 'Automobile5', 'templines-helper-core' ),
                        'icon' => 'flaticon-automobile5',
                    ],
                ],
                'default' => 'flaticon-automobile5'
            ]
        );
        */
        
        $repeater->add_control(
            'icon_svg',
            [
                'label'            => __( 'Icon', 'templines-helper-core' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'default'          => [
                    'value'   => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'fa4compatibility' => 'icon'
            ]
        );
        //Link
        $repeater->add_control(
            'link',
            [
                'label' => __( 'Link', 'templines-helper-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'https://your-link.com', 'templines-helper-core' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );
        //Info
        $repeater->add_control(
            'content',
            [
                'label' => '',
                'type' => Controls_Manager::WYSIWYG,
                'default' => 'Wliquam sit amet urna sed vel nullam semper aibers vestibulum fringilla',
            ]
        );



        $this->add_control(
            'list_services',
            [
                'label'       => 'Service Box List',
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Icon Color', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'scheme' => [
                    'type' => \Elementor\Core\Schemes\Color::get_type(),
                    'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .list-services i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .list-services svg' => 'fill: {{VALUE}}',
                ],

            ]
        );


        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $disable_carousel = $settings['disable_carousel'] == 1 ? 'owl-carousel enable-owl-carousel' : ''; ?>
       
        <div class="slider-services <?php echo esc_attr($disable_carousel); ?> owl-theme owl-theme_mod-a" data-min480="2" data-min768="3" data-min992="4" data-min1200="4" data-pagination="true" data-navigation="false" data-auto-play="4000" data-stop-on-hover="true">
            <?php foreach ($settings['list_services'] as $item){
                $href =  $item['link'];
                $a_href = empty($href['url']) ? wp_kses_post($item['title']).' <strong>'.wp_kses_post($item['title_strong']).'</strong>' : '<a href="'.esc_url($href['url']).'">'.wp_kses_post($item['title']).' <strong>'.wp_kses_post($item['title_strong']).'</strong></a>';
                ?>
                <div class="list-services">
                    <?php Icons_Manager::render_icon( $item['icon_svg']);?>
                    <div class="decor-1"></div>
                    <div class="list-services__inner">
                        <h3 class="list-services__title"><?php echo wp_kses_post($a_href);?></h3>
                        <div class="list-services__description"><?php echo do_shortcode($item['content'])?></div>
                    </div>
                </div>
            <?php } ?>
        </div>
    <?php
    }
}