<?php
use Elementor\Control_Media;
use Elementor\Core\Base\Document;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use ElementorPro\Modules\QueryControl\Module as QueryControlModule;
use ElementorPro\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Reviews extends Widget_Base {

    public function get_name() {
        return 'templines-reviews';
    }

    public function get_title() {
        return esc_html__( 'Reviews', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-star-o templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

	public function get_style_depends() {

		wp_register_style( 'widget_style_reviews', plugins_url( '../assets/css/my-widgets.css', __FILE__  ) );

		return [
			'widget_style_reviews',
		];

	}

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_reviews_general_setting',
            [
                'label' => __( 'General Setting', 'templines-helper-core' ),
            ]
        );
		
		 // Style
        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-one'             =>          esc_attr__('Style One','tm-helper-core'),
                    'style-two'              =>          esc_attr__('Style Two','tm-helper-core'),
                ],
                'default' => 'style-one'
            ]
        );
		
        $this->add_control(
            'reviews_per_page',
            [
                'label' => __( 'Reviews per page', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '3'               =>          esc_attr__('3','tm-helper-core'),
                    '2'               =>          esc_attr__('2','tm-helper-core'),
                    '1'               =>          esc_attr__('1','tm-helper-core'),
                ],
                'default' => '3',
            ]
        );

        // Carousel
        $this->add_control(
            'disable_carousel',
            [
                'label' => __( 'Carousel', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'               =>          esc_attr__('On','tm-helper-core'),
                    '0'              =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'on'
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'BEST CARS!',
            ]
        );


        $repeater->add_control(
            'image',
            [
                'label'             => __( 'Image', 'templines-helper-core' ),
                'type'              => Controls_Manager::MEDIA,
                'label_block'       => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => __( 'Name', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'kyle joseph',
            ]
        );

        $repeater->add_control(
            'position',
            [
                'label' => __( 'Position', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'CUSTOMER',
            ]
        );

        $repeater->add_control(
            'content',
            [
                'label' => 'Content',
                'type' => Controls_Manager::WYSIWYG,
                'default' => 'Wliquam sit amet urna sed vel nullam semper aibe vestibulum fringilla orem ipsum dolor sit amet con sectetur adipisicing elit sed don eiusmod tempor incididunt ut labore et dolore.',
            ]
        );




        $this->add_control(
            'reviews_list',
            [
                'label'       => '',
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings_for_display();

        $disable_carousel = $settings['disable_carousel'] == 1 ? 'owl-carousel  enable-owl-carousel' : '';

		if($settings['style'] == 'style-one'){ 
		?>
			<div class="slider-reviews <?php echo esc_attr($disable_carousel)?> owl-theme owl-theme_mod-a" data-min480="1" data-min768="2" data-min992="<?php echo esc_attr($settings['reviews_per_page'])?>" data-min1200="<?php echo esc_attr($settings['reviews_per_page'])?>" data-pagination="true" data-navigation="false" data-auto-play="400000" data-stop-on-hover="true" >

                <?php foreach ($settings['reviews_list'] as $item){ ?>
                    <?php
                    $img_id = $item['image']['id'];
                    $img_link = wp_get_attachment_image_src( $img_id, 'large' );
                    $img_link = $img_link[0];
                    $image_meta = autozone_wp_get_attachment($img_id);
                    $image_alt = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];
                    ?>
                    <div class="reviews">
                        <h3 class="reviews__title"><?php echo wp_kses_post($item['title'])?></h3>
                        <div class="decor-1"></div>
                        <div class="reviews__text">
                            <?php echo do_shortcode($item['content'])?>
                        </div>
                        <div class="reviews__img"><img class="img-responsive" src="<?php echo esc_url($img_link)?>" height="55" width="55" alt="<?php echo esc_attr($image_alt)?>"></div>
                        <div class="reviews__inner">
                            <div class="reviews__name"><?php echo wp_kses_post($item['name'])?></div>
                            <div class="reviews__category"><?php echo wp_kses_post($item['position'])?></div>
                        </div>
                    </div>
                <?php } ?>

            </div>
        <?php   
			} elseif($settings['style'] == 'style-two'){
		?>
		
		<div class="slider-reviews <?php echo esc_attr($disable_carousel)?> owl-theme owl-theme_mod-a" data-min480="1" data-min768="2" data-min992="<?php echo esc_attr($settings['reviews_per_page'])?>" data-min1200="<?php echo esc_attr($settings['reviews_per_page'])?>" data-pagination="true" data-navigation="false" data-auto-play="400000" data-stop-on-hover="true" >
			<?php foreach ($settings['reviews_list'] as $item){ ?>
                    <?php
                    $img_id = $item['image']['id'];
                    $img_link = wp_get_attachment_image_src( $img_id, 'large' );
                    $img_link = $img_link[0];
                    $image_meta = autozone_wp_get_attachment($img_id);
                    $image_alt = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];
                    ?>
						<div class="box__style">
							<div class="box__style-2">
								<img
								  loading="lazy"
								  src="<?php echo esc_url($img_link)?>"
								  width="85"
								  height="85"
								  alt="<?php echo esc_attr($image_alt)?>"
								  class="avatar"
								/>
								<div class="box__content">
								  <p>
									<?php echo do_shortcode($item['content'])?>
								  </p>
								  <div class="box__name"><?php echo wp_kses_post($item['name'])?></div>
								  <div class="box__role"><?php echo wp_kses_post($item['position'])?></div>
								</div>
							</div>
						</div>
			 <?php } ?>
		</div>
		<?php

        }


    }
}