<?php
use Elementor\Control_Media;
use Elementor\Core\Base\Document;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use ElementorPro\Modules\QueryControl\Module as QueryControlModule;
use ElementorPro\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Product_Slider extends Widget_Base {

    public function get_name() {
        return 'templines-product';
    }

    public function get_title() {
        return esc_html__( 'Product-Slider', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-star-o templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

	public function get_style_depends() {

		wp_register_style( 'widget_style_productSlider', plugins_url( '../assets/css/product-slider.css', __FILE__  ) );

		return [
			'widget_style_productSlider',
		];

	}
	
	public function get_script_depends() {

		wp_register_script( 'widget_js_productSlider', plugins_url( '../assets/js/product-slider.js', __FILE__ ) );

		return [
			'widget_js_productSlider',
		];

	}

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_reviews_general_setting',
            [
                'label' => __( 'General Setting', 'templines-helper-core' ),
            ]
        );
		
		 // Style
        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-one'             =>          esc_attr__('Style One','tm-helper-core'),
                    'style-two'              =>          esc_attr__('Style Two','tm-helper-core'),
                ],
                'default' => 'style-one'
            ]
        );
		
        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'BEST CARS!',
            ]
        );


        $repeater->add_control(
            'image',
            [
                'label'             => __( 'Image', 'templines-helper-core' ),
                'type'              => Controls_Manager::MEDIA,
                'label_block'       => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => __( 'Name', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => 'kyle joseph',
            ]
        );

        $this->add_control(
            'reviews_list',
            [
                'label'       => '',
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings_for_display();

		if($settings['style'] == 'style-one'){ 
		?>

<div class="slider1 swiper">
    <div class="slider1__wrapper swiper-wrapper">
        <?php foreach ($settings['reviews_list'] as $item){ ?>
        <?php
                    $img_id = $item['image']['id'];
                    $img_link = wp_get_attachment_image_src( $img_id, 'large' );
                    $img_link = $img_link[0];
                    $image_meta = autozone_wp_get_attachment($img_id);
                    $image_alt = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];
                    ?>

        <div class="slider1__slide swiper-slide">
            <img src="<?php echo esc_url($img_link)?> " width="700" height="450" alt="<?php echo esc_attr($image_alt)?>">
        </div>
        <?php } ?>
    </div>
    <div class="slider1__bar">
        <div class="slider1__arrows">
            <div class="slider1__arrow slider1__arrow-prev">
                <?php echo '<img src="' . esc_url( plugins_url( '../assets/img/left-arrow-1.svg', __FILE__ ) ) . '" > '; ?>
            </div>
            <div class="slider1__pagination"></div>
            <div class="slider1__arrow slider1__arrow-next">
                <?php echo '<img src="' . esc_url( plugins_url( '../assets/img/right-arrow-1.svg', __FILE__ ) ) . '" > '; ?>

            </div>
        </div>
    </div>
</div>
<?php   
			} elseif($settings['style'] == 'style-two'){
		?>



<div class="slider2">
    <div class="slider2__inner swiper">
        <div class="slider2__wrapper swiper-wrapper">

            <?php foreach ($settings['reviews_list'] as $item){ ?>
            <?php
                    $img_id = $item['image']['id'];
                    $img_link = wp_get_attachment_image_src( $img_id, 'large' );
                    $img_link = $img_link[0];
                    $image_meta = autozone_wp_get_attachment($img_id);
                    $image_alt = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];
                    ?>

            <div class="slider2__slide swiper-slide">
                <img src="<?php echo esc_url($img_link)?>" alt="<?php echo esc_attr($image_alt)?>">
                <div class="box__content">
                    <div class="slider2__box-subtitle">
                        <?php echo do_shortcode($item['title'])?>
                    </div>
                    <h3 class="slider2__box-title">
                        <?php echo wp_kses_post($item['name'])?>
                    </h3>
                </div>
            </div>


            <?php } ?>
        </div>
    </div>
    <div class="slider2__box">

        <div class="slider2__arrows">
            <div class="slider2__arrow slider2__arrow-prev">
                <?php echo '<img src="' . esc_url( plugins_url( '../assets/img/arrow-left.svg', __FILE__ ) ) . '" > '; ?>

            </div>
            <div class="slider2__arrow slider2__arrow-next">
                <?php echo '<img src="' . esc_url( plugins_url( '../assets/img/arrow-right.svg', __FILE__ ) ) . '" > '; ?>

            </div>
        </div>

    </div>



</div>
<?php

        }


    }
}
