<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Map extends Widget_Base {

    public function get_name() {
        return 'templines-map';
    }

    public function get_title() {
        return esc_html__( 'Map', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-font templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_map_style',
            [
                'label' => __( 'General Styles', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __( 'Marker Image', 'templines-helper-core' ),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'address',
            [
                'label' => __( 'Address', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'width',
            [
                'label' => __( 'Map Width', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '90', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'height',
            [
                'label' => __( 'Map Height', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '500px', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'zoom',
            [
                'label' => __( 'Zoom', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '8', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'scrollwheel',
            [
                'label'   => __( 'Scroll Wheel', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-one',
                'options' => [
                    'false'              =>         esc_attr__('Off','templines-helper-core'),
                    'true'              =>         esc_attr__('On','templines-helper-core'),
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $out = '';

        $img_id = $settings['image'];
        $img_link = wp_get_attachment_image_src( $img_id, 'full' );
        $img_link = $img_link[0];
        $image_meta = autozone_wp_get_attachment($img_id);
        $image_alt = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];
        $address = $settings['address'] == '' ? 'San Diego, CA' : $settings['address'];
        $width = $settings['width'] == '' ? '90%' : $settings['width'];
        $height = $settings['height'] == '' ? '500px' : $settings['height'];
        $zoom = $settings['zoom'] == '' ? 8 : $settings['zoom'];
        $scrollwheel = $settings['scrollwheel'] == '' ? 'false' : $settings['scrollwheel'];
        $out = '




        <style scoped>
    
            #contact-map{
                width: '.esc_attr($width).';
                height: '.esc_attr($height).';
                margin: 0 auto;
            }
    
        </style>
    
        <div id="contact-map"></div>
    
        <script type="text/javascript">
        
        
        /*=== initializate google map ====*/
        
        function initMap() {
        
            var styles = [
            {
                "featureType": "administrative",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "saturation": -100
                    },
                    {
                        "lightness": 20
                    }
                ]
            },
            {
                "featureType": "road",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "saturation": -100
                    },
                    {
                        "lightness": 40
                    }
                ]
            },
            {
                "featureType": "water",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "saturation": -10
                    },
                    {
                        "lightness": 30
                    }
                ]
            },
            {
                "featureType": "landscape.man_made",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "simplified"
                    },
                    {
                        "saturation": -60
                    },
                    {
                        "lightness": 10
                    }
                ]
            },
            {
                "featureType": "landscape.natural",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "simplified"
                    },
                    {
                        "saturation": -60
                    },
                    {
                        "lightness": 60
                    }
                ]
            },
            {
                "featureType": "poi",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    },
                    {
                        "saturation": -100
                    },
                    {
                        "lightness": 60
                    }
                ]
            },
            {
                "featureType": "transit",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    },
                    {
                        "saturation": -100
                    },
                    {
                        "lightness": 60
                    }
                ]
            }
        ];
    
        geocoder = new google.maps.Geocoder();
        var myLatLng = {lat: 34.0522342, lng: -118.2436849};
        var address = "'.wp_kses_post($address).'";
        var image = "'.esc_url($img_link).'";
        var zoom = '.esc_attr($zoom).';
        var scrollwheel = '.esc_attr($scrollwheel).';
        
        // Create a map object and specify the DOM element for display.
        var map = new google.maps.Map(document.getElementById("contact-map"), {
            center: myLatLng,
            scrollwheel: scrollwheel,
            zoom: zoom
        });
    
        map.setOptions({styles: styles});
        if (geocoder) {
              geocoder.geocode( { "address": address}, function(results, status) {
                if (status == google.maps.GeocoderStatus.OK) {
                  if (status != google.maps.GeocoderStatus.ZERO_RESULTS) {
                  map.setCenter(results[0].geometry.location);
        
                    var infowindow = new google.maps.InfoWindow(
                        { content: "<b>"+address+"</b>",
                          size: new google.maps.Size(150,50)
                        });
        
                    var marker = new google.maps.Marker({
                        position: results[0].geometry.location,
                        map: map,
                        icon: image,
                        title:address
                    });
                    google.maps.event.addListener(marker, "click", function() {
                        infowindow.open(map,marker);
                    });
        
                  } else {
                    alert("No results found");
                  }
                } else {
                  alert("Geocode was not successful for the following reason: " + status);
                }
              });
            }
        
        
        }
    
        </script>
        ';

        echo $out;
        ?>



   <?php }
}