<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;






if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Latest_Autos extends Widget_Base {

    public function get_name() {
        return 'templines-latest-autos';
    }

    public function get_title() {
        return esc_html__( 'Latest Autos', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-list-ol templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    public function templines_get_models($type = null){

        $terms = get_terms( array(
            'taxonomy' => 'auto-model',
            'hide_empty' => '0'
        ) );

        $options[0] = esc_html__( 'Select a Auto Models', 'templines-helper-core' );

        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
            foreach ( $terms as $cat ) {
                $options[$cat->slug] = $cat->name;
            }
        } else {
            $options[0] = esc_html__( 'Create a Model First', 'templines-helper-core' );
        }

        return $options;
    }

    protected function register_controls() {
        // Sub Title
        $this->start_controls_section(
            'section_elementor_list_general',
            [
                'label' => __( 'General Latest Autos Setting', 'templines-helper-core' ),
            ]
        );
        // Slide Type
        $this->add_control(
            'slide_type',
            [
                'label' => __( 'Slide Type', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ids'             =>          esc_attr__('Items by ID','tm-helper-core'),
                    'idate'              =>          esc_attr__('Items by Date','tm-helper-core'),
                ],
                'default' => 'idate'
            ]
        );

        // Item Count
        $this->add_control(
            'count',
            [
                'label' => __( 'Items Count', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '5'             =>          esc_attr__('5','tm-helper-core'),
                    '10'              =>          esc_attr__('10','tm-helper-core'),
                    '15'             =>          esc_attr__('15','tm-helper-core'),
                    '20'              =>          esc_attr__('20','tm-helper-core'),
                    '25'              =>          esc_attr__('25','tm-helper-core'),
                ],
                'default' => '5'
            ]
        );
        // Autos Status
        $this->add_control(
            'auto_featured',
            [
                'label' => __( 'Autos Status', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'default'               =>          esc_attr__('Default','tm-helper-core'),
                    'Featured'              =>          esc_attr__('Featured','tm-helper-core'),
                    'Sold'                  =>          esc_attr__('Sold','tm-helper-core'),
                    'Reserved'              =>          esc_attr__('Reserved','tm-helper-core'),
                ],
                'default' => 'default'
            ]
        );
        // Auto Models
        $this->add_control(
            'models', [
                'label' => esc_html__( 'Auto Models', 'templines-helper-core'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->templines_get_models(),
                'show_label' => true,
                'label_block' => true,
            ]
        );
        // Carousel
        $this->add_control(
            'carousel',
            [
                'label' => __( 'Autos Status', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'               =>          esc_attr__('Enable','tm-helper-core'),
                    '0'              =>          esc_attr__('Disable','tm-helper-core'),
                ],
                'default' => '1'
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        global $post;
        $items_count = 5;
        $auto_featured = '';

        $slide_type = !empty($settings['slide_type']) ? $settings['slide_type'] : 'idate';
        $carousel = $settings['carousel'] == 1 ? 'fl-latest-carousel' : '';
        $auto_translate = unserialize( get_option( '_pixad_auto_translate' ) );

        $out = '<div>';
        $out .= '
			<div class="slider-grid '.esc_attr($carousel).' owl-theme 
            owl-theme_mod-c" 
            data-pagination="true" 
            data-single-item="true" 
            data-min480="1" data-min768="1" data-min992="1" data-min1200="1"  data-navigation="false" data-stop-on-hover="true" data-auto-play="false"
            
            >
			';
        $Auto = new PIXAD_Autos();
        if( $slide_type == 'ids' ) :
            preg_match_all( '/section_autos_slide([^\]]+)/i', $content, $matches, PREG_OFFSET_CAPTURE );
            $tab_titles = array();
            if ( isset( $matches[1] ) ) {
                if( count($matches[1]) > 0 )
                    $items_count = $items_count*count($matches[1]);
                $tab_titles = $matches[1];
            }

            $tabs_ids = array();

            foreach ( $tab_titles as $tab ) {
                $tab_atts = shortcode_parse_atts( $tab[0] );
                $tabs_ids[] = isset( $tab_atts['item_1'] ) ? $tab_atts['item_1'] : 0;
                $tabs_ids[] = isset( $tab_atts['item_2'] ) ? $tab_atts['item_2'] : 0;
                $tabs_ids[] = isset( $tab_atts['item_3'] ) ? $tab_atts['item_3'] : 0;
                $tabs_ids[] = isset( $tab_atts['item_4'] ) ? $tab_atts['item_4'] : 0;
                $tabs_ids[] = isset( $tab_atts['item_5'] ) ? $tab_atts['item_5'] : 0;
            }

            $args = array(
                'post_type' => 'pixad-autos',
                'orderby' => 'post__in',
                'post__in' => $tabs_ids,
                'posts_per_page' => $items_count,
            );

        else :

            $models_to_query = get_objects_in_term(  $settings['models'], 'auto-model');
            $args = array(
                'post_type' => 'pixad-autos',
                'orderby' => 'date',
                'post__in' => $models_to_query,
                'order' => 'DESC',
            );
            if($auto_featured != ''){
                $args['meta_query'] = array(
                    array(
                        'key' => 'pixad_auto_featured',
                        'value' => $auto_featured
                    ),
                );
            }
            if( is_numeric($settings['count']) )
                $args['showposts'] = $settings['count'];
            else
                $args['posts_per_page'] = 5;
        endif;
        $autos = new WP_Query( $args );

        if ($autos->have_posts()):
            $i = 0;
            $cnt = $autos->found_posts;
            while ($autos->have_posts()) :

                $class = ($i % 5) == 0 ? 'autozone_latest_item_feature' : 'autozone_latest_item';
                $autos->the_post();

                $featured = get_post_meta(get_the_ID(), 'pixad_auto_featured', true) != '' ? '<a class="slider-grid__btn btn btn-default btn-effect" href="javascript:void(0);"><span class="btn-inner">'.$auto_translate[get_post_meta($post->ID, 'pixad_auto_featured', true)].'</span></a>' : '';

                $sale = $Auto->get_meta('_auto_sale_price') != '' ? '<span class="card__wrap-label sale">'.esc_html__( 'Sale', 'autozone' ).'</span>' : '';

                $link = get_the_permalink(get_the_ID());

                $thumbnail = get_the_post_thumbnail(get_the_ID(), $class, array('class' => 'img-responsive'));
                $Auto->Query_Args( array('auto_id' => get_the_ID()) );

                $price_catalog = is_numeric($Auto->get_meta('_auto_price')) || $Auto->get_meta('_auto_price') == ''  ? $Auto->get_price() : $auto_translate[$Auto->get_price()];

                $custom_price_catalog = get_post_meta(get_the_ID(), 'custom_price_catalog', 1) ;
                $price_catalog = $custom_price_catalog ? $custom_price_catalog : $Auto->get_price();
                //$price_catalog = is_numeric($PIXAD_Autos->get_meta('_auto_price')) || $PIXAD_Autos->get_meta('_auto_price') == '' ? $PIXAD_Autos->get_price() : $auto_translate[$PIXAD_Autos->get_price()];

                if($Auto->get_meta('_auto_price')){
                    $show_price = $price_catalog == '' ? '' : '<span class="slider-grid__price">'.wp_kses_post($price_catalog).'</span>';
                }else{
                    $show_price ='';
                }

                if( $i % 5 == 0 ){
                    $out .= '

			<div class="slider-grid__item">
                <div class="row">
                  <div class="col-md-5">
                    <div class="slider-grid__inner slider-grid__inner_mod-a">
                        <a href="'.esc_url($link).'">'.wp_kses_post($thumbnail).'</a>
                        '.$featured.'
                        '.wp_kses_post($sale).'
                        <div class="slider-grid__wrap-name">
                            <span class="slider-grid__name">'.wp_kses_post(get_the_title()).'</span>
                            '.$show_price.'
                        </div>
                    </div>
                  </div>';
                    if($cnt == $i+1)
                        $out .= '</div></div>';
                } elseif( $i % 5 == 1 ) {
                    $out .= '

                  <div class="col-md-7">
                    <div class="row">
                      <div class="col-sm-6">
                        <div class="slider-grid__inner slider-grid__inner_mod-b">
                            <a href="'.esc_url($link).'">'.wp_kses_post($thumbnail).'</a>
                            '.wp_kses_post($sale).'
                            <span class="slider-grid__name">'.wp_kses_post(get_the_title()).'</span>
                            <a href="'.esc_url($link).'">
								<div class="slider-grid__hover">
									'.$show_price.'
									<ul class="slider-grid__info list-unstyled">
										<li><i class="icon icon-speedometer"></i>'.wp_kses_post($Auto->get_meta('_auto_mileage')).'</li>
										<li><i class="icon icon-paper-plane"></i>'.wp_kses_post($Auto->get_meta('_auto_year')).'</li>
									</ul>
								</div>
							</a>
                        </div>
                      </div>';
                    if($cnt == $i+1)
                        $out .= '</div></div></div></div>';
                } elseif( $i % 5 == 2 ) {
                    $out .= '
                      <div class="col-sm-6">
                        <div class="slider-grid__inner slider-grid__inner_mod-b">
                            <a href="'.esc_url($link).'">'.wp_kses_post($thumbnail).'</a>
                            '.wp_kses_post($sale).'
                            <span class="slider-grid__name">'.wp_kses_post(get_the_title()).'</span>
                            <a href="'.esc_url($link).'">
								<div class="slider-grid__hover">
									'.$show_price.'
									<ul class="slider-grid__info list-unstyled">
										<li><i class="icon icon-speedometer"></i>'.wp_kses_post($Auto->get_meta('_auto_mileage')).'</li>
										<li><i class="icon icon-paper-plane"></i>'.wp_kses_post($Auto->get_meta('_auto_year')).'</li>
									</ul>
								</div>
							</a>
                        </div>
                      </div>
                    </div>';
                    if($cnt == $i+1)
                        $out .= '</div></div></div>';
                } elseif( $i % 5 == 3 ) {
                    $out .= '
                    <div class="row">
                      <div class="col-sm-6">
                        <div class="slider-grid__inner slider-grid__inner_mod-b">
                            <a href="'.esc_url($link).'">'.wp_kses_post($thumbnail).'</a>
                            '.wp_kses_post($sale).'
                            <span class="slider-grid__name">'.wp_kses_post(get_the_title()).'</span>
                            <a href="'.esc_url($link).'">
								<div class="slider-grid__hover">
									'.$show_price.'
									<ul class="slider-grid__info list-unstyled">
										<li><i class="icon icon-speedometer"></i>'.wp_kses_post($Auto->get_meta('_auto_mileage')).'</li>
										<li><i class="icon icon-paper-plane"></i>'.wp_kses_post($Auto->get_meta('_auto_year')).'</li>
									</ul>
								</div>
							</a>
                        </div>
                      </div>';
                    if($cnt == $i+1)
                        $out .= '</div></div></div></div>';
                } elseif( $i % 5 == 4 ) {
                    $out .= '
                      <div class="col-sm-6">
                        <div class="slider-grid__inner slider-grid__inner_mod-b">
	                        <a href="' . esc_url($link) . '">' . wp_kses_post($thumbnail) . '</a>
	                        '.wp_kses_post($sale).'
                            <span class="slider-grid__name">' . wp_kses_post(get_the_title()) . '</span>
                            <a href="'.esc_url($link).'">
								<div class="slider-grid__hover">
									'.$show_price.'
									<ul class="slider-grid__info list-unstyled">
										<li><i class="icon icon-speedometer"></i>' . wp_kses_post($Auto->get_meta('_auto_mileage')) . '</li>
										<li><i class="icon icon-paper-plane"></i>' . wp_kses_post($Auto->get_meta('_auto_year')) . '</li>
									</ul>
								</div>
							</a>
                        </div>
                      </div>
                    </div>  ';

                    $out .= '

                  </div>
                </div>
              </div>
        ';
                }
                $i++;
            endwhile;
            wp_reset_postdata();
        endif;

        $out .= '            
		</div>
	</div>';

        echo $out;



    }
}