<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Image_Carousel extends Widget_Base {

    public function get_name() {
        return 'templines-image-carousel';
    }

    public function get_title() {
        return esc_html__( 'Image Gallery', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-file-image-o templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_image_gallery_general_setting',
            [
                'label' => __( 'General Setting', 'templines-helper-core' ),
            ]
        );



        // Style
        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-one'             =>          esc_attr__('Style One','tm-helper-core'),
                    'style-two'              =>          esc_attr__('Style Two','tm-helper-core'),
                ],
                'default' => 'style-one'
            ]
        );

        // Style Layout
        $this->add_control(
            'style_layout',
            [
                'label' => __( 'Style Layout', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'left'             =>          esc_attr__('Left','tm-helper-core'),
                    'right'              =>          esc_attr__('Right','tm-helper-core'),
                ],
                'default' => 'left',
                'condition' => [
                    'style' => 'style-two',
                ],
            ]
        );




        $this->add_control(
            'images',
            [
                'label' => __( 'Images', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->add_control(
            'img_size',
            [
                'label' => __( 'Image size', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => '280x177',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Auto Play', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => '',
            ]
        );

        $this->add_control(
            'css_animation',
            [
                'label' => __( 'CSS Animation', 'templines-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'no'                  => esc_html__( 'No', 'autozone' ),
                    'bounce'            => esc_html__( 'bounce', 'autozone' ),
                    'flash'             => esc_html__( 'flash', 'autozone' ),
                    'pulse'             => esc_html__( 'pulse', 'autozone' ),
                    'rubberBand'        => esc_html__( 'rubberBand', 'autozone' ),
                    'shake'             => esc_html__( 'shake', 'autozone' ),
                    'swing'             => esc_html__( 'swing', 'autozone' ),
                    'tada'              => esc_html__( 'tada', 'autozone' ),
                    'wobble'            => esc_html__( 'wobble', 'autozone' ),
                    'jello'             => esc_html__( 'jello', 'autozone' ),
                    'bounceIn'          => esc_html__( 'bounceIn', 'autozone' ),
                    'bounceInDown'      => esc_html__( 'bounceInDown', 'autozone' ),
                    'bounceInLeft'      => esc_html__( 'bounceInLeft', 'autozone' ),
                    'bounceInRight'     => esc_html__( 'bounceInRight', 'autozone' ),
                    'bounceInUp'        => esc_html__( 'bounceInUp', 'autozone' ),
                    'bounceOut'         => esc_html__( 'bounceOut', 'autozone' ),
                    'bounceOutDown'     => esc_html__( 'bounceOutDown', 'autozone' ),
                    'bounceOutLeft'     => esc_html__( 'bounceOutLeft', 'autozone' ),
                    'bounceOutRight'    => esc_html__( 'bounceOutRight', 'autozone' ),
                    'bounceOutUp'       => esc_html__( 'bounceOutUp', 'autozone' ),
                    'fadeIn'            => esc_html__( 'fadeIn', 'autozone' ),
                    'fadeInDown'        => esc_html__( 'fadeInDown', 'autozone' ),
                    'fadeInDownBig'     => esc_html__( 'fadeInDownBig', 'autozone' ) ,
                    'fadeInLeft'        => esc_html__( 'fadeInLeft', 'autozone' ),
                    'fadeInLeftBig'     => esc_html__( 'fadeInLeftBig', 'autozone' ),
                    'fadeInRight'       => esc_html__( 'fadeInRight', 'autozone' ),
                    'fadeInRightBig'    => esc_html__( 'fadeInRightBig', 'autozone' ),
                    'fadeInUp'          => esc_html__( 'fadeInUp', 'autozone' ),
                    'fadeInUpBig'       => esc_html__( 'fadeInUpBig', 'autozone' ),
                    'fadeOut'           => esc_html__( 'fadeOut', 'autozone' ),
                    'fadeOutDown'       => esc_html__( 'fadeOutDown', 'autozone' ),
                    'fadeOutDownBig'    => esc_html__( 'fadeOutDownBig', 'autozone' ) ,
                    'fadeOutLeft'       => esc_html__( 'fadeOutLeft', 'autozone' ),
                    'fadeOutLeftBig'    => esc_html__( 'fadeOutLeftBig', 'autozone' ),
                    'fadeOutRight'      => esc_html__( 'fadeOutRight', 'autozone' ),
                    'fadeOutRightBig'   => esc_html__( 'fadeOutRightBig', 'autozone' ),
                    'fadeOutUp'         => esc_html__( 'fadeOutUp', 'autozone' ),
                    'fadeOutUpBig'      => esc_html__( 'fadeOutUpBig', 'autozone' ),
                    'flip'              => esc_html__( 'flip', 'autozone' ),
                    'flipInX'           => esc_html__( 'flipInX', 'autozone' ),
                    'flipInY'           => esc_html__( 'flipInY', 'autozone' ),
                    'flipOutX'          => esc_html__( 'flipOutX', 'autozone' ),
                    'flipOutY'          => esc_html__( 'flipOutY', 'autozone' ),
                    'lightSpeedIn'      => esc_html__( 'lightSpeedIn', 'autozone' ),
                    'lightSpeedOut'     => esc_html__( 'lightSpeedOut', 'autozone' ),
                    'rotateIn'          => esc_html__( 'rotateIn', 'autozone' ),
                    'rotateInDownLeft'  => esc_html__( 'rotateInDownLeft', 'autozone' ),
                    'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'autozone' ),
                    'rotateInUpLeft'    => esc_html__( 'rotateInUpLeft', 'autozone' ),
                    'rotateInUpRight'   => esc_html__( 'rotateInUpRight', 'autozone' ),
                    'rotateOut'         => esc_html__( 'rotateOut', 'autozone' ),
                    'rotateOutDownLeft' => esc_html__( 'rotateOutDownLeft', 'autozone' ),
                    'rotateOutDownRight'=> esc_html__( 'rotateOutDownRight', 'autozone' ),
                    'rotateOutUpLeft'   => esc_html__( 'rotateOutUpLeft', 'autozone' ),
                    'rotateOutUpRight'  => esc_html__( 'rotateOutUpRight', 'autozone' ),
                    'slideInUp'         => esc_html__( 'slideInUp', 'autozone' ),
                    'slideInDown'       => esc_html__( 'slideInDown', 'autozone' ),
                    'slideInLeft'       => esc_html__( 'slideInLeft', 'autozone' ),
                    'slideInRight'      => esc_html__( 'slideInRight', 'autozone' ),
                    'slideOutUp'        => esc_html__( 'slideOutUp', 'autozone' ),
                    'slideOutDown'      => esc_html__( 'slideOutDown', 'autozone' ),
                    'slideOutLeft'      => esc_html__( 'slideOutLeft', 'autozone' ),
                    'slideOutRight'     => esc_html__( 'slideOutRight', 'autozone' ),
                    'zoomIn'            => esc_html__( 'zoomIn', 'autozone' ),
                    'zoomInDown'        => esc_html__( 'zoomInDown', 'autozone' ),
                    'zoomInLeft'        => esc_html__( 'zoomInLeft', 'autozone' ),
                    'zoomInRight'       => esc_html__( 'zoomInRight', 'autozone' ),
                    'zoomInUp'          => esc_html__( 'zoomInUp', 'autozone' ),
                    'zoomOut'           => esc_html__( 'zoomOut', 'autozone' ),
                    'zoomOutDown'       => esc_html__( 'zoomOutDown', 'autozone' ),
                    'zoomOutLeft'       => esc_html__( 'zoomOutLeft', 'autozone' ),
                    'zoomOutRight'      => esc_html__( 'zoomOutRight', 'autozone' ),
                    'zoomOutUp'         => esc_html__( 'zoomOutUp', 'autozone' ),
                    'hinge'             => esc_html__( 'hinge', 'autozone' ),
                    'rollIn'            => esc_html__( 'rollIn', 'autozone' ),
                    'rollOut'           => esc_html__( 'rollOut', 'autozone' ),

                ],
                'default' => 'no',
            ]
        );


        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $out = $temp_out = '';
        wp_enqueue_script( 'autozone_carousel_js' );
        wp_enqueue_style( 'autozone_carousel_css' );

        if($settings['style'] == 'style-one'){
            $settings['autoplay'] = is_numeric($settings['autoplay']) && $settings['autoplay'] == '1' ? 'true' : 'false';

            foreach( $settings['images'] as $image ){
                if ( $image > 0 ) {
                    //$img_thumbnail = wpb_getImageBySize( array( 'attach_id' => $image['id'], 'thumb_size' => $settings['img_size'], 'class' => 'img-responsive' ) );
                    $img_thumbnail['p_img_large'] = wp_get_attachment_image_url($image['id'], $settings['img_size']);
                    $img_thumbnail['thumbnail'] = wp_get_attachment_image($image['id'], $settings['img_size']);
                    $image_meta = autozone_wp_get_attachment($image['id']);
                    $image_title = $image_meta['title'];
                } else {
                    $img_thumbnail = array();
                    $img_thumbnail['thumbnail'] = '<img src="' . vc_asset_url( 'vc/no_image.png' ) . '" />';
                    $img_thumbnail['p_img_large']= vc_asset_url( 'vc/no_image.png' );
                }

                if (!filter_var($image_title, FILTER_VALIDATE_URL) === false) {
                    $temp_out .=	'
                        <div class="slider-gallery__item">
                            <a class="slider-gallery__link" href="'.esc_url($image_title).'" >
                                '.$img_thumbnail['thumbnail'].'
                                <div class="slider-gallery__hover">
                                    <i class="icon icon_video-link icon-control-play"></i>
                                    <div class="slider-gallery__title"></div>
                                </div>
                            </a>
                        </div>
                        ';
                } else {
                    $temp_out .= '
                    <div class="slider-gallery__item">
                        <a class="slider-gallery__link" href="'.esc_url($img_thumbnail['p_img_large']).'">
                            '.$img_thumbnail['thumbnail'].'
                            <div class="slider-gallery__hover">
                                <i class="icon icon-magnifier-add"></i>
                                <div class="slider-gallery__title">'.wp_kses_post($image_title).'</div>
                            </div>
                        </a>
                    </div>
                ';
                }

            }
            $out = $settings['css_animation'] != '' ? '<div class="animated" data-animation="' . esc_attr($settings['css_animation']) . '">' : '<div>';
            $out .= '
                <div class="slider-gallery owl-carousel owl-theme owl-theme_mod-a enable-owl-carousel" data-min480="2" data-min768="3" data-min992="4" data-min1200="4" data-pagination="true" data-navigation="false" data-stop-on-hover="true" data-auto-play="'.esc_attr($settings['autoplay']).'">
            
                    '.$temp_out.'
                           
                </div>
	
        </div>';
            echo $out;
        } elseif($settings['style'] == 'style-two'){

            $outPut = '<div class="kswr-imcgal-container kswr-theelement" style="margin-top:0px;margin-bottom:0px;" data-layout="' . $settings['style_layout'] . '">
                            <div class="kswr-imcgal-fakeone"></div>
                            <div class="kswr-imcgal-insider">';
            foreach( $settings['images'] as $image ){
                $link = '';
                $outPut .= '<div class="kswr-imcgal-item kswr-theelement" onclick="kswr_cards_gallery(this);">
                                        <img src="'.wp_get_attachment_image_url($image['id'], "full").'">'.$link.
                                    '</div>';
            }
            $outPut .= '</div>
                        </div>';
            echo $outPut;

        }


    }
}