<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Icon_Box extends Widget_Base {

    public function get_name() {
        return 'templines-icon-box';
    }

    public function get_title() {
        return esc_html__( 'Icon Box', 'templines-helper-core' );
    }

    public function get_icon() {
          return 'fa fa-layer-group templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        // Sub Title
        $this->start_controls_section(
            'section_elementor_icon_box_general',
            [
                'label' => __( 'General Icon Box Setting', 'templines-helper-core' ),
            ]
        );

        //Style
        $this->add_control(
            'style',
            [
                'label'   => __( 'Use Picture or Icon/SVG', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-one',
                'options' => [
                    'style-one'              =>         esc_attr__('Style One','templines-helper-core'),
                    'style-two'              =>         esc_attr__('Style Two','templines-helper-core'),
                ],
            ]
        );


        //Content
        $this->add_control(
            'ibi_title',
            [
                'label' => esc_html__( 'Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Enter your title', 'templines-helper-core' ),
                'default' => 'Largest Dealership',
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => 'Content',
                'type' => Controls_Manager::WYSIWYG,
                'default' => '<p>Exercitation ullamco laboris nis exa  duis aute irure dolor.</p>',

            ]
        );


        //Style
        $this->add_control(
            'icon-box-style',
            [
                'label'   => __( 'Use Picture or Icon/SVG', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'icon',
                'options' => [
                    'icon'              =>         esc_attr__('Icon','templines-helper-core'),
                    'image'              =>         esc_attr__('Image','templines-helper-core'),
                ],
            ]
        );

        $this->add_control(
            'ibi_align',
            [
                'label'   => __( 'Text Alignment', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'center',
                'options' => [
                    'center'              =>         esc_attr__('Center','templines-helper-core'),
                    'left'              =>         esc_attr__('Left','templines-helper-core'),
                    'right'              =>         esc_attr__('Right','templines-helper-core'),
                ],
            ]
        );

        //Icon
        $this->add_control(
            'icon_svg',
            [
                'label'            => __( 'Icon', 'templines-helper-core' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'default'          => [
                    'value'   => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'fa4compatibility' => 'icon',
                'condition' => [
                    'icon-box-style' => array('icon'),
                ],
            ]
        );

        $this->add_control(
            'ibi_image',
            [
                'label' => __( 'Choose Image', 'templines-helper-core' ),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon-box-style' => array('image'),
                ],
            ]
        );


        $this->end_controls_section();
        // Style
        //Icon
        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => __( 'Icon Style', 'templines-helper-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'ibi_style_default',
            [
                'label'   => __( 'Use Default Icon Styling', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'off',
                'options' => [
                    'on'              =>         esc_attr__('On','templines-helper-core'),
                    'off'              =>         esc_attr__('Off','templines-helper-core'),
                ],
            ]
        );
        $this->add_responsive_control(
            'ibi_iconsize',
            [
                'label' => __( 'Icon Size', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 150,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .kswr-ibi-icon-ct i' => 'font-size: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .kswr-ibi-icon-ct img' => 'width: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .kswr-ibi-icon-ct svg' => 'width: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'ibi_style_default' => array('on'),
                ],
            ]
        );
        $this->add_control(
            'ibi_iconcolor',
            [
                'label' => __( 'Icon Color', 'tm-helper-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#222',
                'selectors' => [
                    '{{WRAPPER}} .kswr-ibi-icon-ct i' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'ibi_style_default' => array('on'),
                ],
            ]
        );
        $this->add_control(
            'ibi_iconcolor_hv',
            [
                'label' => __( 'Icon Color Hover', 'tm-helper-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#222',
                'selectors' => [
                    '{{WRAPPER}} .icon_box_wrap:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .blockanimecont:hover .kswr-ibi-icon-ct i' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'ibi_style_default' => array('on'),
                ],
            ]
        );

        $this->end_controls_section();


        // Title
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Content Style', 'templines-helper-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        //Color
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'templines-helper-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'scheme' => [
                    'type' => \Elementor\Core\Schemes\Color::get_type(),
                    'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon_box_wrap .kswr-ibi-title' => 'color: {{VALUE}}',
                ],
                'default' => '#333333'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __( 'Title Typography', 'tm-helper-core' ),
                'selector' => '{{WRAPPER}} .icon_box_wrap .kswr-ibi-title',
            ]
        );


        $this->add_control(
            'content_color',
            [
                'label' => __( 'Content Color', 'templines-helper-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'scheme' => [
                    'type' => \Elementor\Core\Schemes\Color::get_type(),
                    'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon_box_wrap .kswr-ibi-bottom .kswr-ibi-content p' => 'color: {{VALUE}}',
                ],
                'default' => '#444444'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Content Typography', 'tm-helper-core' ),
                'selector' => '{{WRAPPER}} .icon_box_wrap .kswr-ibi-bottom .kswr-ibi-content p',
            ]
        );
        $this->end_controls_section();

    }

    protected function render() {
        $this->add_render_attribute( 'wrapper', 'class', 'page-builder-icon-box-wrap' );
        $settingss = $this->get_settings_for_display();
        $editor_content = $this->parse_text_editor( $settingss['content'] );

        ?>
<div <?php echo $this->get_render_attribute_string('wrapper');?>>
    <?php if($settingss['style'] == 'style-one'){?>
    <div class="icon_box_wrap">
        <div class="kswr-ibi-icon-ct">
            <div class="kswr-icon-container kswr-icon-thatc">
                <?php if($settingss['icon-box-style'] == 'icon') {?>
                <div class="kswr-icon-ic kswr-icon-ic-r kswr-icon-r">
                    <?php Icons_Manager::render_icon($settingss['icon_svg']); ?>
                </div>
                <?php } else {?>
                <?php if(isset($settingss['ibi_image']['url']) && $settingss['ibi_image']['url'] != ''){ ?>
                <img src="<?php echo esc_url($settingss['ibi_image']['url'])?>" />
                <?php } ?>
                <?php } ?>
            </div>
        </div>
        <div class="kswr-ibi-title kswr-shortcode-element"><?php echo $settingss['ibi_title']?></div>

        <div class="km-line-shown">
        </div>

        <div class="kswr-ibi-bottom">
            <div class="kswr-ibi-content kswr-shortcode-element" data-fontsettings="" style=""><?php echo $editor_content?></div>
        </div>
    </div>
    <?php } elseif($settingss['style'] == 'style-two'){?>
    <div class="kswr-animationblock animated fadeInUp" data-reanimation="false" data-animation="fadeInUp" style="animation-duration: 1s; -webkit-animation-duration: 1s; animation-delay:0.1s; -webkit-animation-delay:0.1s;">
        <div class="blockanimecont">
            <div class="kswr-ibi-container kswr-icon-thatc kswr-theelement" data-layout="icontop" data-icolayout="center" data-hover="none">
                <div class="kswr-ibi-icon-ct" style="margin-top:-45px;margin-left:0px;margin-right:0px;margin-bottom:25px;">
                    <div class="kswr-icon-container kswr-icon-thatc kswr-icon-thatc-fijxyBZL" data-rotation="false" data-hover="none" style="width:90px; height: 90px; line-height:90px;  border-radius: 0px; --hover-bg:transparent; ">
                        <div class="kswr-icon-ic kswr-icon-ic-r kswr-icon-r" style=" font-size:50px;">
                            <?php if($settingss['icon-box-style'] == 'icon') {?>
                            <div class="kswr-icon-ic kswr-icon-ic-r kswr-icon-r">
                                <?php Icons_Manager::render_icon($settingss['icon_svg']); ?>
                            </div>
                            <?php } else {?>
                            <?php if(isset($settingss['ibi_image']['url']) && $settingss['ibi_image']['url'] != ''){ ?>
                            <img src="<?php echo esc_url($settingss['ibi_image']['url'])?>" />
                            <?php } ?>
                            <?php } ?>
                        </div>
                        <div class="kswr-icon-ic kswr-icon-ic-h kswr-icon-h" style="font-size:50px;">
                            <?php if($settingss['icon-box-style'] == 'icon') {?>
                            <div class="kswr-icon-ic kswr-icon-ic-r kswr-icon-r">
                                <?php Icons_Manager::render_icon($settingss['icon_svg']); ?>
                            </div>
                            <?php } else {?>
                            <?php if(isset($settingss['ibi_image']['url']) && $settingss['ibi_image']['url'] != ''){ ?>
                            <img src="<?php echo esc_url($settingss['ibi_image']['url'])?>" />
                            <?php } ?>
                            <?php } ?>
                        </div>
                        <div class="kswr-icon-bg kswr-icon-bg-r kswr-icon-r" style="background:rgba(255, 255, 255, 1);border:0px none transparent;border-width:0px;"></div>
                        <div class="kswr-icon-bg kswr-icon-bg-h kswr-icon-h" style="background:transparent;"></div>
                    </div>
                </div>
                <div class="kswr-ibi-title-ct ">
                    <div class="kswr-ibi-title kswr-shortcode-element " data-fontsettings="font-size:16px;" style="font-size:16px; font-family:inherit;font-weight:inherit; color:#333333;margin-top:0px;margin-left:0px;margin-right:0px;margin-bottom:10px;">
                        <?php echo $settingss['ibi_title']?>
                    </div>
                    <div class="kswr-ibi-subtitle kswr-shortcode-element " data-fontsettings="font-size:13px;line-height:2;" style="font-size:13px;line-height:2; font-family:Inherit;font-weight:inherit; color:#999999;margin-top:0px;margin-left:0px;margin-right:0px;margin-bottom:0px;">

                    </div>
                </div>
                <div class="kswr-ibi-bottom">
                    <div class="kswr-ibi-content kswr-shortcode-element " data-fontsettings="font-size:13px;line-height:2;" style="font-size:13px;line-height:2; font-family:Inherit;font-weight:inherit; color:#777777;margin-top:0px;margin-left:0px;margin-right:0px;margin-bottom:20px;">
                        <?php echo $editor_content?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
</div>

<?php

    }
}
