<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Customer_Favourites extends Widget_Base {

    public function get_name() {
        return 'templines-customer-favourites';
    }

    public function get_title() {
        return esc_html__( 'Customer Favourites', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-font templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_customer_favourites_style',
            [
                'label' => __( 'General Styles', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'class_name',
            [
                'label' => __( 'Extra class name', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '', 'templines-helper-core' ),
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $instance = ['number'=>6,];
        $args=['widget_id'=>'сustomer_favourites',];
        ?>
        <div class="widget-wrapper <?php echo esc_attr($settings['class_name']); ?>">
            <?php the_widget( 'WC_Widget_Top_Rated_Products',$instance, $args); 	?>
        </div>

   <?php }
}