<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Custom_Product extends Widget_Base {

    public function get_name() {
        return 'templines-custom-product';
    }

    public function get_title() {
        return esc_html__( 'Custom Product', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-font templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    public function templines_get_product(){

        $args = array( 'post_type' => 'product', 'numberposts' => '-1');
        $products_custom = get_posts($args);

        $product_customs_array[0] = esc_html__( 'Select a Product', 'templines-helper-core' );

        if ( ! empty( $products_custom ) && ! is_wp_error( $products_custom ) ) {
            $product_customs_array = array();
            if(empty($products_custom['errors'])){
                foreach($products_custom as $port_card){
                    $product_customs_array[$port_card->ID] = $port_card->post_title;
                }
            }
        } else {
            $product_customs_array[0] = esc_html__( 'Create a Product First', 'templines-helper-core' );
        }

        return $product_customs_array;
    }


    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_title_general_style',
            [
                'label' => __( 'General Styles', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'product', [
                'label' => esc_html__( 'Choose Product', 'templines-helper-core'),
                'type' => Controls_Manager::SELECT,
                'multiple' => true,
                'options' => $this->templines_get_product(),
                'show_label' => true,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button',
            [
                'label'   => __( 'Enable "Add to cart" button', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true'              =>         esc_attr__('Yes','templines-helper-core'),
                    'false'              =>         esc_attr__('No','templines-helper-core'),
                ],
            ]
        );

        $this->add_control(
            'style',
            [
                'label'   => __( 'Style', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid'              =>         esc_attr__('Grid','templines-helper-core'),
                ],
            ]
        );

        $this->add_control(
            'class_name',
            [
                'label' => esc_html__( 'Extra Class Name', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Class Name', 'templines-helper-core' ),
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $product_id = esc_attr($settings['product']);
        $product = wc_get_product( $product_id );

        $out = '<div class="custom-product-item '.esc_attr($settings['style']).' '.esc_attr($settings['class_name']).'">
					<div class="cpri-wrapper">
						<img src="'.get_the_post_thumbnail_url( $product->get_id(), 'autozone-services-thumb' ).'">';

        $showButton = esc_attr($settings['button']);
        if ( $showButton == 'true' ) {
            $out .= '	<a href= "?add-to-cart='.$product_id.'" class="button product_type_simple add_to_cart_button ajax_add_to_cart" data-product_id="'.$product_id.'"  aria-label="Add “'. $product->get_name() .'” to your cart" rel="nofollow">'.esc_html__( 'Add to cart', 'autozone' ).'</a>';
        }


        $out .= '</div>
					<h4><a href="'.get_permalink( $product->get_id() ).'">'. $product->get_name() .'</a></h4>
					<div class="cpri-price">
						<span>'. $product->get_price_html() .'</span>
					</div>
				</div>';


        echo $out;
    }
}