<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Custom_Post extends Widget_Base {

    public function get_name() {
        return 'templines-custom-post';
    }

    public function get_title() {
        return esc_html__( 'Custom Post', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-font templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    public function templines_get_posts(){

        $args = array(
            'post_status' => 'publish',
            'post_type'   => 'post'
        );
        $posts = get_posts( $args );

        $options[0] = esc_html__( 'Select a Post', 'templines-helper-core' );

        if ( ! empty( $posts ) && ! is_wp_error( $posts ) ) {
            foreach ( $posts as $p ) {
                setup_postdata($posts);
                $options[get_the_ID()] = get_the_title();
            }
        } else {
            $options[0] = esc_html__( 'Create a Post First', 'templines-helper-core' );
        }

        return $options;
    }


    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_title_general_style',
            [
                'label' => __( 'General Styles', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'posts', [
                'label' => esc_html__( 'Choose Posts', 'templines-helper-core'),
                'type' => Controls_Manager::SELECT,
                'multiple' => true,
                'options' => $this->templines_get_posts(),
                'show_label' => true,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'style',
            [
                'label'   => __( 'Style', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid'              =>         esc_attr__('Grid','templines-helper-core'),
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();


        $post_id = esc_attr($settings['posts']);
        $args = array(
            'post_status' => 'publish',
            'p' => $post_id,
        );
        $wp_query = new WP_Query( $args );

        while ($wp_query->have_posts()) :
            $wp_query->the_post();

            $out = '<div class="custom-post-item custom-post-'.esc_attr($style).' '.esc_attr($class_name).'">
            <div class="cpi-image-wrapper" ><a href="'.get_the_permalink().'">'. get_the_post_thumbnail( get_the_ID(), 'autozone-services-thumb', array('srcset' => '') ) .'</a></div> ';

            $out .= '<h4><a href="'.get_the_permalink().'">'. get_the_title() .'</a></h4>';

            $out .= '	<ul class="cpi-date-wrapper"> ';
            if(autozone_get_option('blog_settings_date',1)){
                $out .= '<li><i class="fa fa-calendar"></i>'. get_the_date(null, $wp_query->ID) .'</li>';
            }

            // if( 'open' == $wp_query->comment_status && autozone_get_option('blog_settings_comments',1)) {
            $out .= '<li><i class="fa fa-commenting-o"></i>'. get_comments_number_text(0, 1 ) .'</li> ';
            //	 }


            $out .= '</ul>';



            if ( !get_the_excerpt() == '') {
                $out .= '<div class="cpi-excerpt">'.get_the_excerpt() .'</div>';
            }
            $out .= '<a class="cpi-link-more" href="'.get_the_permalink().'">'.esc_html__( 'Read More', 'autozone' ).' <span>>></span></a>';


            $out .= '</div>';



        endwhile;


        echo $out;


    }
}