<?php
use Elementor\Control_Media;
use Elementor\Core\Base\Document;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use ElementorPro\Modules\QueryControl\Module as QueryControlModule;
use ElementorPro\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Brand extends Widget_Base {

    public function get_name() {
        return 'templines-brand';
    }

    public function get_title() {
        return esc_html__( 'Brand', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-user templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_team_general_setting',
            [
                'label' => __( 'General Setting', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'brands_per_page',
            [
                'label' => __( 'Brands per page', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default'   => '5',
            ]
        );

        // Carousel
        $this->add_control(
            'disable_carousel',
            [
                'label' => __( 'Carousel', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'               =>          esc_attr__('On','tm-helper-core'),
                    '0'              =>          esc_attr__('Off','tm-helper-core'),
                ],
                'default' => 'on'
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'image',
            [
                'label'             => __( 'Team Image', 'templines-helper-core' ),
                'type'              => Controls_Manager::MEDIA,
                'label_block'       => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __( 'Url', 'templines-helper-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'https://your-link.com', 'templines-helper-core' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );



        $this->add_control(
            'brand_list',
            [
                'label'       => '',
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );


        $this->end_controls_section();
    }

    protected function render() {
        $this->add_render_attribute( 'wrapper', 'class', 'templines-brands-wrap' );
        $settings = $this->get_settings_for_display();

        $disable_carousel = $settings['disable_carousel'] == 1 ? 'owl-carousel  enable-owl-carousel' : '';
        $brands_per_page = is_numeric($settings['brands_per_page']) ? $settings['brands_per_page'] : 5;?>

		<div class="<?php echo esc_attr($disable_carousel);?> owl-brands owl-theme" data-pagination="false" data-navigation="true" data-min-slides="<?php echo esc_attr($brands_per_page);?>">
            <?php foreach ($settings['brand_list'] as $item){ ?>
                <?php
                $href = $item['link']['url'];
                $url = isset($href['url']) ? $href['url'] : '';
                $img_id = $item['image']['id'];
                $img_link = wp_get_attachment_image_src( $img_id, 'large' );
                $img_link = $img_link[0];
                $image_meta = autozone_wp_get_attachment($img_id);
                $image_alt = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];
                ?>
                <a href="<?php echo esc_url($url);?>"><img src="<?php echo esc_url($img_link);?>" alt="<?php echo esc_attr($image_alt);?>"></a>
            <?php } ?>
		</div>

        <?php

    }
}