<?php
use Elementor\Control_Media;
use Elementor\Core\Base\Document;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use ElementorPro\Modules\QueryControl\Module as QueryControlModule;
use ElementorPro\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Border_Decor extends Widget_Base {

    public function get_name() {
        return 'templines-border-decor';
    }

    public function get_title() {
        return esc_html__( 'Border Decor', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-user templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_border_decor_general_setting',
            [
                'label' => __( 'General Setting', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'style',
            [
                'label'   => __( 'Border Decor', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'top',
                'options' => [
                    'top'              =>         esc_attr__('Top','templines-helper-core'),
                    'bottom'               =>         esc_attr__('Bottom','templines-helper-core'),
                ],
            ]
        );

        $this->add_control(
            'top_color',
            [
                'label' => __( 'Top decor Color', 'templines-helper-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'scheme' => [
                    'type' => \Elementor\Core\Schemes\Color::get_type(),
                    'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .border-section-top:before' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .border-section-top:after' => 'background-color: {{VALUE}}',
                ],
                'default' => '#dc2d13',
                'condition' => [
                    'style' => ['top'],
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $this->add_render_attribute( 'wrapper', 'class', 'templines-team-wrap' );
        $settings = $this->get_settings_for_display();

        ?>
        <?php if($settings['style'] == 'top'){?>
            <div class="bg_inner border-section-top border-section-top_mod-b"></div>
        <?php } elseif($settings['style'] == 'bottom'){?>
            <div class="border-section-bottom"></div>
        <?php } ?>
        <?php

    }
}