<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Blog_Box extends Widget_Base {

    public function get_name() {
        return 'templines-blog-box';
    }

    public function get_title() {
        return esc_html__( 'Blog Box', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-newspaper-o templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    public function templines_get_categories($type = null){

        $terms = get_categories();

        $options[0] = esc_html__( 'Select a Categories', 'templines-helper-core' );

        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
            foreach ( $terms as $cat ) {
                $options[$cat->term_id] = $cat->name;
            }
        } else {
            $options[0] = esc_html__( 'Create a Category First', 'templines-helper-core' );
        }

        return $options;
    }
	
	public function get_style_depends() {

		wp_register_style( 'widget_style_blog', plugins_url( '../assets/css/my-widgets.css', __FILE__  ) );

		return [
			'widget_style_blog',
		];

	}

    protected function register_controls() {

        $this->start_controls_section(
            'section_elementor_blog_box_general',
            [
                'label' => __( 'General Blog Setting', 'templines-helper-core' ),
            ]
        );

	// Style
        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-one'             =>          esc_attr__('Style One','tm-helper-core'),
                    'style-two'              =>          esc_attr__('Style Two','tm-helper-core'),
                ],
                'default' => 'style-one'
            ]
        );
		
	//Title
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Latest News', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'zigzag',
            [
                'label'   => __( 'ZigZag', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'enable',
                'options' => [
                    'enable'              =>         esc_attr__('Enable','templines-helper-core'),
                    'disable'             =>         esc_attr__('Disable','templines-helper-core'),
                ],
            ]
        );


        $this->add_control(
            'cats', [
                'label' => esc_html__( 'Categories', 'templines-helper-core'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->templines_get_categories(),
                'show_label' => true,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => __( 'Button Text', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'READ ALL NEWS', 'templines-helper-core' ),
            ]
        );
        $this->add_control(
            'link',
            [
                'label' => __( 'Link For All News', 'templines-helper-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'https://your-link.com', 'templines-helper-core' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->add_control(
            'skin',
            [
                'label'   => __( 'Color scheme', 'templines-helper-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'pix-lastnews-dark',
                'options' => [
                    'pix-lastnews-light'              =>         esc_attr__('Light','templines-helper-core'),
                    'pix-lastnews-dark'               =>         esc_attr__('Dark','templines-helper-core'),
                ],
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => 'Title Content',
                'type' => Controls_Manager::WYSIWYG,
                'default' => 'READ our latest blog news',
            ]
        );

        $this->add_control(
            'css_animation',
            [
                'label' => __( 'CSS Animation', 'templines-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'no'                  => esc_html__( 'No', 'autozone' ),
                    'bounce'            => esc_html__( 'bounce', 'autozone' ),
                    'flash'             => esc_html__( 'flash', 'autozone' ),
                    'pulse'             => esc_html__( 'pulse', 'autozone' ),
                    'rubberBand'        => esc_html__( 'rubberBand', 'autozone' ),
                    'shake'             => esc_html__( 'shake', 'autozone' ),
                    'swing'             => esc_html__( 'swing', 'autozone' ),
                    'tada'              => esc_html__( 'tada', 'autozone' ),
                    'wobble'            => esc_html__( 'wobble', 'autozone' ),
                    'jello'             => esc_html__( 'jello', 'autozone' ),
                    'bounceIn'          => esc_html__( 'bounceIn', 'autozone' ),
                    'bounceInDown'      => esc_html__( 'bounceInDown', 'autozone' ),
                    'bounceInLeft'      => esc_html__( 'bounceInLeft', 'autozone' ),
                    'bounceInRight'     => esc_html__( 'bounceInRight', 'autozone' ),
                    'bounceInUp'        => esc_html__( 'bounceInUp', 'autozone' ),
                    'bounceOut'         => esc_html__( 'bounceOut', 'autozone' ),
                    'bounceOutDown'     => esc_html__( 'bounceOutDown', 'autozone' ),
                    'bounceOutLeft'     => esc_html__( 'bounceOutLeft', 'autozone' ),
                    'bounceOutRight'    => esc_html__( 'bounceOutRight', 'autozone' ),
                    'bounceOutUp'       => esc_html__( 'bounceOutUp', 'autozone' ),
                    'fadeIn'            => esc_html__( 'fadeIn', 'autozone' ),
                    'fadeInDown'        => esc_html__( 'fadeInDown', 'autozone' ),
                    'fadeInDownBig'     => esc_html__( 'fadeInDownBig', 'autozone' ) ,
                    'fadeInLeft'        => esc_html__( 'fadeInLeft', 'autozone' ),
                    'fadeInLeftBig'     => esc_html__( 'fadeInLeftBig', 'autozone' ),
                    'fadeInRight'       => esc_html__( 'fadeInRight', 'autozone' ),
                    'fadeInRightBig'    => esc_html__( 'fadeInRightBig', 'autozone' ),
                    'fadeInUp'          => esc_html__( 'fadeInUp', 'autozone' ),
                    'fadeInUpBig'       => esc_html__( 'fadeInUpBig', 'autozone' ),
                    'fadeOut'           => esc_html__( 'fadeOut', 'autozone' ),
                    'fadeOutDown'       => esc_html__( 'fadeOutDown', 'autozone' ),
                    'fadeOutDownBig'    => esc_html__( 'fadeOutDownBig', 'autozone' ) ,
                    'fadeOutLeft'       => esc_html__( 'fadeOutLeft', 'autozone' ),
                    'fadeOutLeftBig'    => esc_html__( 'fadeOutLeftBig', 'autozone' ),
                    'fadeOutRight'      => esc_html__( 'fadeOutRight', 'autozone' ),
                    'fadeOutRightBig'   => esc_html__( 'fadeOutRightBig', 'autozone' ),
                    'fadeOutUp'         => esc_html__( 'fadeOutUp', 'autozone' ),
                    'fadeOutUpBig'      => esc_html__( 'fadeOutUpBig', 'autozone' ),
                    'flip'              => esc_html__( 'flip', 'autozone' ),
                    'flipInX'           => esc_html__( 'flipInX', 'autozone' ),
                    'flipInY'           => esc_html__( 'flipInY', 'autozone' ),
                    'flipOutX'          => esc_html__( 'flipOutX', 'autozone' ),
                    'flipOutY'          => esc_html__( 'flipOutY', 'autozone' ),
                    'lightSpeedIn'      => esc_html__( 'lightSpeedIn', 'autozone' ),
                    'lightSpeedOut'     => esc_html__( 'lightSpeedOut', 'autozone' ),
                    'rotateIn'          => esc_html__( 'rotateIn', 'autozone' ),
                    'rotateInDownLeft'  => esc_html__( 'rotateInDownLeft', 'autozone' ),
                    'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'autozone' ),
                    'rotateInUpLeft'    => esc_html__( 'rotateInUpLeft', 'autozone' ),
                    'rotateInUpRight'   => esc_html__( 'rotateInUpRight', 'autozone' ),
                    'rotateOut'         => esc_html__( 'rotateOut', 'autozone' ),
                    'rotateOutDownLeft' => esc_html__( 'rotateOutDownLeft', 'autozone' ),
                    'rotateOutDownRight'=> esc_html__( 'rotateOutDownRight', 'autozone' ),
                    'rotateOutUpLeft'   => esc_html__( 'rotateOutUpLeft', 'autozone' ),
                    'rotateOutUpRight'  => esc_html__( 'rotateOutUpRight', 'autozone' ),
                    'slideInUp'         => esc_html__( 'slideInUp', 'autozone' ),
                    'slideInDown'       => esc_html__( 'slideInDown', 'autozone' ),
                    'slideInLeft'       => esc_html__( 'slideInLeft', 'autozone' ),
                    'slideInRight'      => esc_html__( 'slideInRight', 'autozone' ),
                    'slideOutUp'        => esc_html__( 'slideOutUp', 'autozone' ),
                    'slideOutDown'      => esc_html__( 'slideOutDown', 'autozone' ),
                    'slideOutLeft'      => esc_html__( 'slideOutLeft', 'autozone' ),
                    'slideOutRight'     => esc_html__( 'slideOutRight', 'autozone' ),
                    'zoomIn'            => esc_html__( 'zoomIn', 'autozone' ),
                    'zoomInDown'        => esc_html__( 'zoomInDown', 'autozone' ),
                    'zoomInLeft'        => esc_html__( 'zoomInLeft', 'autozone' ),
                    'zoomInRight'       => esc_html__( 'zoomInRight', 'autozone' ),
                    'zoomInUp'          => esc_html__( 'zoomInUp', 'autozone' ),
                    'zoomOut'           => esc_html__( 'zoomOut', 'autozone' ),
                    'zoomOutDown'       => esc_html__( 'zoomOutDown', 'autozone' ),
                    'zoomOutLeft'       => esc_html__( 'zoomOutLeft', 'autozone' ),
                    'zoomOutRight'      => esc_html__( 'zoomOutRight', 'autozone' ),
                    'zoomOutUp'         => esc_html__( 'zoomOutUp', 'autozone' ),
                    'hinge'             => esc_html__( 'hinge', 'autozone' ),
                    'rollIn'            => esc_html__( 'rollIn', 'autozone' ),
                    'rollOut'           => esc_html__( 'rollOut', 'autozone' ),

                ],
                'default' => 'no',
            ]
        );


        $this->end_controls_section();

    }
	
	
    protected function render() {

        $settings = $this->get_settings_for_display();

        $date = '';

        $autozone_options = get_option('autozone_general_settings');
        $settings['skin'] = $settings['skin'] == '' ? 'pix-lastnews-light' : $settings['skin'];

        if( $settings['cats'] == '' ):
            $out = '<p>'.esc_html__('No categories selected. To fix this, please login to your WP Admin area and set the categories you want to show by editing this shortcode and setting one or more categories in the multi checkbox field "Categories".', 'autozone');
        else:

            $out = $settings['css_animation'] != '' ? '<div class="animated '.esc_attr($settings['skin']).'" data-animation="' . esc_attr($settings['css_animation']) . '">' : '<div class="'.esc_attr($settings['skin']).'">';
            $out .= $settings['btn_text'] != '' ? '<div class="clearfix"><a class="btn btn-success btn-effect pull-right" href="'.esc_url($settings['link']['url']).'"><span class="btn-inner">'.wp_kses_post($settings['btn_text']).'</span></a></div>' : '';

            $out .= '<div class="heading-news">
                        <h3 class="ui-title-block">'.wp_kses_post($settings['title']).'</h3>
                        <div class="ui-subtitle-block_mod-b">'.wp_kses_post(do_shortcode($settings['content'])).'</div>
                      </div>';

            $cat_to_query = get_objects_in_term( $settings['cats'] , 'category');

            if(!empty($settings['cats'])){
                $args = array(
                    'ignore_sticky_posts' => true,
                    'showposts' => 3,
                    'post__in' => $cat_to_query,
                );
            } else {
                $args = array(
                    'ignore_sticky_posts' => true,
                    'showposts' => 3,
                    'post__in' => 999999999999999999999999999999999,
                );
            }
			
		if($settings['style'] == 'style-one'){ 	
			
            $posts = new WP_Query( $args );
            if ($posts->have_posts()):
                $i=0;
                $cnt = $posts->post_count;
                while ($posts->have_posts()) :
                    $posts->the_post();
                    $custom = get_post_custom($posts->ID);
                    $i++;
                    if(autozone_get_option('autozone_blog_show_date', '1')){
                        $date = '<div class="entry-date">
								<span class="entry-date__inner">
									<span class="entry-date__number">'.wp_kses_post(get_the_time('j')).'</span>
									<br>'.wp_kses_post(get_the_time('M')).'
								</span>
							</div>';
                    }

                    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id($posts->ID), 'autozone-post-thumb');
                    $thumb_large = wp_get_attachment_image_src( get_post_thumbnail_id($posts->ID), 'large');
                    $thumbnail = isset($thumb[0]) && $thumb[0] != '' ? $thumb[0] : get_template_directory_uri().'/images/noimage.jpg';
                    $thumbnail_large = isset($thumb_large[0]) && $thumb_large[0] != '' ? $thumb_large[0] : get_template_directory_uri().'/images/noimage.jpg';

                    $out .= '

				<article class="post post_mod-a clearfix zigzag-'.$settings['zigzag'].'">
					<div class="entry-media">
						<a href="'.esc_url(get_the_permalink()).'" >
							<img class="img-responsive" src="'.esc_url($thumbnail).'" width="470" height="280" alt="'.esc_attr(get_the_title()).'">
							<div class="post-hover helper"><i class="icon icon-magnifier-add"></i></div>
						</a>
					</div>
					<div class="entry-main entry-main_mod-a">
						<div class="entry-main__inner entry-main__inner_mod-a">
							<h3 class="entry-title"><a href="'.esc_url(get_the_permalink()).'">'.wp_kses_post(get_the_title()).'</a></h3>
							<div class="entry-meta">
								<span class="entry-meta__item">'.esc_html__('By:: ', 'autozone').get_the_author_link().'</span>';
                    if( 'open' == $posts->comment_status && autozone_get_option('blog_settings_comments', '1')) {
                        $out .= '	<span class="entry-meta__item">'.esc_html__( 'COMMENTS :: ', 'autozone' ).'<a class="entry-meta__link" href="'.esc_url(get_comments_link( $posts->ID )).'">'.wp_kses_post(get_comments_number()).'</a></span>';
                    }
                    $out .= '
							</div>
						</div>
						<div class="decor-1"></div>
						'.$date.'
						<div class="entry-content">
							'.get_the_excerpt().'
						</div>
					</div>
				</article>
			';
                endwhile;
            endif;
			
			
			} elseif($settings['style'] == 'style-two'){
				
				$out .='
				<div class="box__flex">
				';
				
				  $posts = new WP_Query( $args );
            if ($posts->have_posts()):
                $i=0;
                $cnt = $posts->post_count;
                while ($posts->have_posts()) :
                    $posts->the_post();
                    $custom = get_post_custom($posts->ID);
                    $i++;
                    if(autozone_get_option('autozone_blog_show_date', '1')){
                        $date = '<div class="entry-date">
								<span class="entry-date__inner">
									<span class="entry-date__number">'.wp_kses_post(get_the_time('j')).'</span>
									<br>'.wp_kses_post(get_the_time('F j, Y')).'
								</span>
							</div>';
                    }

                    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id($posts->ID), 'autozone-post-thumb');
                    $thumb_large = wp_get_attachment_image_src( get_post_thumbnail_id($posts->ID), 'large');
                    $thumbnail = isset($thumb[0]) && $thumb[0] != '' ? $thumb[0] : get_template_directory_uri().'/images/noimage.jpg';
                    $thumbnail_large = isset($thumb_large[0]) && $thumb_large[0] != '' ? $thumb_large[0] : get_template_directory_uri().'/images/noimage.jpg';
					$avatar = get_avatar_url( wp_get_current_user(), array(
	'size' => 48,
	'default'=>'wavatar',
) );

                    $out .= '

				<article class="post post_mod-a clearfix zigzag-'.$settings['zigzag'].'">
				<div class="post__box--style-2">
					<div class="box__media">
						<img
						loading="lazy"
						src="'.esc_url($thumbnail).'"
						width="360"
						height="300"
						alt="'.esc_attr(get_the_title()).'"
						class="tumbnail-big"
						/>
						<img
						src="'.esc_url($avatar).'"
						width="80"
						height="80"
						alt="avatar"
						class="avatar"
						/>
					</div>
					 <div class="box__contents">
          <div class="meta__data">
            <span class="data">
			<i class="fa fa-calendar" aria-hidden="true"></i>
              <a href="#">'.wp_kses_post(get_the_time('F j, Y')).'</a>
            </span>
            <span class="quotes">
             <i class="fa fa-commenting-o" aria-hidden="true"></i>
              <a href="'.esc_url(get_comments_link( $posts->ID )).'">'.wp_kses_post(get_comments_number()).'</a>
            </span>
          </div>
          <div class="block__content">
            <h3><a href="'.esc_url(get_the_permalink()).'">'.wp_kses_post(get_the_title()).'</a></h3>
            <p>'.get_the_excerpt().'</p>
            <div class="link__box">
              <a href="'.esc_url(get_the_permalink()).'" class="link__read-more">Read more</a>
            </div>
          </div>
        </div>
					
					
					</div>
				</article>
			';
                endwhile;
            endif;
				
			}
            $out .= '</div>';
        endif;
        echo $out;
        ?>


<?php

    }
}
