<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;






if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Autos extends Widget_Base {

    public function get_name() {
        return 'templines-autos';
    }

    public function get_title() {
        return esc_html__( 'Autos Grid', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-list-ol templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    public function templines_get_models($type = null){

        $terms = get_terms( array(
            'taxonomy' => 'auto-model',
            'hide_empty' => '0'
        ) );

        $options[0] = esc_html__( 'Select a Auto Models', 'templines-helper-core' );

        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
            foreach ( $terms as $cat ) {
                $options[$cat->slug] = $cat->name;
            }
        } else {
            $options[0] = esc_html__( 'Create a Model First', 'templines-helper-core' );
        }

        return $options;
    }

    protected function register_controls() {
        // Sub Title
        $this->start_controls_section(
            'section_elementor_list_general',
            [
                'label' => __( 'General Latest Autos Setting', 'templines-helper-core' ),
            ]
        );

        // Item Count
        $this->add_control(
            'count',
            [
                'label' => __( 'Items Count', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '3'             =>          esc_attr__('3','tm-helper-core'),
                    '6'              =>          esc_attr__('6','tm-helper-core'),
                    '9'             =>          esc_attr__('9','tm-helper-core'),
                ],
                'default' => '3'
            ]
        );
        // Auto Models
        $this->add_control(
            'models', [
                'label' => esc_html__( 'Auto Models', 'templines-helper-core'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->templines_get_models(),
                'show_label' => true,
                'label_block' => true,
            ]
        );


        $this->add_control(
            'btn_text',
            [
                'label' => __( 'Button Text', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'ALL AUTOS', 'templines-helper-core' ),
            ]
        );
        $this->add_control(
            'link',
            [
                'label' => __( 'Link For All Autos', 'templines-helper-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'https://your-link.com', 'templines-helper-core' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );


        $this->end_controls_section();

    }

    protected function render() {
        $settingss = $this->get_settings_for_display();

        $models = '';
        foreach ($settingss['models'] as $m){
            $models .= $m . '|';
        }

        $args = array(
            'post_type' => 'pixad-autos',
            'status'    => 'published',
            'tax_query' => array(
                array (
                    'taxonomy' => 'auto-model',
                    'field' => 'slug',
                    'terms' => $settingss['models'],
                )
            ),
            'posts_per_page' => $settingss['count']
        );


        $autos = new WP_Query( $args );
        $out_btn = $settingss['btn_text'] != '' ? '<div class="templines_all_autos_btn"><a class="btn btn-success btn-effect pull-right" href="'.esc_url($settingss['link']['url']).'"><span class="btn-inner">'.wp_kses_post($settingss['btn_text']).'</span></a></div>' : '';

        $old_body_check = array();
        ?>
<ul class="pixad-body-filter">
    <input type="hidden" class="models" value="<?php echo esc_attr($models)?>" />
    <input type="hidden" class="count" value="<?php echo esc_attr($settingss['count'])?>" />
    <?php while ( $autos->have_posts() ) : $autos->the_post(); ?>
    <?php $body = get_the_terms(get_the_ID(), 'auto-body');
                $old_body_check[$body[0]->slug] = $body[0]->name;
                ?>
    <?php endwhile;?>


    <li data-val="<?php echo esc_attr('all')?>" class="active"><?php echo __('Show All', 'templines-helper-core')?></li>
    <?php
            $old_body_check = array_unique($old_body_check);
            foreach ($old_body_check as $key => $b){ ?>
    <li data-val="<?php echo esc_attr($key)?>"><?php echo esc_html($b)?></li>
    <?php } ?>
</ul>

<?php echo $out_btn; ?>

<div id="pixad-listing">
    <?php
            include( TEMPLINES_HELPER_CORE_PLUGIN_PATH. '/templates/autos.php' );?>
    <?php echo $templines_result;?>

</div>
<?php
    }
}
